/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.IView;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.PhotoTask;
import com.blisscloud.ezuc.client.util.ThumbnailCache;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public abstract class BasePhonePanel
extends JPanel
implements IView,
PhotoTask.IPhotoCallBack {
    private static final long serialVersionUID = -6531059519585132901L;
    private String mJid;
    private PersonalPhoto mCallerPhoto = new PersonalPhoto();
    private PhotoTask mPhotoTask;
    private long mId;

    public BasePhonePanel() {
        this.setCallerPhoto(UIConstants.ICON_PHONE_NONAME.getImage());
        ThumbnailCache.getInstance().register(this);
    }

    public PersonalPhoto getCallerPhoto() {
        return this.mCallerPhoto;
    }

    protected void fetchPhoto(LiteContact contact) {
        if (this.mPhotoTask != null) {
            this.mPhotoTask.cancel(true);
            this.mPhotoTask = null;
        }
        if (contact != null && contact.isPhotoFlag()) {
            BufferedImage img = ContactManager.getPhotoWithRefresh(UCChatClient.context, PhotoType.BIG, KeyUtil.genEmpKey(contact), true);
            if (img != null) {
                img = GraphicUtil.getPresencedPersonalPhoto(170, 170, img, null, true);
                this.mCallerPhoto.setImage(img);
            } else {
                img = ContactManager.getPhotoWithRefresh(UCChatClient.context, PhotoType.SMALL, KeyUtil.genEmpKey(contact), true);
                if (img != null) {
                    img = GraphicUtil.getPresencedPersonalPhoto(48, 48, img, null, true);
                    this.mCallerPhoto.setImage(img);
                } else {
                    this.mCallerPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
                }
                this.mPhotoTask = new PhotoTask();
                this.mPhotoTask.setCallBack(this);
                this.mPhotoTask.execute("/ucrm/employee/showBigPhoto?employeeId=", contact.getId(), this, contact.getJid());
            }
        } else {
            this.mCallerPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
        }
    }

    protected void fetchPhoto(LiteMyContact contact) {
        if (this.mPhotoTask != null) {
            this.mPhotoTask.cancel(true);
            this.mPhotoTask = null;
        }
        if (contact != null && contact.isPhotoFlag()) {
            BufferedImage img = ContactManager.getExternalPhotoWithRefresh(UCChatClient.context, PhotoType.BIG, contact.getId(), true);
            if (img != null) {
                img = GraphicUtil.getPresencedPersonalPhoto(170, 170, img, null, true);
                this.mCallerPhoto.setImage(img);
            } else {
                img = ContactManager.getExternalPhotoWithRefresh(UCChatClient.context, PhotoType.SMALL, contact.getId(), true);
                if (img != null) {
                    img = GraphicUtil.getPresencedPersonalPhoto(48, 48, img, null, true);
                    this.mCallerPhoto.setImage(img);
                } else {
                    this.mCallerPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
                }
                this.mPhotoTask = new PhotoTask();
                this.mPhotoTask.setCallBack(this);
                this.mPhotoTask.execute("/ucrm/contact/showBigPhoto?contactId=", contact.getId(), this, String.valueOf(contact.getId()));
            }
        } else {
            this.mCallerPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
        }
    }

    @Override
    public void loadSuccess(Image bitmap) {
        if (bitmap != null) {
            this.mCallerPhoto.setImage(bitmap);
        } else {
            this.mCallerPhoto.setImage(UIConstants.ICON_PERSON32.getImage());
        }
    }

    @Override
    public void loadFail(String info) {
        Log.i(this.getClass().getSimpleName(), "load image fail: " + info);
    }

    public void setCallerPhoto(Image bitmap) {
        if (this.mCallerPhoto != null) {
            this.mCallerPhoto.setImage(bitmap);
            Dimension d = new Dimension(170, 170);
            this.mCallerPhoto.setPreferredSize(d);
            this.mCallerPhoto.setMinimumSize(d);
            this.mCallerPhoto.setMaximumSize(d);
            this.mCallerPhoto.setImage(bitmap);
            this.mCallerPhoto.invalidate();
            this.mCallerPhoto.repaint();
        }
    }

    public void setCallerPhoto(Image bitmap, int width, int height) {
        if (this.mCallerPhoto != null) {
            Dimension d = new Dimension(width, height);
            this.mCallerPhoto.setPreferredSize(d);
            this.mCallerPhoto.setMinimumSize(d);
            this.mCallerPhoto.setMaximumSize(d);
            this.mCallerPhoto.setImage(bitmap);
            this.mCallerPhoto.invalidate();
            this.mCallerPhoto.repaint();
        }
    }

    public String getJid() {
        return this.mJid;
    }

    public void setJid(String jid) {
        this.mJid = jid;
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long id) {
        this.mId = id;
    }

    protected abstract void doAction();
}

