/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.phone.CallState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class KeypadPanel
extends JPanel {
    private static final long serialVersionUID = 3340159722590742907L;
    private JPanel jPanel3;
    private JLabel lblCall;
    private JPanel panelDial;
    private JLabel lblPadding;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JLabel lblSharp;
    private JLabel lblStar;
    private JLabel lbl0;
    private JLabel lbl9;
    private JLabel lbl8;
    private JLabel lbl7;
    private JLabel lbl6;
    private JLabel lbl5;
    private JLabel lbl4;
    private JLabel lbl3;
    private JLabel lbl2;
    private JLabel lbl1;
    private JPanel panelKeypad;
    private JTextField txtCallee;
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;
    boolean voiceEnabled;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new KeypadPanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public KeypadPanel() {
        this.initGUI();
        this.initReceiver();
        this.setVoiceEnabled(false);
    }

    public String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(clipboard);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.panelKeypad = new JPanel();
            GridBagLayout panelKeypadLayout = new GridBagLayout();
            this.add((Component)this.panelKeypad, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panelKeypad.setLayout(panelKeypadLayout);
            this.panelKeypad.setOpaque(false);
            this.jPanel3 = new JPanel();
            BorderLayout jPanel3Layout = new BorderLayout();
            jPanel3Layout.setHgap(5);
            this.jPanel3.setLayout(jPanel3Layout);
            this.panelKeypad.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
            this.jPanel3.setOpaque(false);
            this.jPanel2 = new RoundedCornerPanel(20, 2.0f);
            this.jPanel3.add((Component)this.jPanel2, "Center");
            BorderLayout jPanel2Layout1 = new BorderLayout();
            jPanel2Layout1.setHgap(3);
            this.jPanel2.setLayout(jPanel2Layout1);
            this.jPanel2.setBackground(Color.WHITE);
            this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.txtCallee = new HintTextField(I18NUtil.getString("call_label_input_phone_num"));
            this.txtCallee.enableInputMethods(false);
            this.jPanel2.add((Component)this.txtCallee, "Center");
            this.txtCallee.setFont(UIConstants.FONT_16_PLAIN);
            this.txtCallee.setBorder(BorderFactory.createEmptyBorder());
            this.txtCallee.setOpaque(false);
            this.txtCallee.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    this.checkPopup(evt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    this.checkPopup(evt);
                }

                private void checkPopup(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        final String pasteContent = KeypadPanel.this.getClipboardContents();
                        if (TextUtils.isBlank((CharSequence)pasteContent)) {
                            return;
                        }
                        JPopupMenu popupMenuMessage = new JPopupMenu();
                        JMenuItem miPaste = new JMenuItem();
                        miPaste.setText(I18NUtil.getString("common_btn_paste"));
                        miPaste.setHorizontalTextPosition(0);
                        miPaste.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent evt) {
                                KeypadPanel.this.txtCallee.replaceSelection(pasteContent);
                            }
                        });
                        popupMenuMessage.add(miPaste);
                        popupMenuMessage.show(KeypadPanel.this, evt.getX(), evt.getY());
                    }
                }
            });
            this.txtCallee.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    KeypadPanel.this.call();
                }
            });
            this.txtCallee.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    String key = KeypadPanel.this.txtCallee.getText();
                    KeypadPanel.this.handleCallBtn();
                    KeypadPanel.this.jLabel3.setVisible(StringUtils.isNotBlank((CharSequence)key));
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    String key = KeypadPanel.this.txtCallee.getText();
                    KeypadPanel.this.handleCallBtn();
                    KeypadPanel.this.jLabel3.setVisible(StringUtils.isNotBlank((CharSequence)key));
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    String key = KeypadPanel.this.txtCallee.getText();
                    KeypadPanel.this.handleCallBtn();
                    KeypadPanel.this.jLabel3.setVisible(StringUtils.isNotBlank((CharSequence)key));
                }
            });
            this.txtCallee.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if ((c < '0' || c > '9') && c != '\b' && c != '*' && c != '#' && c != '+' && c != ',') {
                        e.consume();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyChar() == '1') {
                        KeypadPanel.this.lbl1.setIcon(UIConstants.icon_1click);
                    } else if (e.getKeyChar() == '2') {
                        KeypadPanel.this.lbl2.setIcon(UIConstants.icon_2click);
                    } else if (e.getKeyChar() == '3') {
                        KeypadPanel.this.lbl3.setIcon(UIConstants.icon_3click);
                    } else if (e.getKeyChar() == '4') {
                        KeypadPanel.this.lbl4.setIcon(UIConstants.icon_4click);
                    } else if (e.getKeyChar() == '5') {
                        KeypadPanel.this.lbl5.setIcon(UIConstants.icon_5click);
                    } else if (e.getKeyChar() == '6') {
                        KeypadPanel.this.lbl6.setIcon(UIConstants.icon_6click);
                    } else if (e.getKeyChar() == '7') {
                        KeypadPanel.this.lbl7.setIcon(UIConstants.icon_7click);
                    } else if (e.getKeyChar() == '8') {
                        KeypadPanel.this.lbl8.setIcon(UIConstants.icon_8click);
                    } else if (e.getKeyChar() == '9') {
                        KeypadPanel.this.lbl9.setIcon(UIConstants.icon_9click);
                    } else if (e.getKeyChar() == '0') {
                        KeypadPanel.this.lbl0.setIcon(UIConstants.icon_0click);
                    } else if (e.getKeyChar() == '*') {
                        KeypadPanel.this.lblStar.setIcon(UIConstants.icon_starclick);
                    } else if (e.getKeyChar() == '#') {
                        KeypadPanel.this.lblSharp.setIcon(UIConstants.icon_poundclick);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyChar() == '1') {
                        KeypadPanel.this.lbl1.setIcon(UIConstants.icon_1);
                        KeypadPanel.this.sendDTMF('1');
                    } else if (e.getKeyChar() == '2') {
                        KeypadPanel.this.lbl2.setIcon(UIConstants.icon_2);
                        KeypadPanel.this.sendDTMF('2');
                    } else if (e.getKeyChar() == '3') {
                        KeypadPanel.this.lbl3.setIcon(UIConstants.icon_3);
                        KeypadPanel.this.sendDTMF('3');
                    } else if (e.getKeyChar() == '4') {
                        KeypadPanel.this.lbl4.setIcon(UIConstants.icon_4);
                        KeypadPanel.this.sendDTMF('4');
                    } else if (e.getKeyChar() == '5') {
                        KeypadPanel.this.lbl5.setIcon(UIConstants.icon_5);
                        KeypadPanel.this.sendDTMF('5');
                    } else if (e.getKeyChar() == '6') {
                        KeypadPanel.this.lbl6.setIcon(UIConstants.icon_6);
                        KeypadPanel.this.sendDTMF('6');
                    } else if (e.getKeyChar() == '7') {
                        KeypadPanel.this.lbl7.setIcon(UIConstants.icon_7);
                        KeypadPanel.this.sendDTMF('7');
                    } else if (e.getKeyChar() == '8') {
                        KeypadPanel.this.lbl8.setIcon(UIConstants.icon_8);
                        KeypadPanel.this.sendDTMF('8');
                    } else if (e.getKeyChar() == '9') {
                        KeypadPanel.this.lbl9.setIcon(UIConstants.icon_9);
                        KeypadPanel.this.sendDTMF('9');
                    } else if (e.getKeyChar() == '0') {
                        KeypadPanel.this.lbl0.setIcon(UIConstants.icon_0);
                        KeypadPanel.this.sendDTMF('0');
                    } else if (e.getKeyChar() == '*') {
                        KeypadPanel.this.lblStar.setIcon(UIConstants.icon_star);
                        KeypadPanel.this.sendDTMF('*');
                    } else if (e.getKeyChar() == '#') {
                        KeypadPanel.this.lblSharp.setIcon(UIConstants.icon_pound);
                        KeypadPanel.this.sendDTMF('#');
                    }
                }
            });
            this.jLabel3 = new JLabel();
            this.jLabel3.setVisible(false);
            this.jPanel2.add((Component)this.jLabel3, "East");
            this.jLabel3.setIcon(UIConstants.icon_clear);
            this.jLabel3.setCursor(UIConstants.CURSOR_HAND);
            this.jLabel3.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    KeypadPanel.this.jLabel3.setIcon(UIConstants.icon_clearclick);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    KeypadPanel.this.jLabel3.setIcon(UIConstants.icon_clear);
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    KeypadPanel.this.txtCallee.setText("");
                }
            });
            this.lbl1 = new JLabel();
            this.panelKeypad.add((Component)this.lbl1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl1.setIcon(UIConstants.icon_1);
            this.lbl1.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl1.setIcon(UIConstants.icon_1);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl1.setIcon(UIConstants.icon_1over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "1");
                        KeypadPanel.this.sendDTMF('1');
                    }
                }
            });
            this.lbl2 = new JLabel();
            this.panelKeypad.add((Component)this.lbl2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl2.setIcon(UIConstants.icon_2);
            this.lbl2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl2.setIcon(UIConstants.icon_2);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl2.setIcon(UIConstants.icon_2over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "2");
                        KeypadPanel.this.sendDTMF('2');
                    }
                }
            });
            this.lbl3 = new JLabel();
            this.panelKeypad.add((Component)this.lbl3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl3.setIcon(UIConstants.icon_3);
            this.lbl3.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl3.setIcon(UIConstants.icon_3);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl3.setIcon(UIConstants.icon_3over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "3");
                        KeypadPanel.this.sendDTMF('3');
                    }
                }
            });
            this.lbl4 = new JLabel();
            this.panelKeypad.add((Component)this.lbl4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl4.setIcon(UIConstants.icon_4);
            this.lbl4.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl4.setIcon(UIConstants.icon_4);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl4.setIcon(UIConstants.icon_4over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "4");
                        KeypadPanel.this.sendDTMF('4');
                    }
                }
            });
            this.lbl5 = new JLabel();
            this.panelKeypad.add((Component)this.lbl5, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl5.setIcon(UIConstants.icon_5);
            this.lbl5.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl5.setIcon(UIConstants.icon_5);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl5.setIcon(UIConstants.icon_5over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "5");
                        KeypadPanel.this.sendDTMF('5');
                    }
                }
            });
            this.lbl6 = new JLabel();
            this.panelKeypad.add((Component)this.lbl6, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl6.setIcon(UIConstants.icon_6);
            this.lbl6.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl6.setIcon(UIConstants.icon_6);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl6.setIcon(UIConstants.icon_6over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "6");
                        KeypadPanel.this.sendDTMF('6');
                    }
                }
            });
            this.lbl7 = new JLabel();
            this.panelKeypad.add((Component)this.lbl7, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl7.setIcon(UIConstants.icon_7);
            this.lbl7.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl7.setIcon(UIConstants.icon_7);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl7.setIcon(UIConstants.icon_7over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "7");
                        KeypadPanel.this.sendDTMF('7');
                    }
                }
            });
            this.lbl8 = new JLabel();
            this.panelKeypad.add((Component)this.lbl8, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl8.setIcon(UIConstants.icon_8);
            this.lbl8.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl8.setIcon(UIConstants.icon_8);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl8.setIcon(UIConstants.icon_8over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "8");
                        KeypadPanel.this.sendDTMF('8');
                    }
                }
            });
            this.lbl9 = new JLabel();
            this.panelKeypad.add((Component)this.lbl9, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl9.setIcon(UIConstants.icon_9);
            this.lbl9.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl9.setIcon(UIConstants.icon_9);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl9.setIcon(UIConstants.icon_9over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "9");
                        KeypadPanel.this.sendDTMF('9');
                    }
                }
            });
            this.lblStar = new JLabel();
            this.panelKeypad.add((Component)this.lblStar, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblStar.setIcon(UIConstants.icon_star);
            this.lblStar.addMouseListener(new MouseAdapter(){
                long t = 0L;

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lblStar.setIcon(UIConstants.icon_star);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lblStar.setIcon(UIConstants.icon_starover);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    this.t = System.currentTimeMillis();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (System.currentTimeMillis() - this.t > 300L) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + ",");
                    } else if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "*");
                        KeypadPanel.this.sendDTMF('*');
                    }
                    this.t = 0L;
                }
            });
            this.lbl0 = new JLabel();
            this.panelKeypad.add((Component)this.lbl0, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lbl0.setIcon(UIConstants.icon_0);
            this.lbl0.addMouseListener(new MouseAdapter(){
                long t = 0L;

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl0.setIcon(UIConstants.icon_0);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lbl0.setIcon(UIConstants.icon_0over);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    this.t = System.currentTimeMillis();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (System.currentTimeMillis() - this.t > 300L) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "+");
                    } else if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "0");
                        KeypadPanel.this.sendDTMF('0');
                    }
                    this.t = 0L;
                }
            });
            this.lblSharp = new JLabel();
            this.panelKeypad.add((Component)this.lblSharp, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSharp.setIcon(UIConstants.icon_pound);
            this.lblSharp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lblSharp.setIcon(UIConstants.icon_pound);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.lblSharp.setIcon(UIConstants.icon_poundover);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled) {
                        KeypadPanel.this.txtCallee.setText(KeypadPanel.this.txtCallee.getText() + "#");
                        KeypadPanel.this.sendDTMF('#');
                    }
                }
            });
            this.panelDial = new JPanel();
            this.panelKeypad.add((Component)this.panelDial, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            GridBagLayout panelDialLayout = new GridBagLayout();
            this.panelDial.setLayout(panelDialLayout);
            this.lblCall = new RoundedCornerLabel(I18NUtil.getString("call_btn_callout"), UIConstants.ICON_DIAL, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            this.panelDial.add((Component)this.lblCall, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblCall.setForeground(Color.WHITE);
            this.lblCall.setFont(UIConstants.FONT_14_BOLD);
            this.lblCall.setCursor(UIConstants.CURSOR_HAND);
            this.lblCall.setHorizontalAlignment(0);
            this.lblCall.setPreferredSize(new Dimension(100, 36));
            this.lblCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (KeypadPanel.this.voiceEnabled && TextUtils.isNotBlank((CharSequence)KeypadPanel.this.txtCallee.getText())) {
                        if (TextUtils.isBlank((CharSequence)KeypadPanel.this.txtCallee.getText())) {
                            KeypadPanel.this.txtCallee.requestFocus();
                        } else {
                            KeypadPanel.this.call();
                        }
                    }
                }
            });
            this.lblPadding = new JLabel();
            this.add((Component)this.lblPadding, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    if (action.equals("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_SUCCESS")) {
                        KeypadPanel.this.phone_registerSuccess();
                    } else if (action.equals("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_FAIL")) {
                        String result = intent.getStringExtra("result");
                        KeypadPanel.this.phone_registerFail(result);
                    } else if (action.equals("ezuc.intent.action.event.PHONE_STATE_SIP_UNREGISTER_DONE")) {
                        String result = intent.getStringExtra("result");
                        KeypadPanel.this.phone_unregisterDone(result);
                    } else if (action.equals("ezuc.intent.action.event.PHONE_STATE_CHANGED")) {
                        int line = bundle.getInt("line");
                        KeypadPanel.this.phone_stateChanged(line);
                    }
                }
                catch (Throwable t) {
                    Log.e(KeypadPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_SUCCESS");
        this.filter.addAction("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_FAIL");
        this.filter.addAction("ezuc.intent.action.event.PHONE_STATE_SIP_UNREGISTER_DONE");
        this.filter.addAction("ezuc.intent.action.event.PHONE_STATE_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void call() {
        String input = this.txtCallee.getText();
        if (TextUtils.isNotBlank((CharSequence)input)) {
            DialoutManager.directDialNumberForPad(UCChatClient.context, input.trim(), null);
        }
    }

    public void release() {
        this.txtCallee.setText("");
    }

    private void phone_registerSuccess() {
        Log.d(KeypadPanel.class.getSimpleName(), "phone_registerSuccess");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeypadPanel.this.setVoiceEnabled(true);
            }
        });
    }

    private void phone_registerFail(String result) {
        Log.d(KeypadPanel.class.getSimpleName(), "phone_registerFail result:" + result);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeypadPanel.this.setVoiceEnabled(false);
            }
        });
    }

    private void phone_unregisterDone(String result) {
        Log.d(KeypadPanel.class.getSimpleName(), "phone_unregisterDone result:" + result);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeypadPanel.this.setVoiceEnabled(false);
            }
        });
    }

    private void phone_stateChanged(final int line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CallLine callLine = PhoneAgent.getInstance().getCallLine(line);
                if (callLine.getState() == CallState.INCALL) {
                    KeypadPanel.this.txtCallee.setText("");
                }
                KeypadPanel.this.handleCallBtn();
            }
        });
    }

    private void sendDTMF(char c) {
        PhoneAgent.getInstance().sendDTMF(c, 250);
    }

    private void setVoiceEnabled(boolean b) {
        this.voiceEnabled = b;
        this.txtCallee.setEnabled(b);
        this.lbl1.setEnabled(b);
        this.lbl2.setEnabled(b);
        this.lbl3.setEnabled(b);
        this.lbl4.setEnabled(b);
        this.lbl5.setEnabled(b);
        this.lbl6.setEnabled(b);
        this.lbl7.setEnabled(b);
        this.lbl8.setEnabled(b);
        this.lbl9.setEnabled(b);
        this.lbl0.setEnabled(b);
        this.lblStar.setEnabled(b);
        this.lblSharp.setEnabled(b);
        this.handleCallBtn();
    }

    private void handleCallBtn() {
        if (!this.voiceEnabled) {
            this.lblCall.setEnabled(false);
            this.lblCall.setToolTipText(I18NUtil.getString("phone_notice_not_connected"));
            return;
        }
        PhoneAgent.LineAvailableType ableToCall = PhoneAgent.getInstance().isAvailableToCall();
        if (ableToCall == PhoneAgent.LineAvailableType.NONE) {
            this.lblCall.setEnabled(false);
            this.lblCall.setToolTipText(I18NUtil.getString("call_notice_all_lines_busy"));
            return;
        }
        if (TextUtils.isBlank((CharSequence)this.txtCallee.getText())) {
            this.lblCall.setEnabled(false);
            this.lblCall.setToolTipText(I18NUtil.getString("call_validation_phone_num_empty"));
            return;
        }
        this.lblCall.setToolTipText(null);
        this.handleCallBtnText(true, ableToCall);
    }

    private void handleCallBtnText(boolean btnEnable, PhoneAgent.LineAvailableType ableToCall) {
        this.lblCall.setEnabled(btnEnable);
        if (!btnEnable) {
            this.lblCall.setText(I18NUtil.getString("call_btn_callout"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.lblCall.setText(I18NUtil.getString("call_btn_callout_line1_full"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.lblCall.setText(I18NUtil.getString("call_btn_callout_line2_full"));
        } else {
            this.lblCall.setText(I18NUtil.getString("call_btn_callout"));
        }
    }
}

