/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.client.phone.ImageReceiver;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class MjpegReader
extends Thread {
    private static final String CONTENT_TYPE = "Content-type: image/jpeg";
    private static final String CONTENT_LENGTH = "Content-Length: ";
    private String demoUrl = "http://123.192.148.8:1003/cgi-bin/guest/Video.cgi?authorization=YWRtaW46YWRtaW4xMjM0&media=MJPEG&profile=4";
    private ImageReceiver mImageReceiver;
    private AtomicBoolean mTerminated = new AtomicBoolean(false);
    private HttpClient mHttpClient;

    public MjpegReader(ImageReceiver imageReceiver) {
        this.mImageReceiver = imageReceiver;
    }

    public void terminate() {
        this.mTerminated.set(true);
    }

    protected boolean isTerminate() {
        return this.mTerminated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream inputStream = null;
        try {
            this.mHttpClient = new DefaultHttpClient();
            HttpGet httpGet = new HttpGet(this.demoUrl);
            HttpResponse response = this.mHttpClient.execute((HttpUriRequest)httpGet);
            StatusLine statusLine = response.getStatusLine();
            Log.i(CommonUtil.class.getSimpleName(), "StatusLine:" + String.valueOf(statusLine));
            HttpEntity entity = response.getEntity();
            String[] content_type = entity.getContentType().getValue().split("\\s*;\\s*");
            Log.i("Content-type '{}'", entity.getContentType().getValue());
            if (!"multipart/x-mixed-replace".equals(content_type[0])) {
                httpGet.abort();
                throw new IOException("Content-type is not multipart/x-mixed-replace but " + content_type[0]);
            }
            if (!content_type[1].matches("^boundary\\s*=\\s*.+$")) {
                httpGet.abort();
                throw new IOException("Content-type should have boundary option");
            }
            inputStream = entity.getContent();
            while (!this.isTerminate()) {
                try {
                    byte[] imageBytes = MjpegReader.retrieveNextImage(inputStream);
                    this.mImageReceiver.onImageReceived(imageBytes);
                }
                catch (Throwable e) {
                    System.err.println("failed stream read: " + String.valueOf(e));
                }
            }
        }
        catch (Throwable e) {
            Log.i(MjpegReader.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException httpGet) {}
        }
    }

    private static byte[] retrieveNextImage(InputStream urlStream) throws IOException {
        int currByte = -1;
        Object header = null;
        boolean captureContentLength = false;
        StringWriter contentLengthStringWriter = new StringWriter(128);
        StringWriter headerWriter = new StringWriter(128);
        int contentLength = 0;
        while ((currByte = urlStream.read()) > -1) {
            if (captureContentLength) {
                if (currByte == 10 || currByte == 13) {
                    contentLength = Integer.parseInt(contentLengthStringWriter.toString());
                    break;
                }
                contentLengthStringWriter.write(currByte);
                continue;
            }
            headerWriter.write(currByte);
            String tempString = headerWriter.toString();
            int indexOf = tempString.indexOf(CONTENT_LENGTH);
            if (indexOf <= 0) continue;
            captureContentLength = true;
        }
        while (urlStream.read() != 255) {
        }
        byte[] imageBytes = new byte[contentLength + 1];
        imageBytes[0] = -1;
        int numRead = 0;
        for (int offset = 1; offset < imageBytes.length && (numRead = urlStream.read(imageBytes, offset, imageBytes.length - offset)) >= 0; offset += numRead) {
        }
        return imageBytes;
    }
}

