/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GradientPanel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.phone.BasePhonePanel;
import com.blisscloud.ezuc.client.phone.PhonePanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ThumbnailCache;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public class PhoneIncomePanel
extends BasePhonePanel {
    private static final long serialVersionUID = 6031203066815647921L;
    public static final String VIEW_ID = "PhoneIncomePanel";
    private static final int PHOTO_SIZE = 170;
    private static final String EMPTY_STR = " ";
    private static final Dimension NAME_SIZE = new Dimension(650, 25);
    private static final Dimension MAX_NAME_SIZE = new Dimension(650, 50);
    private static final int PHOTO_GAP = 30;
    private JLabel lblTitle;
    private JTextField phoneOtherName;
    private JTextField phoneGivenName;
    private JTextField phoneIncomeNumber;
    private JPanel toolbarIncoming;
    private RoundedCornerLabel btnAnswer;
    private RoundedCornerLabel btnRefuse;
    private PhoneIncomeBroadcastReceiver phoneReceiver;
    private IntentFilter intentFilter;
    private boolean isClickPhoneButton;
    private int isClickPhoneButtonCount;
    private PersonalPhoto phoneOtherPhoto;
    private JTextArea callAttrPanel;
    private JPopupMenu popupMenu;
    private JTextComponent selectedTextField;
    private int currentPhoneIndex;
    private Timer timer = new Timer("PhoneIncomePanelTimer");

    public PhoneIncomePanel() {
        this.initGUI();
        this.initPopupMenu();
        this.phoneReceiver = new PhoneIncomeBroadcastReceiver();
        this.intentFilter = new IntentFilter();
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_STATE_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_INFO_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.AGENT_STATE_CHANGED");
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            GradientPanel bgPanel = new GradientPanel(1, new Color(0x808080), new Color(0));
            this.add((Component)bgPanel, "Center");
            bgPanel.setLayout(new GridBagLayout());
            int y = 0;
            JPanel gap = new JPanel();
            gap.setOpaque(false);
            bgPanel.add((Component)gap, new GridBagConstraints(0, y++, 1, 1, 1.0, 2.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
            this.lblTitle = new JLabel();
            this.lblTitle.setFont(UIConstants.FONT_18_BOLD);
            this.lblTitle.setText(I18NUtil.getString("call_label_ringing"));
            this.lblTitle.setForeground(Color.WHITE);
            bgPanel.add((Component)this.lblTitle, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            JPanel topPanel = new JPanel();
            topPanel.setOpaque(false);
            topPanel.setLayout(new BoxLayout(topPanel, 0));
            JTextArea callAttrPanel1 = new JTextArea();
            callAttrPanel1.setPreferredSize(new Dimension(170, 170));
            callAttrPanel1.setMaximumSize(new Dimension(170, 170));
            callAttrPanel1.setMinimumSize(new Dimension(170, 170));
            callAttrPanel1.setOpaque(false);
            callAttrPanel1.setForeground(Color.WHITE);
            callAttrPanel1.setFont(UIConstants.FONT_14_PLAIN);
            callAttrPanel1.setBorder(null);
            callAttrPanel1.setEditable(false);
            topPanel.add(callAttrPanel1);
            topPanel.add(Box.createRigidArea(new Dimension(30, 0)));
            this.phoneOtherPhoto = this.getCallerPhoto();
            topPanel.add(this.phoneOtherPhoto);
            topPanel.add(Box.createRigidArea(new Dimension(30, 0)));
            this.callAttrPanel = new JTextArea();
            this.callAttrPanel.setPreferredSize(new Dimension(170, 170));
            this.callAttrPanel.setMaximumSize(new Dimension(170, 170));
            this.callAttrPanel.setMinimumSize(new Dimension(170, 170));
            this.callAttrPanel.setOpaque(false);
            this.callAttrPanel.setForeground(Color.WHITE);
            this.callAttrPanel.setFont(UIConstants.FONT_14_PLAIN);
            this.callAttrPanel.setBorder(null);
            this.callAttrPanel.setEditable(false);
            this.callAttrPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhoneIncomePanel.this.callAttrPanel.getSelectedText()))) {
                        PhoneIncomePanel.this.selectedTextField = PhoneIncomePanel.this.callAttrPanel;
                        PhoneIncomePanel.this.popupMenu.show(PhoneIncomePanel.this.callAttrPanel, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhoneIncomePanel.this.callAttrPanel.selectAll();
                    }
                }
            });
            topPanel.add(this.callAttrPanel);
            bgPanel.add((Component)topPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.phoneOtherName = new JTextField();
            this.phoneOtherName.setHorizontalAlignment(0);
            this.phoneOtherName.setFont(UIConstants.FONT_16_BOLD);
            this.phoneOtherName.setText("xxx");
            this.phoneOtherName.setForeground(Color.LIGHT_GRAY);
            this.phoneOtherName.setBorder(null);
            this.phoneOtherName.setOpaque(false);
            this.phoneOtherName.setEditable(false);
            this.phoneOtherName.setMaximumSize(MAX_NAME_SIZE);
            this.phoneOtherName.setMinimumSize(NAME_SIZE);
            this.phoneOtherName.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhoneIncomePanel.this.phoneOtherName.getSelectedText()))) {
                        PhoneIncomePanel.this.selectedTextField = PhoneIncomePanel.this.phoneOtherName;
                        PhoneIncomePanel.this.popupMenu.show(PhoneIncomePanel.this.phoneOtherName, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhoneIncomePanel.this.phoneOtherName.selectAll();
                    }
                }
            });
            bgPanel.add((Component)this.phoneOtherName, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.25, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.phoneGivenName = new JTextField();
            this.phoneGivenName.setHorizontalAlignment(0);
            this.phoneGivenName.setFont(UIConstants.FONT_16_BOLD);
            this.phoneGivenName.setText("Albert Chiou");
            this.phoneGivenName.setForeground(Color.LIGHT_GRAY);
            this.phoneGivenName.setBorder(null);
            this.phoneGivenName.setOpaque(false);
            this.phoneGivenName.setEditable(false);
            this.phoneGivenName.setMaximumSize(MAX_NAME_SIZE);
            this.phoneGivenName.setMinimumSize(NAME_SIZE);
            this.phoneGivenName.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhoneIncomePanel.this.phoneGivenName.getSelectedText()))) {
                        PhoneIncomePanel.this.selectedTextField = PhoneIncomePanel.this.phoneGivenName;
                        PhoneIncomePanel.this.popupMenu.show(PhoneIncomePanel.this.phoneGivenName, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhoneIncomePanel.this.phoneGivenName.selectAll();
                    }
                }
            });
            bgPanel.add((Component)this.phoneGivenName, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.25, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.phoneIncomeNumber = new JTextField();
            this.phoneIncomeNumber.setHorizontalAlignment(0);
            this.phoneIncomeNumber.setFont(UIConstants.FONT_16_BOLD);
            this.phoneIncomeNumber.setText("613");
            this.phoneIncomeNumber.setForeground(Color.LIGHT_GRAY);
            this.phoneIncomeNumber.setBorder(null);
            this.phoneIncomeNumber.setOpaque(false);
            this.phoneIncomeNumber.setEditable(false);
            this.phoneIncomeNumber.setMaximumSize(MAX_NAME_SIZE);
            this.phoneIncomeNumber.setMinimumSize(NAME_SIZE);
            this.phoneIncomeNumber.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhoneIncomePanel.this.phoneIncomeNumber.getSelectedText()))) {
                        PhoneIncomePanel.this.selectedTextField = PhoneIncomePanel.this.phoneIncomeNumber;
                        PhoneIncomePanel.this.popupMenu.show(PhoneIncomePanel.this.phoneIncomeNumber, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhoneIncomePanel.this.phoneIncomeNumber.selectAll();
                    }
                }
            });
            bgPanel.add((Component)this.phoneIncomeNumber, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.25, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            gap = new JPanel();
            gap.setOpaque(false);
            bgPanel.add((Component)gap, new GridBagConstraints(0, y++, 1, 1, 1.0, 2.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
            this.toolbarIncoming = new JPanel();
            FlowLayout toolbarIncomingLayout = new FlowLayout();
            this.toolbarIncoming.setLayout(toolbarIncomingLayout);
            this.toolbarIncoming.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
            this.toolbarIncoming.setMinimumSize(new Dimension(620, 84));
            this.toolbarIncoming.setOpaque(false);
            this.btnRefuse = new RoundedCornerLabel(I18NUtil.getString("call_btn_reject"), UIConstants.ICON_HANGUP, UIConstants.BACKGROUND_HANGUP_NORMAL, UIConstants.BACKGROUND_HANGUP_OVER, UIConstants.BACKGROUND_HANGUP_PRESSED);
            this.btnRefuse.setEnabled(true);
            Dimension size = new Dimension(120, 54);
            this.btnRefuse.setMinimumSize(size);
            this.btnRefuse.setArc(50);
            this.btnRefuse.setPreferredSize(size);
            this.btnRefuse.setCursor(new Cursor(12));
            this.btnRefuse.setHorizontalAlignment(0);
            this.btnRefuse.setFont(UIConstants.FONT_18_PLAIN);
            this.toolbarIncoming.add(this.btnRefuse);
            this.btnRefuse.setForeground(Color.WHITE);
            this.btnRefuse.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (PhoneIncomePanel.this.btnRefuse.isEnabled()) {
                        PhoneIncomePanel.this.onClickHangup();
                    }
                }
            });
            JLabel btnMiddle = new JLabel();
            btnMiddle.setText("");
            Dimension size2 = new Dimension(30, 54);
            btnMiddle.setMinimumSize(size2);
            btnMiddle.setPreferredSize(size2);
            this.toolbarIncoming.add(btnMiddle);
            this.btnAnswer = new RoundedCornerLabel(I18NUtil.getString("call_btn_answer"), UIConstants.ICON_DIAL, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            this.btnAnswer.setEnabled(true);
            size = new Dimension(120, 54);
            this.btnAnswer.setMinimumSize(size);
            this.btnAnswer.setArc(50);
            this.btnAnswer.setFont(UIConstants.FONT_18_PLAIN);
            this.btnAnswer.setPreferredSize(size);
            this.btnAnswer.setCursor(new Cursor(12));
            this.btnAnswer.setHorizontalAlignment(0);
            this.toolbarIncoming.add(this.btnAnswer);
            this.btnAnswer.setForeground(Color.WHITE);
            this.btnAnswer.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (PhoneIncomePanel.this.btnAnswer.isEnabled()) {
                        PhoneIncomePanel.this.onClickAnswer();
                    }
                }
            });
            bgPanel.add((Component)this.toolbarIncoming, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.5, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            gap = new JPanel();
            gap.setOpaque(false);
            bgPanel.add((Component)gap, new GridBagConstraints(0, y++, 1, 1, 1.0, 2.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initPopupMenu() {
        JMenuItem miCopy = new JMenuItem();
        miCopy.setText(I18NUtil.getString("common_btn_copy"));
        miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (PhoneIncomePanel.this.selectedTextField != null) {
                    String selection = PhoneIncomePanel.this.selectedTextField.getSelectedText();
                    StringSelection stringSelection = new StringSelection(selection);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(miCopy);
    }

    @Override
    public String getViewId() {
        return VIEW_ID;
    }

    @Override
    public void onShow(Intent intent) {
        Log.i(PhonePanel.class.getSimpleName(), "PhoneIncomePanel onShow");
        this.isClickPhoneButton = false;
        this.isClickPhoneButtonCount = 0;
        if (this.phoneReceiver != null) {
            UCChatClient.context.registerReceiver(this.phoneReceiver, this.intentFilter);
        }
        this.initDislplay();
        this.doAction();
        if (PreferencesUtil.isAutoAnswered()) {
            this.timer.schedule((TimerTask)new UCTimerTask(){

                @Override
                public void doRun() {
                    PhoneIncomePanel.this.onClickAnswer();
                }
            }, 1500L);
        }
    }

    @Override
    public void onHide() {
        Log.i(PhonePanel.class.getSimpleName(), "PhoneIncomePanel onHide");
        if (this.phoneReceiver != null) {
            UCChatClient.context.unregisterReceiver(this.phoneReceiver);
        }
    }

    @Override
    public void onClose() {
        if (this.phoneReceiver != null) {
            UCChatClient.context.unregisterReceiver(this.phoneReceiver);
        }
    }

    private void initDislplay() {
        this.phoneOtherName.setText(EMPTY_STR);
        this.phoneGivenName.setText(EMPTY_STR);
        this.phoneIncomeNumber.setText(EMPTY_STR);
    }

    @Override
    protected void doAction() {
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.currentPhoneIndex);
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo == null) {
            Log.e(PhoneIncomePanel.class.getSimpleName(), "line info is null, please check .... ");
            return;
        }
        String[] title = lineInfo.getDispName();
        if (StringUtils.isNotBlank((CharSequence)title[0])) {
            this.phoneOtherName.setText(title[0]);
            this.phoneOtherName.setVisible(true);
        } else {
            this.phoneOtherName.setVisible(false);
        }
        if (StringUtils.isNotBlank((CharSequence)title[1])) {
            this.phoneGivenName.setText(title[1]);
            this.phoneGivenName.setVisible(true);
        } else {
            this.phoneGivenName.setVisible(false);
        }
        if (StringUtils.isNotBlank((CharSequence)title[2])) {
            this.phoneIncomeNumber.setText(title[2]);
            this.phoneIncomeNumber.setVisible(true);
        } else {
            this.phoneIncomeNumber.setVisible(false);
        }
        Activity ctx = UCChatClient.context;
        if (lineInfo.getType() == 1) {
            LiteContact contact = ContactManager.getContact((Context)ctx, lineInfo.getJid());
            this.fetchPhoto(contact);
        } else if (lineInfo.getType() == 2) {
            Image img = UIConstants.ICON_PHONE_PUBLIC_PHONE200.getImage();
            this.setCallerPhoto(img);
        } else if (lineInfo.getType() == 6) {
            long contactId = JidUtil.trimExternalContactId(lineInfo.getJid());
            LiteMyContact myContact = UCDBExternalContact.getExternalContactById(UCChatClient.context, contactId);
            this.fetchPhoto(myContact);
        } else if (lineInfo.getType() == 8) {
            this.setCallerPhoto(UIConstants.ICON_USER_NONAME.getImage());
        } else {
            this.setCallerPhoto(ThumbnailCache.getInstance().getDefaultImage(ctx));
        }
        if (PreferencesUtil.isDisplayCallAttachedData() && WebAgent.callAttachData != null) {
            this.callAttrPanel.setText(WebAgent.getCallAttachDataStr());
        } else {
            this.callAttrPanel.setText("");
        }
    }

    public void onClickHangup() {
        ++this.isClickPhoneButtonCount;
        if (this.isClickPhoneButton) {
            if (this.isClickPhoneButtonCount >= 5) {
                ToastUtil.debug(UCChatClient.context, "XPhoneSIP Resetting!!", 20);
                UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhoneIncomePanel();
            }
            return;
        }
        this.isClickPhoneButton = true;
        PhoneAgent.getInstance().rejectLine(this.currentPhoneIndex);
        this.timer.schedule((TimerTask)new UCTimerTask(this){

            @Override
            public void doRun() {
                UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhoneIncomePanel();
            }
        }, 1000L);
    }

    public void onClickAnswer() {
        ++this.isClickPhoneButtonCount;
        if (this.isClickPhoneButton) {
            if (this.isClickPhoneButtonCount >= 5) {
                ToastUtil.debug(UCChatClient.context, "XPhoneSIP Resetting!!", 20);
                UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhoneIncomePanel();
            }
            return;
        }
        this.isClickPhoneButton = true;
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.currentPhoneIndex);
        if (callLine.getState() == CallState.INCOMING_CALL) {
            PhoneAgent.getInstance().answerLine(this.currentPhoneIndex);
            UCChatClient.getInstance().getMainPanel().getViewContainer().showPhonePanel(0);
        }
    }

    protected void onMatchContact(String jid) {
        LiteContact contact;
        if (TextUtils.isNotBlank((CharSequence)jid) && (contact = ContactManager.getContact((Context)UCChatClient.context, jid.trim())) != null) {
            this.phoneOtherName.setText(ContactManager.getNonEnglishName(contact));
            this.phoneGivenName.setText(ContactManager.getFullEnglishName(contact));
            this.fetchPhoto(contact);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new PhoneIncomePanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setMinimumSize(new Dimension(1120, 600));
        frame.setVisible(true);
    }

    public void setCurrentPhoneIndex(int currentPhoneIndex) {
        this.currentPhoneIndex = currentPhoneIndex;
    }

    public int getCurrentPhoneIndex() {
        return this.currentPhoneIndex;
    }

    private class PhoneIncomeBroadcastReceiver
    extends BroadcastReceiver {
        private PhoneIncomeBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.i(PhoneIncomePanel.class.getSimpleName(), "PhoneIncomeActivity\u6536\u5230\u5ee3\u64ad\uff1a" + intent.getAction());
            if (intent.getAction().equals("ezuc.intent.action.event.PHONE_STATE_CHANGED")) {
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhoneIncomePanel.this.currentPhoneIndex);
                switch (callLine.getState()) {
                    case IDLE: {
                        UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhoneIncomePanel();
                        break;
                    }
                    case INCALL: {
                        UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhoneIncomePanel(callLine.getLineInfo());
                        break;
                    }
                }
            } else if (intent.getAction().equals("ezuc.intent.action.event.PHONE_INFO_CHANGED")) {
                PhoneIncomePanel.this.doAction();
            } else if (intent.getAction().equals("ezuc.intent.action.event.AGENT_STATE_CHANGED")) {
                PhoneIncomePanel.this.doAction();
            } else if (intent.getAction().equals("ezuc.intent.action.event.UC_NETWORK_DISCONNECTED") || intent.getAction().equals("ezuc.intent.action.event.UC_NETWORK_CHANGED")) {
                UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhoneIncomePanel();
            }
        }
    }
}

