/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.component.GradientPanel;
import com.blisscloud.ezuc.client.component.HighlightToggleButton;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.phone.BasePhonePanel;
import com.blisscloud.ezuc.client.phone.ConferenceDialog;
import com.blisscloud.ezuc.client.phone.ImageReceiver;
import com.blisscloud.ezuc.client.phone.KeypadPanelForDtmf;
import com.blisscloud.ezuc.client.phone.MjpegReader;
import com.blisscloud.ezuc.client.phone.TransferDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ThumbnailCache;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Handler;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;

public class PhonePanel
extends BasePhonePanel {
    private static final long serialVersionUID = 4975577396828558640L;
    private static final int PHOTO_SIZE = 170;
    private static final String EMPTY_STR = " ";
    private static final Dimension NAME_SIZE = new Dimension(650, 25);
    private static final Dimension MAX_NAME_SIZE = new Dimension(650, 50);
    private static final int PHOTO_GAP = 30;
    private static final boolean TEST_FLAG = false;
    public static final String VIEW_PREFIX = "PhonePanel";
    private static final int MENU_CLICK_TIP_PERIOD = 3000;
    private JProgressBar micLevelBar;
    private PhoneBroadcastReceiver phoneReceiver;
    private IntentFilter intentFilter;
    private JTextArea callAttrPanel;
    private JLabel callTimer;
    private JTextField phoneOtherName;
    private JTextField phoneGivenName;
    private JTextField phoneOtherExt;
    private JLabel phoneClickText;
    private JPanel toolbarTalking;
    private JPanel toolbarCommand;
    private HighlightToggleButton lblGotoChatroom;
    private JPanel jPanel3;
    private HighlightToggleButton phoneMute;
    private HighlightToggleButton phoneHold;
    private HighlightToggleButton phoneRecording;
    private HighlightToggleButton phoneKeypad;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel phoneHangup;
    private JLabel phoneTransfer;
    private JLabel phoneMeeting;
    private PersonalPhoto phoneOtherPhoto;
    private boolean showHoldMsg = false;
    private boolean showMuteMsg = false;
    private boolean showRecordingMsg = false;
    private NewCallCheckTask newCallCheckTask = null;
    private HangupCleanUpTask hangupCleanUpTask = null;
    private Timer phonePanelTimer = new Timer("PhonePanelTimer", true);
    private Handler callTimeHandler = new Handler("CallTimeHandler3");
    private Runnable callTimeTimer = new Runnable(){

        @Override
        public void run() {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
            PhoneLineInfo info = callLine.getLineInfo();
            if (info != null) {
                String dislTime = info.getCallDuration();
                PhonePanel.this.callTimer.setText(dislTime);
                PhonePanel.this.callTimeHandler.postDelayed(this, 1000L);
            }
        }
    };
    private Handler clickTextHandler = new Handler("ClickTextHandler");
    private Runnable clickTextTimer = new Runnable(){

        @Override
        public void run() {
            PhonePanel.this.phoneClickText.setText(PhonePanel.EMPTY_STR);
        }
    };
    private Runnable clickTextTimer2 = new Runnable(){

        @Override
        public void run() {
            PhonePanel.this.phoneClickText.setText(I18NUtil.getString("setting_notice_conf_mute_first_time"));
            PhonePanel.this.clickTextHandler.postDelayed(PhonePanel.this.clickTextTimer, 3000L);
        }
    };
    private int mPhoneLineIndex;
    private PhoneLineInfo mLineInfo;
    private JLayeredPane layeredPane;
    private KeypadPanelForDtmf menu;
    private boolean menuOn = false;
    private MjpegReader mMjpegReader;
    private JPopupMenu popupMenu;
    private JTextComponent selectedTextField;
    private TransferDialog transferDialog;
    private ConferenceDialog conferenceDialog;

    public PhonePanel(int phoneLineIndex) {
        this.mPhoneLineIndex = phoneLineIndex;
        this.initGUI();
        this.initMenu();
        this.initPopupMenu();
    }

    private void initMenu() {
        try {
            this.menu = new KeypadPanelForDtmf();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initPopupMenu() {
        JMenuItem miCopy = new JMenuItem();
        miCopy.setText(I18NUtil.getString("common_btn_copy"));
        miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (PhonePanel.this.selectedTextField != null) {
                    String selection = PhonePanel.this.selectedTextField.getSelectedText();
                    StringSelection stringSelection = new StringSelection(selection);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(miCopy);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.layeredPane = new JLayeredPane();
            this.layeredPane.setLayout(new GridBagLayout());
            this.add(this.layeredPane);
            GradientPanel bgPanel = new GradientPanel(1, new Color(0x808080), new Color(0));
            this.layeredPane.add(bgPanel, new GridBagConstraints(0, 0, 6, 6, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0), 1);
            bgPanel.setLayout(new GridBagLayout());
            int y = 0;
            JPanel gap = new JPanel();
            gap.setOpaque(false);
            bgPanel.add((Component)gap, new GridBagConstraints(0, y++, 1, 1, 1.0, 2.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
            this.callTimer = new JLabel();
            this.callTimer.setFont(UIConstants.FONT_16_BOLD);
            this.callTimer.setText("00:00");
            this.callTimer.setForeground(Color.LIGHT_GRAY);
            bgPanel.add((Component)this.callTimer, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
            JPanel topPanel = new JPanel();
            topPanel.setOpaque(false);
            topPanel.setLayout(new BoxLayout(topPanel, 0));
            JTextArea callAttrPanel1 = new JTextArea();
            callAttrPanel1.setPreferredSize(new Dimension(170, 170));
            callAttrPanel1.setMaximumSize(new Dimension(170, 170));
            callAttrPanel1.setMinimumSize(new Dimension(170, 170));
            callAttrPanel1.setOpaque(false);
            callAttrPanel1.setForeground(Color.WHITE);
            callAttrPanel1.setFont(UIConstants.FONT_14_PLAIN);
            callAttrPanel1.setBorder(null);
            callAttrPanel1.setEditable(false);
            topPanel.add(callAttrPanel1);
            topPanel.add(Box.createRigidArea(new Dimension(30, 0)));
            this.phoneOtherPhoto = this.getCallerPhoto();
            topPanel.add(this.phoneOtherPhoto);
            topPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.micLevelBar = new JProgressBar(1, 0, 100){

                @Override
                protected void paintComponent(Graphics g) {
                    int value = this.getValue();
                    int height = this.getHeight();
                    int fill = (int)((double)height * ((double)value / (double)this.getMaximum()));
                    g.setColor(Color.DARK_GRAY);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.RED);
                    g.fillRect(0, height - fill, this.getWidth(), fill);
                }
            };
            this.micLevelBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            Dimension narrowSize = new Dimension(6, 130);
            this.micLevelBar.setPreferredSize(narrowSize);
            this.micLevelBar.setMinimumSize(narrowSize);
            this.micLevelBar.setMaximumSize(narrowSize);
            this.micLevelBar.setForeground(Color.RED);
            this.micLevelBar.setBackground(Color.DARK_GRAY);
            this.micLevelBar.setStringPainted(false);
            topPanel.add(this.micLevelBar);
            topPanel.add(Box.createRigidArea(new Dimension(20, 0)));
            this.callAttrPanel = new JTextArea();
            this.callAttrPanel.setPreferredSize(new Dimension(170, 170));
            this.callAttrPanel.setMaximumSize(new Dimension(170, 170));
            this.callAttrPanel.setMinimumSize(new Dimension(170, 170));
            this.callAttrPanel.setOpaque(false);
            this.callAttrPanel.setForeground(Color.WHITE);
            this.callAttrPanel.setFont(UIConstants.FONT_14_PLAIN);
            this.callAttrPanel.setBorder(null);
            this.callAttrPanel.setEditable(false);
            this.callAttrPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhonePanel.this.callAttrPanel.getSelectedText()))) {
                        PhonePanel.this.selectedTextField = PhonePanel.this.callAttrPanel;
                        PhonePanel.this.popupMenu.show(PhonePanel.this.callAttrPanel, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhonePanel.this.callAttrPanel.selectAll();
                    }
                }
            });
            topPanel.add(this.callAttrPanel);
            bgPanel.add((Component)topPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.phoneOtherName = new JTextField();
            this.phoneOtherName.setHorizontalAlignment(0);
            this.phoneOtherName.setFont(UIConstants.FONT_16_BOLD);
            this.phoneOtherName.setText("xxx");
            this.phoneOtherName.setForeground(Color.LIGHT_GRAY);
            this.phoneOtherName.setBackground(Color.BLUE);
            this.phoneOtherName.setBorder(null);
            this.phoneOtherName.setOpaque(false);
            this.phoneOtherName.setEditable(false);
            this.phoneOtherName.setMaximumSize(MAX_NAME_SIZE);
            this.phoneOtherName.setMinimumSize(NAME_SIZE);
            this.phoneOtherName.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhonePanel.this.phoneOtherName.getSelectedText()))) {
                        PhonePanel.this.selectedTextField = PhonePanel.this.phoneOtherName;
                        PhonePanel.this.popupMenu.show(PhonePanel.this.phoneOtherName, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhonePanel.this.phoneOtherName.selectAll();
                    }
                }
            });
            bgPanel.add((Component)this.phoneOtherName, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.25, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.phoneGivenName = new JTextField();
            this.phoneGivenName.setHorizontalAlignment(0);
            this.phoneGivenName.setFont(UIConstants.FONT_16_BOLD);
            this.phoneGivenName.setText("Albert Chiou");
            this.phoneGivenName.setForeground(Color.LIGHT_GRAY);
            this.phoneGivenName.setBackground(Color.BLUE);
            this.phoneGivenName.setBorder(null);
            this.phoneGivenName.setOpaque(false);
            this.phoneGivenName.setEditable(false);
            this.phoneGivenName.setMaximumSize(MAX_NAME_SIZE);
            this.phoneGivenName.setMinimumSize(NAME_SIZE);
            this.phoneGivenName.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhonePanel.this.phoneGivenName.getSelectedText()))) {
                        PhonePanel.this.selectedTextField = PhonePanel.this.phoneGivenName;
                        PhonePanel.this.popupMenu.show(PhonePanel.this.phoneGivenName, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhonePanel.this.phoneGivenName.selectAll();
                    }
                }
            });
            bgPanel.add((Component)this.phoneGivenName, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.25, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.phoneOtherExt = new JTextField();
            this.phoneOtherExt.setHorizontalAlignment(0);
            this.phoneOtherExt.setFont(UIConstants.FONT_16_BOLD);
            this.phoneOtherExt.setText("613");
            this.phoneOtherExt.setForeground(Color.LIGHT_GRAY);
            this.phoneOtherExt.setBackground(Color.BLUE);
            this.phoneOtherExt.setBorder(null);
            this.phoneOtherExt.setOpaque(false);
            this.phoneOtherExt.setEditable(false);
            this.phoneOtherExt.setMaximumSize(MAX_NAME_SIZE);
            this.phoneOtherExt.setMinimumSize(NAME_SIZE);
            this.phoneOtherExt.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = PhonePanel.this.phoneOtherExt.getSelectedText()))) {
                        PhonePanel.this.selectedTextField = PhonePanel.this.phoneOtherExt;
                        PhonePanel.this.popupMenu.show(PhonePanel.this.phoneOtherExt, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        PhonePanel.this.phoneOtherExt.selectAll();
                    }
                }
            });
            bgPanel.add((Component)this.phoneOtherExt, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.25, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
            JPanel toolBarFullPanel = new JPanel();
            toolBarFullPanel.setLayout(new GridBagLayout());
            toolBarFullPanel.setOpaque(false);
            this.phoneClickText = new JLabel();
            this.phoneClickText.setText(EMPTY_STR);
            this.phoneClickText.setFont(UIConstants.FONT_14_PLAIN);
            this.phoneClickText.setForeground(Color.LIGHT_GRAY);
            toolBarFullPanel.add((Component)this.phoneClickText, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.toolbarTalking = new JPanel();
            FlowLayout toolbarTalkingLayout = new FlowLayout();
            toolbarTalkingLayout.setHgap(12);
            this.toolbarTalking.setLayout(toolbarTalkingLayout);
            this.toolbarTalking.setMinimumSize(new Dimension(650, 80));
            toolBarFullPanel.add((Component)this.toolbarTalking, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
            bgPanel.add((Component)toolBarFullPanel, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.5, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.toolbarTalking.setOpaque(false);
            this.jPanel3 = new RoundedCornerPanel(6, 1.0f, new Color(90, 91, 91)){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    int count = this.getComponentCount();
                    if (count > 1) {
                        g.setColor(new Color(90, 91, 91));
                        for (int i = 1; i < count; ++i) {
                            Component comp = this.getComponent(i);
                            if (!comp.isVisible()) continue;
                            g.drawLine(comp.getX() - 1, 0, comp.getX() - 1, this.getHeight());
                        }
                    }
                }
            };
            this.toolbarTalking.add(this.jPanel3);
            FlowLayout jPanel3Layout = new FlowLayout();
            jPanel3Layout.setVgap(0);
            jPanel3Layout.setHgap(1);
            this.jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.jPanel3.setOpaque(false);
            this.jPanel3.setLayout(jPanel3Layout);
            this.lblGotoChatroom = new HighlightToggleButton(UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_TO, UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_FROM);
            this.jPanel3.add(this.lblGotoChatroom);
            this.lblGotoChatroom.setToolTipText(I18NUtil.getString("chatroom_btn_switch_to_chat_view"));
            this.lblGotoChatroom.setIcon(UIConstants.ICON_CHAT_NORMAL);
            this.lblGotoChatroom.setText(I18NUtil.getString("call_back_to_chatroom"));
            this.lblGotoChatroom.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.lblGotoChatroom.setHorizontalAlignment(0);
            this.lblGotoChatroom.setHorizontalTextPosition(0);
            this.lblGotoChatroom.setVerticalTextPosition(3);
            this.lblGotoChatroom.setPreferredSize(new Dimension(64, 64));
            this.lblGotoChatroom.setCursor(new Cursor(12));
            this.lblGotoChatroom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PhonePanel.this.onClickChatroomButton();
                }
            });
            this.lblGotoChatroom.getInputMap(2).put(KeyStroke.getKeyStroke(67, 512), "Alt+C");
            this.lblGotoChatroom.getActionMap().put("Alt+C", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhonePanel.this.onClickChatroomButton();
                }
            });
            this.phoneMute = new HighlightToggleButton(UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_TO, UIConstants.COLOR_SELECTED_ITEM_FROM, UIConstants.COLOR_SELECTED_ITEM_TO);
            this.jPanel3.add(this.phoneMute);
            this.phoneMute.setIcon(UIConstants.ICON_MUTE_ON);
            this.phoneMute.setSelectedIcon(UIConstants.ICON_MUTE_ON);
            this.phoneMute.setDisabledIcon(UIConstants.ICON_MUTE_OFF);
            this.phoneMute.setText(I18NUtil.getString("call_btn_mute"));
            this.phoneMute.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneMute.setHorizontalAlignment(0);
            this.phoneMute.setHorizontalTextPosition(0);
            this.phoneMute.setVerticalTextPosition(3);
            this.phoneMute.setPreferredSize(new Dimension(64, 64));
            this.phoneMute.setCursor(new Cursor(12));
            this.phoneMute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PhonePanel.this.onClickMuteButton();
                }
            });
            this.phoneMute.getInputMap(2).put(KeyStroke.getKeyStroke(77, 512), "Alt+M");
            this.phoneMute.getActionMap().put("Alt+M", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhonePanel.this.onClickMuteButton();
                }
            });
            this.phoneRecording = new HighlightToggleButton(UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_TO, UIConstants.COLOR_SELECTED_ITEM_FROM, UIConstants.COLOR_SELECTED_ITEM_TO);
            this.jPanel3.add(this.phoneRecording);
            this.phoneRecording.setIcon(UIConstants.ICON_RECORDING_ON);
            this.phoneRecording.setSelectedIcon(UIConstants.ICON_RECORDING_ON);
            this.phoneRecording.setDisabledIcon(UIConstants.ICON_RECORDING_OFF);
            this.phoneRecording.setText(I18NUtil.getString("call_btn_record"));
            this.phoneRecording.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneRecording.setHorizontalAlignment(0);
            this.phoneRecording.setHorizontalTextPosition(0);
            this.phoneRecording.setVerticalTextPosition(3);
            this.phoneRecording.setPreferredSize(new Dimension(64, 64));
            this.phoneRecording.setCursor(new Cursor(12));
            this.phoneRecording.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PhonePanel.this.onClickRecording();
                }
            });
            this.phoneRecording.getInputMap(2).put(KeyStroke.getKeyStroke(82, 512), "Alt+R");
            this.phoneRecording.getActionMap().put("Alt+R", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhonePanel.this.onClickRecording();
                }
            });
            this.phoneHold = new HighlightToggleButton(UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_TO, UIConstants.COLOR_SELECTED_ITEM_FROM, UIConstants.COLOR_SELECTED_ITEM_TO);
            this.jPanel3.add(this.phoneHold);
            this.phoneHold.setIcon(UIConstants.ICON_HOLD_ON);
            this.phoneHold.setSelectedIcon(UIConstants.ICON_HOLD_ON);
            this.phoneHold.setDisabledIcon(UIConstants.ICON_HOLD_OFF);
            this.phoneHold.setText(I18NUtil.getString("call_btn_hold"));
            this.phoneHold.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneHold.setHorizontalAlignment(0);
            this.phoneHold.setHorizontalTextPosition(0);
            this.phoneHold.setVerticalTextPosition(3);
            this.phoneHold.setPreferredSize(new Dimension(64, 64));
            this.phoneHold.setCursor(new Cursor(12));
            this.phoneHold.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PhonePanel.this.onClickHoldButton();
                }
            });
            this.phoneHold.getInputMap(2).put(KeyStroke.getKeyStroke(72, 512), "Alt+H");
            this.phoneHold.getActionMap().put("Alt+H", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhonePanel.this.onClickHoldButton();
                }
            });
            this.phoneKeypad = new HighlightToggleButton(UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_TO, UIConstants.COLOR_SELECTED_ITEM_FROM, UIConstants.COLOR_SELECTED_ITEM_TO);
            this.jPanel3.add(this.phoneKeypad);
            this.phoneKeypad.setBorderPainted(false);
            this.phoneKeypad.setFocusPainted(false);
            this.phoneKeypad.setContentAreaFilled(false);
            this.phoneKeypad.setFont(UIConstants.FONT_12_PLAIN);
            this.phoneKeypad.setIcon(UIConstants.ICON_KEYPAD);
            this.phoneKeypad.setText(I18NUtil.getString("call_btn_keypad"));
            this.phoneKeypad.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneKeypad.setHorizontalAlignment(0);
            this.phoneKeypad.setHorizontalTextPosition(0);
            this.phoneKeypad.setVerticalTextPosition(3);
            this.phoneKeypad.setPreferredSize(new Dimension(64, 64));
            this.phoneKeypad.setCursor(new Cursor(12));
            this.phoneKeypad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PhonePanel.this.onClickKeyboardButton();
                }
            });
            this.phoneKeypad.getInputMap(2).put(KeyStroke.getKeyStroke(75, 512), "Alt+K");
            this.phoneKeypad.getActionMap().put("Alt+K", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhonePanel.this.onClickKeyboardButton();
                }
            });
            this.toolbarCommand = new JPanel();
            FlowLayout toolbarCommandLayout = new FlowLayout();
            toolbarCommandLayout.setHgap(12);
            this.toolbarCommand.setLayout(toolbarCommandLayout);
            this.toolbarCommand.setMinimumSize(new Dimension(650, 60));
            bgPanel.add((Component)this.toolbarCommand, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.toolbarCommand.setOpaque(false);
            this.phoneHangup = new JLabel();
            this.toolbarCommand.add(this.phoneHangup);
            this.phoneHangup.setToolTipText(I18NUtil.getString("call_btn_hangup"));
            this.phoneHangup.setIcon(UIConstants.ICON_ENDCALL_NORMAL);
            this.phoneHangup.setCursor(new Cursor(12));
            this.phoneHangup.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (PhonePanel.this.phoneHangup.isEnabled()) {
                        PhonePanel.this.phoneHangup.setIcon(UIConstants.ICON_ENDCALL_OVER);
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (PhonePanel.this.phoneHangup.isEnabled()) {
                        PhonePanel.this.phoneHangup.setIcon(UIConstants.ICON_ENDCALL_NORMAL);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (PhonePanel.this.phoneHangup.isEnabled()) {
                        PhonePanel.this.phoneHangup.setIcon(UIConstants.ICON_ENDCALL_CLICK);
                        PhonePanel.this.onClickHangup();
                    }
                }
            });
            this.jSeparator3 = new JSeparator();
            this.toolbarCommand.add(this.jSeparator3);
            this.jSeparator3.setOrientation(1);
            this.jSeparator3.setPreferredSize(Chatroom.SIZE_SEPARATOR);
            this.jSeparator3.setForeground(Chatroom.FOREGROUND_SEPARATOR);
            this.jSeparator3.setBackground(Chatroom.BACKGROUND_SEPARATOR);
            this.phoneTransfer = new JLabel();
            this.toolbarCommand.add(this.phoneTransfer);
            this.phoneTransfer.setToolTipText(I18NUtil.getString("call_btn_transfer"));
            this.phoneTransfer.setIcon(UIConstants.ICON_TRANSFER_NORMAL);
            this.phoneTransfer.setCursor(new Cursor(12));
            this.phoneTransfer.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (PhonePanel.this.phoneTransfer.isEnabled()) {
                        PhonePanel.this.phoneTransfer.setIcon(UIConstants.ICON_TRANSFER_OVER);
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (PhonePanel.this.phoneTransfer.isEnabled()) {
                        PhonePanel.this.phoneTransfer.setIcon(UIConstants.ICON_TRANSFER_NORMAL);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (PhonePanel.this.phoneTransfer.isEnabled()) {
                        PhonePanel.this.phoneTransfer.setIcon(UIConstants.ICON_TRANSFER_CLICK);
                        PhonePanel.this.onClickTransfer();
                    }
                }
            });
            this.jSeparator4 = new JSeparator();
            this.toolbarCommand.add(this.jSeparator4);
            this.jSeparator4.setOrientation(1);
            this.jSeparator4.setPreferredSize(Chatroom.SIZE_SEPARATOR);
            this.jSeparator4.setForeground(Chatroom.FOREGROUND_SEPARATOR);
            this.jSeparator4.setBackground(Chatroom.BACKGROUND_SEPARATOR);
            this.phoneMeeting = new JLabel();
            this.toolbarCommand.add(this.phoneMeeting);
            this.phoneMeeting.setToolTipText(I18NUtil.getString("call_btn_invite_full"));
            this.phoneMeeting.setIcon(UIConstants.ICON_MEETING_NORMAL);
            this.phoneMeeting.setCursor(new Cursor(12));
            this.phoneMeeting.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (PhonePanel.this.phoneMeeting.isEnabled()) {
                        PhonePanel.this.phoneMeeting.setIcon(UIConstants.ICON_MEETING_OVER);
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (PhonePanel.this.phoneMeeting.isEnabled()) {
                        PhonePanel.this.phoneMeeting.setIcon(UIConstants.ICON_MEETING_NORMAL);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (PhonePanel.this.phoneMeeting.isEnabled()) {
                        PhonePanel.this.phoneMeeting.setIcon(UIConstants.ICON_MEETING_CLICK);
                        PhonePanel.this.onClickInvite();
                    }
                }
            });
            gap = new JPanel();
            gap.setOpaque(false);
            bgPanel.add((Component)gap, new GridBagConstraints(0, y++, 1, 1, 1.0, 2.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getViewId() {
        return VIEW_PREFIX + this.mPhoneLineIndex;
    }

    @Override
    public void onShow(Intent intent) {
        Log.i(PhonePanel.class.getSimpleName(), "PhonePanel onShow");
        if (this.phoneReceiver != null) {
            UCChatClient.context.unregisterReceiver(this.phoneReceiver);
        }
        this.phoneReceiver = new PhoneBroadcastReceiver();
        this.intentFilter = new IntentFilter();
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_MUTE_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_RECORDING_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_STATE_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_INFO_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.UC_NETWORK_DISCONNECTED");
        this.intentFilter.addAction("ezuc.intent.action.event.UC_NETWORK_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.EXE_CALL_EMPLOYEE_FAIL");
        this.intentFilter.addAction("ezuc.intent.action.event.EXE_CALL_EMPLOYEE_DONE");
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_TWO_LINE_OPER_FAILED");
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_CALL_BRIDGED");
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER");
        this.intentFilter.addAction("ezuc.intent.action.event.PHONE_INVITE_JOIN_MEETME");
        this.intentFilter.addAction("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.MIC_LEVEL_CHANGED");
        this.initDisplay();
        UCChatClient.context.registerReceiver(this.phoneReceiver, this.intentFilter);
        this.phoneClickText.setText(EMPTY_STR);
        this.doAction();
    }

    @Override
    public void onHide() {
        Log.i(PhonePanel.class.getSimpleName(), "PhonePanel onHide");
        this.closeDtmfMenu();
    }

    private void closeDtmfMenu() {
        if (this.menuOn) {
            this.menu.cleanup();
            this.layeredPane.remove(this.menu);
            this.menuOn = false;
        }
        this.phoneKeypad.setEntered(false);
        this.phoneKeypad.setSelected(false);
        this.phoneKeypad.revalidate();
        this.phoneKeypad.repaint();
    }

    @Override
    public void onClose() {
        if (this.transferDialog != null) {
            this.transferDialog.dispose();
            this.transferDialog = null;
        }
        if (this.conferenceDialog != null) {
            this.conferenceDialog.dispose();
            this.conferenceDialog = null;
        }
        if (this.phoneReceiver != null) {
            UCChatClient.context.unregisterReceiver(this.phoneReceiver);
        }
        this.closeDtmfMenu();
        this.stopTimer(this.hangupCleanUpTask);
        this.stopTimer(this.newCallCheckTask);
        if (this.phonePanelTimer != null) {
            this.phonePanelTimer.cancel();
        }
        if (this.mMjpegReader != null) {
            this.mMjpegReader.terminate();
            this.mMjpegReader.interrupt();
            this.mMjpegReader = null;
        }
    }

    private void initDisplay() {
        this.phoneOtherName.setText(EMPTY_STR);
        this.phoneGivenName.setText(EMPTY_STR);
        this.phoneOtherExt.setText(EMPTY_STR);
        this.callTimer.setText(EMPTY_STR);
        this.phoneClickText.setText(EMPTY_STR);
        this.phoneMute.setSelected(false);
        this.phoneHold.setSelected(false);
        this.phoneRecording.setSelected(false);
    }

    private void applyDemoVideo() {
        if (this.mMjpegReader == null) {
            this.mMjpegReader = new MjpegReader(new ImageReceiver(){

                @Override
                public void onImageReceived(byte[] bytes) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    try {
                        BufferedImage b = ImageIO.read(bais);
                        PhonePanel.this.setCallerPhoto(b, b.getWidth(), b.getHeight());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        if (bais != null) {
                            try {
                                bais.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            });
            this.mMjpegReader.start();
        }
    }

    private void updateCurrentLineInfo(PhoneLineInfo lineInfo) {
        if (lineInfo == null) {
            Log.e(PhonePanel.class.getSimpleName(), "line info is null, please check .... ");
            return;
        }
        this.mLineInfo = lineInfo;
        String[] title = lineInfo.getDispName();
        if (StringUtils.isNotBlank((CharSequence)title[0])) {
            this.phoneOtherName.setText(title[0]);
            this.phoneOtherName.setVisible(true);
        } else {
            this.phoneOtherName.setVisible(false);
        }
        if (StringUtils.isNotBlank((CharSequence)title[1])) {
            this.phoneGivenName.setText(title[1]);
            this.phoneGivenName.setVisible(true);
        } else {
            this.phoneGivenName.setVisible(false);
        }
        if (StringUtils.isNotBlank((CharSequence)title[2])) {
            this.phoneOtherExt.setText(title[2]);
            this.phoneOtherExt.setVisible(true);
        } else {
            this.phoneOtherExt.setVisible(false);
        }
        Activity ctx = UCChatClient.context;
        if (lineInfo.getType() == 1) {
            LiteContact contact = ContactManager.getContact((Context)ctx, lineInfo.getJid());
            this.fetchPhoto(contact);
        } else if (lineInfo.getType() == 2) {
            this.setCallerPhoto(UIConstants.ICON_PHONE_PUBLIC_PHONE200.getImage());
        } else if (lineInfo.getType() == 6) {
            LiteMyContact myContact = UCDBExternalContact.getExternalContactById(UCChatClient.context, JidUtil.trimExternalContactId(lineInfo.getJid()));
            this.fetchPhoto(myContact);
        } else if (lineInfo.getType() == 8) {
            this.setCallerPhoto(UIConstants.ICON_USER_NONAME.getImage());
        } else if (lineInfo.getType() == 4) {
            ArrayList<String> participantJidList = UCDBChatRoom.findChatRoomParticipants((Context)ctx, lineInfo.getJid());
            this.setCallerPhoto(GraphicUtil.getChatRoomImage(ctx, participantJidList, null, true, true));
        } else if (lineInfo.getType() == 5) {
            this.setCallerPhoto(UIConstants.ICON_PHONE_CONFERENCE.getImage());
        } else {
            this.setCallerPhoto(ThumbnailCache.getInstance().getDefaultImage(ctx));
        }
        if (lineInfo.getJid() == null) {
            this.lblGotoChatroom.setText(I18NUtil.getString("call_back_to_phonelist"));
        } else {
            this.lblGotoChatroom.setText(I18NUtil.getString("call_back_to_chatroom"));
        }
    }

    private void loadLineInfo() {
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo == null) {
            Log.e(PhonePanel.class.getSimpleName(), "line info is null, please check .... ");
            return;
        }
        this.updateCurrentLineInfo(lineInfo);
    }

    @Override
    protected void doAction() {
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo == null) {
            Log.e(PhonePanel.class.getSimpleName(), "line info is null, please check .... ");
            return;
        }
        this.updateCurrentLineInfo(lineInfo);
        CallState state = callLine.getState();
        boolean isMute = callLine.isMute();
        boolean isRecordingOn = callLine.isRecordingFlag();
        this.enableAction(lineInfo, state, isMute, isRecordingOn);
        if (state == CallState.IDLE || state == CallState.OUTGOING_CALL) {
            this.stopTimer(this.newCallCheckTask);
            this.newCallCheckTask = new NewCallCheckTask();
            this.phonePanelTimer.schedule((TimerTask)this.newCallCheckTask, 16000L);
        }
        if (PreferencesUtil.isDisplayCallAttachedData() && WebAgent.callAttachData != null) {
            this.callAttrPanel.setText(WebAgent.getCallAttachDataStr());
        } else {
            this.callAttrPanel.setText("");
        }
    }

    private boolean directInviteCheckIsMeetme(int currentLineIndex) {
        CallLine meetmeLine = PhoneAgent.getInstance().getCallLine(currentLineIndex);
        List<CallLine> lineList = PhoneAgent.getInstance().getOtherLineAbleToNewConf(currentLineIndex);
        Iterator<CallLine> iterator = lineList.iterator();
        if (iterator.hasNext()) {
            CallLine line = iterator.next();
            WebAgent.getInstance().makeInviteConference(meetmeLine.getLineInfo().getJid(), line.getSipCallId());
            return true;
        }
        return false;
    }

    private boolean directInviteCheckNotMeetme(int currentLineIndex) {
        List<CallLine> lineList = PhoneAgent.getInstance().getOtherLineAbleToNewConf(currentLineIndex);
        List<CallLine> meetmeLineList = PhoneAgent.getInstance().getOtherConferenceLine(currentLineIndex);
        if (meetmeLineList.size() == 0 && lineList.size() == 1) {
            CallLine otherLine;
            HashSet<String> participantJidSet = new HashSet<String>();
            participantJidSet.add(PreferencesUtil.getUserJid(UCChatClient.context));
            CallLine currentLine = PhoneAgent.getInstance().getCallLine(currentLineIndex);
            String sipCallId1 = null;
            String sipCallId2 = null;
            if (currentLineIndex == 0) {
                sipCallId1 = currentLine.getSipCallId();
            } else if (currentLineIndex == 1) {
                sipCallId2 = currentLine.getSipCallId();
            }
            PhoneLineInfo lineInfo = currentLine.getLineInfo();
            if (TextUtils.isNotBlank((CharSequence)lineInfo.getJid())) {
                participantJidSet.add(lineInfo.getJid());
            }
            if ((otherLine = lineList.get(0)).getLineId() == 0) {
                sipCallId1 = otherLine.getSipCallId();
            } else if (otherLine.getLineId() == 1) {
                sipCallId2 = otherLine.getSipCallId();
            }
            PhoneLineInfo otherLineInfo = otherLine.getLineInfo();
            if (TextUtils.isNotBlank((CharSequence)otherLineInfo.getJid())) {
                participantJidSet.add(otherLineInfo.getJid());
            }
            String roomId = UCDBChatRoom.findThreeWayCallingChatRoom(UCChatClient.context, participantJidSet);
            WebAgent.getInstance().makeThreeWayCalling(roomId, participantJidSet, sipCallId1, sipCallId2, null);
            return true;
        }
        if (meetmeLineList.size() == 1 && lineList.size() == 0) {
            CallLine currentLine = PhoneAgent.getInstance().getCallLine(currentLineIndex);
            CallLine meetmeLine = meetmeLineList.get(0);
            WebAgent.getInstance().makeInviteConference(meetmeLine.getLineInfo().getJid(), currentLine.getSipCallId());
            return true;
        }
        return false;
    }

    public void onClickInvite() {
        int currentLineIndex = PhoneAgent.getInstance().getCurrentLineIndex();
        CallLine currentLine = PhoneAgent.getInstance().getCallLine(currentLineIndex);
        if (currentLine.getLineInfo().isMeetme() ? this.directInviteCheckIsMeetme(currentLineIndex) : this.directInviteCheckNotMeetme(currentLineIndex)) {
            return;
        }
        if (this.conferenceDialog != null) {
            this.conferenceDialog.dispose();
            this.conferenceDialog = null;
        }
        this.conferenceDialog = new ConferenceDialog((JFrame)UCChatClient.getInstance(), currentLineIndex);
        Dimension d = this.conferenceDialog.getSize();
        int x = UCChatClient.getInstance().getX() + (UCChatClient.getInstance().getWidth() - (int)d.getWidth()) / 2;
        int y = UCChatClient.getInstance().getY() + (UCChatClient.getInstance().getHeight() - (int)d.getHeight()) / 2;
        this.conferenceDialog.setLocation(x, y);
        this.conferenceDialog.setVisible(true);
        this.conferenceDialog = null;
    }

    public void onClickTransfer() {
        List<CallLine> lineList;
        if (PreferencesUtil.isNoPopupTransferEnabled() && (lineList = PhoneAgent.getInstance().getOtherLineAbleToTransfer(this.mPhoneLineIndex)) != null && lineList.size() == 1) {
            CallLine callLine1 = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
            CallLine callLine2 = lineList.get(0);
            WebAgent.getInstance().makeTwoStepTransfer(callLine1.getSipCallId(), callLine2.getSipCallId());
            return;
        }
        if (this.transferDialog != null) {
            this.transferDialog.dispose();
            this.transferDialog = null;
        }
        this.transferDialog = new TransferDialog((JFrame)UCChatClient.getInstance(), this.mPhoneLineIndex);
        Dimension d = this.transferDialog.getSize();
        int x = UCChatClient.getInstance().getX() + (UCChatClient.getInstance().getWidth() - (int)d.getWidth()) / 2;
        int y = UCChatClient.getInstance().getY() + (UCChatClient.getInstance().getHeight() - (int)d.getHeight()) / 2;
        this.transferDialog.setLocation(x, y);
        this.transferDialog.setVisible(true);
        this.transferDialog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClickKeyboardButton() {
        PhonePanel phonePanel = this;
        synchronized (phonePanel) {
            if (!this.menuOn) {
                this.layeredPane.add(this.menu, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(-40, 0, 0, 0), 0, 0), 0);
                this.menuOn = true;
                this.menu.requestFocusSelf();
            } else {
                this.closeDtmfMenu();
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void onClickHangup() {
        try {
            this.stopTimer(this.newCallCheckTask);
            CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
            PhoneLineInfo info = callLine.getLineInfo();
            if (info != null) {
                if (JidUtil.isChatConfJid(info.getJid())) {
                    int result = JOptionPane.showConfirmDialog(this, I18NUtil.getString("call_title_meetme_hangup_confirm"), I18NUtil.getString("common_title_warning"), 2, 2);
                    if (result == 0) {
                        this.doHangup();
                    }
                } else {
                    this.doHangup();
                }
            }
        }
        catch (Throwable t) {
            Log.e(PhonePanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private void doHangup() {
        PhoneAgent.getInstance().hangupLine(this.mPhoneLineIndex);
        this.stopTimer(this.hangupCleanUpTask);
        this.hangupCleanUpTask = new HangupCleanUpTask();
        this.phonePanelTimer.schedule((TimerTask)this.hangupCleanUpTask, 6000L);
    }

    public void onClickChatroomButton() {
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo != null) {
            String chatId = lineInfo.getJid();
            UCChatClient.getInstance().getMainPanel().showChatroom(chatId);
        }
    }

    public void onClickMuteButton() {
        try {
            Log.i(PhonePanel.class.getSimpleName(), "PhoneActivity onClickMuteButton");
            if (PhoneAgent.getInstance().toggleMute(this.mPhoneLineIndex)) {
                this.showMuteMsg = true;
            } else {
                CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
                boolean isMute = callLine.isMute();
                if (isMute) {
                    this.phoneMute.setSelected(true);
                } else {
                    this.phoneMute.setSelected(false);
                }
            }
        }
        catch (Throwable t) {
            Log.e(PhonePanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    public void onClickRecording() {
        if (!PreferencesUtil.hasRecordingLicense(UCChatClient.context)) {
            this.phoneRecording.setSelected(false);
            ToastUtil.show(UCChatClient.context, I18NUtil.getString("permission_no_rec_license"), 10);
            return;
        }
        try {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
            CallState lineState = callLine.getState();
            boolean isRecordingOn = callLine.isRecordingFlag();
            if (lineState == CallState.HOLD && !isRecordingOn) {
                ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_record_not_allow_while_hold"), 20);
                this.phoneRecording.setSelected(false);
                return;
            }
            if (PhoneAgent.getInstance().toggleRecording(this.mPhoneLineIndex)) {
                this.showRecordingMsg = true;
            } else {
                boolean isRecording = callLine.isRecordingFlag();
                if (isRecording) {
                    this.phoneRecording.setSelected(true);
                } else {
                    this.phoneRecording.setSelected(false);
                }
            }
        }
        catch (Throwable t) {
            Log.e(PhonePanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    public void onClickHoldButton() {
        try {
            if (PhoneAgent.getInstance().toggleHold(this.mPhoneLineIndex)) {
                this.showHoldMsg = true;
            } else {
                CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
                if (callLine.getState() == CallState.HOLD) {
                    this.phoneHold.setSelected(true);
                } else {
                    this.phoneHold.setSelected(false);
                }
                this.phoneClickText.setText(I18NUtil.getString("call_notice_unhold_failed"));
                this.clickTextHandler.postDelayed(this.clickTextTimer, 3000L);
            }
        }
        catch (Throwable t) {
            Log.e(PhonePanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private void handleIncomingState(Intent intent) {
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo == null) {
            Log.e(PhonePanel.class.getSimpleName(), "line info is null, please check .... ");
            UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhonePanel(this.mPhoneLineIndex, this.mLineInfo);
            return;
        }
        CallState state = callLine.getState();
        boolean isMute = callLine.isMute();
        boolean isRecordingOn = callLine.isRecordingFlag();
        this.enableAction(lineInfo, state, isMute, isRecordingOn);
        if (!lineInfo.isIncomingCall() && TextUtils.isBlank((CharSequence)this.phoneOtherExt.getText())) {
            this.phoneOtherExt.setText(lineInfo.getNumber());
        }
    }

    private void handleOutgoingState(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo == null) {
            UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhonePanel(this.mPhoneLineIndex, this.mLineInfo);
            return;
        }
        this.updateCurrentLineInfo(lineInfo);
        CallState state = callLine.getState();
        boolean isMute = callLine.isMute();
        boolean isRecordingOn = callLine.isRecordingFlag();
        this.enableAction(lineInfo, state, isMute, isRecordingOn);
    }

    private void handleIncallState(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        if (lineInfo == null) {
            Log.e(PhonePanel.class.getSimpleName(), "line info is null, please check .... ");
            UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhonePanel(this.mPhoneLineIndex, this.mLineInfo);
            return;
        }
        this.stopTimer(this.newCallCheckTask);
        CallState state = callLine.getState();
        boolean isMute = callLine.isMute();
        boolean isRecordingOn = callLine.isRecordingFlag();
        this.enableAction(lineInfo, state, isMute, isRecordingOn);
    }

    private void handleHoldState(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            return;
        }
        int line = bundle.getInt("line");
        if (this.mPhoneLineIndex != line) {
            return;
        }
        this.phoneHold.setSelected(true);
        if (this.showHoldMsg) {
            this.phoneClickText.setText(I18NUtil.getString("call_notice_call_hold_on"));
            this.clickTextHandler.postDelayed(this.clickTextTimer, 3000L);
        }
        this.showHoldMsg = false;
    }

    private void handleIdleState(Bundle bundle) {
        this.closeDtmfMenu();
        if (this.mMjpegReader != null) {
            this.mMjpegReader.terminate();
            this.mMjpegReader.interrupt();
            this.mMjpegReader = null;
        }
        this.stopTimer(this.newCallCheckTask);
        this.stopTimer(this.hangupCleanUpTask);
        UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhonePanel(this.mPhoneLineIndex, this.mLineInfo);
        this.mLineInfo = null;
    }

    private void enableAction(PhoneLineInfo lineInfo, CallState state, boolean isMute, boolean isRecordingOn) {
        if (lineInfo == null || state == CallState.IDLE) {
            this.phoneKeypad.setEnabled(false);
            this.phoneHold.setEnabled(false);
            this.phoneHold.setSelected(false);
            this.phoneRecording.setEnabled(false);
            this.phoneRecording.setSelected(false);
            this.phoneMute.setEnabled(true);
            this.phoneMute.setSelected(false);
        } else if (state == CallState.INCOMING_CALL) {
            this.phoneKeypad.setEnabled(false);
            this.phoneHold.setEnabled(false);
            this.phoneHold.setSelected(false);
            this.phoneRecording.setEnabled(false);
            this.phoneRecording.setSelected(false);
            this.phoneMute.setEnabled(true);
            this.phoneMute.setSelected(isMute);
        } else if (state == CallState.OUTGOING_CALL) {
            this.phoneKeypad.setEnabled(false);
            this.phoneHold.setEnabled(false);
            this.phoneHold.setSelected(false);
            this.phoneRecording.setEnabled(false);
            this.phoneRecording.setSelected(false);
            this.phoneMute.setEnabled(true);
            this.phoneMute.setSelected(isMute);
        } else if (state == CallState.INCALL) {
            this.phoneKeypad.setEnabled(true);
            this.phoneHold.setEnabled(true);
            this.phoneHold.setSelected(false);
            this.phoneRecording.setEnabled(true);
            this.phoneRecording.setSelected(isRecordingOn);
            this.phoneMute.setEnabled(true);
            this.phoneMute.setSelected(isMute);
            this.callTimer.setVisible(true);
            this.callTimeHandler.removeCallbacks(this.callTimeTimer);
            this.callTimeHandler.postDelayed(this.callTimeTimer, 100L);
        } else if (state == CallState.HOLD) {
            this.phoneKeypad.setEnabled(true);
            this.phoneHold.setEnabled(true);
            this.phoneHold.setSelected(true);
            this.phoneRecording.setEnabled(true);
            this.phoneRecording.setSelected(isRecordingOn);
            this.phoneMute.setEnabled(true);
            this.phoneMute.setSelected(isMute);
            this.callTimer.setVisible(true);
            this.callTimeHandler.removeCallbacks(this.callTimeTimer);
            this.callTimeHandler.postDelayed(this.callTimeTimer, 100L);
        }
        boolean transferAvailable = PhoneAgent.getInstance().checkTransferFuncAvailable(this.mPhoneLineIndex);
        boolean conferenceAvailable = PhoneAgent.getInstance().checkConferenceferFuncAvailable(this.mPhoneLineIndex);
        boolean stateOKForFun = state == CallState.INCALL || state == CallState.HOLD;
        this.phoneTransfer.setEnabled(transferAvailable && stateOKForFun);
        this.phoneTransfer.setVisible(transferAvailable && stateOKForFun);
        this.jSeparator3.setVisible(transferAvailable && stateOKForFun);
        this.phoneMeeting.setEnabled(conferenceAvailable && stateOKForFun);
        this.phoneMeeting.setVisible(conferenceAvailable && stateOKForFun);
        this.jSeparator4.setVisible(conferenceAvailable && stateOKForFun);
        this.revalidate();
        this.repaint();
    }

    private void stopTimer(TimerTask timerTask) {
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new PhonePanel(0));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setMinimumSize(new Dimension(1120, 600));
        frame.setVisible(true);
    }

    public class NewCallCheckTask
    extends UCTimerTask {
        @Override
        public void doRun() {
            Log.i(PhonePanel.class.getSimpleName(), "Start NewCallCheckTask");
            try {
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                if (callLine.getState() == CallState.IDLE) {
                    PhoneAgent.getInstance().playBusyTone();
                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_send_timeout"), 20);
                    PhoneAgent.getInstance().timeoutCleanUp();
                    UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhonePanel(PhonePanel.this.mPhoneLineIndex, PhonePanel.this.mLineInfo);
                }
            }
            catch (Throwable t) {
                Log.e(PhonePanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
            }
        }
    }

    public class HangupCleanUpTask
    extends UCTimerTask {
        @Override
        public void doRun() {
            Log.i(PhonePanel.class.getSimpleName(), "Start HangupCleanUpTask");
            PhoneAgent.getInstance().timeoutCleanUp();
            UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhonePanel(PhonePanel.this.mPhoneLineIndex, PhonePanel.this.mLineInfo);
        }
    }

    private class PhoneBroadcastReceiver
    extends BroadcastReceiver {
        private PhoneBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("ezuc.intent.action.event.PHONE_MUTE_CHANGED".equals(action)) {
                Bundle bundle = intent.getExtras();
                if (bundle == null) {
                    return;
                }
                int line = bundle.getInt("line");
                if (PhonePanel.this.mPhoneLineIndex != line) {
                    return;
                }
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                boolean isMute = callLine.isMute();
                if (isMute) {
                    PhonePanel.this.phoneMute.setSelected(true);
                    if (PhonePanel.this.showMuteMsg) {
                        PhonePanel.this.phoneClickText.setText(I18NUtil.getString("call_notice_call_muted"));
                        PhoneLineInfo info = callLine.getLineInfo();
                        if (info != null && !PreferencesUtil.isConfAutoMuteEnabled() && JidUtil.isConfJid(info.getJid()) && PreferencesUtil.isConfMuteFirstTime()) {
                            PhonePanel.this.clickTextHandler.postDelayed(PhonePanel.this.clickTextTimer2, 3000L);
                        } else {
                            PhonePanel.this.clickTextHandler.postDelayed(PhonePanel.this.clickTextTimer, 3000L);
                        }
                    }
                } else {
                    PhonePanel.this.phoneMute.setSelected(false);
                }
                PhonePanel.this.showMuteMsg = false;
            } else if ("ezuc.intent.action.event.PHONE_RECORDING_CHANGED".equals(action)) {
                Bundle bundle = intent.getExtras();
                if (bundle == null) {
                    return;
                }
                int line = bundle.getInt("line");
                if (PhonePanel.this.mPhoneLineIndex != line) {
                    return;
                }
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                boolean isRecordingOn = callLine.isRecordingFlag();
                if (isRecordingOn) {
                    PhonePanel.this.phoneRecording.setSelected(true);
                    if (PhonePanel.this.showRecordingMsg) {
                        PhonePanel.this.phoneClickText.setText(I18NUtil.getString("call_notice_call_recording_on"));
                        PhonePanel.this.clickTextHandler.postDelayed(PhonePanel.this.clickTextTimer, 3000L);
                    }
                } else {
                    PhonePanel.this.phoneRecording.setSelected(false);
                }
                PhonePanel.this.showRecordingMsg = false;
            } else if ("ezuc.intent.action.event.PHONE_INFO_CHANGED".equals(action)) {
                PhonePanel.this.loadLineInfo();
            } else if ("ezuc.intent.action.event.PHONE_STATE_CHANGED".equals(action)) {
                Bundle bundle = intent.getExtras();
                if (bundle == null) {
                    return;
                }
                int line = bundle.getInt("line");
                if (PhonePanel.this.mPhoneLineIndex != line) {
                    return;
                }
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                CallState lineState = callLine.getState();
                switch (lineState) {
                    case IDLE: {
                        PhonePanel.this.handleIdleState(bundle);
                        break;
                    }
                    case OUTGOING_CALL: {
                        PhonePanel.this.handleOutgoingState(intent);
                        break;
                    }
                    case INCALL: {
                        PhonePanel.this.handleIncallState(intent);
                        break;
                    }
                    case INCOMING_CALL: {
                        PhonePanel.this.handleIncomingState(intent);
                        break;
                    }
                    case HOLD: {
                        PhonePanel.this.handleHoldState(intent);
                    }
                }
            } else if ("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED".equals(action)) {
                String jid = intent.getStringExtra("jid");
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                PhoneLineInfo lineInfo = callLine.getLineInfo();
                if (lineInfo != null && lineInfo.getType() == 1 && lineInfo.getJid() != null && lineInfo.getJid().equalsIgnoreCase(jid)) {
                    LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, lineInfo.getJid());
                    PhonePanel.this.fetchPhoto(contact);
                }
            } else if ("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED".equals(action)) {
                long contactId = intent.getLongExtra("id", -1L);
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                PhoneLineInfo lineInfo = callLine.getLineInfo();
                if (lineInfo != null && lineInfo.getType() == 1 && (contactId + "@externalcontact").equalsIgnoreCase(lineInfo.getJid())) {
                    LiteMyContact contact = ContactManager.getExternalContact(context, contactId);
                    PhonePanel.this.fetchPhoto(contact);
                }
            } else if (action.equals("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED")) {
                String chatRoomJid = intent.getStringExtra("chatId");
                if (chatRoomJid == null) {
                    return;
                }
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                PhoneLineInfo lineInfo = callLine.getLineInfo();
                if (lineInfo != null && chatRoomJid.equals(lineInfo.getJid())) {
                    PhonePanel.this.updateCurrentLineInfo(lineInfo);
                }
            } else if ("ezuc.intent.action.event.EXE_CALL_EMPLOYEE_DONE".equals(action)) {
                PhonePanel.this.stopTimer(PhonePanel.this.newCallCheckTask);
            } else if ("ezuc.intent.action.event.EXE_CALL_EMPLOYEE_FAIL".equals(action)) {
                PhonePanel.this.stopTimer(PhonePanel.this.newCallCheckTask);
                UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhonePanel(PhonePanel.this.mPhoneLineIndex, PhonePanel.this.mLineInfo);
            } else if ("ezuc.intent.action.event.UC_NETWORK_DISCONNECTED".equals(action) || "ezuc.intent.action.event.UC_NETWORK_CHANGED".equals(action)) {
                UCChatClient.getInstance().getMainPanel().getViewContainer().hidePhonePanel(PhonePanel.this.mPhoneLineIndex, PhonePanel.this.mLineInfo);
            } else if ("ezuc.intent.action.event.PHONE_CALL_BRIDGED".equals(action) || "ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER".equals(action)) {
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                PhoneLineInfo lineInfo = callLine.getLineInfo();
                PhonePanel.this.updateCurrentLineInfo(lineInfo);
                CallState state = callLine.getState();
                boolean isMute = callLine.isMute();
                boolean isRecordingOn = callLine.isRecordingFlag();
                PhonePanel.this.enableAction(lineInfo, state, isMute, isRecordingOn);
            } else if ("ezuc.intent.action.event.PHONE_INVITE_JOIN_MEETME".equals(action)) {
                boolean newAdd;
                CallLine callLine = PhoneAgent.getInstance().getCallLine(PhonePanel.this.mPhoneLineIndex);
                PhoneLineInfo lineInfo = callLine.getLineInfo();
                if (lineInfo != null && (newAdd = ChatRoomManager.prepareChatRoom(UCChatClient.context, lineInfo.getJid()))) {
                    WebAgent.getInstance().getOneRoomSync(lineInfo.getJid());
                }
            } else if ("ezuc.intent.action.event.MIC_LEVEL_CHANGED".equals(action)) {
                int level = intent.getIntExtra("level", 0);
                SwingUtilities.invokeLater(() -> {
                    int target = level;
                    int current = PhonePanel.this.micLevelBar.getValue();
                    if (Math.abs(target - current) > 10) {
                        PhonePanel.this.micLevelBar.setValue(target);
                    } else {
                        PhonePanel.this.micLevelBar.setValue((current + target) / 2);
                    }
                });
            }
        }
    }

    public static class PhoneActionValue {
        public static final int NONE = 0;
        public static final int TRANSFER = 1;
        public static final int HARDPHONE = 2;
        public static final int INVITE = 3;
    }

    public static class ReturnType {
        public static final int CALLEND = 1;
        public static final int SWITCHMODE = 2;
    }

    public static class DialogTag {
        public static final String TRANSFER = "1";
        public static final String INVITE = "2";
        public static final String SELECT_NUMBER = "3";
        public static final String TRANSFER_ACTION = "4";
        public static final String SELECT_MY_CONTACT = "5";
        public static final String SELECT_PHONE_ADDRESSBOOK = "6";
    }
}

