/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.resource;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.resource.UTF8Control;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NUtil {
    private static ResourceBundle resource = ResourceBundle.getBundle("i18n/ucChatClient", I18NUtil.getAppLocale(), new UTF8Control());

    public static Locale getAppLocale() {
        Locale locale = Locale.getDefault();
        if (Locale.TAIWAN.getCountry().equals(locale.getCountry()) && Locale.TAIWAN.getLanguage().equals(locale.getLanguage())) {
            return Locale.TAIWAN;
        }
        if (Locale.CHINA.getCountry().equals(locale.getCountry()) && Locale.CHINA.getLanguage().equals(locale.getLanguage())) {
            return Locale.CHINA;
        }
        if (Locale.CHINESE.getCountry().equals(locale.getCountry()) && Locale.CHINESE.getLanguage().equals(locale.getLanguage())) {
            return Locale.CHINESE;
        }
        return Locale.US;
    }

    public static String getAppName() {
        int productType = PreferencesUtil.getInt(UCChatClient.context, "PRODUCTTYPE", 0);
        return I18NUtil.getProductName(productType);
    }

    public static String getProductName(int productType) {
        if (productType == 0) {
            return I18NUtil.getString("product_ezuc_name");
        }
        if (productType == 1) {
            return I18NUtil.getString("product_ezphone_name");
        }
        if (productType == 2) {
            return I18NUtil.getString("product_miracle_name");
        }
        if (productType == 3) {
            return I18NUtil.getString("product_ezcc_name");
        }
        return I18NUtil.getString("product_other_name");
    }

    public static String getString(String key) {
        try {
            return resource.getString(key);
        }
        catch (MissingResourceException e) {
            Log.e(I18NUtil.class.getSimpleName(), "missing resource key = " + key);
            return key;
        }
    }
}

