/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.setting;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.setting.AdvancedSettingCallback;
import com.blisscloud.ezuc.client.setting.AutoAttendantControlPanel;
import com.blisscloud.ezuc.client.setting.CallForwardControlPanel;
import com.blisscloud.ezuc.client.setting.ClientApiControlPanel;
import com.blisscloud.ezuc.client.setting.OutboundPrefixControlPanel;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvancedSettingInfoDialog
extends GenericDialog
implements AdvancedSettingCallback {
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;
    private JTabbedPane jTabbedPane1;
    private AutoAttendantControlPanel autoAttendantControlPanel;
    private CallForwardControlPanel callForwardControlPanel;
    private OutboundPrefixControlPanel outboundPrefixControlPanel;
    private ClientApiControlPanel clientApiControlPanel;

    public AdvancedSettingInfoDialog(JFrame frame) {
        super(frame);
        this.initGUI();
        this.initReceiver();
    }

    public void display() {
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.loadData();
        }
        super.setVisible(b);
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("fun_title_advanced_setting"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.jTabbedPane1 = new JTabbedPane();
            this.getContentPane().add((Component)this.jTabbedPane1, "Center");
            this.jTabbedPane1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.autoAttendantControlPanel = new AutoAttendantControlPanel(this);
            this.jTabbedPane1.addTab(I18NUtil.getString("fun_title_auto_attendant_setting"), null, this.autoAttendantControlPanel, null);
            this.callForwardControlPanel = new CallForwardControlPanel(this);
            this.jTabbedPane1.addTab(I18NUtil.getString("fun_title_callforward_setting"), null, this.callForwardControlPanel, null);
            this.outboundPrefixControlPanel = new OutboundPrefixControlPanel(this);
            this.jTabbedPane1.addTab(I18NUtil.getString("fun_title_outbound_prefix_setting"), null, this.outboundPrefixControlPanel, null);
            this.clientApiControlPanel = new ClientApiControlPanel(this);
            this.jTabbedPane1.addTab(I18NUtil.getString("fun_title_client_api_control_setting"), null, this.clientApiControlPanel, null);
            this.setSize(680, 420);
            this.setMinimumSize(new Dimension(580, 420));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if (action.equals("ezuc.intent.action.event.FETCH_VOICE_CONFIG")) {
                        AdvancedSettingInfoDialog.this.loadData();
                    } else if (action.equals("ezuc.intent.action.event.FETCH_LANGUAGE_LIST")) {
                        AdvancedSettingInfoDialog.this.loadData();
                    } else if (action.equals("ezuc.intent.action.event.LOGIN_USER_SITE_CHANGED")) {
                        AdvancedSettingInfoDialog.this.loadData();
                    } else if (action.equals("ezuc.intent.action.event.OUTBOUND_REFIX_LIST_CHANGED")) {
                        AdvancedSettingInfoDialog.this.loadData();
                    } else if (action.equals("ezuc.intent.action.event.CONTACT_LIST_CHANGED")) {
                        AdvancedSettingInfoDialog.this.loadData();
                    } else if (action.equals("ezuc.intent.action.event.PERSONAL_INFO_CHANGED")) {
                        AdvancedSettingInfoDialog.this.loadData();
                    }
                }
                catch (Throwable t) {
                    Log.e(AdvancedSettingInfoDialog.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.FETCH_VOICE_CONFIG");
        this.filter.addAction("ezuc.intent.action.event.FETCH_LANGUAGE_LIST");
        this.filter.addAction("ezuc.intent.action.event.LOGIN_USER_SITE_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.OUTBOUND_REFIX_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CONTACT_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PERSONAL_INFO_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void loadData() {
        JSONObject voiceData = this.loadVoiceData();
        this.autoAttendantControlPanel.loadData(voiceData);
        this.callForwardControlPanel.loadData(voiceData);
        this.outboundPrefixControlPanel.loadData();
        this.repaint();
    }

    private JSONObject loadVoiceData() {
        String voiceConigJsonStr = PreferencesUtil.getVoiceSetting(UCChatClient.context);
        JSONObject voiceData = null;
        if (!TextUtils.isEmpty((CharSequence)voiceConigJsonStr)) {
            try {
                voiceData = new JSONObject(voiceConigJsonStr);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return voiceData;
    }

    @Override
    public JSONObject getVoiceData() {
        return this.loadVoiceData();
    }

    @Override
    public void onClose() {
        this.setVisible(false);
    }
}

