/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.setting;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.setting.AdvancedSettingCallback;
import com.blisscloud.ezuc.client.setting.CallForwardPhoneSelectionPanel;
import com.blisscloud.ezuc.client.setting.CallForwardResult;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.json.JSONException;
import org.json.JSONObject;

public class CallForwardControlPanel
extends JPanel {
    private JScrollPane callForwardScrollPanel;
    private JPanel callForwardInsidePanel;
    private RoundedCornerPanel callForwardTopPanel;
    private JLabel callForwardBottomPadding;
    private JLabel dndLabel;
    private JCheckBox dndCheckBox;
    private JLabel allTransferLabel;
    private CallForwardPhoneSelectionPanel allTransferPanel;
    private JLabel busyTransferLabel;
    private CallForwardPhoneSelectionPanel busyTransferPanel;
    private JLabel noAnswerTransferLabel;
    private CallForwardPhoneSelectionPanel noAnswerTransferPanel;
    private AdvancedSettingCallback mCallback;

    public CallForwardControlPanel(AdvancedSettingCallback callback) {
        this.mCallback = callback;
        BorderLayout callForwardControlLayout = new BorderLayout();
        callForwardControlLayout.setVgap(10);
        this.setLayout(callForwardControlLayout);
        this.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        this.callForwardScrollPanel = new UCScrollPane(10);
        this.add((Component)this.callForwardScrollPanel, "Center");
        this.callForwardInsidePanel = new JPanel();
        this.callForwardScrollPanel.setViewportView(this.callForwardInsidePanel);
        this.callForwardInsidePanel.setLayout(new GridBagLayout());
        int insidePanelY = 0;
        this.callForwardTopPanel = new RoundedCornerPanel();
        this.callForwardInsidePanel.add((Component)this.callForwardTopPanel, new GridBagConstraints(0, insidePanelY++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.callForwardTopPanel.setLayout(new GridBagLayout());
        this.callForwardTopPanel.setBackground(Color.WHITE);
        this.dndLabel = new JLabel();
        this.callForwardTopPanel.add((Component)this.dndLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.dndLabel.setText(I18NUtil.getString("setting_transrule_dnd"));
        this.dndLabel.setFont(UIConstants.FONT_12_BOLD);
        this.dndCheckBox = new JCheckBox();
        this.callForwardTopPanel.add((Component)this.dndCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.dndCheckBox.setOpaque(false);
        this.dndCheckBox.setFont(UIConstants.FONT_12_PLAIN);
        JSeparator separator1 = new JSeparator();
        this.callForwardTopPanel.add((Component)separator1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        separator1.setForeground(Color.LIGHT_GRAY);
        separator1.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
        this.allTransferLabel = new JLabel();
        this.callForwardTopPanel.add((Component)this.allTransferLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.allTransferLabel.setText(I18NUtil.getString("setting_transtype_all_calls"));
        this.allTransferLabel.setFont(UIConstants.FONT_12_BOLD);
        this.allTransferPanel = new CallForwardPhoneSelectionPanel();
        this.callForwardTopPanel.add((Component)this.allTransferPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        JSeparator separator2 = new JSeparator();
        this.callForwardTopPanel.add((Component)separator2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        separator2.setForeground(Color.LIGHT_GRAY);
        separator2.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
        this.busyTransferLabel = new JLabel();
        this.callForwardTopPanel.add((Component)this.busyTransferLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.busyTransferLabel.setText(I18NUtil.getString("setting_transtype_busy_in"));
        this.busyTransferLabel.setFont(UIConstants.FONT_12_BOLD);
        this.busyTransferPanel = new CallForwardPhoneSelectionPanel();
        this.callForwardTopPanel.add((Component)this.busyTransferPanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        JSeparator separator3 = new JSeparator();
        this.callForwardTopPanel.add((Component)separator3, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        separator3.setForeground(Color.LIGHT_GRAY);
        separator3.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
        this.noAnswerTransferLabel = new JLabel();
        this.callForwardTopPanel.add((Component)this.noAnswerTransferLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.noAnswerTransferLabel.setText(I18NUtil.getString("setting_transtype_no_answer"));
        this.noAnswerTransferLabel.setFont(UIConstants.FONT_12_BOLD);
        this.noAnswerTransferPanel = new CallForwardPhoneSelectionPanel();
        this.callForwardTopPanel.add((Component)this.noAnswerTransferPanel, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
        this.callForwardBottomPadding = new JLabel();
        this.callForwardInsidePanel.add((Component)this.callForwardBottomPadding, new GridBagConstraints(0, insidePanelY++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel actionPanel = new JPanel();
        this.add((Component)actionPanel, "South");
        FlowLayout jPanel3Layout = new FlowLayout();
        jPanel3Layout.setAlignment(1);
        actionPanel.setLayout(jPanel3Layout);
        actionPanel.setOpaque(false);
        JButton btnSaveCallForward = new JButton();
        actionPanel.add(btnSaveCallForward);
        btnSaveCallForward.setText(I18NUtil.getString("common_btn_apply"));
        btnSaveCallForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallForwardControlPanel.this.btnSaveAutoCallForwardPerformed(evt);
            }
        });
        JButton btnSaveCloseCallForward = new JButton();
        actionPanel.add(btnSaveCloseCallForward);
        btnSaveCloseCallForward.setText(I18NUtil.getString("common_btn_apply_close"));
        btnSaveCloseCallForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallForwardControlPanel.this.btnSaveCloseCallForwardActionPerformed(evt);
            }
        });
        JButton btnCancelCallForward = new JButton();
        actionPanel.add(btnCancelCallForward);
        btnCancelCallForward.setText(I18NUtil.getString("common_btn_cancel"));
        btnCancelCallForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallForwardControlPanel.this.mCallback.onClose();
            }
        });
    }

    protected void btnSaveCloseCallForwardActionPerformed(ActionEvent evt) {
        boolean result = this.btnSaveAutoCallForwardPerformed(evt);
        if (result) {
            this.mCallback.onClose();
        }
    }

    protected boolean btnSaveAutoCallForwardPerformed(ActionEvent evt) {
        try {
            CallForwardResult result;
            JSONObject voiceData = this.mCallback.getVoiceData();
            boolean doUpdate = false;
            if (this.dndCheckBox != null) {
                voiceData.put("dndFlag", this.dndCheckBox.isSelected());
                doUpdate = true;
            }
            if ((result = this.allTransferPanel.onSave()) == null) {
                return false;
            }
            this.mergeData(voiceData, result, "allAutoTransferRuleTypeId", "allAutoTransferRuleNumber", "allAutoTransferRuleSiteId");
            doUpdate = true;
            result = this.busyTransferPanel.onSave();
            if (result == null) {
                return false;
            }
            this.mergeData(voiceData, result, "busyAutoTransferRuleTypeId", "busyAutoTransferRuleNumber", "busyAutoTransferRuleSiteId");
            doUpdate = true;
            result = this.noAnswerTransferPanel.onSave();
            if (result == null) {
                return false;
            }
            this.mergeData(voiceData, result, "noAnswerAutoTransferRuleTypeId", "noAnswerAutoTransferRuleNumber", "noAnswerAutoTransferRuleSiteId");
            doUpdate = true;
            if (doUpdate) {
                WebAgent.getInstance().updateVoiceConfigNew(voiceData);
            }
            return true;
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "setLanguage", e);
            return false;
        }
    }

    private void mergeData(JSONObject voiceData, CallForwardResult result, String typeKey, String numberKey, String siteKey) throws JSONException {
        voiceData.put(typeKey, result.getType());
        switch (result.getType()) {
            case 0: {
                voiceData.remove(numberKey);
                voiceData.remove(siteKey);
                break;
            }
            case 1: {
                voiceData.remove(numberKey);
                voiceData.remove(siteKey);
                break;
            }
            case 2: {
                voiceData.put(numberKey, result.getNumber());
                voiceData.remove(siteKey);
                break;
            }
            case 3: {
                voiceData.put(numberKey, result.getNumber());
                voiceData.remove(siteKey);
                break;
            }
            case 5: {
                voiceData.put(numberKey, result.getNumber());
                voiceData.put(siteKey, result.getSiteId());
                break;
            }
            case 4: {
                voiceData.put(numberKey, result.getNumber());
                voiceData.remove(siteKey);
                break;
            }
            case 6: {
                voiceData.put(numberKey, result.getNumber());
                voiceData.put(siteKey, result.getSiteId());
            }
        }
    }

    public void loadData(JSONObject voiceData) {
        this.loadDndData(voiceData);
        this.loadTransfer(voiceData);
    }

    private void loadDndData(JSONObject voiceData) {
        boolean dndFlag = false;
        if (voiceData.has("subscribeRecEmailFlag")) {
            dndFlag = voiceData.optBoolean("dndFlag", false);
        }
        this.dndCheckBox.setSelected(dndFlag);
    }

    private void loadTransfer(JSONObject voiceData) {
        CallForwardResult allTransferInput = this.getCallForwardResult(voiceData, "allAutoTransferRuleTypeId", "allAutoTransferRuleNumber", "allAutoTransferRuleSiteId", "allAutoTransferRuleDeviceId");
        this.allTransferPanel.loadData(allTransferInput);
        CallForwardResult busyTransferInput = this.getCallForwardResult(voiceData, "busyAutoTransferRuleTypeId", "busyAutoTransferRuleNumber", "busyAutoTransferRuleSiteId", "busyAutoTransferRuleDeviceId");
        this.busyTransferPanel.loadData(busyTransferInput);
        CallForwardResult noAnswerTransferInput = this.getCallForwardResult(voiceData, "noAnswerAutoTransferRuleTypeId", "noAnswerAutoTransferRuleNumber", "noAnswerAutoTransferRuleSiteId", "noAnswerAutoTransferRuleDeviceId");
        this.noAnswerTransferPanel.loadData(noAnswerTransferInput);
    }

    private CallForwardResult getCallForwardResult(JSONObject voiceData, String typeKey, String numberKey, String siteKey, String deviceIdKey) {
        int currentType = voiceData.optInt(typeKey, -1);
        String currentNumber = voiceData.optString(numberKey, null);
        long currentSiteId = voiceData.optLong(siteKey, -1L);
        String deviceId = voiceData.optString(deviceIdKey, null);
        CallForwardResult result = new CallForwardResult();
        result.setType(currentType);
        result.setNumber(currentNumber);
        result.setSiteId(currentSiteId);
        result.setDeviceId(deviceId);
        return result;
    }
}

