/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.setting;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.setting.CallForwardItem;
import com.blisscloud.ezuc.client.setting.CallForwardResult;
import com.blisscloud.ezuc.client.setting.CallForwardSelectionRenderer;
import com.blisscloud.ezuc.client.setting.SiteSelectionRenderer;
import com.blisscloud.ezuc.client.setting.TelePhoneSelectionRenderer;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class CallForwardPhoneSelectionPanel
extends JPanel
implements ActionListener {
    private JComboBox<CallForwardItem> typeBox;
    private DefaultComboBoxModel<CallForwardItem> typeBoxModel = new DefaultComboBoxModel();
    private JTextField numberField;
    private JTextField deviceIdField;
    private JComboBox<LiteTeleNumber> mobileBox;
    private DefaultComboBoxModel<LiteTeleNumber> mobileBoxModel = new DefaultComboBoxModel();
    private JComboBox<LiteTeleNumber> homeBox;
    private DefaultComboBoxModel<LiteTeleNumber> homeBoxModel = new DefaultComboBoxModel();
    private JComboBox<LiteSite> siteBox;
    private DefaultComboBoxModel<LiteSite> siteBoxModel = new DefaultComboBoxModel();

    public CallForwardPhoneSelectionPanel() {
        this.setBackground(Color.WHITE);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(3);
        this.setLayout(flowLayout);
        this.typeBox = new JComboBox();
        this.add(this.typeBox);
        this.typeBox.setFont(UIConstants.FONT_12_PLAIN);
        this.typeBox.setModel(this.typeBoxModel);
        this.typeBox.setRenderer(new CallForwardSelectionRenderer());
        this.siteBox = new JComboBox();
        this.add(this.siteBox);
        this.siteBox.setFont(UIConstants.FONT_12_PLAIN);
        this.siteBox.setModel(this.siteBoxModel);
        this.siteBox.setRenderer(new SiteSelectionRenderer());
        this.mobileBox = new JComboBox();
        this.add(this.mobileBox);
        this.mobileBox.setFont(UIConstants.FONT_12_PLAIN);
        this.mobileBox.setModel(this.mobileBoxModel);
        this.mobileBox.setRenderer(new TelePhoneSelectionRenderer());
        this.homeBox = new JComboBox();
        this.add(this.homeBox);
        this.homeBox.setFont(UIConstants.FONT_12_PLAIN);
        this.homeBox.setModel(this.homeBoxModel);
        this.homeBox.setRenderer(new TelePhoneSelectionRenderer());
        this.numberField = new JTextField(10);
        this.add(this.numberField);
        this.numberField.setFont(UIConstants.FONT_12_PLAIN);
        this.numberField.setVisible(false);
        this.deviceIdField = new JTextField(10);
        this.add(this.deviceIdField);
        this.deviceIdField.setFont(UIConstants.FONT_12_PLAIN);
        this.deviceIdField.setVisible(false);
    }

    public void loadData(CallForwardResult input) {
        boolean hasCallTransferConfigPermission = PreferencesUtil.hasCallTransferConfigPermission(UCChatClient.context);
        this.typeBox.setEnabled(hasCallTransferConfigPermission);
        this.mobileBox.setEnabled(hasCallTransferConfigPermission);
        this.homeBox.setEnabled(hasCallTransferConfigPermission);
        this.siteBox.setEnabled(hasCallTransferConfigPermission);
        int currentType = input.getType();
        String currentNumber = input.getNumber();
        long currentSiteId = input.getSiteId();
        String deviceId = input.getDeviceId();
        this.typeBox.removeActionListener(this);
        DefaultComboBoxModel typeBoxModel = (DefaultComboBoxModel)this.typeBox.getModel();
        DefaultComboBoxModel mobileBoxModel = (DefaultComboBoxModel)this.mobileBox.getModel();
        DefaultComboBoxModel homeBoxModel = (DefaultComboBoxModel)this.homeBox.getModel();
        DefaultComboBoxModel siteBoxModel = (DefaultComboBoxModel)this.siteBox.getModel();
        typeBoxModel.removeAllElements();
        mobileBoxModel.removeAllElements();
        homeBoxModel.removeAllElements();
        siteBoxModel.removeAllElements();
        List<LiteSite> siteList = UCDBSite.getAllSites(UCChatClient.context);
        for (int i = 0; siteList != null && i < siteList.size(); ++i) {
            LiteSite site = siteList.get(i);
            siteBoxModel.addElement(site);
            if (currentSiteId != site.getId()) continue;
            siteBoxModel.setSelectedItem(site);
        }
        CallForwardItem none = new CallForwardItem(0, I18NUtil.getString("setting_transfer_option_no_forward"));
        CallForwardItem ext = new CallForwardItem(5, I18NUtil.getString("setting_transfer_option_company_ext_number"));
        CallForwardItem voicemail = new CallForwardItem(1, I18NUtil.getString("setting_transfer_option_voicemail"));
        CallForwardItem mobile = new CallForwardItem(2, I18NUtil.getString("setting_transfer_option_detail_mobile"));
        CallForwardItem home = new CallForwardItem(3, I18NUtil.getString("setting_transfer_option_detail_home"));
        CallForwardItem other = new CallForwardItem(4, I18NUtil.getString("setting_transfer_option_detail_other"));
        CallForwardItem device = new CallForwardItem(6, I18NUtil.getString("setting_transfer_option_dn"));
        typeBoxModel.addElement(none);
        typeBoxModel.addElement(voicemail);
        typeBoxModel.addElement(mobile);
        typeBoxModel.addElement(home);
        typeBoxModel.addElement(ext);
        typeBoxModel.addElement(other);
        if (currentType == 6) {
            typeBoxModel.addElement(device);
        }
        String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
        LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, myJid);
        List<LiteTeleNumber> mobilePhoneList = contact.getMobilePhone();
        for (int i = 0; mobilePhoneList != null && i < mobilePhoneList.size(); ++i) {
            LiteTeleNumber number = mobilePhoneList.get(i);
            mobileBoxModel.addElement(number);
            if (currentType != 2 || currentNumber == null || !currentNumber.equals(number.getNumber())) continue;
            mobileBoxModel.setSelectedItem(number);
        }
        List<LiteTeleNumber> homePhoneList = contact.getHomePhone();
        for (int i = 0; homePhoneList != null && i < homePhoneList.size(); ++i) {
            LiteTeleNumber number = homePhoneList.get(i);
            homeBoxModel.addElement(number);
            if (currentType != 3 || currentNumber == null || !currentNumber.equals(number.getNumber())) continue;
            homeBoxModel.setSelectedItem(number);
        }
        switch (currentType) {
            case 0: {
                typeBoxModel.setSelectedItem(none);
                this.numberField.setText("");
                this.deviceIdField.setText("");
                break;
            }
            case 1: {
                typeBoxModel.setSelectedItem(voicemail);
                this.numberField.setText("");
                this.deviceIdField.setText("");
                break;
            }
            case 2: {
                typeBoxModel.setSelectedItem(mobile);
                this.numberField.setText("");
                this.deviceIdField.setText("");
                break;
            }
            case 3: {
                typeBoxModel.setSelectedItem(home);
                this.numberField.setText("");
                this.deviceIdField.setText("");
                break;
            }
            case 5: {
                typeBoxModel.setSelectedItem(ext);
                this.numberField.setText(currentNumber != null ? currentNumber : "");
                this.deviceIdField.setText("");
                break;
            }
            case 4: {
                typeBoxModel.setSelectedItem(other);
                this.numberField.setText(currentNumber != null ? currentNumber : "");
                this.deviceIdField.setText("");
                break;
            }
            case 6: {
                typeBoxModel.setSelectedItem(device);
                this.numberField.setText(currentNumber);
                this.deviceIdField.setText(deviceId);
            }
        }
        this.typeSwitch();
        this.typeBox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.typeSwitch();
    }

    private void typeSwitch() {
        CallForwardItem typeItem = (CallForwardItem)this.typeBox.getSelectedItem();
        switch (typeItem.getType()) {
            case 0: {
                this.numberField.setVisible(false);
                this.numberField.setEnabled(false);
                this.deviceIdField.setVisible(false);
                this.deviceIdField.setEnabled(false);
                this.mobileBox.setVisible(false);
                this.homeBox.setVisible(false);
                this.siteBox.setVisible(false);
                this.siteBox.setEnabled(false);
                break;
            }
            case 1: {
                this.numberField.setVisible(false);
                this.numberField.setEnabled(false);
                this.deviceIdField.setVisible(false);
                this.deviceIdField.setEnabled(false);
                this.mobileBox.setVisible(false);
                this.homeBox.setVisible(false);
                this.siteBox.setVisible(false);
                this.siteBox.setEnabled(false);
                break;
            }
            case 2: {
                this.numberField.setVisible(false);
                this.numberField.setEnabled(false);
                this.deviceIdField.setVisible(false);
                this.deviceIdField.setEnabled(false);
                this.mobileBox.setVisible(true);
                this.homeBox.setVisible(false);
                this.siteBox.setVisible(false);
                this.siteBox.setEnabled(false);
                break;
            }
            case 3: {
                this.numberField.setVisible(false);
                this.numberField.setEnabled(false);
                this.deviceIdField.setVisible(false);
                this.deviceIdField.setEnabled(false);
                this.mobileBox.setVisible(false);
                this.homeBox.setVisible(true);
                this.siteBox.setVisible(false);
                this.siteBox.setEnabled(false);
                break;
            }
            case 5: {
                this.numberField.setVisible(true);
                this.numberField.setEnabled(true);
                this.deviceIdField.setVisible(false);
                this.deviceIdField.setEnabled(false);
                this.mobileBox.setVisible(false);
                this.homeBox.setVisible(false);
                if (this.siteBoxModel.getSize() <= 1) {
                    this.siteBox.setVisible(false);
                    this.siteBox.setEnabled(true);
                    break;
                }
                this.siteBox.setVisible(true);
                this.siteBox.setEnabled(true);
                break;
            }
            case 4: {
                this.numberField.setVisible(true);
                this.numberField.setEnabled(true);
                this.deviceIdField.setVisible(false);
                this.deviceIdField.setEnabled(false);
                this.mobileBox.setVisible(false);
                this.homeBox.setVisible(false);
                this.siteBox.setVisible(false);
                this.siteBox.setEnabled(false);
                break;
            }
            case 6: {
                this.numberField.setEnabled(false);
                this.deviceIdField.setEnabled(false);
                if (StringUtils.isNotBlank((CharSequence)this.deviceIdField.getText())) {
                    this.numberField.setVisible(false);
                    this.deviceIdField.setVisible(true);
                } else {
                    this.numberField.setVisible(true);
                    this.deviceIdField.setVisible(false);
                }
                this.mobileBox.setVisible(false);
                this.homeBox.setVisible(false);
                if (this.siteBoxModel.getSize() <= 1) {
                    this.siteBox.setVisible(false);
                } else {
                    this.siteBox.setVisible(true);
                }
                this.siteBox.setEnabled(false);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public CallForwardResult onSave() {
        CallForwardItem typeItem = (CallForwardItem)this.typeBox.getSelectedItem();
        CallForwardResult result = new CallForwardResult();
        result.setType(typeItem.getType());
        switch (typeItem.getType()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                LiteTeleNumber number = (LiteTeleNumber)this.mobileBox.getSelectedItem();
                if (number == null || StringUtils.isBlank((CharSequence)number.getNumber())) {
                    JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_label_number_not_exist"), I18NUtil.getString("common_title_error"), 0);
                    this.mobileBox.requestFocus();
                    return null;
                }
                Pattern pattern = Pattern.compile("^[+][0-9][0-9,]{1,28}$|^[0-9][0-9,]{2,29}$");
                Matcher matcher = pattern.matcher(number.getNumber().trim());
                if (!matcher.matches()) {
                    String msg = "<html><p style=\"text-align:left;padding:10px 20px;\">" + I18NUtil.getString("abook_validation_phone_format_incorrect") + "</p></html>";
                    JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_title_error"), 0);
                    this.homeBox.requestFocus();
                    return null;
                }
                result.setNumber(number.getNumber());
                break;
            }
            case 3: {
                LiteTeleNumber number = (LiteTeleNumber)this.homeBox.getSelectedItem();
                if (number == null || StringUtils.isBlank((CharSequence)number.getNumber())) {
                    JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_label_number_not_exist"), I18NUtil.getString("common_title_error"), 0);
                    this.homeBox.requestFocus();
                    return null;
                }
                Pattern pattern = Pattern.compile("^[+][0-9][0-9,]{1,28}$|^[0-9][0-9,]{2,29}$");
                Matcher matcher = pattern.matcher(number.getNumber().trim());
                if (!matcher.matches()) {
                    String msg = "<html><p style=\"text-align:left;padding:10px 20px;\">" + I18NUtil.getString("abook_validation_phone_format_incorrect") + "</p></html>";
                    JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_title_error"), 0);
                    this.homeBox.requestFocus();
                    return null;
                }
                result.setNumber(number.getNumber());
                break;
            }
            case 5: {
                ArrayList<String> extList;
                LiteSite site1 = (LiteSite)this.siteBox.getSelectedItem();
                String number3 = this.numberField.getText();
                if (TextUtils.isBlank((CharSequence)number3)) {
                    JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_trans_validation_ext_num_empty"), I18NUtil.getString("common_title_error"), 0);
                    this.numberField.requestFocus();
                    return null;
                }
                Pattern pattern = Pattern.compile("\\d*");
                Matcher matcher = pattern.matcher(number3);
                if (!matcher.matches()) {
                    JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_validation_digit_only"), I18NUtil.getString("common_title_error"), 0);
                    this.numberField.requestFocus();
                    return null;
                }
                String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
                LiteContact mySelf = ContactManager.getContact((Context)UCChatClient.context, myJid);
                if (mySelf != null && (extList = mySelf.getExtList()) != null && extList.size() != 0) {
                    for (String s : extList) {
                        String[] siext = s.split("_");
                        if (siext.length != 2) continue;
                        String destSitePrefix = siext[0];
                        String destSiteExt = siext[1];
                        if (!site1.getPrefix().equals(destSitePrefix) || !destSiteExt.equalsIgnoreCase(number3)) continue;
                        JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_trans_validation_ext_num_same"), I18NUtil.getString("common_title_error"), 0);
                        this.numberField.requestFocus();
                        return null;
                    }
                }
                result.setNumber(number3);
                result.setSiteId(site1.getId());
                break;
            }
            case 4: {
                String number = this.numberField.getText();
                if (TextUtils.isBlank((CharSequence)number)) {
                    JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_label_number_not_exist"), I18NUtil.getString("common_title_error"), 0);
                    this.numberField.requestFocus();
                    return null;
                }
                Pattern pattern = Pattern.compile("^[+][0-9][0-9,]{1,28}$|^[0-9][0-9,]{2,29}$");
                Matcher matcher = pattern.matcher(number.trim());
                if (!matcher.matches()) {
                    String msg = "<html><p style=\"text-align:left;padding:10px 20px;\">" + I18NUtil.getString("abook_validation_phone_format_incorrect") + "</p></html>";
                    JOptionPane.showMessageDialog(this, msg, I18NUtil.getString("common_title_error"), 0);
                    this.homeBox.requestFocus();
                    return null;
                }
                result.setNumber(number);
                break;
            }
            case 6: {
                String number5 = this.numberField.getText();
                LiteSite site2 = (LiteSite)this.siteBox.getSelectedItem();
                result.setNumber(number5);
                result.setSiteId(site2.getId());
            }
        }
        return result;
    }
}

