/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.setting;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.setting.AdvancedSettingCallback;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class ClientApiControlPanel
extends JPanel {
    private JScrollPane scrollPanel;
    private JPanel insidePanel;
    private RoundedCornerPanel topPanel;
    private JLabel bottomPadding;
    private JTextField portField;
    private AdvancedSettingCallback mCallback;

    public ClientApiControlPanel(AdvancedSettingCallback callback) {
        this.mCallback = callback;
        BorderLayout autoAttendantControlLayout = new BorderLayout();
        autoAttendantControlLayout.setVgap(10);
        this.setLayout(autoAttendantControlLayout);
        this.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 10));
        this.scrollPanel = new UCScrollPane(10);
        this.add((Component)this.scrollPanel, "Center");
        this.insidePanel = new JPanel();
        this.scrollPanel.setViewportView(this.insidePanel);
        this.insidePanel.setLayout(new GridBagLayout());
        int insidePanelY = 0;
        this.topPanel = new RoundedCornerPanel();
        this.insidePanel.add((Component)this.topPanel, new GridBagConstraints(0, insidePanelY++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.setBackground(Color.WHITE);
        JLabel portLabel = new JLabel();
        this.topPanel.add((Component)portLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
        portLabel.setText(I18NUtil.getString("setting_label_api_port"));
        portLabel.setFont(UIConstants.FONT_12_BOLD);
        JLabel portPrefix = new JLabel();
        this.topPanel.add((Component)portPrefix, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 0), 0, 0));
        portPrefix.setText(I18NUtil.getString("setting_label_api_port_prefix"));
        this.portField = new JTextField(5);
        this.topPanel.add((Component)this.portField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 0, 6, 1), 0, 0));
        this.portField.setText(String.valueOf(PreferencesUtil.getApiHttpServerPort()));
        JLabel dialoutLabel = new JLabel();
        this.topPanel.add((Component)dialoutLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
        dialoutLabel.setText(I18NUtil.getString("setting_label_api_dialout"));
        dialoutLabel.setFont(UIConstants.FONT_12_BOLD);
        JLabel dialoutSample = new JLabel();
        this.topPanel.add((Component)dialoutSample, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 0), 0, 0));
        dialoutSample.setText(I18NUtil.getString("setting_label_api_dialout_url"));
        JLabel hangupLabel = new JLabel();
        this.topPanel.add((Component)hangupLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
        hangupLabel.setText(I18NUtil.getString("setting_label_api_hangup"));
        hangupLabel.setFont(UIConstants.FONT_12_BOLD);
        JLabel hangupSample = new JLabel();
        this.topPanel.add((Component)hangupSample, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 0), 0, 0));
        hangupSample.setText(I18NUtil.getString("setting_label_api_hangup_url"));
        JLabel dialoutHardLabel = new JLabel();
        this.topPanel.add((Component)dialoutHardLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
        dialoutHardLabel.setText(I18NUtil.getString("setting_label_api_dialout_hard"));
        dialoutHardLabel.setFont(UIConstants.FONT_12_BOLD);
        JLabel dialoutHardSample = new JLabel();
        this.topPanel.add((Component)dialoutHardSample, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 0), 0, 0));
        dialoutHardSample.setText(I18NUtil.getString("setting_label_api_dialout_hard_url"));
        JLabel hangupHardLabel = new JLabel();
        this.topPanel.add((Component)hangupHardLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
        hangupHardLabel.setText(I18NUtil.getString("setting_label_api_hangup_hard"));
        hangupHardLabel.setFont(UIConstants.FONT_12_BOLD);
        JLabel hangupHardSample = new JLabel();
        this.topPanel.add((Component)hangupHardSample, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 0), 0, 0));
        hangupHardSample.setText(I18NUtil.getString("setting_label_api_hangup_hard_url"));
        JLabel popupRoomLabel = new JLabel();
        this.topPanel.add((Component)popupRoomLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
        popupRoomLabel.setText(I18NUtil.getString("setting_label_api_popup_room"));
        popupRoomLabel.setFont(UIConstants.FONT_12_BOLD);
        JLabel popupRoomSample = new JLabel();
        this.topPanel.add((Component)popupRoomSample, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 0), 0, 0));
        popupRoomSample.setText(I18NUtil.getString("setting_label_api_popup_room_url"));
        this.bottomPadding = new JLabel();
        this.insidePanel.add((Component)this.bottomPadding, new GridBagConstraints(0, insidePanelY++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel actionPanel = new JPanel();
        this.add((Component)actionPanel, "South");
        FlowLayout jPanel3Layout = new FlowLayout();
        jPanel3Layout.setAlignment(1);
        actionPanel.setLayout(jPanel3Layout);
        actionPanel.setOpaque(false);
        JButton btnSave = new JButton();
        actionPanel.add(btnSave);
        btnSave.setText(I18NUtil.getString("common_btn_apply"));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientApiControlPanel.this.btnSaveActionPerformed(evt);
            }
        });
        JButton btnSaveClose = new JButton();
        actionPanel.add(btnSaveClose);
        btnSaveClose.setText(I18NUtil.getString("common_btn_apply_close"));
        btnSaveClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientApiControlPanel.this.btnSaveCloseActionPerformed(evt);
            }
        });
        JButton btnCancel = new JButton();
        actionPanel.add(btnCancel);
        btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientApiControlPanel.this.mCallback.onClose();
            }
        });
    }

    protected void btnSaveCloseActionPerformed(ActionEvent evt) {
        boolean result = this.btnSaveActionPerformed(evt);
        if (result) {
            this.mCallback.onClose();
        }
    }

    protected boolean btnSaveActionPerformed(ActionEvent evt) {
        try {
            String portStr = this.portField.getText();
            if (StringUtils.isBlank((CharSequence)portStr) || !TextUtils.isDigitsOnly(portStr)) {
                JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_label_api_client_port_only_number"), I18NUtil.getString("common_title_error"), 0);
                this.portField.requestFocus();
                return false;
            }
            int port = Integer.parseInt(portStr);
            if (port < 1024 || port > 65535) {
                JOptionPane.showMessageDialog(this, I18NUtil.getString("setting_label_api_client_port_range"), I18NUtil.getString("common_title_error"), 0);
                this.portField.requestFocus();
                return false;
            }
            PreferencesUtil.setApiHttpServerPort(port);
            UCChatClient.getInstance().stopHttpServer();
            if (UCChatClient.getInstance().startHttpServerSync()) {
                String msg = String.format(I18NUtil.getString("setting_message_client_api_restart"), port);
                ToastUtil.show(UCChatClient.context, msg, 10);
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

