/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.text;

import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.MsgTextWriter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class HistoryTextWriter
implements MsgTextWriter {
    private JTextPane lblLastMsg;
    private int iconSize = 16;
    private int writeSize = 0;
    private int maxLength = -1;
    private boolean skipEnabled = false;
    private boolean maxCheckEnabled = false;

    public HistoryTextWriter(JTextPane lblLastMsg) {
        this.lblLastMsg = lblLastMsg;
    }

    public HistoryTextWriter(JTextPane lblLastMsg, int iconSize, int maxLength) {
        this.lblLastMsg = lblLastMsg;
        this.iconSize = iconSize;
        this.maxLength = maxLength;
        this.maxCheckEnabled = this.maxLength > 0;
    }

    private boolean preInsertIcon(String iconPath) {
        ImageIcon emoticonIcon = GraphicUtil.getScaledIcon(iconPath, this.iconSize, this.iconSize);
        return emoticonIcon != null;
    }

    private boolean insertIcon(String iconPath) {
        ImageIcon emoticonIcon = GraphicUtil.getScaledIcon(iconPath, this.iconSize, this.iconSize);
        if (emoticonIcon != null) {
            this.lblLastMsg.insertIcon(emoticonIcon);
            return true;
        }
        return false;
    }

    private void checkSize() throws UCThreadException {
        if (this.maxCheckEnabled && this.writeSize >= this.maxLength) {
            this.skipEnabled = true;
            try {
                this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), "...", null);
            }
            catch (BadLocationException e) {
                Log.i(HistoryTextWriter.class.getSimpleName(), e.getMessage(), e);
            }
        }
    }

    @Override
    public void writeStickerIcon(String stickerKey) throws UCThreadException {
        if (this.skipEnabled) {
            return;
        }
        String iconPath = ChatRoomManager.getStickerPath(stickerKey);
        if (iconPath != null) {
            this.insertIcon(iconPath);
        }
        ++this.writeSize;
        this.checkSize();
    }

    @Override
    public void writeOneEmoticonIcon(String emoticonKey) throws UCThreadException {
        if (this.skipEnabled) {
            return;
        }
        String iconPath = ChatRoomManager.getEmoticonSmallPath(emoticonKey);
        if (iconPath != null) {
            this.insertIcon(iconPath);
        }
        ++this.writeSize;
        this.checkSize();
    }

    @Override
    public void writeLink(String text, String url) throws UCThreadException {
        if (this.skipEnabled) {
            return;
        }
        if (this.maxCheckEnabled && this.writeSize + text.length() >= this.maxLength) {
            text = text.substring(0, this.maxLength - this.writeSize);
        }
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setUnderline(attributes, true);
        try {
            this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), text, attributes);
        }
        catch (BadLocationException e) {
            Log.i(HistoryTextWriter.class.getSimpleName(), e.getMessage(), e);
        }
        this.writeSize += text.length();
        this.checkSize();
    }

    @Override
    public boolean preWriteEmoticonIcon(String emoticonKey) throws UCThreadException {
        String iconPath;
        if (this.skipEnabled) {
            return true;
        }
        if ((emoticonKey.startsWith("[emoticon_") || emoticonKey.startsWith("[emo")) && (iconPath = ChatRoomManager.getEmoticonSmallPath(emoticonKey)) != null) {
            return this.preInsertIcon(iconPath);
        }
        return false;
    }

    @Override
    public boolean writeEmoticonIcon(String emoticonKey) throws UCThreadException {
        String iconPath;
        if (this.skipEnabled) {
            return true;
        }
        if ((emoticonKey.startsWith("[emoticon_") || emoticonKey.startsWith("[emo")) && (iconPath = ChatRoomManager.getEmoticonSmallPath(emoticonKey)) != null) {
            boolean result = this.insertIcon(iconPath);
            if (result) {
                ++this.writeSize;
                this.checkSize();
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean preWriteEmojiIcon(String codePointStr) throws UCThreadException {
        if (this.skipEnabled) {
            return true;
        }
        String emojiPath = "images/emoji/" + codePointStr + ".png";
        return this.preInsertIcon(emojiPath);
    }

    @Override
    public boolean writeEmojiIcon(String codePointStr) throws UCThreadException {
        if (this.skipEnabled) {
            return true;
        }
        String emojiPath = "images/emoji/" + codePointStr + ".png";
        boolean result = this.insertIcon(emojiPath);
        if (result) {
            ++this.writeSize;
            this.checkSize();
        }
        return result;
    }

    @Override
    public void writeText(String text) throws UCThreadException {
        if (this.skipEnabled) {
            return;
        }
        if (this.maxCheckEnabled && this.writeSize + text.length() >= this.maxLength) {
            text = text.substring(0, this.maxLength - this.writeSize);
        }
        try {
            this.lblLastMsg.getDocument().insertString(this.lblLastMsg.getCaretPosition(), text, null);
        }
        catch (BadLocationException e) {
            Log.i(HistoryTextWriter.class.getSimpleName(), e.getMessage(), e);
        }
        this.writeSize += text.length();
        this.checkSize();
    }
}

