/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.tool;

import com.blisscloud.ezuc.client.UIConstants;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.border.AbstractBorder;

public class CustomBorder
extends AbstractBorder {
    private final BasicStroke stroke;
    private final Paint paint;
    private boolean mShowAll = false;

    public CustomBorder() {
        this.mShowAll = false;
        this.stroke = new BasicStroke(0.1f);
        this.paint = null;
    }

    public CustomBorder(boolean showAll) {
        this.mShowAll = showAll;
        this.stroke = new BasicStroke(0.1f);
        this.paint = null;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        float size = this.stroke.getLineWidth();
        if (size > 0.0f) {
            if ((g = g.create()) instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setStroke(this.stroke);
                g2d.setPaint((Paint)(this.paint != null ? this.paint : (c == null ? null : c.getForeground())));
                g2d.setColor(UIConstants.COLOR_LIGHT_GRAY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.mShowAll) {
                    g2d.drawLine(x, y + height - 1, x + width, y + height - 1);
                } else {
                    g2d.drawLine(x + 65, y + height - 1, x + width, y + height - 1);
                }
            }
            g.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(3, 10, 3, 10);
        return insets;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public Paint getPaint() {
        return this.paint;
    }
}

