/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.update;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GetDownloadUrlTask;
import com.blisscloud.ezuc.client.util.PackageInfo;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.VersionCheckHelper;
import com.blisscloud.ezuc.client.util.VersionCheckUtils;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class UpdateDialog
extends GenericDialog {
    private static final String CARD_CHECK = "CARD_CHECK";
    private static final String CARD_HINT = "CARD_HINT";
    private static final String CARD_DOWNLOADING = "CARD_DOWNLOADING";
    private JPanel panelContent;
    private JPanel jPanel1;
    private JButton btnUpdateLater;
    private JButton btnUpdateNow;
    private JLabel lblVersion;
    private JButton btnCancelUpdate;
    private JProgressBar pbDownload;
    private JLabel jLabel1;
    private JPanel panelHint;
    private JPanel panelDownloading;
    private JLabel lblChecking;
    private JPanel panelCheck;
    private JPanel jPanel2;
    private JLabel lblFilesizeHeader;
    private JLabel lblFilesize;
    private JLabel lblChangelistHeader;
    private JScrollPane jScrollPane1;
    private JTextArea txtChangelist;
    private JButton btnConfirm;
    CardLayout panelContentLayout = new CardLayout();
    int mCurrentVersionCode;
    String mCurrentVersionInfo;
    Bundle mVersionInfo;
    VersionCheckHelper mVersionHelper;
    boolean mShowCheckUI;
    boolean mShowIfUpdateReady;
    private String mRedirectUrl;
    private String mRedirectUrlForMac;
    private String mRedirectUrlForArm64;
    private String mVersion;
    private String mDetails;
    private String mReleaseData;
    private String mSize;
    private String mSizeForMac;
    private String mSizeForArm64;
    private GetDownloadUrlTask mGetDownloadUrlTask;
    private Timer timer = new Timer("UpdateDialogTimer");
    DownloadThread dt;
    ProgressThread pt;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                UpdateDialog inst = new UpdateDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    public UpdateDialog() {
        super(UCChatClient.getInstance());
        this.initGUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UpdateDialog.this.closeDownloadThreads();
            }
        });
    }

    public UpdateDialog(JFrame frame) {
        super(frame);
        this.initGUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UpdateDialog.this.closeDownloadThreads();
            }
        });
    }

    public void doCheck(boolean showCheckUI) {
        this.doCheck(showCheckUI, true);
    }

    public void doCheck(boolean showCheckUI, boolean showIfUpdateReady) {
        PackageInfo info = VersionCheckUtils.getVersionInfo(UCChatClient.context);
        this.mCurrentVersionCode = info.getVersionCode();
        this.mCurrentVersionInfo = info.getVersionInfo();
        if (this.mVersionHelper != null) {
            this.mVersionHelper.terminate();
            this.mVersionHelper = null;
        }
        String enterpriseKey = null;
        String mode = PreferencesUtil.getEnterpriseNoMode(UCChatClient.context);
        enterpriseKey = "MODE_ENT_NO".equalsIgnoreCase(mode) ? PreferencesUtil.getEnterpriseNo(UCChatClient.context) : PreferencesUtil.getEnterpriseIp(UCChatClient.context);
        this.mVersionHelper = new VersionCheckHelper(UCChatClient.context, enterpriseKey, new VersionCheckListener());
        this.mShowCheckUI = showCheckUI;
        this.mShowIfUpdateReady = showIfUpdateReady;
        if (this.mShowCheckUI) {
            this.showCard(CARD_CHECK);
            this.setVisible(true);
        }
    }

    private void initGUI() {
        try {
            this.setModal(true);
            this.setResizable(true);
            this.setDefaultCloseOperation(2);
            this.setTitle(I18NUtil.getString("setting_about_check_version"));
            this.setSize(600, 500);
            this.setLocationRelativeTo(UCChatClient.getInstance());
            this.panelContent = new JPanel();
            this.panelContent.setLayout(this.panelContentLayout);
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.panelCheck = new JPanel();
            BorderLayout panelCheckLayout = new BorderLayout();
            this.panelCheck.setLayout(panelCheckLayout);
            this.panelContent.add((Component)this.panelCheck, CARD_CHECK);
            this.panelCheck.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.lblChecking = new JLabel();
            this.panelCheck.add((Component)this.lblChecking, "Center");
            this.lblChecking.setText(I18NUtil.getString("version_checking"));
            this.lblChecking.setIcon(UIConstants.ICON_LOADING24);
            this.lblChecking.setFont(UIConstants.FONT_16_PLAIN);
            this.lblChecking.setHorizontalAlignment(0);
            this.lblChecking.setHorizontalTextPosition(0);
            this.lblChecking.setVerticalTextPosition(3);
            this.lblChecking.setIconTextGap(15);
            this.lblChecking.addMouseListener(new MouseAdapter(){
                Date pressedTime;
                long timeClicked;

                @Override
                public void mousePressed(MouseEvent e) {
                    this.pressedTime = new Date();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.timeClicked = new Date().getTime() - this.pressedTime.getTime();
                    if (this.timeClicked >= 5000L) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FileChooser fc = new FileChooser();
                                UCUploadFileChooser.setInitialOpenDir(fc);
                                final File selectedFile = fc.showOpenDialog(null);
                                if (selectedFile != null) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            Log.i(UpdateDialog.class.getSimpleName(), "f:" + selectedFile.getName());
                                            try {
                                                UpdateDialog.this.downloadUpdate(selectedFile);
                                            }
                                            catch (FileNotFoundException e1) {
                                                Log.e(UpdateDialog.class.getSimpleName(), "ERROR:" + e1.getLocalizedMessage(), e1);
                                            }
                                            UpdateDialog.this.setVisible(false);
                                            ToastUtil.showLong(I18NUtil.getString("version_notice_update_processing"));
                                            PreferencesUtil.setChatLastOpenDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });
            this.jPanel2 = new JPanel();
            this.panelCheck.add((Component)this.jPanel2, "South");
            this.btnConfirm = new JButton();
            this.jPanel2.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.setVisible(false);
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    UpdateDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.panelHint = new JPanel();
            GridBagLayout panelHintLayout = new GridBagLayout();
            this.panelHint.setLayout(panelHintLayout);
            this.panelContent.add((Component)this.panelHint, CARD_HINT);
            this.lblVersion = new JLabel();
            this.panelHint.add((Component)this.lblVersion, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblVersion.setText("");
            this.lblVersion.setFont(UIConstants.FONT_14_PLAIN);
            this.lblVersion.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setVgap(10);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelHint.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnUpdateLater = new JButton();
            this.jPanel1.add(this.btnUpdateLater);
            this.btnUpdateLater.setText(I18NUtil.getString("common_btn_version_update_later"));
            this.btnUpdateLater.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    UpdateDialog.this.btnUpdateLaterActionPerformed(evt);
                }
            });
            this.btnUpdateNow = new JButton();
            this.jPanel1.add(this.btnUpdateNow);
            this.btnUpdateNow.setText(I18NUtil.getString("common_btn_version_update"));
            this.btnUpdateNow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    UpdateDialog.this.btnUpdateNowActionPerformed(evt);
                }
            });
            this.lblFilesizeHeader = new JLabel();
            this.panelHint.add((Component)this.lblFilesizeHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblFilesizeHeader.setText(I18NUtil.getString("version_filesizelabel"));
            this.lblFilesize = new JLabel();
            this.panelHint.add((Component)this.lblFilesize, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblChangelistHeader = new JLabel();
            this.panelHint.add((Component)this.lblChangelistHeader, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 0, 0), 0, 0));
            this.lblChangelistHeader.setText(I18NUtil.getString("version_changelistexplabel"));
            this.jScrollPane1 = new JScrollPane();
            this.panelHint.add((Component)this.jScrollPane1, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.5, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            this.txtChangelist = new JTextArea();
            this.jScrollPane1.setViewportView(this.txtChangelist);
            this.txtChangelist.setEditable(false);
            this.panelDownloading = new JPanel();
            GridBagLayout panelDownloadingLayout = new GridBagLayout();
            this.panelContent.add((Component)this.panelDownloading, CARD_DOWNLOADING);
            this.panelDownloading.setLayout(panelDownloadingLayout);
            this.jLabel1 = new JLabel();
            this.panelDownloading.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText(I18NUtil.getString("version_downloading"));
            this.jLabel1.setFont(UIConstants.FONT_14_PLAIN);
            this.jLabel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.pbDownload = new JProgressBar();
            this.panelDownloading.add((Component)this.pbDownload, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 0, 0), 0, 0));
            this.pbDownload.setMinimum(0);
            this.pbDownload.setMaximum(100);
            this.pbDownload.setValue(0);
            this.pbDownload.setStringPainted(true);
            this.pbDownload.setPreferredSize(new Dimension(220, 25));
            this.btnCancelUpdate = new JButton();
            this.panelDownloading.add((Component)this.btnCancelUpdate, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 0, new Insets(15, 0, 0, 0), 0, 0));
            this.btnCancelUpdate.setText(I18NUtil.getString("version_btn_update_cancel"));
            this.btnCancelUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    UpdateDialog.this.btnCancelUpdateActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getNoNeedUpdateInfo() {
        return "<html><table><tr><td align=\"center\">" + I18NUtil.getString("version_no_needupdate") + "</td></tr><tr><td></td></tr><tr><td align=\"center\">" + this.mCurrentVersionInfo + " (" + this.mCurrentVersionCode + ")</td></tr></table></html>";
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnUpdateLaterActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnCancelUpdateActionPerformed(ActionEvent evt) {
        this.dispose();
        this.closeDownloadThreads();
    }

    private void closeDownloadThreads() {
        if (this.dt != null) {
            this.dt.terminate();
            this.dt.interrupt();
            this.dt = null;
        }
        if (this.pt != null) {
            this.pt.terminate();
            this.pt.interrupt();
            this.pt = null;
        }
    }

    private void btnUpdateNowActionPerformed(ActionEvent evt) {
        if (this.mGetDownloadUrlTask != null) {
            this.mGetDownloadUrlTask.terminate();
            this.mGetDownloadUrlTask = null;
        }
        String enterpriseKey = null;
        String mode = PreferencesUtil.getEnterpriseNoMode(UCChatClient.context);
        enterpriseKey = "MODE_ENT_NO".equalsIgnoreCase(mode) ? PreferencesUtil.getEnterpriseNo(UCChatClient.context) : PreferencesUtil.getEnterpriseIp(UCChatClient.context);
        if (this.isWindows()) {
            int index = this.mRedirectUrl.indexOf("/ucds/");
            this.mGetDownloadUrlTask = new GetDownloadUrlTask(UCChatClient.context, enterpriseKey, this.mRedirectUrl.substring(index), new GetDownloadUrlListener());
        } else if (UpdateDialog.isArm64()) {
            int index = this.mRedirectUrlForArm64.indexOf("/ucds/");
            this.mGetDownloadUrlTask = new GetDownloadUrlTask(UCChatClient.context, enterpriseKey, this.mRedirectUrlForArm64.substring(index), new GetDownloadUrlListener());
        } else {
            int index = this.mRedirectUrlForMac.indexOf("/ucds/");
            this.mGetDownloadUrlTask = new GetDownloadUrlTask(UCChatClient.context, enterpriseKey, this.mRedirectUrlForMac.substring(index), new GetDownloadUrlListener());
        }
    }

    private void downloadUpdate(String downloadUrl, long fileSize) {
        InputStream inputStream = null;
        try {
            URL url = new URL(downloadUrl);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(40000);
            conn.setReadTimeout(40000);
            inputStream = conn.getInputStream();
        }
        catch (Exception e) {
            Log.e(UpdateDialog.class.getSimpleName(), e.getLocalizedMessage(), e);
            JOptionPane.showMessageDialog(this, I18NUtil.getString("version_update_download_failed"), I18NUtil.getString("common_title_error"), 0);
            this.dispose();
            return;
        }
        if (this.isWindows()) {
            localFile = new File(FileUtil.getUpdateRoot(true), "update.zip");
            this.dt = new DownloadThread(fileSize, inputStream, localFile);
            this.dt.start();
        } else {
            localFile = new File(FileUtil.getUpdateRoot(true), "update.dmg");
            this.dt = new DownloadThread(fileSize, inputStream, localFile);
            this.dt.start();
        }
        this.pt = new ProgressThread(this.dt);
        this.pt.start();
    }

    private void downloadUpdate(File manuallyUploadfile) throws FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(manuallyUploadfile);
        if (this.isWindows()) {
            File localFile = new File(FileUtil.getUpdateRoot(true), "update.zip");
            this.dt = new DownloadThread(localFile.length(), inputStream, localFile);
            this.dt.start();
        } else {
            File localFile = new File(FileUtil.getUpdateRoot(true), "update.dmg");
            this.dt = new DownloadThread(localFile.length(), inputStream, localFile);
            this.dt.start();
        }
        this.pt = new ProgressThread(this.dt);
        this.pt.start();
    }

    public boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("windows");
    }

    public boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("mac");
    }

    public static boolean isArm64() {
        String arch = System.getProperty("os.arch").toLowerCase();
        return arch.equals("aarch64") || arch.equals("arm64");
    }

    private void showCard(String cardName) {
        this.panelContentLayout.show(this.panelContent, cardName);
        this.panelContent.revalidate();
        this.panelContent.repaint();
    }

    class VersionCheckListener
    implements ICheckCompleteListener {
        VersionCheckListener() {
        }

        @Override
        public void onCheckCompleted(Object data, int type) {
            if (data instanceof Bundle) {
                UpdateDialog.this.mVersionInfo = (Bundle)data;
                boolean connectionError = UpdateDialog.this.mVersionInfo.getBoolean("error");
                if (connectionError) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdateDialog.this.lblChecking.setText(I18NUtil.getString("version_update_conn_failed"));
                            UpdateDialog.this.lblChecking.setIcon(null);
                            UpdateDialog.this.btnConfirm.setVisible(true);
                        }
                    });
                    return;
                }
                if (!UpdateDialog.this.mVersionInfo.containsKey("versionCode") && UpdateDialog.this.mShowCheckUI) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdateDialog.this.lblChecking.setText(UpdateDialog.this.getNoNeedUpdateInfo());
                            UpdateDialog.this.lblChecking.setIcon(null);
                            UpdateDialog.this.btnConfirm.setVisible(true);
                        }
                    });
                    return;
                }
                UpdateDialog.this.mVersion = UpdateDialog.this.mVersionInfo.getString("versionName");
                UpdateDialog.this.mRedirectUrl = UpdateDialog.this.mVersionInfo.getString("downloadUrl");
                UpdateDialog.this.mRedirectUrlForMac = UpdateDialog.this.mVersionInfo.getString("downloadUrlForMac");
                UpdateDialog.this.mRedirectUrlForArm64 = UpdateDialog.this.mVersionInfo.getString("downloadUrlForArm64");
                UpdateDialog.this.mSize = UpdateDialog.this.mVersionInfo.getString("fileSize");
                UpdateDialog.this.mSizeForMac = UpdateDialog.this.mVersionInfo.getString("fileSizeForMac");
                UpdateDialog.this.mSizeForArm64 = UpdateDialog.this.mVersionInfo.getString("fileSizeForArm64");
                UpdateDialog.this.mReleaseData = UpdateDialog.this.mVersionInfo.getString("releaseDate");
                UpdateDialog.this.mDetails = UpdateDialog.this.mVersionInfo.getString("details");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean isNeedUpgrade = VersionCheckUtils.isSameVersion(UpdateDialog.this.mVersionInfo, UpdateDialog.this.mCurrentVersionCode);
                            if (isNeedUpgrade) {
                                PreferencesUtil.setUpgradeReadyVersion(UpdateDialog.this.mVersion);
                                BroadcastUtil.sendUpgradeRequiredEvent(UCChatClient.context);
                                if (UpdateDialog.this.mShowIfUpdateReady) {
                                    UpdateDialog.this.lblVersion.setText("<html>" + String.format(I18NUtil.getString("version_hasnewversion_body"), UpdateDialog.this.mVersion) + "</html>");
                                    float fileSize = 0.0f;
                                    fileSize = UpdateDialog.this.isWindows() ? Float.parseFloat(UpdateDialog.this.mSize) / 1000000.0f : (UpdateDialog.isArm64() ? Float.parseFloat(UpdateDialog.this.mSizeForArm64) / 1000000.0f : Float.parseFloat(UpdateDialog.this.mSizeForMac) / 1000000.0f);
                                    UpdateDialog.this.lblFilesize.setText(String.format("%.2fMB", Float.valueOf(fileSize)));
                                    UpdateDialog.this.txtChangelist.setText(UpdateDialog.this.mDetails);
                                    UpdateDialog.this.txtChangelist.setCaretPosition(0);
                                    UpdateDialog.this.showCard(UpdateDialog.CARD_HINT);
                                    UpdateDialog.this.setVisible(true);
                                }
                            } else {
                                PreferencesUtil.removeUpgradeReadyVersion();
                                BroadcastUtil.sendUpgradeRequiredEvent(UCChatClient.context);
                                if (UpdateDialog.this.mShowCheckUI) {
                                    UpdateDialog.this.lblChecking.setText(UpdateDialog.this.getNoNeedUpdateInfo());
                                    UpdateDialog.this.lblChecking.setIcon(null);
                                    UpdateDialog.this.btnConfirm.setVisible(true);
                                }
                            }
                        }
                        catch (Throwable t) {
                            Log.e(UpdateDialog.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                        }
                    }
                });
            }
        }
    }

    class DownloadThread
    extends Thread {
        long fileSize;
        InputStream inputStream;
        File localFile;
        long fileRead;
        boolean downloading;
        FileOutputStream localFileOutputStream;
        boolean terminated;

        public DownloadThread(long fileSize, InputStream inputStream, File localFile) {
            super("UC-DownloadUploadThread");
            this.fileSize = 0L;
            this.fileRead = 0L;
            this.downloading = true;
            this.localFileOutputStream = null;
            this.terminated = false;
            this.fileSize = fileSize;
            this.inputStream = inputStream;
            this.localFile = localFile;
        }

        public void terminate() {
            this.terminated = true;
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (Exception ex) {
                Log.e(UpdateDialog.class.getSimpleName(), ex.getLocalizedMessage());
            }
            try {
                if (this.localFileOutputStream != null) {
                    this.localFileOutputStream.close();
                }
            }
            catch (Exception ex) {
                Log.e(UpdateDialog.class.getSimpleName(), ex.getLocalizedMessage());
            }
        }

        private void upzip() {
            Log.i(UpdateDialog.class.getSimpleName(), "starting to unzip ...." + String.valueOf(this.localFile));
            try {
                ZipEntry ze;
                String userHomeDir = System.getProperty("user.home");
                File appDir = new File(userHomeDir + File.separator + "ucChatClient");
                File updateDir = new File(appDir, "update");
                ZipInputStream zis = new ZipInputStream(new FileInputStream(this.localFile));
                byte[] buff = new byte[10240];
                while ((ze = zis.getNextEntry()) != null) {
                    Log.i(UpdateDialog.class.getSimpleName(), ze.getName());
                    File entryFile = new File(updateDir, ze.getName());
                    if (ze.isDirectory()) {
                        entryFile.mkdirs();
                        continue;
                    }
                    entryFile.getParentFile().mkdirs();
                    FileOutputStream zefos = new FileOutputStream(entryFile);
                    int read = 0;
                    while ((read = zis.read(buff)) > 0) {
                        zefos.write(buff, 0, read);
                    }
                    zefos.close();
                }
                zis.close();
            }
            catch (Throwable t) {
                Log.e(UpdateDialog.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
            }
            Log.i(UpdateDialog.class.getSimpleName(), "unzip finish ...");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.i(UpdateDialog.class.getSimpleName(), "download update start! ");
            try {
                File jarFile;
                int len;
                this.localFileOutputStream = new FileOutputStream(this.localFile);
                byte[] buffer = new byte[10240];
                while ((len = this.inputStream.read(buffer)) > 0) {
                    this.localFileOutputStream.write(buffer, 0, len);
                    this.fileRead += (long)len;
                }
                this.downloading = false;
                Log.i(UpdateDialog.class.getSimpleName(), "download update complete! " + this.localFile.getAbsolutePath());
                if (UpdateDialog.this.isWindows()) {
                    this.upzip();
                }
                if (!(jarFile = new File(UCChatClient.class.getProtectionDomain().getCodeSource().getLocation().toURI())).getName().endsWith(".jar")) {
                    Log.e(UpdateDialog.class.getSimpleName(), "UCChatClient is not launched from ucChatClient.jar! your path is " + jarFile.getAbsolutePath());
                    JOptionPane.showMessageDialog(UpdateDialog.this, "\u76ee\u524d\u662f\u958b\u767c\u6a21\u5f0f\uff0c\u6bcb\u9808\u66f4\u65b0!", I18NUtil.getString("common_title_warning"), 2);
                    UpdateDialog.this.dispose();
                    return;
                }
                UpdateDialog.this.dispose();
                ToastUtil.showLong(I18NUtil.getString("version_notice_update_processing"));
                UpdateDialog.this.timer.schedule((TimerTask)new RestartTimer(), 3000L);
            }
            catch (Throwable e) {
                Log.e(UpdateDialog.class.getSimpleName(), e.getLocalizedMessage(), e);
                if (!this.terminated) {
                    JOptionPane.showMessageDialog(UpdateDialog.this, I18NUtil.getString("version_update_download_failed"), I18NUtil.getString("common_title_error"), 0);
                    UpdateDialog.this.dispose();
                }
            }
            finally {
                this.downloading = false;
                if (this.localFileOutputStream != null) {
                    try {
                        this.localFileOutputStream.close();
                    }
                    catch (IOException e) {
                        Log.e(UpdateDialog.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        Log.e(UpdateDialog.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    class ProgressThread
    extends Thread {
        DownloadThread dt;
        boolean isTerminated;

        public ProgressThread(DownloadThread dt) {
            super("UC-DownloadUploadProgressThread");
            this.isTerminated = false;
            this.dt = dt;
        }

        public void terminate() {
            this.isTerminated = true;
        }

        @Override
        public void run() {
            while (this.dt.downloading && !this.isTerminated) {
                this.setProgressBarValue();
                try {
                    ProgressThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setProgressBarValue();
            Log.i(UpdateDialog.class.getSimpleName(), "progress => end ");
        }

        private void setProgressBarValue() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Log.d(UpdateDialog.class.getSimpleName(), "progress => " + ProgressThread.this.dt.fileRead);
                    int percent = (int)((float)ProgressThread.this.dt.fileRead / (float)ProgressThread.this.dt.fileSize * 100.0f);
                    UpdateDialog.this.pbDownload.setValue(percent);
                }
            });
        }
    }

    class GetDownloadUrlListener
    implements ICheckCompleteListener {
        GetDownloadUrlListener() {
        }

        @Override
        public void onCheckCompleted(final Object result, int type) {
            Log.i(UpdateDialog.class.getSimpleName(), "onCheckCompleted===>" + String.valueOf(result));
            if (TextUtils.isNotBlank((CharSequence)String.valueOf(result))) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateDialog.this.showCard(UpdateDialog.CARD_DOWNLOADING);
                    }
                });
                Thread t = new Thread("UpdateDialogDelayRunner"){

                    @Override
                    public void run() {
                        if (UpdateDialog.this.isWindows()) {
                            UpdateDialog.this.downloadUpdate(String.valueOf(result), (int)Float.parseFloat(UpdateDialog.this.mSize));
                        } else if (UpdateDialog.isArm64()) {
                            UpdateDialog.this.downloadUpdate(String.valueOf(result), (int)Float.parseFloat(UpdateDialog.this.mSizeForArm64));
                        } else {
                            UpdateDialog.this.downloadUpdate(String.valueOf(result), (int)Float.parseFloat(UpdateDialog.this.mSizeForMac));
                        }
                    }
                };
                t.start();
            }
        }
    }

    class RestartTimer
    extends UCTimerTask {
        RestartTimer() {
        }

        private File getJreDir(File installDir) {
            File javaJreDir = new File(installDir.getAbsolutePath() + File.separator + "jre64");
            Log.i(UpdateDialog.class.getSimpleName(), "javaJreDir:" + javaJreDir.getAbsolutePath());
            if (!javaJreDir.exists()) {
                javaJreDir = new File(System.getenv("JAVA_HOME"));
            }
            return javaJreDir;
        }

        @Override
        public void doRun() {
            try {
                if (UpdateDialog.this.isWindows()) {
                    Log.i(UpdateDialog.class.getSimpleName(), System.getProperty("os.name"));
                    File jarFile = new File(UCChatClient.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    File installDir = jarFile.getParentFile();
                    File javaJreDir = this.getJreDir(installDir);
                    if (!javaJreDir.exists()) {
                        Log.e(UpdateDialog.class.getSimpleName(), "canot find java home, skip!");
                        return;
                    }
                    String javaBin = javaJreDir.getAbsolutePath() + File.separator + "bin" + File.separator + "javaw";
                    String userHomeDir = System.getProperty("user.home");
                    File appDir = new File(userHomeDir + File.separator + "ucChatClient");
                    File updateDir = new File(appDir, "update");
                    String classpath = updateDir.getAbsolutePath() + File.separator + "updater.jar";
                    String[] commandAry = new String[]{javaBin, "-cp", classpath, "com.blisscloud.ezuc.LibUpdater", installDir.getPath()};
                    Process process = Runtime.getRuntime().exec(commandAry);
                } else if (UpdateDialog.this.isMac()) {
                    File localFile = new File(FileUtil.getUpdateRoot(false), "update.dmg");
                    try {
                        ProcessBuilder pb = new ProcessBuilder("open", localFile.getAbsolutePath());
                        pb.start();
                    }
                    catch (Exception e) {
                        Log.e(UpdateDialog.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
                    }
                }
                Log.i(UpdateDialog.class.getSimpleName(), "after run ....");
                System.exit(0);
            }
            catch (Throwable e) {
                Log.e(UpdateDialog.class.getSimpleName(), e.getLocalizedMessage(), e);
                JOptionPane.showMessageDialog(UpdateDialog.this, I18NUtil.getString("version_update_download_failed"), I18NUtil.getString("common_title_error"), 0);
                UpdateDialog.this.dispose();
            }
        }

        private void printProcess(Process p) throws IOException {
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                Log.i(UpdateDialog.class.getSimpleName(), line);
            }
            input.close();
            BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((line = error.readLine()) != null) {
                Log.e(UpdateDialog.class.getSimpleName(), line);
            }
            error.close();
        }
    }
}

