/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LitePresence;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.PresenceManager;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import org.apache.commons.codec.binary.Base64;

public final class GraphicUtil {
    public static final Color BG_COLOR = new Color(235, 235, 235);
    private static final BasicStroke STROKE_PRESENCE = new BasicStroke(1.0f, 2, 0, 1.0f, null, 0.0f);
    private static final BasicStroke STROKE_BORDER = new BasicStroke(3.0f, 2, 0, 1.0f, null, 0.0f);
    private static Map<String, Image> imageCache = new HashMap<String, Image>();
    private static final int CROPPED_IMAGE_SIZE = 192;

    public static void centerWindowOnScreen(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = window.getSize();
        if (size.height > screenSize.height) {
            size.height = screenSize.height;
        }
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
        }
        window.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public static void drawHighlightBorder(Graphics g, int x, int y, int width, int height, boolean raised, Color shadow, Color highlight) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(raised ? highlight : shadow);
        g.drawLine(0, 0, width - 2, 0);
        g.drawLine(0, 1, 0, height - 2);
        g.setColor(raised ? shadow : highlight);
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.drawLine(0, height - 1, width - 2, height - 1);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public static Point getPopupMenuShowPoint(JPopupMenu popup, MouseEvent event) {
        Component source = (Component)event.getSource();
        Point topLeftSource = source.getLocationOnScreen();
        Point ptRet = GraphicUtil.getPopupMenuShowPoint(popup, topLeftSource.x + event.getX(), topLeftSource.y + event.getY());
        ptRet.translate(-topLeftSource.x, -topLeftSource.y);
        return ptRet;
    }

    public static Point getPopupMenuShowPoint(JPopupMenu popup, int x, int y) {
        Dimension sizeMenu = popup.getPreferredSize();
        Point bottomRightMenu = new Point(x + sizeMenu.width, y + sizeMenu.height);
        for (Rectangle screenBounds : GraphicUtil.getScreenBounds()) {
            if (screenBounds.x > x || x > screenBounds.x + screenBounds.width) continue;
            Dimension sizeScreen = screenBounds.getSize();
            sizeScreen.height -= 32;
            int xOffset = 0;
            if (bottomRightMenu.x > screenBounds.x + sizeScreen.width) {
                xOffset = -sizeMenu.width;
            }
            int yOffset = 0;
            if (bottomRightMenu.y > screenBounds.y + sizeScreen.height) {
                yOffset = sizeScreen.height - bottomRightMenu.y;
            }
            return new Point(x + xOffset, y + yOffset);
        }
        return new Point(x, y);
    }

    public static void centerWindowOnComponent(Window window, Component over) {
        if (over == null || !over.isShowing()) {
            GraphicUtil.centerWindowOnScreen(window);
            return;
        }
        Point parentLocation = over.getLocationOnScreen();
        Dimension parentSize = over.getSize();
        Dimension size = window.getSize();
        int x = parentLocation.x + (parentSize.width - size.width) / 2;
        int y = parentLocation.y + (parentSize.height - size.height) / 2;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (x + size.width > screenSize.width) {
            x = screenSize.width - size.width;
        }
        if (x < 0) {
            x = 0;
        }
        if (y + size.height > screenSize.height) {
            y = screenSize.height - size.height;
        }
        if (y < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static boolean isAncestorOfFocusedComponent(Component c) {
        if (c.hasFocus()) {
            return true;
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int n = cont.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component child = cont.getComponent(i);
                if (!GraphicUtil.isAncestorOfFocusedComponent(child)) continue;
                return true;
            }
        }
        return false;
    }

    public static Component getFocusableComponentOrChild(Component c) {
        return GraphicUtil.getFocusableComponentOrChild(c, false);
    }

    public static Component getFocusableComponentOrChild(Component c, boolean deepest) {
        if (c != null && c.isEnabled() && c.isVisible() && c instanceof Container) {
            JComponent jc;
            Container cont = (Container)c;
            if (!deepest && c instanceof JComponent && (jc = (JComponent)c).isRequestFocusEnabled()) {
                return jc;
            }
            int n = cont.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component child = cont.getComponent(i);
                Component focused = GraphicUtil.getFocusableComponentOrChild(child, deepest);
                if (focused == null) continue;
                return focused;
            }
            if (c instanceof JComponent) {
                JComponent jc2;
                if (deepest && (jc2 = (JComponent)c).isRequestFocusEnabled()) {
                    return jc2;
                }
            } else {
                return c;
            }
        }
        return null;
    }

    public static Component focusComponentOrChild(Component c) {
        return GraphicUtil.focusComponentOrChild(c, false);
    }

    public static Component focusComponentOrChild(Component c, boolean deepest) {
        Component focusable = GraphicUtil.getFocusableComponentOrChild(c, deepest);
        if (focusable != null) {
            focusable.requestFocus();
        }
        return focusable;
    }

    public static Image loadFromResource(String imageName, Class<?> cls) {
        try {
            URL url = cls.getResource(imageName);
            if (url == null) {
                return null;
            }
            Image image = imageCache.get(url.toString());
            if (image == null) {
                image = Toolkit.getDefaultToolkit().createImage(url);
                imageCache.put(url.toString(), image);
            }
            return image;
        }
        catch (Exception e) {
            Log.e(GraphicUtil.class.getSimpleName(), "ERROR" + e.getMessage(), e);
            return null;
        }
    }

    public static Rectangle[] getScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = graphicsEnvironment.getScreenDevices();
        Rectangle[] screenBounds = new Rectangle[screenDevices.length];
        for (int i = 0; i < screenDevices.length; ++i) {
            GraphicsDevice screenDevice = screenDevices[i];
            GraphicsConfiguration defaultConfiguration = screenDevice.getDefaultConfiguration();
            screenBounds[i] = defaultConfiguration.getBounds();
        }
        return screenBounds;
    }

    public static void makeSameSize(JComponent ... comps) {
        if (comps.length == 0) {
            return;
        }
        int max = 0;
        for (JComponent comp1 : comps) {
            int w = comp1.getPreferredSize().width;
            max = w > max ? w : max;
        }
        Dimension dim = new Dimension(max, comps[0].getPreferredSize().height);
        for (JComponent comp : comps) {
            comp.setPreferredSize(dim);
        }
    }

    public static String toHTMLColor(Color c) {
        int color = c.getRGB();
        String s = Integer.toHexString(color |= 0xFF000000);
        return s.substring(2);
    }

    public static String createToolTip(String text, int width) {
        String htmlColor = GraphicUtil.toHTMLColor(UIConstants.COLOR_TOOLTIP);
        return "<html><table width=" + width + " bgColor=" + htmlColor + "><tr><td>" + text + "</td></tr></table></table>";
    }

    public static String createToolTip(String text) {
        String htmlColor = GraphicUtil.toHTMLColor(UIConstants.COLOR_TOOLTIP);
        return "<html><table  bgColor=" + htmlColor + "><tr><td>" + text + "</td></tr></table></table>";
    }

    public static ImageIcon createShadowPicture(Image buf) {
        buf = GraphicUtil.removeTransparency(buf);
        JLabel label = new JLabel();
        int width = buf.getWidth(null);
        int height = buf.getHeight(null);
        int extra = 4;
        BufferedImage splash = new BufferedImage(width + extra, height + extra, 2);
        Graphics2D g2 = (Graphics2D)splash.getGraphics();
        BufferedImage shadow = new BufferedImage(width + extra, height + extra, 2);
        Graphics g = shadow.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.3f));
        g.fillRoundRect(0, 0, width, height, 12, 12);
        g2.drawImage(shadow, GraphicUtil.getBlurOp(7), 0, 0);
        g2.drawImage(buf, 0, 0, label);
        return new ImageIcon(splash);
    }

    public static BufferedImage removeTransparency(Image image) {
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        BufferedImage bi2 = new BufferedImage(w, h, 1);
        Graphics2D g = bi2.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bi2;
    }

    public static Image toImage(BufferedImage bufferedImage) {
        return Toolkit.getDefaultToolkit().createImage(bufferedImage.getSource());
    }

    private static ConvolveOp getBlurOp(int size) {
        float[] data = new float[size * size];
        float value = 1.0f / (float)(size * size);
        for (int i = 0; i < data.length; ++i) {
            data[i] = value;
        }
        return new ConvolveOp(new Kernel(size, size, data));
    }

    public static BufferedImage convert(Image im) throws InterruptedException, IOException {
        BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 3);
        Graphics bg = bi.getGraphics();
        bg.drawImage(im, 0, 0, null);
        bg.dispose();
        return bi;
    }

    public static BufferedImage convertBase64StringToImage(String photoStr) {
        try {
            byte[] photoData = Base64.decodeBase64((String)photoStr);
            ByteArrayInputStream bais = new ByteArrayInputStream(photoData);
            return ImageIO.read(bais);
        }
        catch (Exception e) {
            Log.e(GraphicUtil.class.getSimpleName(), "ERROR" + e.getMessage(), e);
            return null;
        }
    }

    public static BufferedImage crop(BufferedImage originalImage) {
        int width;
        int height = originalImage.getHeight();
        int finalSize = width = originalImage.getWidth();
        finalSize = height > width ? width : height;
        int xc = (width - finalSize) / 2;
        int yc = (height - finalSize) / 2;
        BufferedImage croppedImage = originalImage.getSubimage(xc, yc, finalSize, finalSize);
        return croppedImage;
    }

    public static String convertImageToBase64String(BufferedImage bi) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "png", baos);
            byte[] imageValue = baos.toByteArray();
            String base64ImageValue = Base64.encodeBase64String((byte[])imageValue);
            return base64ImageValue;
        }
        catch (Exception e) {
            Log.e(GraphicUtil.class.getSimpleName(), "ERROR" + e.getMessage(), e);
            return null;
        }
    }

    public static void load(Image image) throws InterruptedException, IOException {
        MediaTracker tracker = new MediaTracker(new Label());
        tracker.addImage(image, 0);
        tracker.waitForID(0);
        if (tracker.isErrorID(0)) {
            throw new IOException("error loading image");
        }
    }

    public static byte[] getBytesFromImage(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            fileInputStream.read(data);
            fileInputStream.close();
            return data;
        }
        catch (IOException e) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static ImageIcon scaleImageIcon(ImageIcon icon, int newHeight, int newWidth) {
        Image img = icon.getImage();
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        if (height > newHeight) {
            height = newHeight;
        }
        if (width > newWidth) {
            width = newWidth;
        }
        img = img.getScaledInstance(width, height, 4);
        return new ImageIcon(img);
    }

    public static Map<String, Object> cropImageAsBase64(File srcFile) {
        return GraphicUtil.cropImageAsBase64(FileUtil.readFileHandleExif(srcFile));
    }

    public static Map<String, Object> cropImageAsBase64(BufferedImage originalImage) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        try {
            int width = originalImage.getWidth();
            int height = originalImage.getHeight();
            float ratio = (float)Math.min(192, Math.min(width, height)) / (float)Math.max(width, height);
            int cropWidth = (int)(ratio * (float)width);
            int cropHeight = (int)(ratio * (float)height);
            BufferedImage cropImage = new BufferedImage(cropWidth, cropHeight, 1);
            Graphics2D g = cropImage.createGraphics();
            g.drawImage(originalImage.getScaledInstance(cropWidth, cropHeight, 4), 0, 0, cropWidth, cropHeight, BG_COLOR, null);
            g.dispose();
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
            ImageWriter writer = iter.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(1.0f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageOutputStream ios = ImageIO.createImageOutputStream(baos);
            writer.setOutput(ios);
            IIOImage image = new IIOImage(cropImage, null, null);
            writer.write(null, image, iwp);
            writer.dispose();
            String content = Base64.encodeBase64String((byte[])baos.toByteArray());
            baos.close();
            ret.put("cropWidth", cropWidth);
            ret.put("cropHeight", cropHeight);
            ret.put("base64Image", content);
            return ret;
        }
        catch (IOException e) {
            Log.e(GraphicUtil.class.getSimpleName(), "ERROR" + e.getMessage(), e);
            return null;
        }
    }

    public static ImageIcon scale(ImageIcon icon, int newHeight, int newWidth) {
        int width;
        boolean scaleHeight;
        Image img = icon.getImage();
        int height = icon.getIconHeight();
        boolean bl = scaleHeight = height * newWidth > (width = icon.getIconWidth()) * newHeight;
        if (height > newHeight) {
            if (width <= newWidth || scaleHeight) {
                height = newHeight;
                width = -1;
            } else {
                height = -1;
                width = newWidth;
            }
        } else if (width > newWidth) {
            height = -1;
            width = newWidth;
        } else if (scaleHeight) {
            height = newHeight;
            width = -1;
        } else {
            height = -1;
            width = newWidth;
        }
        img = img.getScaledInstance(width, height, 4);
        return new ImageIcon(img);
    }

    public static ImageIcon fitToSquare(ImageIcon icon, int newSize) {
        int newHeight;
        int newWidth;
        if (newSize <= 0) {
            return icon;
        }
        int oldWidth = icon.getIconWidth();
        int oldHeight = icon.getIconHeight();
        if (oldHeight >= oldWidth) {
            newWidth = (int)((float)oldWidth * (float)newSize / (float)oldHeight);
            newHeight = newSize;
        } else {
            newWidth = newSize;
            newHeight = (int)((float)oldHeight * (float)newSize / (float)oldWidth);
        }
        Image img = icon.getImage().getScaledInstance(newWidth, newHeight, 4);
        return new ImageIcon(img);
    }

    public static BufferedImage getRoundedCornerImage(Image image) {
        int imgWidth = image.getWidth(null);
        int imgHeight = image.getHeight(null);
        return GraphicUtil.getRoundedCornerImage(image, imgWidth, imgHeight, 0.3f, 0.3f);
    }

    public static BufferedImage getRoundedCornerImage(Image image, int width, int height) {
        return GraphicUtil.getRoundedCornerImage(image, width, height, 0.3f, 0.3f);
    }

    public static BufferedImage convertVideoThumbnailImage(BufferedImage image, int maxWidth, int playSize) {
        int original = image.getWidth();
        int width = Math.min(original, maxWidth);
        double ratio = (double)width * 1.0 / (double)original * 1.0;
        int height = (int)((double)image.getHeight() * ratio);
        BufferedImage compoundedImg = new BufferedImage(width, height, 2);
        Graphics2D rounded2D = compoundedImg.createGraphics();
        rounded2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rounded2D.drawImage(image, 0, 0, width, height, null);
        Image playImg = new ImageIcon(UIConstants.class.getClassLoader().getResource("images/message/play.png")).getImage();
        playImg = GraphicUtil.getScaledIcon(playImg, playSize, playSize).getImage();
        rounded2D.drawImage(playImg, (width - playImg.getWidth(null)) / 2, (height - playImg.getHeight(null)) / 2, null);
        return compoundedImg;
    }

    public static BufferedImage convertThumbnailImage(BufferedImage image, int maxWidth) {
        int original = image.getWidth();
        int width = Math.min(original, maxWidth);
        double ratio = (double)width * 1.0 / (double)original * 1.0;
        int height = (int)((double)image.getHeight() * ratio);
        BufferedImage compoundedImg = new BufferedImage(width, height, 2);
        Graphics2D rounded2D = compoundedImg.createGraphics();
        rounded2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rounded2D.drawImage(image, 0, 0, width, height, null);
        return compoundedImg;
    }

    public static Image getChatRoomImage(Context ctx, List<String> participantJidList, Map<String, LiteContact> contactsMap, boolean isBig, boolean roundImage) {
        ArrayList<Image> participantImages = new ArrayList<Image>();
        ArrayList<Image> defaultImages = new ArrayList<Image>();
        LiteContact defaultContact = null;
        for (int i = 0; participantJidList != null && i < participantJidList.size(); ++i) {
            String participantJid = participantJidList.get(i);
            LiteContact contact = null;
            if (contactsMap != null && contactsMap.containsKey(participantJid)) {
                contact = contactsMap.get(participantJid);
            } else {
                contact = ContactManager.getContact(ctx, participantJid);
                if (contactsMap != null) {
                    contactsMap.put(participantJid, contact);
                }
            }
            if (contact == null) continue;
            defaultContact = contact;
            Image bi = ContactManager.getContactImage(contact, isBig ? 100 : 32, true, roundImage);
            if (bi == null) {
                defaultImages.add(isBig ? UIConstants.ICON_PERSON96.getImage() : UIConstants.ICON_PERSON32.getImage());
                continue;
            }
            participantImages.add(bi);
        }
        participantImages.addAll(defaultImages);
        if (participantImages != null && participantImages.size() == 1 && defaultContact != null) {
            Image bi = ContactManager.getContactImage(defaultContact, isBig ? 100 : 48, false, roundImage);
            if (bi != null) {
                return bi;
            }
            return isBig ? UIConstants.ICON_PERSON96.getImage() : UIConstants.ICON_PERSON64.getImage();
        }
        return GraphicUtil.getCompoundRoundedCornerImage(participantImages, isBig ? 170 : 64, isBig ? 170 : 64, true, roundImage);
    }

    public static Image getChatRoomImage48(Context ctx, List<String> participantJidList, Map<String, LiteContact> contactsMap, boolean roundImage) {
        ArrayList<Image> participantImages = new ArrayList<Image>();
        ArrayList<Image> defaultImages = new ArrayList<Image>();
        LiteContact defaultContact = null;
        for (int i = 0; participantJidList != null && i < participantJidList.size(); ++i) {
            String participantJid = participantJidList.get(i);
            LiteContact contact = null;
            if (contactsMap != null && contactsMap.containsKey(participantJid)) {
                contact = contactsMap.get(participantJid);
            } else {
                contact = ContactManager.getContact(ctx, participantJid);
                if (contactsMap != null) {
                    contactsMap.put(participantJid, contact);
                }
            }
            if (contact == null) continue;
            defaultContact = contact;
            Image bi = ContactManager.getContactImage(contact, 32, true, roundImage);
            if (bi == null) {
                defaultImages.add(UIConstants.ICON_PERSON32.getImage());
                continue;
            }
            participantImages.add(bi);
        }
        participantImages.addAll(defaultImages);
        if (participantImages != null && participantImages.size() == 1 && defaultContact != null) {
            Image bi = ContactManager.getContactImage(defaultContact, 48, false, roundImage);
            if (bi != null) {
                return bi;
            }
            return UIConstants.ICON_PERSON48.getImage();
        }
        return GraphicUtil.getCompoundRoundedCornerImage(participantImages, 48, 48, true, roundImage);
    }

    public static Image getCompoundRoundedCornerImage(List<Image> images, int width, int height, boolean hasGrayBack, boolean roundImage) {
        BufferedImage compoundedImg = new BufferedImage(width, height, 2);
        Graphics2D rounded2D = compoundedImg.createGraphics();
        rounded2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (hasGrayBack) {
            rounded2D.setColor(new Color(229, 229, 229));
            rounded2D.fillRoundRect(0, 0, width, height, 0, 0);
        }
        if (images != null) {
            int count = images.size();
            if (count == 1) {
                rounded2D.drawImage(images.get(0), 0, 0, width, height, null);
            } else if (count == 2) {
                rounded2D.drawImage(images.get(0), 0, height / 4, width / 2, height / 2, null);
                rounded2D.drawImage(images.get(1), width / 2, height / 4, width / 2, height / 2, null);
            } else if (count == 3) {
                rounded2D.drawImage(images.get(0), width / 4, 0, width / 2, height / 2, null);
                rounded2D.drawImage(images.get(1), 0, height / 2, width / 2, height / 2, null);
                rounded2D.drawImage(images.get(2), width / 2, height / 2, width / 2, height / 2, null);
            } else if (count == 4) {
                rounded2D.drawImage(images.get(0), 0, 0, width / 2, height / 2, null);
                rounded2D.drawImage(images.get(1), width / 2, 0, width / 2, height / 2, null);
                rounded2D.drawImage(images.get(2), 0, height / 2, width / 2, height / 2, null);
                rounded2D.drawImage(images.get(3), width / 2, height / 2, width / 2, height / 2, null);
            } else if (count == 5) {
                rounded2D.drawImage(images.get(0), width / 6, height / 6, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(1), width / 2, height / 6, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(2), 0, height / 2, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(3), width / 3, height / 2, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(4), 2 * width / 3, height / 2, width / 3, height / 3, null);
            } else if (count == 6) {
                rounded2D.drawImage(images.get(0), 0, height / 6, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(1), width / 3, height / 6, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(2), 2 * width / 3, height / 6, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(3), 0, height / 2, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(4), width / 3, height / 2, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(5), 2 * width / 3, height / 2, width / 3, height / 3, null);
            } else if (count == 7) {
                rounded2D.drawImage(images.get(0), width / 3, 0, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(1), 0, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(2), width / 3, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(3), 2 * width / 3, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(4), 0, 2 * height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(5), width / 3, 2 * height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(6), 2 * width / 3, 2 * height / 3, width / 3, height / 3, null);
            } else if (count == 8) {
                rounded2D.drawImage(images.get(0), width / 6, 0, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(1), width / 2, 0, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(2), 0, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(3), width / 3, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(4), 2 * width / 3, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(5), 0, 2 * height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(6), width / 3, 2 * height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(7), 2 * width / 3, 2 * height / 3, width / 3, height / 3, null);
            } else if (count >= 9) {
                rounded2D.drawImage(images.get(0), 0, 0, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(1), width / 3, 0, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(2), 2 * width / 3, 0, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(3), 0, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(4), width / 3, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(5), 2 * width / 3, height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(6), 0, 2 * height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(7), width / 3, 2 * height / 3, width / 3, height / 3, null);
                rounded2D.drawImage(images.get(8), 2 * width / 3, 2 * height / 3, width / 3, height / 3, null);
            }
        }
        if (roundImage) {
            return GraphicUtil.getRoundedCornerImage(compoundedImg, width, height, 0.3f, 0.3f);
        }
        return compoundedImg;
    }

    public static BufferedImage getRoundedCornerImage(Image image, int width, int height, float roundPx, float roundPy) {
        BufferedImage roundedImg = new BufferedImage(width, height, 2);
        Graphics2D rounded2D = roundedImg.createGraphics();
        rounded2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rounded2D.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width, height, (float)width * roundPx, (float)height * roundPy));
        rounded2D.setComposite(AlphaComposite.SrcIn);
        rounded2D.drawImage(image, 0, 0, width, height, null);
        return roundedImg;
    }

    public static ImageIcon getScaledIcon(String imagePath, int width, int height) {
        URL url = GraphicUtil.class.getClassLoader().getResource(imagePath);
        if (url == null) {
            return null;
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        if (image == null) {
            return null;
        }
        image = image.getScaledInstance(width, height, 4);
        return new ImageIcon(image);
    }

    public static ImageIcon getScaledIconFast(Image image, int width, int height) {
        image = image.getScaledInstance(width, height, 2);
        return new ImageIcon(image);
    }

    public static ImageIcon getScaledIcon(Image image, int width, int height) {
        image = image.getScaledInstance(width, height, 4);
        return new ImageIcon(image);
    }

    public static Image getScaled(Image image, int width, int height) {
        return image.getScaledInstance(width, height, 4);
    }

    public static final int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container c = component.getParent();
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (c.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    public static final List<Component> getChildComponent(Container parent, Class cls) {
        Component[] childComps;
        ArrayList<Component> ret = new ArrayList<Component>();
        for (Component childComp : childComps = parent.getComponents()) {
            if (!cls.isAssignableFrom(childComp.getClass())) continue;
            ret.add(childComp);
        }
        return ret;
    }

    public static void writeScaledImage(File source, File dest, int width, int height) {
        try {
            BufferedImage sourceBI = FileUtil.readFileHandleExif(source);
            Image scaledImage = sourceBI.getScaledInstance(width, height, 4);
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D big = bi.createGraphics();
            big.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            big.setComposite(AlphaComposite.SrcOver);
            big.drawImage(scaledImage, 0, 0, null);
            ImageIO.write((RenderedImage)bi, "png", dest);
        }
        catch (IOException e) {
            Log.e(GraphicUtil.class.getSimpleName(), "ERROR" + e.getMessage(), e);
        }
    }

    public static void writeScaledImage(File source, File dest, double ratio) throws IOException {
        BufferedImage sourceBI = FileUtil.readFileHandleExif(source);
        int scaledWidth = (int)((double)sourceBI.getWidth() * ratio);
        int scaledHeight = (int)((double)sourceBI.getHeight() * ratio);
        BufferedImage bi = GraphicUtil.createScaledCenterImage(sourceBI, scaledWidth, scaledHeight);
        String fileName = source.getName();
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        ImageIO.write((RenderedImage)bi, extension, dest);
    }

    public static BufferedImage createScaledCenterImage(BufferedImage originalBI, int destWidth, int destHeight) {
        int type = originalBI.getTransparency() == 1 ? 1 : 2;
        Log.d(GraphicUtil.class.getSimpleName(), "originalBI.getType()==>" + originalBI.getType());
        int srcWidth = originalBI.getWidth(null);
        int srcHeight = originalBI.getHeight(null);
        float xRatio = (float)srcWidth / (float)destWidth;
        float yRatio = (float)srcHeight / (float)destHeight;
        float biRatio = Math.max(xRatio, yRatio);
        int scaledSrcWidth = (int)((float)srcWidth / biRatio);
        int scaledSrcHeight = (int)((float)srcHeight / biRatio);
        int x = (destWidth - scaledSrcWidth) / 2;
        int y = (destHeight - scaledSrcHeight) / 2;
        Image image = originalBI.getScaledInstance(scaledSrcWidth, scaledSrcHeight, 4);
        BufferedImage scaledImage = new BufferedImage(destWidth, destHeight, type);
        scaledImage.getGraphics().drawImage(image, x, y, scaledSrcWidth, scaledSrcHeight, null);
        return scaledImage;
    }

    public static BufferedImage createScaledImage(BufferedImage originalBI, double ratio) {
        int type = originalBI.getTransparency() == 1 ? 1 : 2;
        int w = originalBI.getWidth();
        int h = originalBI.getHeight();
        int scaledSrcWidth = (int)((double)w * ratio);
        int scaledSrcHeight = (int)((double)h * ratio);
        Image image = originalBI.getScaledInstance(scaledSrcWidth, scaledSrcHeight, 4);
        BufferedImage scaledImage = new BufferedImage(scaledSrcWidth, scaledSrcHeight, type);
        scaledImage.getGraphics().drawImage(image, 0, 0, null);
        return scaledImage;
    }

    public static BufferedImage getPresencedPersonalPhoto(int width, int height, Image image, LitePresence presence, boolean roundedImage) {
        return GraphicUtil.getPresencedPersonalPhoto(width, height, image, presence, roundedImage, null, null, null);
    }

    public static BufferedImage getPresencedPersonalPhoto(int width, int height, Image image, LitePresence presence, boolean roundedImage, Color borderColorFrom, Color borderColorTo) {
        return GraphicUtil.getPresencedPersonalPhoto(width, height, image, presence, roundedImage, borderColorFrom, borderColorTo, null);
    }

    public static BufferedImage getPresencedPersonalPhoto(int width, int height, Image image, LitePresence presence, boolean roundedImage, Color borderColorFrom, Color borderColorTo, Image hintImage) {
        Image photoImage = null;
        photoImage = image == null ? (width <= 32 ? UIConstants.ICON_PERSON32.getImage() : (width <= 48 ? UIConstants.ICON_PERSON48.getImage() : (width <= 64 ? UIConstants.ICON_PERSON64.getImage() : UIConstants.ICON_PERSON96.getImage()))) : (roundedImage ? GraphicUtil.getRoundedCornerImage(image) : image);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D big = bi.createGraphics();
        big.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (presence == null) {
            if (photoImage.getWidth(null) > width || photoImage.getHeight(null) > height) {
                big.drawImage(photoImage.getScaledInstance(width, height, 4), 0, 0, width, height, null);
            } else {
                big.drawImage(photoImage, 0, 0, width, height, null);
            }
        } else {
            big.setColor(Color.WHITE);
            big.fill(new RoundRectangle2D.Float(0.0f, 0.0f, width - 1, height - 1, (float)width * 0.3f, (float)width * 0.3f));
            if (photoImage.getWidth(null) > width || photoImage.getHeight(null) > height) {
                big.drawImage(photoImage.getScaledInstance(width, height, 4), 0, 0, width, height, null);
            } else {
                big.drawImage(photoImage, 0, 0, width, height, null);
            }
            big.setComposite(AlphaComposite.SrcIn);
            Color presenceColor = PresenceManager.getPresenceColor(presence);
            float presenceRatio = 1.1f;
            float presenceX = (float)(-width) * presenceRatio * 0.88f;
            float presenceY = (float)(-height) * 0.05f;
            float arc = (float)width * 0.3f;
            RoundRectangle2D.Float rect = new RoundRectangle2D.Float(presenceX, presenceY, (float)width * presenceRatio, (float)height * presenceRatio, arc, arc);
            big.setColor(presenceColor);
            big.fill(rect);
            big.setColor(Color.WHITE);
            big.setStroke(STROKE_PRESENCE);
            big.draw(rect);
        }
        if (borderColorFrom != null) {
            if (borderColorTo == null) {
                borderColorTo = borderColorFrom;
            }
            RoundRectangle2D.Float rect = new RoundRectangle2D.Float(0.0f, 0.0f, width - 1, height - 1, (float)width * 0.3f, (float)width * 0.3f);
            GradientPaint paintBorder = new GradientPaint(0.0f, 0.0f, borderColorFrom, 0.0f, height, borderColorTo, true);
            big.setPaint(paintBorder);
            big.setStroke(STROKE_BORDER);
            big.draw(rect);
        }
        if (hintImage != null) {
            big.setComposite(AlphaComposite.SrcOver);
            big.drawImage(hintImage, width - hintImage.getWidth(null), height - hintImage.getHeight(null), null);
        }
        return bi;
    }

    public static void main(String[] args) {
        GraphicUtil.writeScaledImage(new File("f:\\voice_off.png"), new File("f:\\voice_off2.png"), 16, 16);
    }
}

