/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import com.blisscloud.ezuc.client.util.simulate.Log;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.atomic.AtomicLong;

public class SystemUtils {
    private static AtomicLong sequence = new AtomicLong(System.currentTimeMillis());

    public static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.startsWith("windows");
    }

    public static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0 || osName.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("sunos") >= 0;
    }

    public static int getAvailablePort(int fromPort, int maxTry) {
        ServerSocket ss = null;
        for (int port = fromPort; port < fromPort + maxTry; ++port) {
            try {
                ss = new ServerSocket(port);
                try {
                    ss.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return port;
            }
            catch (IOException e) {
                Log.w(SystemUtils.class.getSimpleName(), "port " + port + " is in use!");
                continue;
            }
        }
        return -1;
    }

    public static long getAndIncrementSequence() {
        return sequence.getAndIncrement();
    }
}

