/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class ToneUtil {
    public static void generateTone(char c) {
        try {
            if (c == '1') {
                ToneUtil.generateTone(697, 1209, 100, 25, true);
            } else if (c == '2') {
                ToneUtil.generateTone(697, 1336, 100, 25, true);
            } else if (c == '3') {
                ToneUtil.generateTone(697, 1477, 100, 25, true);
            } else if (c == '4') {
                ToneUtil.generateTone(770, 1209, 100, 25, true);
            } else if (c == '5') {
                ToneUtil.generateTone(770, 1336, 100, 25, true);
            } else if (c == '6') {
                ToneUtil.generateTone(770, 1477, 100, 25, true);
            } else if (c == '7') {
                ToneUtil.generateTone(852, 1209, 100, 25, true);
            } else if (c == '8') {
                ToneUtil.generateTone(852, 1336, 100, 25, true);
            } else if (c == '9') {
                ToneUtil.generateTone(852, 1477, 100, 25, true);
            } else if (c == '0') {
                ToneUtil.generateTone(941, 1336, 100, 25, true);
            } else if (c == '*') {
                ToneUtil.generateTone(941, 1209, 100, 25, true);
            } else if (c == '#') {
                ToneUtil.generateTone(941, 1477, 100, 25, true);
            }
        }
        catch (LineUnavailableException lue) {
            System.out.println(lue);
        }
    }

    public static void generateTone(int hz1, int hz2, int msecs, int volume, boolean addHarmonic) throws LineUnavailableException {
        AudioFormat af;
        byte[] buf;
        float frequency = 44100.0f;
        if (addHarmonic) {
            buf = new byte[2];
            af = new AudioFormat(frequency, 8, 2, true, false);
        } else {
            buf = new byte[1];
            af = new AudioFormat(frequency, 8, 1, true, false);
        }
        SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
        sdl.open(af);
        sdl.start();
        int i = 0;
        while ((float)i < (float)(msecs / 2) * frequency / 1000.0f) {
            ToneUtil.write(hz1, volume, addHarmonic, frequency, buf, sdl, i);
            ToneUtil.write(hz2, volume, addHarmonic, frequency, buf, sdl, i);
            ++i;
        }
        sdl.drain();
        sdl.stop();
        sdl.close();
        sdl = null;
    }

    private static void write(int hz1, int volume, boolean addHarmonic, float frequency, byte[] buf, SourceDataLine sdl, int i) {
        double angle = (double)((float)i / (frequency / (float)hz1)) * 2.0 * Math.PI;
        buf[0] = (byte)(Math.sin(angle) * (double)volume);
        if (addHarmonic) {
            double angle2 = (double)((float)i / (frequency / (float)hz1)) * 2.0 * Math.PI;
            buf[1] = (byte)(Math.sin(2.0 * angle2) * (double)volume * 0.6);
            sdl.write(buf, 0, 2);
        } else {
            sdl.write(buf, 0, 1);
        }
    }
}

