/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util.simulate;

import com.blisscloud.ezuc.client.annotation.SimulateAndroid;
import com.blisscloud.ezuc.client.util.simulate.AssetManager;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.ComponentName;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Service;
import com.blisscloud.ezuc.client.util.simulate.ServiceConnection;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;

@SimulateAndroid(androidClassName="android.content.Context")
public class Context {
    public static final int BIND_AUTO_CREATE = 1;
    public static final int BIND_DEBUG_UNBIND = 2;
    public static final int BIND_NOT_FOREGROUND = 4;
    public static final int BIND_ABOVE_CLIENT = 8;
    public static final int BIND_ALLOW_OOM_MANAGEMENT = 16;
    public static final int BIND_WAIVE_PRIORITY = 32;
    public static final int BIND_IMPORTANT = 64;
    public static final int BIND_ADJUST_WITH_ACTIVITY = 128;
    public static final int BIND_TREAT_LIKE_ACTIVITY = 0x8000000;
    public static final int BIND_VISIBLE = 0x10000000;
    public static final int BIND_SHOWING_UI = 0x20000000;
    public static final int BIND_NOT_VISIBLE = 0x40000000;
    private AssetManager assets = new AssetManager();
    private Map<BroadcastReceiver, IntentFilter> receiverMap = new ConcurrentHashMap<BroadcastReceiver, IntentFilter>();
    public static final String CONNECTIVITY_SERVICE = "connectivity";
    private Map<String, Service> serviceMap = new HashMap<String, Service>();

    public Context getApplicationContext() {
        return this;
    }

    public void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        if (filter != null) {
            this.receiverMap.put(receiver, filter);
        }
    }

    public void unregisterReceiver(BroadcastReceiver receiver) {
        this.receiverMap.remove(receiver);
    }

    public void sendBroadcast(final Intent intent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HashSet<BroadcastReceiver> receivers = new HashSet<BroadcastReceiver>(Context.this.receiverMap.keySet());
                for (BroadcastReceiver receiver : receivers) {
                    IntentFilter filter = Context.this.receiverMap.get(receiver);
                    if (filter == null || !filter.hasAction(intent.getAction())) continue;
                    receiver.onReceive(Context.this, intent);
                }
            }
        });
    }

    public void startService(Intent intent) {
    }

    public AssetManager getAssets() {
        return this.assets;
    }

    public File getExternalFilesDir(String type) {
        return FileUtil.getExternalFileDir(type);
    }

    public String getPackageName() {
        return "com.blisscloud.ezuc";
    }

    public boolean bindService(Intent service, ServiceConnection conn, int flags) {
        ComponentName compName = service.getComponent();
        String clsName = compName.getClassName();
        try {
            Service serviceInstance = (Service)Class.forName(clsName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            serviceInstance.onCreate();
            conn.onServiceConnected(compName, serviceInstance);
            this.serviceMap.put(clsName, serviceInstance);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void unbindService(ServiceConnection conn) {
        try {
            conn.onServiceDisconnected(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean stopService(Intent service) {
        ComponentName compName = service.getComponent();
        String clsName = compName.getClassName();
        Service serviceInstance = this.serviceMap.remove(clsName);
        serviceInstance.onDestroy();
        return true;
    }
}

