/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util.simulate;

import com.blisscloud.ezuc.client.annotation.SimulateAndroid;
import com.blisscloud.ezuc.client.util.simulate.Message;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

@SimulateAndroid(androidClassName="android.os.Handler")
public class Handler {
    Timer timer;
    HandlerTask handlerTask;
    Runnable handlerTaskTarget;

    public void handleMessage(Message msg) {
    }

    private Handler() {
        this.timer = new Timer();
    }

    public Handler(String name) {
        this.timer = new Timer(name);
    }

    public String getMessageName(Message message) {
        if (message.callback != null) {
            return message.callback.getClass().getName();
        }
        return "0x" + Integer.toHexString(message.what);
    }

    public final Message obtainMessage() {
        return Message.obtain(this);
    }

    public final Message obtainMessage(int what) {
        return Message.obtain(this, what);
    }

    public final Message obtainMessage(int what, Object obj) {
        return Message.obtain(this, what, obj);
    }

    public final Message obtainMessage(int what, int arg1, int arg2) {
        return Message.obtain(this, what, arg1, arg2);
    }

    public final Message obtainMessage(int what, int arg1, int arg2, Object obj) {
        return Message.obtain(this, what, arg1, arg2, obj);
    }

    public boolean postDelayed(Runnable target, long delayMillis) {
        this.removeCallbacks(this.handlerTaskTarget);
        this.handlerTaskTarget = target;
        this.handlerTask = new HandlerTask(this, target);
        this.timer.schedule((TimerTask)this.handlerTask, delayMillis);
        return true;
    }

    public void removeCallbacks(Runnable target) {
        if (this.timer == null) {
            return;
        }
        if (target == this.handlerTaskTarget) {
            if (this.handlerTask != null) {
                this.handlerTask.cancel();
            }
            this.timer.purge();
            this.handlerTaskTarget = null;
            this.handlerTask = null;
        }
    }

    public final boolean sendMessage(Message msg) {
        return this.sendMessageDelayed(msg, 0L);
    }

    public final boolean sendEmptyMessage(int what) {
        return this.sendEmptyMessageDelayed(what, 0L);
    }

    public final boolean sendEmptyMessageDelayed(int what, long delayMillis) {
        Message msg = Message.obtain();
        msg.what = what;
        return this.sendMessageDelayed(msg, delayMillis);
    }

    public final boolean sendEmptyMessageAtTime(int what, long uptimeMillis) {
        Message msg = Message.obtain();
        msg.what = what;
        return this.sendMessageAtTime(msg, uptimeMillis);
    }

    public final boolean sendMessageDelayed(Message msg, long delayMillis) {
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        return this.sendMessageAtTime(msg, System.currentTimeMillis() + delayMillis);
    }

    public boolean sendMessageAtTime(Message msg, long uptimeMillis) {
        MessageTask msgTask = new MessageTask(msg);
        this.timer.schedule((TimerTask)msgTask, new Date(uptimeMillis));
        return true;
    }

    public void removeMessages(int what) {
    }

    public static void main(String[] args) {
        Runnable sipAccountResultTimer = new Runnable(){

            @Override
            public void run() {
                System.out.println("\u4efb\u52d9\u6642\u9593\uff1a" + String.valueOf(new Date()));
            }
        };
        Handler handler = new Handler();
        handler.postDelayed(sipAccountResultTimer, 2000L);
        System.out.println("\u73fe\u5728\u6642\u9593\uff1a" + String.valueOf(new Date()));
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        handler.removeCallbacks(sipAccountResultTimer);
    }

    class HandlerTask
    extends UCTimerTask {
        Runnable target;

        public HandlerTask(Handler this$0, Runnable target) {
            this.target = target;
        }

        @Override
        public void doRun() {
            if (this.target != null) {
                this.target.run();
            }
        }
    }

    class MessageTask
    extends UCTimerTask {
        Message msg;

        public MessageTask(Message msg) {
            this.msg = msg;
        }

        @Override
        public void doRun() {
            Handler.this.handleMessage(this.msg);
        }
    }

    public static interface Callback {
        public boolean handleMessage(Message var1);
    }
}

