/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.wechat;

import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.Utils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WechatCloseDialog
extends GenericDialog {
    private JPanel panelContent;
    private JComboBox cmbServiceCategory;
    private JComboBox cmbSubServiceCategory;
    private JLabel lblMemo;
    private JScrollPane spMemo;
    private JLabel lblServiceCategory;
    private JButton btnCancel;
    private JButton btnClose;
    private JPanel jPanel1;
    private JTextArea txtMemo;
    JSONArray categoryArray = null;
    List<JSONObject> categoryJSList = null;
    List<JSONObject> subcategoryJSList = null;
    long categoryId = -1L;
    long subcategoryId = -1L;
    String jid;
    String account;
    LiteCustomer customer = null;
    DefaultComboBoxModel cmbModelServiceCategory = new DefaultComboBoxModel();
    DefaultComboBoxModel cmbModelSubServiceCategory = new DefaultComboBoxModel();
    boolean ok = false;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                WechatCloseDialog inst = new WechatCloseDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    private WechatCloseDialog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public WechatCloseDialog(JFrame frame, String wechatJID) {
        super(frame);
        this.initGUI();
        this.initCategory();
        this.initSubCategory();
        this.jid = wechatJID;
        this.account = Utils.convertKey(this.jid);
        this.customer = CustomerManager.getCustomerInfo(UCChatClient.context, this.account);
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("wechat_title_closed_case_list"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(Color.WHITE);
            this.lblServiceCategory = new JLabel();
            this.panelContent.add((Component)this.lblServiceCategory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 15, 0, 15), 0, 0));
            this.lblServiceCategory.setText(I18NUtil.getString("wechat_service_category"));
            this.cmbServiceCategory = new JComboBox();
            this.panelContent.add((Component)this.cmbServiceCategory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 0, 15), 0, 0));
            this.cmbServiceCategory.setModel(this.cmbModelServiceCategory);
            this.cmbServiceCategory.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    WechatCloseDialog.this.cmbServiceCategoryItemStateChanged(evt);
                }
            });
            this.cmbSubServiceCategory = new JComboBox();
            this.panelContent.add((Component)this.cmbSubServiceCategory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 15, 0, 15), 0, 0));
            this.cmbSubServiceCategory.setModel(this.cmbModelSubServiceCategory);
            this.lblMemo = new JLabel();
            this.panelContent.add((Component)this.lblMemo, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 15, 0, 15), 0, 0));
            this.lblMemo.setText(I18NUtil.getString("wechat_remarks"));
            this.spMemo = new JScrollPane();
            this.panelContent.add((Component)this.spMemo, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 15, 0, 15), 0, 0));
            this.txtMemo = new JTextArea();
            this.spMemo.setViewportView(this.txtMemo);
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(2);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 10, 5), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnClose = new JButton();
            this.jPanel1.add(this.btnClose);
            this.btnClose.setText(I18NUtil.getString("wechat_close"));
            this.btnClose.setIcon(UIConstants.ICON_WECHAT_CLOSE);
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WechatCloseDialog.this.btnCloseActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WechatCloseDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(300, 400);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initCategory() {
        this.cmbModelServiceCategory.removeAllElements();
        this.cmbModelSubServiceCategory.removeAllElements();
        String categoryData = PreferencesUtil.getString(UCChatClient.context, "customer.service.cotegory", null);
        if (TextUtils.isBlank((CharSequence)categoryData)) {
            ToastUtil.showShort(I18NUtil.getString("common_no_item_all"));
            return;
        }
        if (this.categoryArray == null) {
            try {
                this.categoryArray = new JSONArray(categoryData);
            }
            catch (JSONException e) {
                Log.e(WechatCloseDialog.class.getSimpleName(), "initCategory", e);
                ToastUtil.showShort(I18NUtil.getString("common_no_item_all"));
                return;
            }
        }
        try {
            this.categoryJSList = new ArrayList<JSONObject>();
            for (int i = 0; i < this.categoryArray.length(); ++i) {
                JSONObject jo = this.categoryArray.getJSONObject(i);
                if (jo.getLong("parent") != 0L) continue;
                this.categoryJSList.add(jo);
                this.cmbModelServiceCategory.addElement(jo.getString("name"));
            }
        }
        catch (JSONException e) {
            Log.e(WechatCloseDialog.class.getSimpleName(), "initCategory fail", e);
        }
    }

    private void initSubCategory() {
        this.cmbModelSubServiceCategory.removeAllElements();
        try {
            ArrayList<JSONObject> subList = new ArrayList<JSONObject>();
            for (int i = 0; i < this.categoryArray.length(); ++i) {
                JSONObject jo = this.categoryArray.getJSONObject(i);
                if (jo.getLong("parent") != this.categoryId) continue;
                subList.add(jo);
                this.cmbModelSubServiceCategory.addElement(jo.getString("name"));
            }
            this.cmbSubServiceCategory.setVisible(this.cmbModelSubServiceCategory.getSize() > 0);
        }
        catch (JSONException e) {
            Log.e(WechatCloseDialog.class.getSimpleName(), "initSubCategory fail", e);
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        if (this.categoryId == -1L) {
            ToastUtil.showShort(I18NUtil.getString("wechat_no_service_category"));
            return;
        }
        WebAgent.getInstance().setCustomerServiceDone(this.account, this.subcategoryId > -1L ? this.subcategoryId : this.categoryId, this.txtMemo.getText().toString());
        this.ok = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.ok = false;
        this.dispose();
    }

    private void cmbServiceCategoryItemStateChanged(ItemEvent evt) {
        int position = this.cmbServiceCategory.getSelectedIndex();
        try {
            JSONObject selectJO = this.categoryJSList.get(position);
            this.categoryId = selectJO.getLong("id");
            this.initSubCategory();
        }
        catch (JSONException e) {
            Log.e(WechatCloseDialog.class.getSimpleName(), "onItemClick CATEGORY fail", e);
        }
    }
}

