/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;

public abstract class BaseAgent {
    private BroadcastReceiver receiver = null;
    private IntentFilter intentFilter = null;
    protected Context context;

    public BaseAgent(Context context) {
        this.context = context;
        this.receiver = this.createReceiver();
        this.intentFilter = this.createIntentFilter();
        context.registerReceiver(this.receiver, this.intentFilter);
    }

    public void v(String tag, String msg) {
        Log.v(tag, msg);
    }

    public void d(String tag, String msg) {
        Log.d(tag, msg);
    }

    public void i(String tag, String msg) {
        Log.i(tag, msg);
    }

    public void w(String tag, String msg) {
        Log.w(tag, msg);
    }

    public void e(String tag, String msg) {
        Log.e(tag, msg);
    }

    protected static void sendBroadcast(Context context, String action) {
        context.sendBroadcast(BaseAgent.createIntent(action));
    }

    protected static void sendBroadcast(Context context, Intent intent) {
        context.sendBroadcast(intent);
    }

    private static Intent createIntent(String action) {
        Intent intent = new Intent(action);
        Bundle bundle = new Bundle();
        intent.putExtras(bundle);
        return intent;
    }

    public void onAgentDestroy() {
        if (this.receiver != null) {
            try {
                this.context.unregisterReceiver(this.receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract BroadcastReceiver createReceiver();

    public abstract IntentFilter createIntentFilter();
}

