/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.ChatSendFileTask;
import com.blisscloud.mobile.ezuc.agent.ChatSendMsgTask;
import com.blisscloud.mobile.ezuc.agent.ChatUploadSendFileTask;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.AppUtils;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Component;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class ChatActionUtil {
    public static final int UPLOAD_IMAGE_MAX_SIZE = 0xA00000;

    public static boolean sendMessage(String refPacketId, List<ChatReceiver> chatReceiverList, String text) {
        int textLimit = PreferencesUtil.getTextUploadUpperLimit(UCChatClient.context);
        Log.i(ChatActionUtil.class.getSimpleName(), "size check: msg:" + text.length() + " vs limit:" + textLimit);
        if (text.length() > textLimit) {
            ToastUtil.show(UCChatClient.context, String.format(I18NUtil.getString("chat_text_too_long"), textLimit), 10);
            return false;
        }
        String data = Base64.encodeBase64String((byte[])text.getBytes());
        ChatSendMsgTask info = new ChatSendMsgTask(refPacketId, chatReceiverList, data, text, 0);
        WebAgent.getInstance().sendChatText(info);
        return true;
    }

    public static void sendLocation(String refPacketId, List<ChatReceiver> chatReceiverList, String title, String address, double latitude, double longitude) {
        String data = Base64.encodeBase64String((byte[])address.getBytes());
        ChatSendMsgTask task = new ChatSendMsgTask(refPacketId, chatReceiverList, data, address, 8);
        task.setLatitude(latitude);
        task.setLongitude(longitude);
        task.setTitle(title);
        WebAgent.getInstance().sendChatText(task);
    }

    public static boolean resendMessage(List<ChatReceiver> chatReceiverList, Message message, Component parentComp) {
        String msgContent;
        String refPacketId = null;
        if (message.getProps() != null) {
            try {
                JSONObject propObj = new JSONObject(message.getProps());
                if (propObj.has("refPacketId")) {
                    refPacketId = propObj.getString("refPacketId");
                }
            }
            catch (Exception e) {
                Log.e(ChatActionUtil.class.getSimpleName(), e.getMessage(), e);
            }
        }
        if (message.getMsgType() == 1) {
            msgContent = message.getContent();
            ChatSendMsgTask info = new ChatSendMsgTask(refPacketId, chatReceiverList, msgContent, msgContent, 1);
            info.setDuration(message.getDuration());
            WebAgent.getInstance().sendChatText(info);
            return true;
        }
        if (message.getMsgType() == 6) {
            msgContent = message.getContent();
            ChatSendMsgTask info = new ChatSendMsgTask(refPacketId, chatReceiverList, msgContent, msgContent, 6);
            info.setDuration(message.getDuration());
            WebAgent.getInstance().sendChatText(info);
            return true;
        }
        if (message.getMsgType() == 0) {
            return ChatActionUtil.sendMessage(refPacketId, chatReceiverList, message.getContent());
        }
        if ("REJECTED".equals(message.getStatus()) || "E".equals(message.getStatus())) {
            ChatSendFileTask task = new ChatSendFileTask(refPacketId, chatReceiverList, message.getFileName(), message.getFileSize(), message.getContent(), message.getMsgType());
            if (StringUtils.isNotBlank((CharSequence)message.getMimeType())) {
                task.setMimeType(message.getMimeType());
            }
            task.setFileExtraInfo(message.getExtraMsgInfo());
            task.setFileDownloadUrl(message.getFileDownloadURL());
            WebAgent.getInstance().sendChatFile(task);
            return true;
        }
        if ("UPLOAD_FAILED".equals(message.getStatus())) {
            File imageFile = new File(message.getFileLocalPathToFetch());
            return ChatActionUtil.uploadFile(chatReceiverList, imageFile, true, message.getExtraMsgInfo(), parentComp);
        }
        return false;
    }

    public static boolean uploadFile(List<ChatReceiver> chatReceiverList, File file, boolean original, String extraInfo, Component parentComp) {
        boolean result;
        if (!file.exists()) {
            Log.e(ChatActionUtil.class.getSimpleName(), "file " + file.getAbsolutePath() + " does not exist!");
            JOptionPane.showMessageDialog(parentComp, I18NUtil.getString("media_upload_failed_not_found"), I18NUtil.getString("common_title_error"), 0);
            return false;
        }
        String fileExt = FileUtil.getFileExtension(file);
        if (!ChatActionUtil.validFileExt(fileExt)) {
            JOptionPane.showMessageDialog(parentComp, I18NUtil.getString("media_upload_failed_type_unsupported"), I18NUtil.getString("common_title_error"), 0);
            return false;
        }
        long fileLimit = PreferencesUtil.getFileUploadUpperLimit(UCChatClient.context);
        long fileSize = file.length();
        if (fileLimit != -1L && fileSize > fileLimit) {
            JOptionPane.showMessageDialog(parentComp, String.format(I18NUtil.getString("chat_validation_doc_maxsize"), FileUtil.convertFileSizeDisplay(fileLimit)), I18NUtil.getString("common_title_error"), 0);
            return false;
        }
        int textLimit = PreferencesUtil.getTextUploadUpperLimit(UCChatClient.context);
        if (extraInfo != null) {
            Log.i(ChatActionUtil.class.getSimpleName(), "size check: extra:" + extraInfo.length() + " vs limit:" + textLimit);
            if (extraInfo.length() > textLimit) {
                System.out.println("=." + extraInfo.length());
                ToastUtil.show(UCChatClient.context, String.format(I18NUtil.getString("chat_text_too_long"), textLimit), 10);
                return false;
            }
        }
        if (!(result = ChatActionUtil.uploadFileLocal(chatReceiverList, file, original, extraInfo, parentComp))) {
            JOptionPane.showMessageDialog(parentComp, I18NUtil.getString("media_upload_failed_general"), I18NUtil.getString("common_title_error"), 0);
        }
        if (chatReceiverList.size() > 0) {
            ChatReceiver lastReceiver = chatReceiverList.get(chatReceiverList.size() - 1);
            AppUtils.startChat(UCChatClient.context, lastReceiver.getReceiverJid());
        }
        return true;
    }

    private static boolean validFileExt(String fileExt) {
        return UCUploadFileChooser.IMAGE_TYPES.contains(fileExt) || UCUploadFileChooser.TIFF_TYPES.contains(fileExt) || UCUploadFileChooser.VIDEO_TYPES.contains(fileExt) || UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) || UCUploadFileChooser.AUDIO_TYPES.contains(fileExt);
    }

    private static boolean uploadFileLocal(List<ChatReceiver> chatReceiverList, File file, boolean originalFlag, String extraInfo, Component parentComp) {
        String fileExt = FileUtil.getFileExtension(file);
        Log.i(ChatActionUtil.class.getSimpleName(), "try to upload file:" + file.getAbsolutePath() + ", fileExt:" + fileExt + ", originalFlag:" + originalFlag);
        try {
            if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                Log.i(ChatActionUtil.class.getSimpleName(), "image type");
                String imageBase64Content = AppUtils.genThumbnailPhoto(file);
                if (!originalFlag) {
                    file = ChatActionUtil.compressImageToTemp(file);
                }
                String mimeType = FileUtil.getFileMimeType(file.getName());
                ChatUploadSendFileTask info = new ChatUploadSendFileTask(chatReceiverList, file, imageBase64Content, 5, mimeType);
                info.setFileExtraInfo(extraInfo);
                WebAgent.getInstance().uploadChatFile(info);
                return true;
            }
            if (UCUploadFileChooser.TIFF_TYPES.contains(fileExt)) {
                Log.i(ChatActionUtil.class.getSimpleName(), "tiff type");
                String imageBase64Content = AppUtils.genThumbnailPhoto(file);
                String mimeType = FileUtil.getFileMimeType(file.getName());
                ChatUploadSendFileTask info = new ChatUploadSendFileTask(chatReceiverList, file, imageBase64Content, 11, mimeType);
                info.setFileExtraInfo(extraInfo);
                WebAgent.getInstance().uploadChatFile(info);
                return true;
            }
            if (UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) {
                Log.i(ChatActionUtil.class.getSimpleName(), "video type");
                String imageBase64Content = AppUtils.genThumbnailVideo(file);
                String mimeType = FileUtil.getFileMimeType(file.getName());
                ChatUploadSendFileTask info = new ChatUploadSendFileTask(chatReceiverList, file, imageBase64Content, 4, mimeType);
                info.setFileExtraInfo(extraInfo);
                info.setDuration(AppUtils.getVideoDuration(file));
                WebAgent.getInstance().uploadChatFile(info);
                return true;
            }
            if (UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) || UCUploadFileChooser.AUDIO_TYPES.contains(fileExt)) {
                Log.i(ChatActionUtil.class.getSimpleName(), "doc or audio type");
                ChatUploadSendFileTask info = new ChatUploadSendFileTask(chatReceiverList, file, null, 11);
                info.setFileExtraInfo(extraInfo);
                WebAgent.getInstance().uploadChatFile(info);
                return true;
            }
            Log.e(ChatActionUtil.class.getSimpleName(), "other type exten:" + fileExt);
        }
        catch (Throwable e) {
            Log.e(ChatActionUtil.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
        return false;
    }

    protected static File compressImageToTemp(File srcFile) throws Exception {
        String fileExt = FileUtil.getFileExtension(srcFile);
        File tempImageFile = File.createTempFile("ezuc_", (String)(StringUtils.isNotBlank((CharSequence)fileExt) ? "." + fileExt : ""));
        Log.i(ChatActionUtil.class.getSimpleName(), "create " + String.valueOf(tempImageFile));
        tempImageFile.deleteOnExit();
        Log.i(ChatActionUtil.class.getSimpleName(), "deleteOnExit " + String.valueOf(tempImageFile));
        ChatActionUtil.compressImage(srcFile, tempImageFile, 0xA00000);
        Log.i(ChatActionUtil.class.getSimpleName(), "compressImage src:" + String.valueOf(srcFile) + " dst:" + String.valueOf(tempImageFile));
        return tempImageFile;
    }

    protected static void compressImage(File srcFile, File targetFile, int fileSizeLimit) throws Exception {
        if (!srcFile.exists()) {
            return;
        }
        float ratio = 1.0f;
        GraphicUtil.writeScaledImage(srcFile, targetFile, ratio);
        Log.i(ChatActionUtil.class.getSimpleName(), "1 TARGET FILE SIZE " + targetFile.length() + ", ratio:" + ratio);
        while (targetFile.length() > (long)fileSizeLimit) {
            GraphicUtil.writeScaledImage(srcFile, targetFile, ratio -= 0.1f);
            Log.i(ChatActionUtil.class.getSimpleName(), "2 TARGET FILE SIZE " + targetFile.length() + ", ratio:" + ratio);
        }
    }
}

