/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.ChatTaskBase;
import com.blisscloud.mobile.ezuc.agent.ChatUploadTask;
import com.blisscloud.mobile.ezuc.connection.web.ActionObj;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ChatSendFileTask
extends ChatTaskBase
implements ChatUploadTask {
    protected String fileName;
    protected String mimeType;
    protected String thumbnail;
    protected long fileSize;
    protected Long duration;
    protected int msgType;
    protected String fileDownloadUrl;
    protected String fileExtraInfo;
    private String quotePackageId = null;

    protected ChatSendFileTask() {
    }

    public ChatSendFileTask(String quotePackageId, List<ChatReceiver> chatReceiverList, String fileName, long fileSize, String thumbnail, int msgType) {
        this.fileName = fileName;
        this.mimeType = FileUtil.getFileMimeType(this.fileName);
        this.fileSize = fileSize;
        this.thumbnail = thumbnail;
        this.msgType = msgType;
        this.chatReceiverList = chatReceiverList;
        this.quotePackageId = quotePackageId;
    }

    @Override
    public String getInfo() {
        return "ChatFileTask(" + this.msgType + ") to " + this.getReceiverJidStr();
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public String getFileDownloadUrl() {
        return this.fileDownloadUrl;
    }

    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public void setFileDownloadUrl(String fileDownloadUrl) {
        this.fileDownloadUrl = fileDownloadUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @Override
    public List<ActionObj> getMsgAction(Context context) {
        ArrayList<ActionObj> actionList = new ArrayList<ActionObj>();
        for (ChatReceiver receiver : this.chatReceiverList) {
            LiteCustomer customer;
            ActionObj action = null;
            if (JidUtil.isChatConfJid(receiver.getReceiverJid())) {
                action = new ActionObj("multiChat.sendRoomFileMsg");
                action.setValue("roomJid", receiver.getReceiverJid());
            } else {
                action = new ActionObj("chat.sendFileMsg");
                action.setValue("receiverJid", receiver.getReceiverJid());
            }
            action.setValue("packetId", receiver.getPacketId());
            if (JidUtil.isCustomerJid(receiver.getReceiverJid()) && (customer = CustomerManager.getCustomerInfo(context, JidUtil.convertKey(receiver.getReceiverJid()))) != null && StringUtils.isNotBlank((CharSequence)customer.getSessionId())) {
                action.setValue("sessionId", customer.getSessionId());
            }
            this.getFileCommon(action);
            actionList.add(action);
        }
        return actionList;
    }

    @Override
    public ActionObj getMultiReceiverMsgAction(Context context) {
        ActionObj action = new ActionObj("chat.sendMultiFileMsg");
        ArrayList receiverInfoList = new ArrayList();
        for (ChatReceiver receiver : this.chatReceiverList) {
            LiteCustomer customer;
            HashMap<String, String> receiverMap = new HashMap<String, String>();
            receiverMap.put("packetId", receiver.getPacketId());
            receiverMap.put("receiverJid", receiver.getReceiverJid());
            if (JidUtil.isCustomerJid(receiver.getReceiverJid()) && (customer = CustomerManager.getCustomerInfo(context, JidUtil.convertKey(receiver.getReceiverJid()))) != null && StringUtils.isNotBlank((CharSequence)customer.getSessionId())) {
                receiverMap.put("sessionId", customer.getSessionId());
            }
            receiverInfoList.add(receiverMap);
        }
        action.setValue("receiverInfo", receiverInfoList);
        if (StringUtils.isNotBlank((CharSequence)this.quotePackageId)) {
            action.setValue("refPacketId", this.quotePackageId);
        }
        this.getFileCommon(action);
        return action;
    }

    private ActionObj getFileCommon(ActionObj action) {
        action.setValue("fileName", this.getFileName());
        action.setValue("fileSize", this.getFileSize());
        if (StringUtils.isNotBlank((CharSequence)this.getThumbnail())) {
            action.setValue("fileContent", this.getThumbnail());
        } else {
            action.setValue("fileContent", "nodata");
        }
        action.setValue("fileDownloadURL", this.getFileDownloadUrl());
        action.setValue("type", this.getMsgType());
        if (StringUtils.isNotBlank((CharSequence)this.getMimeType())) {
            action.setValue("mimeType", this.getMimeType());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getFileExtraInfo())) {
            action.setValue("fileExtraInfo", this.getFileExtraInfo());
        }
        if (this.getDuration() != null) {
            action.setValue("duration", this.getDuration());
        } else {
            action.setValue("duration", this.getFileSize());
        }
        if (StringUtils.isNotBlank((CharSequence)this.quotePackageId)) {
            action.setValue("refPacketId", this.quotePackageId);
        }
        action.setValue("paraNoReturn", "fileName,fileSize,fileContent,fileDownloadURL,type,duration,sessionId");
        return action;
    }

    public String getFileExtraInfo() {
        return this.fileExtraInfo;
    }

    public void setFileExtraInfo(String fileExtraInfo) {
        this.fileExtraInfo = fileExtraInfo;
    }

    public String toString() {
        return "ChatSendFileTask [fileName=" + this.fileName + ", fileSize=" + this.fileSize + ", chatReceiverList=" + String.valueOf(this.chatReceiverList) + "]";
    }

    public String getQuotePackageId() {
        return this.quotePackageId;
    }

    public void setQuotePackageId(String quotePackageId) {
        this.quotePackageId = quotePackageId;
    }
}

