/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ClassUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Handler;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.BaseAgent;
import com.blisscloud.mobile.ezuc.agent.ChatMsgQueueController;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.ChatSendFileTask;
import com.blisscloud.mobile.ezuc.agent.ChatSendMsgTask;
import com.blisscloud.mobile.ezuc.agent.ChatUploadSendFileTask;
import com.blisscloud.mobile.ezuc.agent.NetworkService;
import com.blisscloud.mobile.ezuc.bean.AgentAction;
import com.blisscloud.mobile.ezuc.bean.AgentStatusType;
import com.blisscloud.mobile.ezuc.bean.FileBean;
import com.blisscloud.mobile.ezuc.bean.MediaType;
import com.blisscloud.mobile.ezuc.bean.MsgBean;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.bean.QueueStatus;
import com.blisscloud.mobile.ezuc.callback.WebConnectionListener;
import com.blisscloud.mobile.ezuc.connection.web.ActionObj;
import com.blisscloud.mobile.ezuc.connection.web.WebConnectionImpl;
import com.blisscloud.mobile.ezuc.db.UCDBCustomer;
import com.blisscloud.mobile.ezuc.db.UCDBReaderLog;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.task.EventController;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebAgent
extends BaseAgent {
    public static final String PARAMETER = "parameter";
    public static final int LOGIN_REQUEST_TYPE_UNKNOWN = 0;
    public static final int LOGIN_REQUEST_TYPE_LOGINPAGE = 1;
    public static String ENTER_TYPE_SELF = "SELF";
    public static String ENTER_TYPE_SYNC = "SYNC";
    private WebConnectionImpl connectionCurrent;
    public static String logingFailMsg = "";
    public static boolean isLogin = false;
    public static boolean isSyncData = false;
    public static AgentStatusType agentState = AgentStatusType.OFFLINE;
    public static Long auxReasonId = null;
    public static HashSet<MediaType> agentLoginMediaTypes = new HashSet();
    public static ConcurrentHashMap<Long, QueueStatus> queueStatusMap = new ConcurrentHashMap();
    public static int mLoginRequestType = 0;
    public static boolean siteSelectionListRequired = false;
    public static boolean noQueryExternalContactList = false;
    public static JSONObject callAttachData = new JSONObject();
    private static volatile WebAgent instance = null;
    public static String refCallId = null;
    private static Object lock = new Object();
    private Timer checkLocalTimer = new Timer("WebAgentTimer");
    public Set<String> oldEventRoomSyncSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private static HashSet<String> ignoreSet = new HashSet();
    private boolean waitForLogoutResponse = false;
    public static boolean haveSipAccountReady;
    public int sipAccountResultTryCount = 0;
    private Handler sipAccountResultHandler = new Handler("WebAgentSipResultHandler");
    private Runnable sipAccountResultTimer = new Runnable(){

        @Override
        public void run() {
            try {
                if (!PreferencesUtil.hasPhoneCallLicense(WebAgent.this.context)) {
                    Log.e(this.getClass().getSimpleName(), "----- no get sip phone");
                    return;
                }
                if (haveSipAccountReady) {
                    Log.i(this.getClass().getSimpleName(), "haveSipAccountReady is " + haveSipAccountReady + ", no need to request sip info skip!");
                    WebAgent.this.sipAccountResultTryCount = 0;
                    WebAgent.this.stopSipRequestProcess();
                    return;
                }
                Log.i(WebAgent.class.getSimpleName(), "sipAccountResultTimer haveSipAccountReady is " + haveSipAccountReady + ", request now ...");
                WebConnectionImpl conn = WebAgent.this.getConnection();
                if (!NetworkService.getInstance().isOnline() || conn == null || !conn.isConnected()) {
                    return;
                }
                long siteId = PreferencesUtil.getSipUsePbxSite(WebAgent.this.context);
                String orgDn = PreferencesUtil.getSipUserName(WebAgent.this.context);
                String deviceName = PreferencesUtil.getString(WebAgent.this.context, "DEVICENAME", "");
                if (siteId == -1L) {
                    Log.i(WebConnectionImpl.class.getSimpleName(), "getSipAccount but siteId is null");
                    return;
                }
                ActionObj action = new ActionObj("employee.getSipAccount");
                action.setValue("siteId", String.valueOf(siteId));
                action.setValue("orgDn", orgDn);
                action.setValue("deviceInfo", deviceName);
                action.setValue("deviceType", "desktop");
                conn.sendTextMessage(action.toJSONString());
                long timeWait = 10000L;
                timeWait = WebAgent.this.sipAccountResultTryCount < 50 ? 30000L : 60000L;
                Log.i(WebAgent.class.getSimpleName(), "if no response from UCRM web socket, retry getSipAccount again after " + timeWait);
                WebAgent.this.sipAccountResultHandler.postDelayed(this, timeWait);
                ++WebAgent.this.sipAccountResultTryCount;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    };
    int skipCount;

    public static String getCallAttachDataStr() {
        StringBuffer b = new StringBuffer();
        try {
            if (callAttachData.has("DNIS")) {
                b.append(I18NUtil.getString("DNIS"));
                b.append(": ");
                b.append(callAttachData.getString("DNIS"));
                b.append("\n");
            }
            if (callAttachData.has("INBOUND_RULE_INFO")) {
                b.append(I18NUtil.getString("attachdata.inbound_rule_info"));
                b.append(": ");
                b.append(callAttachData.getString("INBOUND_RULE_INFO"));
                b.append("\n");
            }
            if (callAttachData.has("MENU_RULE_INFO")) {
                b.append(I18NUtil.getString("attachdata.menu_rule_info"));
                b.append(": ");
                b.append(callAttachData.getString("MENU_RULE_INFO"));
                b.append("\n");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Iterator iter = callAttachData.keys();
        if (iter != null) {
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (ignoreSet.contains(key)) continue;
                String value = "";
                try {
                    value = callAttachData.getString(key);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    value = "NA";
                }
                b.append(key);
                b.append(": ");
                b.append(value);
                b.append("\n");
            }
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebAgent getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    Log.w(WebAgent.class.getSimpleName(), "WebAgent service instance is null, recreate now !");
                    instance = new WebAgent(UCChatClient.context);
                }
            }
        }
        return instance;
    }

    public static void stopInstance() {
        if (instance != null) {
            instance.onAgentDestroy();
            instance = null;
        }
    }

    private WebAgent(Context ctx) {
        super(ctx);
        this.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebConnectionImpl getConnection() {
        if (this.connectionCurrent == null) {
            WebAgent webAgent = this;
            synchronized (webAgent) {
                if (this.connectionCurrent == null) {
                    WebConnectionListener callback = new WebConnectionListener(this.context);
                    this.connectionCurrent = new WebConnectionImpl(callback);
                    this.connectionCurrent.onStart();
                }
            }
        }
        return this.connectionCurrent;
    }

    @Override
    public BroadcastReceiver createReceiver() {
        return null;
    }

    @Override
    public IntentFilter createIntentFilter() {
        return null;
    }

    public void connect() {
        Log.i(this.getClass().getSimpleName(), "WebAgent connect ..........");
        this.getConnection().connect();
    }

    public void cleanConnection() {
        Log.i(this.getClass().getSimpleName(), "WebAgent cleanConnection ..........");
        this.stopSipRequestProcess();
        this.cleanLoginFlag();
        this.getConnection().cleanConnection();
    }

    public void login(int _loginRequestType) {
        Log.i(this.getClass().getSimpleName(), "WebAgent login .........." + _loginRequestType);
        mLoginRequestType = _loginRequestType;
        if (!isLogin) {
            BroadcastUtil.sendUcrmLoginRequestEvent(this.context);
        } else {
            Log.i(this.getClass().getSimpleName(), "WebAgent login: already login, skip!");
        }
    }

    public void logout(final int reason, final boolean cleanFlagRequired) {
        Log.i(this.getClass().getSimpleName(), "WebAgent logout ............ ");
        BroadcastUtil.sendStopPhoneServiceRequestEvent(this.context, "logout");
        ChatMsgQueueController.getInstance(this.context).cleanAllTask();
        PreferencesUtil.cleanSipPhoneInfo(this.context);
        this.checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

            @Override
            public void doRun() {
                if (PreferencesUtil.isAutoLogout() && PreferencesUtil.isAgent() && agentLoginMediaTypes != null && agentLoginMediaTypes.size() != 0) {
                    WebAgent.this.agentLogout();
                }
                PreferencesUtil.putInt(WebAgent.this.context, "LOGOUTREASON", reason);
                PreferencesUtil.putBoolean(WebAgent.this.context, "LOGOUTCLEANFLAG", cleanFlagRequired);
                if (WebAgent.this.connectionCurrent != null && WebAgent.this.connectionCurrent.isConnected()) {
                    WebAgent.this.waitForLogoutResponse = true;
                    Log.i(this.getClass().getSimpleName(), "WebAgent do logout");
                    WebAgent.this.connectionCurrent.logout();
                    WebAgent.this.checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                        @Override
                        public void doRun() {
                            WebAgent.this.logoutResultOK(null);
                        }
                    }, 2000L);
                } else {
                    WebAgent.this.waitForLogoutResponse = true;
                    WebAgent.this.logoutResultOK(null);
                }
            }
        }, 600L);
    }

    public synchronized void logoutResultOK(String result) {
        if (!this.waitForLogoutResponse) {
            return;
        }
        this.waitForLogoutResponse = false;
        agentLoginMediaTypes.clear();
        queueStatusMap.clear();
        PreferencesUtil.setUCRMCheckTime(this.context, -1L);
        TaskController.getInstance().cleanupAndTerminate();
        this.cleanLoginFlag();
        PreferencesUtil.putString(this.context, "LOGIN_SESSION_ID", "");
        PreferencesUtil.putString(this.context, "LOGIN_DEVICES", "");
        PreferencesUtil.putString(this.context, "DEVICE_INFO", "");
        int reason = PreferencesUtil.getInt(this.context, "LOGOUTREASON", -1);
        boolean cleanFlagRequired = PreferencesUtil.getBoolean(this.context, "LOGOUTCLEANFLAG", true);
        PreferencesUtil.putInt(this.context, "LOGOUTREASON", -1);
        PreferencesUtil.putBoolean(this.context, "LOGOUTCLEANFLAG", true);
        if (cleanFlagRequired) {
            PreferencesUtil.cancelRemainLoggedIn(this.context);
        }
        if (this.connectionCurrent != null && this.connectionCurrent.isConnected()) {
            this.connectionCurrent.cleanConnection();
        }
        if (reason != 4002 && reason != 4001) {
            BroadcastUtil.sendLogoutEvent(this.context, reason, cleanFlagRequired, result);
        }
    }

    public void loginFailed(String returnInfo, String place, int reason) {
        BroadcastUtil.sendStopPhoneServiceRequestEvent(this.context, "loginFailed");
        logingFailMsg = returnInfo;
        PreferencesUtil.cancelRemainLoggedIn(this.context);
        this.stopSipRequestProcess();
        this.cleanConnection();
        PreferencesUtil.putString(this.context, "LOGIN_SESSION_ID", "");
        BroadcastUtil.sendLoginFailedEvent(this.context, reason, returnInfo);
    }

    public void cleanLoginFlag() {
        Log.i(this.getClass().getSimpleName(), "WebAgent cleanLoginFlag ...");
        isLogin = false;
        isSyncData = false;
        agentState = AgentStatusType.OFFLINE;
        ContactManager.clearPhoneEmpStatusCache();
        ContactManager.clearPhoneLocStatusCache();
        BroadcastUtil.sendContactHistoryChangedEvent(this.context);
    }

    public void notifyOnOpen() {
    }

    public void notifyOnClose(int code, String reason, boolean tryConnectFail) {
        this.cleanLoginFlag();
        ChatMsgQueueController.suspendInstance(true);
        this.stopSipRequestProcess();
        if (!PreferencesUtil.isRemainLoggedIn(this.context)) {
            PreferencesUtil.putString(this.context, "LOGIN_SESSION_ID", "");
        }
        PreferencesUtil.putString(this.context, "LOGIN_DEVICES", "");
        PreferencesUtil.putString(this.context, "DEVICE_INFO", "");
        BroadcastUtil.sendWebDisconnectdEvent(this.context, code, reason);
        if (tryConnectFail) {
            BroadcastUtil.sendWebTryConnectFailedEvent(this.context, code, reason);
        }
        BroadcastUtil.sendUcrmConnectionLostEvent(this.context);
        BroadcastUtil.sendContactHistoryChangedEvent(this.context);
    }

    @Override
    public void onAgentDestroy() {
        Log.i(this.getClass().getSimpleName(), "WebAgent onDestroy ......................... ");
        super.onAgentDestroy();
        EventController.getInstance().terminate();
        if (this.checkLocalTimer != null) {
            this.checkLocalTimer.cancel();
        }
        this.cleanLoginFlag();
        this.stopSipRequestProcess();
        try {
            if (this.connectionCurrent != null) {
                this.connectionCurrent.onDestroy();
                this.connectionCurrent = null;
            }
        }
        catch (Exception e) {
            Log.e(this.getClass().getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
        }
    }

    public void queryMeetMeList() {
        ActionObj action = new ActionObj("meetme.listAllStaticConferenceRoom");
        this.sendAction(action);
    }

    public static void onDestroy() {
        if (instance != null) {
            instance.onAgentDestroy();
            instance = null;
        }
    }

    public void getOneMeetMe(long roomId) {
        Log.d(this.getClass().getSimpleName(), "WebAgent \u67e5\u8a62\u6703\u8b70\u5ba4====>");
        ActionObj action = new ActionObj("meetme.getOneConferenceRoom");
        action.setValue("roomId", roomId);
        this.sendAction(action);
    }

    public void queryMeetMeListUser(long roomId) {
        if (this.checkConfNo(roomId)) {
            ActionObj action = new ActionObj("meetme.listUserWs");
            action.setValue("roomId", roomId);
            this.sendAction(action);
        }
    }

    public void getAddressBookScope() {
        ActionObj action = new ActionObj("employee.getAddressBookScope");
        this.sendAction(action);
    }

    public void matchEmployeeByOutgoingPhoneNo(String token, long currentSiteId, String phoneNumber) {
        ActionObj action = new ActionObj("employee.matchEmployeeByOutgoingPhoneNo");
        action.setValue("siteId", currentSiteId);
        action.setValue("phoneNumber", phoneNumber);
        action.setValue("token", token);
        this.sendAction(action);
    }

    public void matchEmployeeByIncomingPhoneNo(String token, long currentSiteId, String phoneNumber) {
        ActionObj action = new ActionObj("employee.matchEmployeeByIncomingPhoneNo");
        action.setValue("siteId", currentSiteId);
        action.setValue("phoneNumber", phoneNumber);
        action.setValue("token", token);
        this.sendAction(action);
    }

    public void addExtraAddressBookByJids(Set<String> empJidSet) {
        if (empJidSet == null || empJidSet.size() == 0) {
            return;
        }
        ActionObj action = new ActionObj("employee.addExtraAddressBookByJids");
        action.setValue("jids", CommonUtil.strSetToString(empJidSet));
        this.sendAction(action);
    }

    public void removeExtraAddressBookByJids(Set<String> empJidSet) {
        if (empJidSet == null || empJidSet.size() == 0) {
            return;
        }
        ActionObj action = new ActionObj("employee.removeExtraAddressBookByJids");
        action.setValue("jids", CommonUtil.strSetToString(empJidSet));
        this.sendAction(action);
    }

    public void queryEmployeeListByJids(Set<String> empJidSet) {
        if (empJidSet == null || empJidSet.size() == 0) {
            return;
        }
        ActionObj action = new ActionObj("employee.getEmployeeByJids");
        action.setValue("jids", CommonUtil.strSetToString(empJidSet));
        this.sendAction(action);
    }

    public void queryEmployeeListByIds(String token, Set<Long> empIdSet) {
        if (empIdSet == null || empIdSet.size() == 0) {
            return;
        }
        ActionObj action = new ActionObj("employee.getEmployeeListByIds");
        action.setValue("timeStamp", -1);
        if (token != null) {
            action.setValue("token", token);
        }
        action.setValue("ids", CommonUtil.longSetToString(empIdSet));
        this.sendAction(action);
    }

    public void queryEmployeeListByIds(Set<Long> empIdSet) {
        if (empIdSet == null || empIdSet.size() == 0) {
            return;
        }
        this.queryEmployeeListByIds(null, empIdSet);
    }

    public void refreshChatRoomMemberListByIds(String roomJID, long timestamp, HashSet<Long> empIdSet) {
        if (empIdSet == null || empIdSet.size() == 0) {
            return;
        }
        ActionObj action = new ActionObj("employee.getEmployeeListByIds");
        action.setValue("timeStamp", timestamp);
        action.setValue("chatRoomJid", roomJID);
        action.setValue("ids", CommonUtil.longSetToString(empIdSet));
        this.sendAction(action);
    }

    public void getAllDepartmentList() {
        ActionObj action = new ActionObj("employee.getAllDepartmentList");
        this.sendAction(action);
    }

    public void reloadDirtyEmployeeList(long empId) {
        Log.i(this.getClass().getSimpleName(), "queryEmployeeList startId:" + empId);
        ActionObj action = new ActionObj("employee.getEmployeeListByPage");
        action.setValue("startId", empId);
        action.setValue("pageSize", 100);
        this.sendAction(action);
    }

    public void getDirtyEmployeeListByPage(long timestamp, long lastEmpId) {
        Log.i(this.getClass().getSimpleName(), "queryEmployeeList timestamp:" + timestamp + ", lastEmpId:" + lastEmpId);
        ActionObj action = new ActionObj("employee.getEmployeeListByPage");
        action.setValue("lastEmpId", lastEmpId);
        action.setValue("timeStamp", timestamp);
        action.setValue("pageSize", 100);
        this.sendAction(action);
    }

    public synchronized void getEmpContactRecordsByPage() {
        int contactRequestSeq = PreferencesUtil.getInt(this.context, "SYNC_CONTACT_RECORD_SEQ", 0);
        contactRequestSeq = contactRequestSeq > 1000 ? 0 : ++contactRequestSeq;
        PreferencesUtil.putInt(this.context, "SYNC_CONTACT_RECORD_SEQ", contactRequestSeq);
        this.getEmpContactRecordsByPageLocal(contactRequestSeq);
    }

    public void getEmpContactRecordsByPageLocal(int requestSeq) {
        ActionObj action = new ActionObj("contactRecord.getEmpContactRecords");
        long lastContactLogId = PreferencesUtil.getLastContactLogId(this.context);
        if (lastContactLogId == -1L) {
            action.setValue("daysCount", PreferencesUtil.getSyncDaysCount(this.context));
        }
        action.setValue("requestSeq", requestSeq);
        action.setValue("lastContactLogId", lastContactLogId);
        action.setValue("pageSize", 300);
        this.sendAction(action);
    }

    public void queryPhoneEmpStatusList() {
        ActionObj action = new ActionObj("employee.getPhoneStatusWithType");
        this.sendAction(action);
    }

    public void queryPhoneLocStatusList() {
        ActionObj action = new ActionObj("employee.getLocationPhoneStatusWithType");
        this.sendAction(action);
    }

    public void queryDeletedJidList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "employee.getDeletedJidList.TimeStamp");
        ActionObj action = new ActionObj("employee.getDeletedJidList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void queryLocation() {
        ActionObj action = new ActionObj("employee.getLocation");
        this.sendAction(action);
    }

    public void lock(long roomId) {
        Log.d(this.getClass().getSimpleName(), "WebAgent lock() \u9396\u5b9a\u6703\u8b70\u5ba4:" + roomId);
        if (this.checkConfNo(roomId)) {
            ActionObj action = new ActionObj("meetme.lock");
            action.setValue("roomId", roomId);
            this.sendAction(action);
        }
    }

    public void unLock(long roomId) {
        Log.d(this.getClass().getSimpleName(), "WebAgent lock() \u53d6\u6d88\u9396\u5b9a\u6703\u8b70\u5ba4:" + roomId);
        if (this.checkConfNo(roomId)) {
            ActionObj action = new ActionObj("meetme.unLock");
            action.setValue("roomId", roomId);
            this.sendAction(action);
        }
    }

    public void muteAll(long roomId) {
        Log.d(this.getClass().getSimpleName(), "WebAgent lock() \u5168\u90e8\u975c\u97f3(\u6703\u8b70\u4eba\u54e1):" + roomId);
        if (this.checkConfNo(roomId)) {
            ActionObj action = new ActionObj("meetme.muteAll");
            action.setValue("roomId", roomId);
            this.sendAction(action);
        }
    }

    public void unMuteAll(long roomId) {
        Log.d(this.getClass().getSimpleName(), "WebAgent lock() \u53d6\u6d88\u5168\u90e8\u975c\u97f3(\u6703\u8b70\u4eba\u54e1):" + roomId);
        if (this.checkConfNo(roomId)) {
            ActionObj action = new ActionObj("meetme.unMuteAll");
            action.setValue("roomId", roomId);
            this.sendAction(action);
        }
    }

    public void kickAll(long roomId) {
        Log.d(this.getClass().getSimpleName(), "WebAgent lock() \u7d50\u675f\u6703\u8b70\u5ba4:" + roomId);
        if (this.checkConfNo(roomId)) {
            ActionObj action = new ActionObj("meetme.kickAll");
            action.setValue("roomId", roomId);
            this.sendAction(action);
        }
    }

    public void muteUser(long roomId, String userNo) {
        Log.d(this.getClass().getSimpleName(), "WebAgent muteUser() \u975c\u97f3(\u6703\u8b70\u4eba\u54e1):" + roomId + "-" + userNo);
        if (this.checkConfNo(roomId) && this.checkUserNo(userNo)) {
            ActionObj action = new ActionObj("meetme.muteUser");
            action.setValue("roomId", roomId);
            action.setValue("userNo", userNo);
            this.sendAction(action);
        }
    }

    public void unMuteUser(long roomId, String userNo) {
        Log.d(this.getClass().getSimpleName(), "WebAgent unMuteUser() \u53d6\u6d88\u975c\u97f3(\u6703\u8b70\u4eba\u54e1):" + roomId + "-" + userNo);
        if (this.checkConfNo(roomId) && this.checkUserNo(userNo)) {
            ActionObj action = new ActionObj("meetme.unMuteUser");
            action.setValue("roomId", roomId);
            action.setValue("userNo", userNo);
            this.sendAction(action);
        }
    }

    public void kickUser(long roomId, String userNo, long empId) {
        Log.d(this.getClass().getSimpleName(), "WebAgent lock() \u9a45\u9010(\u6703\u8b70\u4eba\u54e1):" + roomId + "-" + userNo + "-" + empId);
        if (this.checkConfNo(roomId) && this.checkUserNo(userNo)) {
            ActionObj action = new ActionObj("meetme.kickUser");
            action.setValue("roomId", roomId);
            action.setValue("userNo", userNo);
            action.setValue("employeeId", empId);
            this.sendAction(action);
        }
    }

    public void kickUser(long roomId, String userNo) {
        Log.d(this.getClass().getSimpleName(), "WebAgent lock() \u9a45\u9010(\u6703\u8b70\u4eba\u54e1):" + roomId + "-" + userNo);
        if (this.checkConfNo(roomId) && this.checkUserNo(userNo)) {
            ActionObj action = new ActionObj("meetme.kickUser");
            action.setValue("roomId", roomId);
            action.setValue("userNo", userNo);
            this.sendAction(action);
        }
    }

    public boolean isConnected() {
        return this.connectionCurrent != null && this.connectionCurrent.isConnected();
    }

    public boolean isConnecting() {
        return this.connectionCurrent != null && this.connectionCurrent.isConnecting();
    }

    private boolean checkConfNo(long roomId) {
        if (roomId == -1L) {
            Log.e(this.getClass().getSimpleName(), "WebAgent \u6703\u8b70\u5ba4\u7de8\u865f\u53c3\u6578 roomId \u672a\u8a2d\u5b9a");
            return false;
        }
        return true;
    }

    private boolean checkUserNo(String userNo) {
        if (userNo == null) {
            Log.d(this.getClass().getSimpleName(), "WebAgent \u4eba\u54e1\u7de8\u865f\u53c3\u6578\u672a\u8a2d\u5b9a");
            return false;
        }
        return true;
    }

    public void getAllSiteList() {
        ActionObj action = new ActionObj("employee.getAllSiteList");
        this.sendAction(action);
    }

    public void getAllOutboundPrefixList() {
        ActionObj action = new ActionObj("employee.getOutboundPrefixList");
        this.sendAction(action);
    }

    public void getMySiteList() {
        ActionObj action = new ActionObj("employee.getMySiteList");
        this.sendAction(action);
    }

    public void stopSipRequestProcess() {
        this.sipAccountResultHandler.removeCallbacks(this.sipAccountResultTimer);
    }

    public void startSipRequestProcess(String place) {
        Log.w(this.getClass().getSimpleName(), "startSipRequestProcess:" + place);
        this.insternalStartSipRequestProcess(place, 1000L);
    }

    public void insternalStartSipRequestProcess(String place, long timer) {
        Log.d(this.getClass().getSimpleName(), "startSipRequestProcess place:" + place + " " + timer);
        this.stopSipRequestProcess();
        haveSipAccountReady = false;
        this.sipAccountResultTryCount = 0;
        this.sipAccountResultHandler.postDelayed(this.sipAccountResultTimer, timer);
    }

    public void getSipAccountOnRegFail(int registrationFailureCount, String place) {
        Log.i(this.getClass().getSimpleName(), "getSipAccountOnRegFail .... failed count is " + registrationFailureCount);
        long timer = 3000L;
        timer = registrationFailureCount < 5 ? 3000L : (registrationFailureCount < 10 ? 10000L : (registrationFailureCount < 30 ? 30000L : (registrationFailureCount < 100 ? 30000L : 120000L)));
        this.insternalStartSipRequestProcess(place, timer);
    }

    public void callEmployee(String calleeEmpId) {
        Log.d(this.getClass().getSimpleName(), "==============callEmployee");
        String loginSip = PreferencesUtil.getSipUserName(this.context);
        long siteId = PreferencesUtil.getSipUsePbxSite(this.context);
        ActionObj action = new ActionObj("employee.makeCall");
        action.setValue("callerDeviceIds", loginSip);
        action.setValue("mySiteId", String.valueOf(siteId));
        action.setValue("calleeEmplopyeeId", calleeEmpId);
        this.sendAction(action);
    }

    public void makeCall(String destSiteId, String destNumber) {
        Log.d(this.getClass().getSimpleName(), "==============callExt");
        String loginSip = PreferencesUtil.getSipUserName(this.context);
        long siteId = PreferencesUtil.getSipUsePbxSite(this.context);
        ActionObj action = new ActionObj("employee.makeCall");
        action.setValue("callerDeviceIds", loginSip);
        action.setValue("mySiteId", String.valueOf(siteId));
        action.setValue("destSiteId", destSiteId);
        action.setValue("destNumber", destNumber);
        this.sendAction(action);
    }

    public void makeCallUsingHardhone(long destSiteId, String destNumber, long mySiteId, List<String> deviceIdList) {
        Log.d(this.getClass().getSimpleName(), "==============callExt");
        ActionObj action = new ActionObj("employee.makeCall");
        action.setValue("callerDeviceIds", String.join((CharSequence)",", deviceIdList));
        action.setValue("mySiteId", String.valueOf(mySiteId));
        action.setValue("destSiteId", String.valueOf(destSiteId));
        action.setValue("destNumber", destNumber);
        this.sendAction(action);
    }

    public void hangupCall(long mySiteId) {
        ActionObj action = new ActionObj("employee.hangupCall");
        action.setValue("callRefId", refCallId);
        action.setValue("mySiteId", String.valueOf(mySiteId));
        this.sendAction(action);
    }

    public void joinConference(String callerDeviceIds, String role, long siteId, String chatRoomId, String name, boolean isAutoAnswer) {
        Log.d(this.getClass().getSimpleName(), "==============joinConference \u96fb\u8a71\u529f\u80fd ... \u6253\u96fb\u8a71\u52a0\u5165\u4e00\u500b\u96fb\u8a71\u6703\u8b70meetme, \u7cfb\u7d71\u6703\u5148call\u56de\u4f86\u518dcall\u53bb\u6703\u8b70\u5ba4 ....");
        ActionObj action = new ActionObj("conferenceRoom.joinConference");
        action.setValue("callerDeviceIds", callerDeviceIds);
        action.setValue("role", role);
        action.setValue("siteId", String.valueOf(siteId));
        action.setValue("chatRoomId", chatRoomId);
        action.setValue("name", name);
        action.setValue("isAutoAnswer", isAutoAnswer ? "Y" : "N");
        this.sendAction(action);
    }

    public void findDyncConfRoom(long siteId, String chatRoomId, String name) {
        ActionObj action = new ActionObj("conferenceRoom.findDynamicConfRoom");
        action.setValue("siteId", String.valueOf(siteId));
        action.setValue("chatRoomId", chatRoomId);
        action.setValue("name", name);
        this.sendAction(action);
    }

    public void joinChatRoom(String chatRoomId) {
        Log.d(this.getClass().getSimpleName(), "==============joinChatRoom");
        ActionObj action = new ActionObj("conferenceRoom.joinChatRoom");
        action.setValue("chatRoomId", chatRoomId);
        this.sendAction(action);
    }

    public void changePersonalPhoto(String employeeAccount, String photoStr) {
        ActionObj action = new ActionObj("employee.changePersonalPhoto");
        action.setValue("employeeAccount", employeeAccount);
        action.setValue("photoString", photoStr);
        action.setValue("paraNoReturn", 1);
        this.sendAction(action);
    }

    public void deletePersonalRecord(String id) {
        ActionObj action = new ActionObj("record.deletePersonalRecord");
        action.setValue("id", id);
        this.sendAction(action);
    }

    public void deleteVoiceMessage(String id) {
        ActionObj action = new ActionObj("record.deleteVoiceMessage");
        action.setValue("id", id);
        this.sendAction(action);
    }

    public void listVoiceAndRecord() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "record.listVoiceMessageAndPersonalReocrd.TimeStamp");
        ActionObj action = new ActionObj("record.listVoiceMessageAndPersonalReocrd");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void listDeletedVoiceAndRecord() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "record.getDeletedVMAndPRList.TimeStamp");
        ActionObj action = new ActionObj("record.getDeletedVMAndPRList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void changePassword(String password) {
        ActionObj action = new ActionObj("employee.updatePassword");
        if (TextUtils.isNotBlank((CharSequence)password)) {
            action.setValue("password", password.trim());
        }
        this.sendAction(action);
    }

    public void changeConferenceRoomName(Long roomId, String conferenceRoomName) {
        ActionObj action = new ActionObj("conferenceRoom.modifyConferenceRoomName");
        if (roomId != null) {
            action.setValue("roomId", (long)roomId);
        }
        if (TextUtils.isNotBlank((CharSequence)conferenceRoomName)) {
            action.setValue("name", conferenceRoomName.trim());
        }
        this.sendAction(action);
    }

    public void leaveConference(Long roomId) {
        ActionObj action = new ActionObj("conferenceRoom.leaveConference");
        if (roomId != null) {
            action.setValue("roomId", (long)roomId);
        }
        this.sendAction(action);
    }

    public void changeLocale(Locale locale) {
        ActionObj action = new ActionObj("system.changeLocale");
        action.setValue("localeLanguage", locale.getLanguage());
        action.setValue("localeCountry", locale.getCountry());
        this.sendAction(action);
    }

    public void getCompanyName() {
        ActionObj action = new ActionObj("employee.getCompanyName");
        this.sendAction(action);
    }

    public void verifyConferenceRoomPinCode(long roomId, String pinCode) {
        ActionObj action = new ActionObj("conferenceRoom.verifyConferenceRoomPinCode");
        action.setValue("pinCode", pinCode);
        action.setValue("roomId", roomId);
        this.sendAction(action);
    }

    public void getConferenceRoomMemberList(long roomId) {
        ActionObj action = new ActionObj("conferenceRoom.getMemberList");
        action.setValue("roomId", roomId);
        this.sendAction(action);
    }

    public void updatePersonalPhones(String phones) {
        ActionObj action = new ActionObj("employee.updatePersonalPhonesNew");
        try {
            action.setValue("phones", new JSONArray(phones));
        }
        catch (JSONException e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "updatePersonalPhones ", e);
        }
        this.sendAction(action);
    }

    public void updatePersonalGender(int gender) {
        ActionObj action = new ActionObj("employee.updatePersonalGender");
        action.setValue("gender", gender);
        this.sendAction(action);
    }

    public void updatePersonalBirthday(String birthday) {
        ActionObj action = new ActionObj("employee.updatePersonalBirthday");
        action.setValue("birthday", birthday);
        this.sendAction(action);
    }

    public void updatePersonalBirthdayHideType(int type) {
        ActionObj action = new ActionObj("employee.updatePersonalBirthdayHideType");
        action.setValue("birthdayHideType", type);
        this.sendAction(action);
    }

    public void getDeviceInfo() {
        ActionObj action = new ActionObj("employee.getDeviceInfosAllSite");
        this.sendAction(action);
    }

    public void updateDeviceInfo(String deviceinfo) {
        ActionObj action = new ActionObj("employee.updateDeviceInfosAllSite");
        try {
            action.setValue("sites", new JSONArray(deviceinfo));
        }
        catch (JSONException e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "updatePersonalPhones ", e);
        }
        this.sendAction(action);
    }

    public void getRingSite() {
        ActionObj action = new ActionObj("employee.getRingSite");
        this.sendAction(action);
    }

    public void addExternalContact(String name, String phones, String company, String organization, String title, String birthday, String email, String photoStr) {
        ActionObj action = new ActionObj("contact.addContactInfoNew");
        action.setValue("name", name);
        JSONArray phoneNumber = null;
        try {
            phoneNumber = TextUtils.isNotBlank((CharSequence)phones) ? new JSONArray(phones.trim()) : new JSONArray();
            action.setValue("phones", phoneNumber);
        }
        catch (JSONException e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
        if (TextUtils.isNotBlank((CharSequence)company)) {
            action.setValue("company", company.trim());
        }
        if (TextUtils.isNotBlank((CharSequence)organization)) {
            action.setValue("organization", organization.trim());
        }
        if (TextUtils.isNotBlank((CharSequence)title)) {
            action.setValue("title", title.trim());
        }
        if (TextUtils.isNotBlank((CharSequence)birthday)) {
            action.setValue("birthDayStr", birthday.trim());
        }
        if (TextUtils.isNotBlank((CharSequence)email)) {
            action.setValue("email", email.trim());
        }
        if (TextUtils.isNotBlank((CharSequence)photoStr)) {
            action.setValue("photoString", photoStr.trim());
        }
        this.sendAction(action);
    }

    public void modifyExternalContact(long id, String name, String phones, String company, String organization, String title, String birthday, String email) {
        ActionObj action = new ActionObj("contact.modifyContactInfoNew");
        action.setValue("contactId", id);
        if (TextUtils.isNotBlank((CharSequence)name)) {
            action.setValue("name", name.trim());
        }
        JSONArray phoneNumber = null;
        try {
            phoneNumber = TextUtils.isNotBlank((CharSequence)phones) ? new JSONArray(phones.trim()) : new JSONArray();
            action.setValue("phones", phoneNumber);
        }
        catch (JSONException e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
        if (TextUtils.isNotBlank((CharSequence)company)) {
            action.setValue("company", company.trim());
        } else {
            action.setValue("company", "");
        }
        if (TextUtils.isNotBlank((CharSequence)organization)) {
            action.setValue("organization", organization.trim());
        } else {
            action.setValue("organization", "");
        }
        if (TextUtils.isNotBlank((CharSequence)title)) {
            action.setValue("title", title.trim());
        } else {
            action.setValue("title", "");
        }
        if (TextUtils.isNotBlank((CharSequence)birthday)) {
            action.setValue("birthDayStr", birthday.trim());
        }
        if (TextUtils.isNotBlank((CharSequence)email)) {
            action.setValue("email", email.trim());
        } else {
            action.setValue("email", "");
        }
        this.sendAction(action);
    }

    public void queryExternalContactList() {
        if (!noQueryExternalContactList) {
            long timestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getMyContactList.TimeStamp");
            ActionObj action = new ActionObj("contact.getMyContactList");
            action.setValue("timeStamp", timestamp);
            this.sendAction(action);
        }
    }

    public void changeExternalContactPhoto(long contactId, String photoStr) {
        ActionObj action = new ActionObj("contact.changePersonalPhoto");
        action.setValue("contactId", contactId);
        action.setValue("photoString", photoStr);
        action.setValue("paraNoReturn", 1);
        this.sendAction(action);
    }

    public void deleteExternalContact(String contactIds) {
        ActionObj action = new ActionObj("contact.deleteContactInfo");
        action.setValue("contactIds", contactIds);
        this.sendAction(action);
    }

    public void addGroupInfo(String name, String members) {
        ActionObj action = new ActionObj("group.addGroupInfo");
        action.setValue("name", name);
        action.setValue("members", members);
        if (TextUtils.isNotBlank((CharSequence)members)) {
            try {
                action.setValue("members", new JSONArray(members.trim()));
            }
            catch (JSONException e) {
                Log.e(WebConnectionImpl.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
            }
        } else {
            action.setValue("members", new JSONArray());
        }
        this.sendAction(action);
    }

    public void modifyGroupInfo(long groupId, String name, String members) {
        ActionObj action = new ActionObj("group.modifyGroupInfo");
        action.setValue("groupId", groupId);
        action.setValue("name", name);
        action.setValue("members", members);
        if (TextUtils.isNotBlank((CharSequence)members)) {
            try {
                action.setValue("members", new JSONArray(members.trim()));
            }
            catch (JSONException e) {
                Log.e(WebConnectionImpl.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
            }
        }
        this.sendAction(action);
    }

    public void addContactToGroup(String groupName, List<String> ids, int type) {
        long groupId = ContactManager.getGroupIdByName(this.context, groupName);
        String members = ContactManager.getAddMembers(this.context, groupName, ids, type);
        this.modifyGroupInfo(groupId, groupName, members);
    }

    public void addContactToGroup(String groupName, String id, int type) {
        long groupId = ContactManager.getGroupIdByName(this.context, groupName);
        if (groupId >= 0L) {
            String members = ContactManager.getAddMembers(this.context, groupName, id, type);
            this.modifyGroupInfo(groupId, groupName, members);
        } else {
            Log.e(this.getClass().getSimpleName(), "can't find group name:" + groupName);
        }
    }

    public void removeContactFromGroup(String groupName, String id, int type) {
        long groupId = ContactManager.getGroupIdByName(this.context, groupName);
        String members = ContactManager.getRemoveMembers(this.context, groupName, id, type);
        this.modifyGroupInfo(groupId, groupName, members);
    }

    public void addFavorite(String id, int type) {
        this.addContactToGroup("My favorites", id, type);
    }

    public void removeFavorite(String id, int type) {
        this.removeContactFromGroup("My favorites", id, type);
    }

    public void addMychatRoom(String id) {
        this.addContactToGroup("My chat rooms", id, 3);
    }

    public void removeMyChatRoom(String id) {
        this.removeContactFromGroup("My chat rooms", id, 3);
    }

    public void deleteGroupByName(String groupName) {
        long groupId = ContactManager.getGroupIdByName(this.context, groupName);
        ActionObj action = new ActionObj("group.deleteGroupInfo");
        action.setValue("groupIds", String.valueOf(groupId));
        this.sendAction(action);
    }

    public void queryGroupList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "group.getMyGroupList.20150921.TimeStamp");
        ActionObj action = new ActionObj("group.getMyGroupList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void getVoiceConfig() {
        ActionObj action = new ActionObj("employee.getVoiceConfig");
        this.sendAction(action);
    }

    public void updateVoiceConfigNew(JSONObject data) {
        int allType = data.optInt("allAutoTransferRuleTypeId", 0);
        long allSiteId = data.optLong("allAutoTransferRuleSiteId", -1L);
        String allNumber = data.optString("allAutoTransferRuleNumber", null);
        int busyType = data.optInt("busyAutoTransferRuleTypeId", 0);
        long busySiteId = data.optLong("busyAutoTransferRuleSiteId", -1L);
        String busyNumber = data.optString("busyAutoTransferRuleNumber", null);
        int noAnswerType = data.optInt("noAnswerAutoTransferRuleTypeId", 0);
        long noAnswerSiteId = data.optLong("noAnswerAutoTransferRuleSiteId", -1L);
        String noAnswerNumber = data.optString("noAnswerAutoTransferRuleNumber", null);
        int languageId = data.optInt("languageId", -1);
        boolean recemail = data.optBoolean("subscribeRecEmailFlag", false);
        boolean dndflag = data.optBoolean("dndFlag", false);
        String password = data.optString("voicePassword", null);
        if (TextUtils.isBlank((CharSequence)password) || !TextUtils.isDigitsOnly(password)) {
            password = "1234";
        }
        ActionObj action = new ActionObj("employee.updateVoiceConfigNew");
        action.setValue("allAutoTransferRuleTypeId", allType);
        if (allSiteId != -1L) {
            action.setValue("allAutoTransferRuleSiteId", allSiteId);
        }
        if (allNumber != null) {
            action.setValue("allAutoTransferRuleNumber", allNumber);
        }
        action.setValue("busyAutoTransferRuleTypeId", busyType);
        if (busySiteId != -1L) {
            action.setValue("busyAutoTransferRuleSiteId", busySiteId);
        }
        if (busyNumber != null) {
            action.setValue("busyAutoTransferRuleNumber", busyNumber);
        }
        action.setValue("noAnswerAutoTransferRuleTypeId", noAnswerType);
        if (noAnswerSiteId != -1L) {
            action.setValue("noAnswerAutoTransferRuleSiteId", noAnswerSiteId);
        }
        if (noAnswerNumber != null) {
            action.setValue("noAnswerAutoTransferRuleNumber", noAnswerNumber);
        }
        action.setValue("languageId", languageId);
        action.setValue("subscribeRecEmailFlag", recemail);
        action.setValue("dndFlag", dndflag);
        action.setValue("voicePassword", password);
        this.sendAction(action);
    }

    public void getLanguageList() {
        ActionObj action = new ActionObj("system.getVoiceLanguageList");
        this.sendAction(action);
    }

    public boolean enableDND() {
        ActionObj action = new ActionObj("employee.setDNDFlagOn");
        return this.sendActionResponse(action);
    }

    public boolean disableDND() {
        ActionObj action = new ActionObj("employee.setDNDFlagOff");
        return this.sendActionResponse(action);
    }

    public void deleteDevice(long siteId, String deviceId) {
        ActionObj action = new ActionObj("employee.deleteDevice");
        action.setValue("deviceId", deviceId);
        action.setValue("siteId", siteId);
        this.sendAction(action);
    }

    public String getLogingFailMsg() {
        return logingFailMsg;
    }

    public void getCustomerInfo(String customerAccount) {
        ActionObj action = new ActionObj("customer.getCustomerInfo");
        action.setValue("customerAccount", customerAccount);
        this.sendAction(action);
    }

    public void getCustomerInfoList() {
        Set<Long> customerIds = UCDBCustomer.getCustomerIds(this.context);
        if (customerIds == null || customerIds.size() == 0) {
            return;
        }
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "customer.getCustomerList.TimeStamp");
        ActionObj action = new ActionObj("customer.getCustomerInfoList");
        action.setValue("timeStamp", timestamp);
        action.setValue("customerIds", CommonUtil.longSetToString(customerIds));
        this.sendAction(action);
    }

    public void updateCustomerLevel(String customerAccount, int level) {
        ActionObj action = new ActionObj("customer.updateCustomerLevel");
        action.setValue("customerAccount", customerAccount);
        action.setValue("level", level);
        this.sendAction(action);
    }

    public void getCustomerHistoryLog(String customerAccount, String sessionId) {
        ActionObj action = new ActionObj("customer.getCustomerHistoryLog");
        action.setValue("customerAccount", customerAccount);
        action.setValue("sessionId", sessionId);
        this.sendAction(action);
    }

    public void getCustomerServiceCategory() {
        ActionObj action = new ActionObj("customer.getServiceCategory");
        this.sendAction(action);
    }

    public void setCustomerServiceDone(String customerAccount, long categoryId, String comment) {
        ActionObj action = new ActionObj("customer.serviceDone");
        action.setValue("customerAccount", customerAccount);
        action.setValue("categoryId", categoryId);
        action.setValue("comment", comment);
        this.sendAction(action);
    }

    public void setCustomerManualTransfer(String customerAccount, long receiverId, long categoryId, String comment) {
        ActionObj action = new ActionObj("customer.manualTransfer");
        action.setValue("customerAccount", customerAccount);
        action.setValue("receiverId", receiverId);
        action.setValue("categoryId", categoryId);
        action.setValue("comment", comment);
        this.sendAction(action);
    }

    public void updateLoginSite() {
        long mySiteId = PreferencesUtil.getSipUsePbxSite(this.context);
        if (mySiteId == -1L) {
            return;
        }
        ActionObj action = new ActionObj("employee.updateLoginSite");
        action.setValue("loginSiteId", String.valueOf(mySiteId));
        this.sendAction(action);
    }

    public void updateLoginSip() {
        String sipAccount = PreferencesUtil.getSipUserName(this.context);
        if (TextUtils.isBlank((CharSequence)sipAccount)) {
            return;
        }
        ActionObj action = new ActionObj("employee.updateLoginSip");
        action.setValue("loginSip", sipAccount);
        this.sendAction(action);
    }

    private String convertPropToJsonStr(Map<String, Object> props) {
        JSONObject obj = new JSONObject();
        if (props != null) {
            for (String key : props.keySet()) {
                Object value = props.get(key);
                try {
                    obj.put(key, value.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return obj.toString();
    }

    public void sendDisplayedMessageNotification(String fromJID, String packetId) {
        ActionObj action = new ActionObj("chat.sendMsgDisplayedNotification");
        action.setValue("fromJid", fromJID);
        action.setValue("packetId", packetId);
        this.sendAction(action);
    }

    public void removeRoomMembers(String roomJID, Collection<String> memberJIDs) {
        ActionObj action = new ActionObj("multiChat.removeRoomMembers");
        action.setValue("roomJid", roomJID);
        action.setValue("memberJids", CommonUtil.getJSONArrayString(memberJIDs));
        this.sendAction(action);
    }

    public void inviteRoomParticipants(String roomJID, List<String> participantJIDs) {
        ActionObj action = new ActionObj("multiChat.inviteRoomParticipants");
        action.setValue("roomJid", roomJID);
        action.setValue("participantJids", CommonUtil.getJSONArrayString(participantJIDs));
        this.sendAction(action);
    }

    public void changeRoomSubject(String roomJID, String subject) {
        ActionObj action = new ActionObj("multiChat.changeRoomSubject");
        action.setValue("roomJid", roomJID);
        action.setValue("subject", subject);
        this.sendAction(action);
    }

    public void exitRoom(String roomJID) {
        ActionObj action = new ActionObj("multiChat.exitRoom");
        action.setValue("roomJid", roomJID);
        this.sendAction(action);
    }

    public String createChatRoom(String subject, List<String> participantJids) {
        Log.d(this.getClass().getSimpleName(), "createChatRoom subject:" + subject + ", participantJids:" + String.valueOf(participantJids));
        String requestId = ChatRoomManager.getRequestId(this.context);
        ActionObj action = new ActionObj("multiChat.createChatRoom");
        action.setValue("requestId", requestId);
        action.setValue("subject", subject);
        action.setValue("participantJids", CommonUtil.getJSONArrayString(participantJids));
        this.sendAction(action);
        return requestId;
    }

    public void getChatEventBeginTime() {
        ActionObj action = new ActionObj("chat.getChatEventBeginTime");
        this.sendAction(action);
    }

    public void calculateOldestChatEventId(long daysAgo) {
        ActionObj action = new ActionObj("employee.calculateOldestChatEventId");
        action.setValue("days", daysAgo);
        this.sendAction(action);
    }

    public void getOldChatEventByEventId(long lastChatEventId) {
        boolean liteReady = PreferencesUtil.isLiteEventLogEnabled(this.context);
        ActionObj action = new ActionObj(liteReady ? "chat.getOldChatEventLite" : "chat.getOldChatEvent");
        action.setValue("lastChatEventId", lastChatEventId);
        action.setValue("pageSize", liteReady ? 500 : 20);
        this.sendAction(action);
    }

    public void getOldChatEventDetailsByEventIds(Set<Long> chatEventIds) {
        ActionObj action = new ActionObj("chat.getChatEventList");
        action.setValue("ids", CommonUtil.longSetToString(chatEventIds));
        this.sendAction(action);
    }

    public void getRefChatEventDetailsByPacketId(String packetId) {
        ActionObj action = new ActionObj("chat.getRefChatEventList");
        action.setValue("packetId", packetId);
        this.sendAction(action);
    }

    public void queryLoginDeviceList() {
        ActionObj action = new ActionObj("employee.getLoginDeviceList");
        this.sendAction(action);
    }

    public void removeLoginDeviceById(String uniqueDeviceId) {
        ActionObj action = new ActionObj("employee.removeLoginDeviceList");
        HashSet<String> set = new HashSet<String>();
        set.add(uniqueDeviceId);
        action.setValue("deviceUniqueIdList", CommonUtil.getJSONArrayString(set));
        this.sendAction(action);
    }

    public void enableChatRoomNotice(String jid, boolean noPrompt) {
        ActionObj action = new ActionObj("chat.removeChatRoomFilter");
        action.setValue("Jid", jid);
        if (noPrompt) {
            action.setValue("noPromptResult", "true");
        }
        this.sendAction(action);
    }

    public void disableChatRoomNotice(String jid) {
        ActionObj action = new ActionObj("chat.addChatRoomFilter");
        action.setValue("Jid", jid);
        this.sendAction(action);
    }

    public void getDisableChatRoomNoticeList() {
        ActionObj action = new ActionObj("chat.getChatRoomFilterList");
        this.sendAction(action);
    }

    public void reportSyncDone() {
        this.oldEventRoomSyncSet.clear();
    }

    public void clearSyncRoomInfo() {
        Log.d(WebAgent.class.getSimpleName(), "clearSyncRoomInfo----------------- ALL");
        this.oldEventRoomSyncSet.clear();
    }

    public void clearSyncRoomInfo(String roomJID) {
        Log.d(WebAgent.class.getSimpleName(), "clearSyncRoomInfo----------------- roomJID:" + roomJID);
        this.oldEventRoomSyncSet.remove(roomJID);
    }

    public void reportOneRoomInfoGot(String roomJID) {
        if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
            return;
        }
        Log.d(WebAgent.class.getSimpleName(), "reportOneRoomInfoGot----------------- roomJID:" + roomJID);
        this.oldEventRoomSyncSet.add(roomJID);
    }

    public void getOneRoomSync(String roomJID) {
        if (PreferencesUtil.isSyncOldChatEventDone(this.context) || !this.oldEventRoomSyncSet.contains(roomJID)) {
            UCDBRemoteMark.addSyncChatRoomRemoteMark(UCChatClient.context, roomJID);
            this.getOneRoomNew(roomJID, true);
        } else {
            Log.d(WebAgent.class.getSimpleName(), "getOneRoomSync skip----------------- roomJID:" + roomJID + ", skipCount:" + this.skipCount++);
        }
    }

    public void getOneRoomReSync(String roomJID) {
        this.getOneRoomNew(roomJID, true);
    }

    private void getOneRoomNew(String roomJID, boolean sync) {
        Log.d(WebAgent.class.getSimpleName(), "----------------- getOneRoomNew jid:" + roomJID + " " + ClassUtil.getCallingMethod());
        boolean oneRoomHasMembers = PreferencesUtil.isOneRoomNewHasMembers(this.context);
        if (!oneRoomHasMembers) {
            this.getOneRoomNewLocal(roomJID, sync);
            this.getRoomMembersNewLocal(roomJID, sync);
        } else {
            this.getOneRoomNewLocal(roomJID, sync);
        }
    }

    private void getRoomMembersNewLocal(String roomJID, boolean sync) {
        ActionObj action = new ActionObj("multiChat.getRoomMembersNew");
        action.setValue("roomJid", roomJID);
        if (sync) {
            action.setValue("forSync", sync);
        }
        this.sendAction(action);
    }

    private void getOneRoomNewLocal(String roomJID, boolean sync) {
        ActionObj action = new ActionObj("multiChat.getOneRoomNew");
        action.setValue("roomJid", roomJID);
        if (sync) {
            action.setValue("forSync", sync);
        }
        this.sendAction(action);
    }

    public void getRoomsForUpdate() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getChatRoomInfo.TimeStamp");
        ActionObj action = new ActionObj("multiChat.getRooms");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void markChatEventAsRead(long chatEventId) {
        ActionObj action = new ActionObj("chat.makeChatEventRead");
        action.setValue("chatEventIds", String.valueOf(chatEventId));
        this.sendAction(action);
    }

    public void markChatEventAsRead(String chatEventIds) {
        ActionObj action = new ActionObj("chat.makeChatEventRead");
        action.setValue("chatEventIds", chatEventIds);
        this.sendAction(action);
    }

    public void markChatEventAsPlayed(long chatEventId) {
        ActionObj action = new ActionObj("chat.makeChatEventPlayed");
        action.setValue("chatEventIds", String.valueOf(chatEventId));
        this.sendAction(action);
    }

    public void markChatEventAsPlayed(String chatEventIds) {
        ActionObj action = new ActionObj("chat.makeChatEventPlayed");
        action.setValue("chatEventIds", chatEventIds);
        this.sendAction(action);
    }

    public void markVoicemailAsRead(String ids) {
        ActionObj action = new ActionObj("record.updateReadStatusForVoiceMessage");
        action.setValue("ids", ids);
        this.sendAction(action);
    }

    public void markPersonalRecordAsRead(String ids) {
        ActionObj action = new ActionObj("record.updateReadStatusForPersonalRecord");
        action.setValue("ids", ids);
        this.sendAction(action);
    }

    public void makeTwoStepTransfer(String sipCallId1, String sipCallId2) {
        ActionObj action = new ActionObj("phone.makeTwoStepTransfer");
        action.setValue("sipCallId1", sipCallId1);
        action.setValue("sipCallId2", sipCallId2);
        this.sendAction(action);
    }

    public void parkCall(String sipCallId1) {
        ActionObj action = new ActionObj("phone.parkCall");
        action.setValue("sipCallId1", sipCallId1);
        this.sendAction(action);
    }

    public void makeThreeWayCalling(String chatRoomId, Set<String> jidSet, String sipCallId1, String sipCallId2, String sipCallId3) {
        ActionObj action = new ActionObj("phone.makeThreeWayCalling");
        if (TextUtils.isNotBlank((CharSequence)chatRoomId)) {
            action.setValue("chatRoomId", chatRoomId.trim());
        }
        action.setValue("jids", CommonUtil.strSetToString(jidSet));
        if (sipCallId1 != null) {
            action.setValue("sipCallId1", sipCallId1);
        }
        if (sipCallId2 != null) {
            action.setValue("sipCallId2", sipCallId2);
        }
        if (sipCallId3 != null) {
            action.setValue("sipCallId3", sipCallId3);
        }
        this.sendAction(action);
    }

    public void makeInviteConference(String chatRoomId, String sipCallId1) {
        ActionObj action = new ActionObj("phone.makeInviteConference");
        action.setValue("chatRoomId", chatRoomId);
        if (sipCallId1 != null) {
            action.setValue("sipCallId1", sipCallId1);
        }
        this.sendAction(action);
    }

    public void addPhoneNumToOutboundBlackList(String phoneNum, String reason) {
        ActionObj action = new ActionObj("phone.addPhoneNumToOutboundBlackList");
        action.setValue("phoneNum", phoneNum);
        action.setValue("reason", reason);
        this.sendAction(action);
    }

    public void addPhoneNumToInboundBlackList(String phoneNum, String reason) {
        ActionObj action = new ActionObj("phone.addPhoneNumToBlackList");
        action.setValue("phoneNum", phoneNum);
        action.setValue("reason", reason);
        this.sendAction(action);
    }

    public void checkRecentCallRecords(String phoneNum, PhoneLineInfo lineInfo) {
        ActionObj action = new ActionObj("phone.checkRecentCallRecords");
        action.setValue("phoneNum", phoneNum);
        long mySiteId = PreferencesUtil.getSipUsePbxSite(this.context);
        action.setValue("mySiteId", mySiteId);
        try {
            action.setLineInfoObj(lineInfo.convertToJson());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.sendAction(action);
    }

    public void deleteChatEvent(long chatEventId) {
        if (chatEventId == -1L) {
            return;
        }
        ActionObj action = new ActionObj("chat.deleteChatEvent");
        action.setValue("chatEventIds", String.valueOf(chatEventId));
        this.sendAction(action);
    }

    public void deleteChatEvent(Set<Long> chatEventIdAry) {
        ActionObj action = new ActionObj("chat.deleteChatEvent");
        action.setValue("chatEventIds", CommonUtil.longSetToString(chatEventIdAry));
        this.sendAction(action);
    }

    public void deleteChatEventsByRoomJid(String roomJid) {
        ActionObj action = new ActionObj("chat.deleteChatEventByRoomJid");
        action.setValue("roomJid", roomJid);
        this.sendAction(action);
    }

    public void deleteChatEventsByUserJid(String userJid) {
        ActionObj action = new ActionObj("chat.deleteChatEventByUserJid");
        action.setValue("userJid", userJid);
        this.sendAction(action);
    }

    public void getDeletedGroupList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getDeletedGroupList.TimeStamp");
        ActionObj action = new ActionObj("group.getDeletedGroupList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void getChatMessageReaderInfo() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getChatMessageReaderInfo.TimeStamp");
        ActionObj action = new ActionObj("chat.getChatMessageReaderInfoByTimeStamp");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void getReaderTime(String packetId) {
        long lastReadLogId = UCDBReaderLog.getLastReaderLogId(this.context, packetId);
        ActionObj action = new ActionObj("chat.getReaderTime");
        action.setValue("packetId", packetId);
        action.setValue("readLogId", String.valueOf(lastReadLogId));
        action.setValue("pageSize", 300);
        this.sendAction(action);
    }

    public void getDeletedContactList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getDeletedContactList.TimeStamp");
        ActionObj action = new ActionObj("contact.getDeletedContactList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void updateOutboundPrefix(long prefixId) {
        ActionObj action = new ActionObj("employee.updateOutboundPrefix");
        action.setValue("outboundPrefixId", prefixId);
        this.sendAction(action);
    }

    public void getUnreadChatEventIdList() {
        ActionObj action = new ActionObj("chat.getUnreadChatEvenIdList");
        this.sendAction(action);
    }

    public void getPlayedChatEventIdList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "chat.getPlayedChatEventList.TimeStamp");
        if (timestamp > 0L) {
            ActionObj action = new ActionObj("chat.getPlayedChatEvenIdList");
            action.setValue("timeStamp", timestamp);
            this.sendAction(action);
        } else {
            PreferencesUtil.setTimeStamp(this.context, "chat.getPlayedChatEventList.TimeStamp", System.currentTimeMillis());
        }
    }

    public void updateOldestChatEventId(long oldestEventId) {
        ActionObj action = new ActionObj("employee.updateOldestChatEventId");
        action.setValue("oldestChatEventId", oldestEventId);
        this.sendAction(action);
    }

    public void updateOldestChatEventIdToCurrent() {
        ActionObj action = new ActionObj("employee.updateOldestChatEventId");
        action.setValue("oldestChatEventId", 0);
        this.sendAction(action);
    }

    public void getPublishBulletinList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "bulletin.getPublishBulletinList.TimeStamp");
        ActionObj action = new ActionObj("bulletin.getPublishBulletinList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void getSuppressBulletinList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "bulletin.getSuppressBulletinList.TimeStamp");
        ActionObj action = new ActionObj("bulletin.getSuppressBulletinList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void getBulletinInfo(long bulletinId) {
        ActionObj action = new ActionObj("bulletin.getBulletinInfo");
        action.setValue("bulletinId", bulletinId);
        this.sendAction(action);
    }

    public void markBulletinAsRead(long bulletinId) {
        ActionObj action = new ActionObj("bulletin.makeBulletinAsRead");
        action.setValue("bulletinId", bulletinId);
        this.sendAction(action);
    }

    public void markBulletinAsMark(long bulletinId) {
        ActionObj action = new ActionObj("bulletin.makeBulletinAsMark");
        action.setValue("bulletinId", bulletinId);
        action.setValue("marked", true);
        this.sendAction(action);
    }

    public void markBulletinAsUnmark(long bulletinId) {
        ActionObj action = new ActionObj("bulletin.makeBulletinAsMark");
        action.setValue("bulletinId", bulletinId);
        action.setValue("marked", false);
        this.sendAction(action);
    }

    public void getBulletinReadCountList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "bulletin.getBulletinReadCountList.TimeStamp");
        ActionObj action = new ActionObj("bulletin.getReadCountList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void getApiUserList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "apiUser.getApiUserList.TimeStamp");
        ActionObj action = new ActionObj("apiUser.getApiUserList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void getDeletedApiUserList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "apiUser.getDeletedApiUserList.TimeStamp");
        ActionObj action = new ActionObj("apiUser.getDeletedApiUserList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public boolean recallChatMessage(String packetId) {
        ActionObj action = new ActionObj("chat.recallChatMsg");
        action.setValue("packetId", packetId);
        return this.sendActionResponse(action);
    }

    public void getRecallInfo() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getRecallInfo.TimeStamp");
        ActionObj action = new ActionObj("chat.getRecallInfoByTimeStamp");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void agentLogin(Set<MediaType> loginMediaTypeSet) {
        ActionObj action = new ActionObj("agent.login");
        action.setValue("mediaTypes", StringUtils.join(loginMediaTypeSet, (String)","));
        this.sendAction(action);
    }

    public void agentLogin(Set<MediaType> loginMediaTypeSet, Set<Long> skillQueueSet) {
        ActionObj action = new ActionObj("agent.login");
        action.setValue("mediaTypes", StringUtils.join(loginMediaTypeSet, (String)","));
        action.setValue("skillIds", StringUtils.join(skillQueueSet, (String)","));
        this.sendAction(action);
    }

    public void agentLogout() {
        ActionObj action = new ActionObj("agent.logout");
        this.sendAction(action);
    }

    public void changeAgentState(AgentAction agentAction, Long auxReasonId) {
        ActionObj action = new ActionObj("agent.changeState");
        action.setValue("actionCode", agentAction.toString());
        if (auxReasonId != null && agentAction == AgentAction.AUX) {
            action.setValue("auxReasonId", auxReasonId);
        }
        this.sendAction(action);
    }

    public void getFaxDocList() {
        long initTimestamp = PreferencesUtil.getTimeStamp(this.context, "fax.init.TimeStamp");
        if (initTimestamp == -1L) {
            PreferencesUtil.setTimeStamp(this.context, "fax.init.TimeStamp", System.currentTimeMillis());
        }
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "fax.getFaxDocList.TimeStamp");
        ActionObj action = new ActionObj("fax.listFaxDoc");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void getFaxDocDeletedList() {
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "fax.getFaxDocDeletedList.TimeStamp");
        ActionObj action = new ActionObj("fax.getDeletedFaxDocList");
        action.setValue("timeStamp", timestamp);
        this.sendAction(action);
    }

    public void markFaxDocAsRead(long faxDocId) {
        ActionObj action = new ActionObj("fax.updateReadStatus");
        action.setValue("ids", String.valueOf(faxDocId));
        this.sendAction(action);
    }

    public void deleteFaxDoc(Long faxDocId) {
        ActionObj action = new ActionObj("fax.deleteFaxDoc");
        action.setValue("ids", String.valueOf(faxDocId));
        this.sendAction(action);
    }

    public void resendFaxDoc(Long faxDocId) {
        ActionObj action = new ActionObj("fax.resendFaxDoc");
        action.setValue("ids", String.valueOf(faxDocId));
        this.sendAction(action);
    }

    public void cancelFaxDoc(Long faxDocId) {
        ActionObj action = new ActionObj("fax.cancelFaxDoc");
        action.setValue("ids", String.valueOf(faxDocId));
        this.sendAction(action);
    }

    public void getSatisfactionSurveyList() {
        ActionObj action = new ActionObj("personalCustomer.getSatisfactionSurveyList");
        this.sendAction(action);
    }

    public void sendChatText(ChatSendMsgTask info) {
        String myJid = PreferencesUtil.getUserJid(this.context);
        List<ChatReceiver> receiverList = info.getChatReceiverList();
        for (ChatReceiver receiver : receiverList) {
            MsgBean bean = new MsgBean();
            bean.setChatEventId(-1L);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(receiver.getReceiverJid());
            bean.setPacketId(receiver.getPacketId());
            bean.setStatus("N");
            bean.setFromJid(myJid);
            bean.setToJid(receiver.getReceiverJid());
            bean.setContent(info.getOriginalContent());
            bean.setMsgType(info.getType());
            bean.setDuration(info.getDuration() != null ? info.getDuration() : 0L);
            bean.setRead(true);
            bean.setPlayed(true);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            bean.setTitle(info.getTitle());
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (info.getTitle() != null) {
                props.put("title", info.getTitle());
            }
            if (info.getLatitude() != null) {
                props.put("latitude", info.getLatitude());
            }
            if (info.getLongitude() != null) {
                props.put("longitude", info.getLongitude());
            }
            if (info.getQuotePackageId() != null) {
                props.put("refPacketId", info.getQuotePackageId());
            }
            bean.setProps(props != null ? this.convertPropToJsonStr(props) : null);
            ChatRoomManager.newOutChatMsg(this.context, receiver.getReceiverJid(), bean);
        }
        BroadcastUtil.sendContactHistoryChangedEvent(this.context);
        BroadcastUtil.sendMsgChangedEvent(this.context, info.getReceiverJidList(), true);
        ChatMsgQueueController.getInstance(this.context).addTask(info);
    }

    public void sendChatFile(ChatSendFileTask info) {
        String myJid = PreferencesUtil.getUserJid(this.context);
        List<ChatReceiver> receiverList = info.getChatReceiverList();
        for (ChatReceiver receiver : receiverList) {
            FileBean bean = new FileBean();
            bean.setChatEventId(-1L);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(receiver.getReceiverJid());
            bean.setPacketId(receiver.getPacketId());
            bean.setStatus("N");
            bean.setFromJid(myJid);
            bean.setToJid(receiver.getReceiverJid());
            bean.setFileContent(info.getThumbnail());
            bean.setFileName(info.getFileName());
            bean.setFileLocalPath(null);
            bean.setFileSize(info.getFileSize());
            bean.setFileDownloadURL(info.getFileDownloadUrl());
            bean.setMsgType(info.getMsgType());
            bean.setDuration(info.getDuration() != null ? info.getDuration() : 0L);
            bean.setRead(true);
            bean.setPlayed(true);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            bean.setMimeType(info.getMimeType());
            bean.setExtraText(info.getFileExtraInfo());
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (info.getQuotePackageId() != null) {
                props.put("refPacketId", info.getQuotePackageId());
            }
            bean.setProps(props != null ? this.convertPropToJsonStr(props) : null);
            ChatRoomManager.newChatFile(this.context, receiver.getReceiverJid(), bean);
        }
        BroadcastUtil.sendContactHistoryChangedEvent(this.context);
        BroadcastUtil.sendMsgChangedEvent(this.context, info.getReceiverJidList(), true);
        ChatMsgQueueController.getInstance(this.context).addTask(info);
    }

    public void uploadChatFile(ChatUploadSendFileTask info) {
        Log.i(WebAgent.class.getSimpleName(), "uploadChatFile:" + String.valueOf(info));
        String myJid = PreferencesUtil.getUserJid(this.context);
        List<ChatReceiver> receiverList = info.getChatReceiverList();
        for (ChatReceiver receiver : receiverList) {
            FileBean bean = new FileBean();
            bean.setChatEventId(-1L);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(receiver.getReceiverJid());
            bean.setPacketId(receiver.getPacketId());
            bean.setStatus("UPLOADING");
            bean.setFromJid(myJid);
            bean.setToJid(receiver.getReceiverJid());
            bean.setFileContent(info.getThumbnail());
            bean.setFileName(info.getFileName());
            bean.setFileLocalPath(info.getFileLocalPath());
            bean.setFileSize(info.getFileSize());
            bean.setFileDownloadURL(null);
            bean.setMsgType(info.getMsgType());
            bean.setDuration(info.getDuration() != null ? info.getDuration() : 0L);
            bean.setRead(true);
            bean.setPlayed(true);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            bean.setMimeType(info.getMimeType());
            bean.setExtraText(info.getFileExtraInfo());
            HashMap<String, Object> props = new HashMap<String, Object>();
            if (info.getQuotePackageId() != null) {
                props.put("refPacketId", info.getQuotePackageId());
            }
            bean.setProps(props != null ? this.convertPropToJsonStr(props) : null);
            ChatRoomManager.newChatFile(this.context, receiver.getReceiverJid(), bean);
        }
        BroadcastUtil.sendContactHistoryChangedEvent(this.context);
        BroadcastUtil.sendMsgChangedEvent(this.context, info.getReceiverJidList(), true);
        ChatMsgQueueController.getInstance(this.context).addTask(info);
    }

    public void sendChatFileAfterUpload(ChatUploadSendFileTask info) {
        ChatMsgQueueController.getInstance(this.context).doSendMsgOut(info);
    }

    public void cancelUploading(String packetId) {
        ChatMsgQueueController.getInstance(this.context).cancelMsg(packetId);
    }

    public void sendAction(ActionObj action) {
        this.getConnection().sendTextMessage(action.toJSONString());
    }

    private boolean sendActionResponse(ActionObj action) {
        return this.getConnection().sendTextMessage(action.toJSONString());
    }

    public void fetchFreeSeatingList() {
        ActionObj action = new ActionObj("device.fetchFreeSeatingList");
        long mySiteId = PreferencesUtil.getSipUsePbxSite(this.context);
        action.setValue("mySiteId", mySiteId);
        this.sendAction(action);
    }

    public void cancelFreeSeating() {
        ActionObj action = new ActionObj("device.cancelFreeSeating");
        long mySiteId = PreferencesUtil.getSipUsePbxSite(this.context);
        action.setValue("mySiteId", mySiteId);
        this.sendAction(action);
    }

    public void requestFreeSeating(String deviceId) {
        ActionObj action = new ActionObj("device.requestFreeSeating");
        long mySiteId = PreferencesUtil.getSipUsePbxSite(this.context);
        action.setValue("mySiteId", mySiteId);
        action.setValue("deviceId", deviceId);
        this.sendAction(action);
    }

    static {
        ignoreSet.add("DNIS");
        ignoreSet.add("INBOUND_RULE_INFO");
        ignoreSet.add("MENU_RULE_INFO");
        ignoreSet.add("ANI");
        ignoreSet.add("CALL_ID");
        haveSipAccountReady = false;
    }
}

