/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.bean;

import com.blisscloud.ezuc.client.outboundfilter.CallResultType;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Message {
    private long id;
    private String status;
    private String fromJid;
    private String toJid;
    private String content;
    private ContentType contentType = ContentType.TEXT;
    private String packetId;
    private String timeZone;
    private long createTime;
    private long serverTime;
    private String fromName;
    private String fileName;
    private long fileSize;
    private String fileLocalPath;
    private String fileDownloadURL;
    private int msgType;
    private boolean read;
    private boolean played;
    private long duration;
    private String noticeContent;
    private String noticeThumbnail;
    private long chatEventId;
    private long syncEventId;
    private int readCount;
    private String readerList;
    private String chatRoomJid;
    private String props;
    private int mainType = 0;
    private boolean lazyContent;
    private String phoneNumber;
    private boolean recalled;
    private boolean outboundTrunk;
    private String mimeType;
    private String extraMsgInfo;
    private Long contactRecordId;
    private String title;

    public String getChatRoomJid() {
        return this.chatRoomJid;
    }

    public void setChatRoomJid(String chatRoomJid) {
        this.chatRoomJid = chatRoomJid;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getToJid() {
        return this.toJid;
    }

    public void setToJid(String toJid) {
        this.toJid = toJid;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFromJid() {
        return this.fromJid;
    }

    public void setFromJid(String fromJid) {
        this.fromJid = fromJid;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(long serverTime) {
        this.serverTime = serverTime;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = ContentType.valueOf(contentType);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileDownloadURL() {
        if (null == this.fileDownloadURL || "null".equalsIgnoreCase(this.fileDownloadURL)) {
            return "";
        }
        return this.fileDownloadURL;
    }

    public void setFileDownloadURL(String fileDownloadURL) {
        this.fileDownloadURL = fileDownloadURL;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getPacketId() {
        return this.packetId;
    }

    public void setPacketId(String packetId) {
        this.packetId = packetId;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public String getNoticeContent() {
        return this.noticeContent;
    }

    public void setNoticeContent(String noticeContent) {
        this.noticeContent = noticeContent;
    }

    public String getNoticeThumbnail() {
        return this.noticeThumbnail;
    }

    public void setNoticeThumbnail(String noticeThumbnail) {
        this.noticeThumbnail = noticeThumbnail;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getChatEventId() {
        return this.chatEventId;
    }

    public void setChatEventId(long chatEventId) {
        this.chatEventId = chatEventId;
    }

    public long getSyncEventId() {
        return this.syncEventId;
    }

    public void setSyncEventId(long syncEventId) {
        this.syncEventId = syncEventId;
    }

    public boolean isPlayed() {
        return this.played;
    }

    public void setPlayed(boolean played) {
        this.played = played;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public void setReadCount(int readCount) {
        this.readCount = readCount;
    }

    public String getReaderList() {
        return this.readerList;
    }

    public void setReaderList(String readerList) {
        this.readerList = readerList;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
    }

    public int getMainType() {
        return this.mainType;
    }

    public void setMainType(int mainType) {
        this.mainType = mainType;
    }

    public boolean isLazyContent() {
        return this.lazyContent;
    }

    public void setLazyContent(boolean lazyContent) {
        this.lazyContent = lazyContent;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public boolean isRecalled() {
        return this.recalled;
    }

    public void setRecalled(boolean recalled) {
        this.recalled = recalled;
    }

    public boolean isOutboundTrunk() {
        return this.outboundTrunk;
    }

    public void setOutboundTrunk(boolean outboundTrunk) {
        this.outboundTrunk = outboundTrunk;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileLocalPath() {
        return this.fileLocalPath;
    }

    public void setFileLocalPath(String fileLocalPath) {
        this.fileLocalPath = fileLocalPath;
    }

    public String getNoPrefixNumber() {
        if (this.props != null) {
            try {
                JSONObject obj = new JSONObject(this.props);
                if (obj.has("dialExtNoPrefix")) {
                    return obj.getString("dialExtNoPrefix");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getDialResult() {
        Object suffix = "";
        if (this.props != null) {
            try {
                JSONObject obj = new JSONObject(this.props);
                if (obj.has("dialResult")) {
                    String dialResult = obj.getString("dialResult");
                    if (!CallResultType.FAILED_UNKNOWN.toString().equals(dialResult)) {
                        if (CallResultType.FAILED_ROUTIG_ERROR.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_routing");
                        } else if (CallResultType.FAILED_CONGESTION.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_congestion");
                        } else if (CallResultType.NO_DIAL_RUN_OUT_TIME.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_run_out_time");
                        } else if (CallResultType.NO_DIAL_TIME_QUOTA_EXHAUSTED.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_time_quota_exhausted");
                        } else if (CallResultType.NO_DIAL_NO_PERMISSION.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_no_permission");
                        } else if (CallResultType.NO_DIAL_FORBIDDEN_TIME.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_forbidden_time");
                        } else if (CallResultType.NO_DIAL_WRONG_NO.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_wrong_no");
                        } else if (CallResultType.NO_DIAL_IN_BLOCK_LIST.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_in_black_list");
                        } else if (CallResultType.NO_DIAL_EMP_OFF_DUTY.toString().equals(dialResult)) {
                            suffix = (String)suffix + I18NUtil.getString("call_dial_failed_reason_emp_off_duty");
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            return " (" + (String)suffix + ")";
        }
        return "";
    }

    public boolean isOutboundRecording(Context ctx) {
        boolean isOutbound = false;
        if (this.msgType == 13 || this.msgType == 1006) {
            try {
                JSONObject props = new JSONObject(this.props);
                VoiceItem voiceItem = VoicemailManager.parseMessageProps(ctx, props);
                if (voiceItem.isOutboundTrunk()) {
                    isOutbound = true;
                }
            }
            catch (JSONException e) {
                Log.e(Message.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
        }
        return isOutbound;
    }

    public String getFileNameForDisp() {
        if (StringUtils.isBlank((CharSequence)this.fileName)) {
            return null;
        }
        int index = this.fileName.lastIndexOf(File.separator);
        if (index != -1) {
            return this.fileName.substring(index + 1);
        }
        return this.fileName;
    }

    public String getFileLocalPathToFetch() {
        if (StringUtils.isNotBlank((CharSequence)this.fileLocalPath)) {
            return this.fileLocalPath;
        }
        return this.fileName;
    }

    public String getFileSizeToDisp() {
        if (this.fileSize > 0L) {
            return FileUtil.convertFileSizeDisplay(this.fileSize);
        }
        if (this.duration > 0L) {
            return FileUtil.convertFileSizeDisplay(this.duration);
        }
        return "0";
    }

    public long getFileSizeToCal() {
        if (this.fileSize > 0L) {
            return this.fileSize;
        }
        if (this.duration > 0L) {
            return this.duration;
        }
        return 0L;
    }

    public String getFileExtension() {
        return FileUtil.getFileExtension(this.getFileNameForDisp());
    }

    public String getExtraMsgInfo() {
        return this.extraMsgInfo;
    }

    public void setExtraMsgInfo(String extraMsgInfo) {
        this.extraMsgInfo = extraMsgInfo;
    }

    public Long getContactRecordId() {
        return this.contactRecordId;
    }

    public void setContactRecordId(Long contactRecordId) {
        this.contactRecordId = contactRecordId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static enum ContentType {
        TEXT,
        FILE;

    }
}

