/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.callback;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.bean.web.LiteBulletinAttachment;
import com.blisscloud.ezuc.bean.web.LiteBulletinDetail;
import com.blisscloud.ezuc.bean.web.LiteBulletinHeader;
import com.blisscloud.ezuc.bean.web.LiteDepartment;
import com.blisscloud.ezuc.bean.web.LiteFaxDoc;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.bean.ReaderCountBean;
import com.blisscloud.ezuc.client.bean.SysRecordingItem;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.freeseating.FreeSeatingSelectionDialog;
import com.blisscloud.ezuc.client.outboundfilter.AddNumToOutboundBlackListConfirmDialog;
import com.blisscloud.ezuc.client.outboundfilter.OutboundFilterDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.PackageInfo;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.VersionCheckUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatMsgQueueController;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.AgentAction;
import com.blisscloud.mobile.ezuc.bean.AgentStatusType;
import com.blisscloud.mobile.ezuc.bean.AuthOption;
import com.blisscloud.mobile.ezuc.bean.CustomerKey;
import com.blisscloud.mobile.ezuc.bean.CustomerPhotoTask;
import com.blisscloud.mobile.ezuc.bean.EmpPhotoTask;
import com.blisscloud.mobile.ezuc.bean.MediaType;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.bean.MessageChannelPhotoTask;
import com.blisscloud.mobile.ezuc.bean.MsgReaderTime;
import com.blisscloud.mobile.ezuc.bean.QueueStatus;
import com.blisscloud.mobile.ezuc.callback.WebCallBack;
import com.blisscloud.mobile.ezuc.db.UCDBBulletin;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBCustomer;
import com.blisscloud.mobile.ezuc.db.UCDBDept;
import com.blisscloud.mobile.ezuc.db.UCDBFaxDoc;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBReaderLog;
import com.blisscloud.mobile.ezuc.db.UCDBRecording;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.AddressBookScopeManager;
import com.blisscloud.mobile.ezuc.manager.BulletinManager;
import com.blisscloud.mobile.ezuc.manager.ChatEventManager;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DataChangeEventManager;
import com.blisscloud.mobile.ezuc.manager.DeviceManager;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import com.blisscloud.mobile.ezuc.manager.task.ChatEventController;
import com.blisscloud.mobile.ezuc.manager.task.CleanAllTask;
import com.blisscloud.mobile.ezuc.manager.task.EventController;
import com.blisscloud.mobile.ezuc.manager.task.GetBulletinSubjectPhotoTask;
import com.blisscloud.mobile.ezuc.manager.task.GetDataTask;
import com.blisscloud.mobile.ezuc.manager.task.GetLogoTask;
import com.blisscloud.mobile.ezuc.manager.task.GetOldChatHistoryPageEventIdTask;
import com.blisscloud.mobile.ezuc.manager.task.LoadDeletedJidDataTask;
import com.blisscloud.mobile.ezuc.manager.task.MeetmeJoinTask;
import com.blisscloud.mobile.ezuc.manager.task.MeetmeLeaveTask;
import com.blisscloud.mobile.ezuc.manager.task.MeetmeMuteTask;
import com.blisscloud.mobile.ezuc.manager.task.SyncBulletinDetailsTask;
import com.blisscloud.mobile.ezuc.manager.task.SyncChatHistoryTask;
import com.blisscloud.mobile.ezuc.manager.task.SyncChatRoomInfoTask;
import com.blisscloud.mobile.ezuc.manager.task.SyncRemoteMarkTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.manager.task.UpdateSingleChatRoomInfoTask;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MigratedFromMobileApp
public class WebConnectionListener
implements WebCallBack {
    private boolean useSSL = true;
    private Context context = null;
    private ConcurrentHashMap<String, ReaderCountBean> downloadFileTaskMap = new ConcurrentHashMap();
    private Timer checkLocalTimer = new Timer("WebConnectionListenerTimer");

    public WebConnectionListener(Context _context) {
        this.context = _context;
    }

    @Override
    public void notifyOnOpen() {
        Log.d(WebConnectionListener.class.getSimpleName(), "WebAgent onOpen() \u9023\u7dda\u5efa\u7acb");
        WebAgent.getInstance().notifyOnOpen();
        BroadcastUtil.sendUcrmConnectionOpenEvent(this.context);
    }

    @Override
    public void notifyTimeout() {
        BroadcastUtil.sendUcrmConnectionTimeoutEvent(this.context);
    }

    @Override
    public void notifyException(String message) {
        BroadcastUtil.sendUcrmConnectionExceptionEvent(this.context);
    }

    @Override
    public synchronized void notifyOnClose(int code, String reason, boolean tryConnectFail) {
        Log.i(WebConnectionListener.class.getSimpleName(), "WebAgent onClose() \u9023\u7dda\u95dc\u9589: " + reason + ", code: " + code + ", tryConnectFail:" + tryConnectFail);
        WebAgent.getInstance().notifyOnClose(code, reason, tryConnectFail);
    }

    @Override
    public String getURI() {
        if (PreferencesUtil.getHost(this.context) == null || "".equals(PreferencesUtil.getHost(this.context))) {
            return null;
        }
        String url = null;
        url = this.useSSL ? (PreferencesUtil.isInOffice(this.context) ? "wss://" + this.ipv6Decorate(PreferencesUtil.getHost(this.context)) + ":8443/ucrm/cmd.ws" : "wss://" + this.ipv6Decorate(PreferencesUtil.getExternalHost(this.context)) + ":" + PreferencesUtil.getExternalPort(this.context) + "/ucrm/cmd.ws") : "ws://" + this.ipv6Decorate(PreferencesUtil.getHost(this.context)) + ":8080/ucrm/cmd.ws";
        return url;
    }

    private String ipv6Decorate(String address) {
        InetAddressValidator validator = InetAddressValidator.getInstance();
        if (validator.isValidInet6Address(address)) {
            return "[" + address + "]";
        }
        return address;
    }

    @Override
    public String getLoginID() {
        return PreferencesUtil.getLoginID(this.context);
    }

    @Override
    public String getLoginToken() {
        return PreferencesUtil.getLoginToken(this.context);
    }

    @Override
    public String getEnterpriseNo() {
        String enterpriseNo = PreferencesUtil.getEnterpriseNo(this.context);
        if (TextUtils.isNotBlank((CharSequence)enterpriseNo)) {
            return enterpriseNo.trim().toLowerCase();
        }
        return null;
    }

    @Override
    public String getLoginSip() {
        return PreferencesUtil.getSipUserName(this.context);
    }

    @Override
    public String getLoginPWD() {
        return PreferencesUtil.getLoginPWD(this.context);
    }

    @Override
    public int getAppType() {
        return PreferencesUtil.getInt(this.context, "APPTYPE", 0);
    }

    @Override
    public int getVersionCode() {
        PackageInfo versioninfo = VersionCheckUtils.getVersionInfo(this.context);
        return versioninfo.getVersionCode();
    }

    @Override
    public String getVersionName() {
        PackageInfo versioninfo = VersionCheckUtils.getVersionInfo(this.context);
        return versioninfo.getVersionName();
    }

    @Override
    public String getVersionDate() {
        PackageInfo versioninfo = VersionCheckUtils.getVersionInfo(this.context);
        return versioninfo.getVersionDate();
    }

    @Override
    public String getDeviceName() {
        return PreferencesUtil.getString(this.context, "DEVICENAME", "");
    }

    @Override
    public String getLoginSessionId() {
        return PreferencesUtil.getString(this.context, "LOGIN_SESSION_ID", "");
    }

    @Override
    public int getDeviceType() {
        return PreferencesUtil.getInt(this.context, "DEVICETYPE", 1);
    }

    @Override
    public int getProductType() {
        return PreferencesUtil.getInt(this.context, "PRODUCTTYPE", 0);
    }

    @Override
    public String getDeviceOS() {
        return PreferencesUtil.getString(this.context, "DEVICEOS", "");
    }

    @Override
    public String getDeviceId() {
        return PreferencesUtil.getString(this.context, "DEVICEID", "");
    }

    @Override
    public String getMacAddress() {
        return PreferencesUtil.getString(this.context, "MACADDRESS", "");
    }

    @Override
    public synchronized void loginResult(int returnCode, String returnInfo, final String result, final String sessionId, final JSONObject dataObj) {
        try {
            Log.d(WebConnectionListener.class.getSimpleName(), "returnCode " + returnCode);
            ChatEventController.getInstance(this).deactive();
            WebAgent.logingFailMsg = "";
            if (returnCode == 0) {
                JSONObject userProfile = dataObj.getJSONObject("userProfile");
                final LiteContact userContact = (LiteContact)new Gson().fromJson(userProfile.toString(), new TypeToken<LiteContact>(this){}.getType());
                Long newEmpId = userContact.getId();
                long existUserId = PreferencesUtil.getUserId(this.context);
                if (existUserId != 0L && newEmpId != null && newEmpId != existUserId) {
                    final String loginAcc = PreferencesUtil.getLoginID(this.context);
                    final String loginPass = PreferencesUtil.getLoginPWD(this.context);
                    CleanAllTask task = new CleanAllTask(this.context){

                        @Override
                        protected void onPostExecute(Void resultx) {
                            PreferencesUtil.setLoginInfo(WebConnectionListener.this.context, loginAcc, loginPass);
                            try {
                                WebConnectionListener.this.handleLoginResult(result, sessionId, dataObj, userContact);
                            }
                            catch (JSONException e) {
                                Log.e(WebConnectionListener.class.getSimpleName(), e.getLocalizedMessage(), e);
                            }
                        }
                    };
                    task.execute(new Void[0]);
                } else {
                    this.handleLoginResult(result, sessionId, dataObj, userContact);
                }
            } else {
                Log.e(WebConnectionListener.class.getSimpleName(), "WebAgent \u767b\u5165\u5931\u6557:" + returnInfo);
                WebAgent.getInstance().loginFailed(returnInfo, "FAIL_LOGIN_IN_GENERAL", returnCode);
            }
        }
        catch (Throwable e) {
            Log.e(WebConnectionListener.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private void handleLoginResult(String result, String sessionId, JSONObject dataObj, LiteContact userContact) throws JSONException {
        JSONObject obj;
        boolean hasVoiceLicence;
        String agentLoginMediaTypes;
        Log.d(WebConnectionListener.class.getSimpleName(), "WebAgent \u767b\u5165\u6210\u529f:" + result + " sessionId:" + sessionId);
        if (dataObj.has("tenantId")) {
            PreferencesUtil.setTenantId(this.context, dataObj.getLong("tenantId"));
        }
        if (dataObj.has("accessKey")) {
            String newAccessKey = dataObj.getString("accessKey");
            PreferencesUtil.setAccessKey(this.context, newAccessKey);
        }
        if (dataObj.has("serverVersion")) {
            PreferencesUtil.setServerVersion(this.context, dataObj.getString("serverVersion"));
        }
        if (dataObj.has("mobileSrtpUsed")) {
            PreferencesUtil.setMobileSrtpUsed(this.context, dataObj.getBoolean("mobileSrtpUsed"));
        } else {
            PreferencesUtil.setMobileSrtpUsed(this.context, false);
        }
        if (dataObj.has("autoHangupEnabled")) {
            PreferencesUtil.setAutoHangupEnabled(this.context, dataObj.getBoolean("autoHangupEnabled"));
        }
        if (dataObj.has("autoHangupTimeoutSec")) {
            PreferencesUtil.setAutoHangupTimeoutSec(this.context, dataObj.getInt("autoHangupTimeoutSec"));
        }
        if (dataObj.has("api")) {
            PreferencesUtil.setApi(this.context, dataObj.getString("api"));
        }
        if (dataObj.has("meetmePrefix")) {
            PreferencesUtil.setMeetmePrefixOld(this.context, dataObj.getString("meetmePrefix"));
        }
        if (dataObj.has("outboundFilterEnabled")) {
            PreferencesUtil.setOutboundFilterEnabled(this.context, dataObj.getBoolean("outboundFilterEnabled"));
        }
        if (dataObj.has("outboundFilterRecordingIncluded")) {
            PreferencesUtil.setOutboundFilterRecordingIncluded(this.context, dataObj.getBoolean("outboundFilterRecordingIncluded"));
        }
        this.savePermissionInfo(dataObj);
        PreferencesUtil.saveLicenceInfo(this.context, dataObj);
        if (dataObj.has("fileUploadUpperLimit")) {
            PreferencesUtil.setFileUploadUpperLimit(this.context, dataObj.getInt("fileUploadUpperLimit"));
        }
        if (dataObj.has("textUploadUpperLimit")) {
            PreferencesUtil.setTextUploadUpperLimit(this.context, dataObj.getInt("textUploadUpperLimit"));
        }
        JSONObject userProfile = dataObj.getJSONObject("userProfile");
        LiteContact liteContact = (LiteContact)new Gson().fromJson(userProfile.toString(), new TypeToken<LiteContact>(this){}.getType());
        PreferencesUtil.setUserInfo(this.context, liteContact);
        ContactManager.setWSContact(this.context, liteContact, 0, 1);
        PreferencesUtil.setUserJid(this.context, liteContact.getJid());
        PreferencesUtil.setUserResource(this.context, ChatRoomManager.getResource());
        if (dataObj.has("agentRole")) {
            PreferencesUtil.setAgentRole(dataObj.getString("agentRole"));
        } else {
            PreferencesUtil.setAgentRole(null);
        }
        BroadcastUtil.sendAgentRoleChangedEvent(this.context);
        PreferencesUtil.setPasswordExpiredPopupDone(this.context, true);
        if (dataObj.has("reminderExpiredType")) {
            int passwordExpiredType = dataObj.getInt("reminderExpiredType");
            PreferencesUtil.setPasswordExpiredType(this.context, passwordExpiredType);
            PreferencesUtil.setPasswordExpiredDays(this.context, 0);
            if (passwordExpiredType == 2 && dataObj.has("passwordRemainingDays")) {
                int expireddays = dataObj.getInt("passwordRemainingDays");
                PreferencesUtil.setPasswordExpiredDays(this.context, expireddays);
            }
            if (passwordExpiredType != 0) {
                PreferencesUtil.setPasswordExpiredPopupDone(this.context, false);
            }
        }
        if (dataObj.has("authOption")) {
            int authOption = dataObj.getInt("authOption");
            PreferencesUtil.setAuthOption(this.context, AuthOption.getValue(authOption));
            BroadcastUtil.sendAuthOptionChanged(this.context);
        }
        WebAgent.agentState = AgentStatusType.LOGOUT;
        WebAgent.agentLoginMediaTypes.clear();
        WebAgent.callAttachData = new JSONObject();
        WebAgent.queueStatusMap.clear();
        if (dataObj.has("agentState")) {
            String agentStateCode = dataObj.getString("agentState");
            WebAgent.agentState = AgentStatusType.getValue(agentStateCode);
        }
        Long auxReasonId = null;
        if (dataObj.has("auxReasonId")) {
            auxReasonId = dataObj.getLong("auxReasonId");
        }
        WebAgent.auxReasonId = auxReasonId;
        if (dataObj.has("agentLoginMediaTypes") && StringUtils.isNotBlank((CharSequence)(agentLoginMediaTypes = dataObj.getString("agentLoginMediaTypes")))) {
            String[] loginTypes;
            for (String mediaType : loginTypes = agentLoginMediaTypes.split(",")) {
                WebAgent.agentLoginMediaTypes.add(MediaType.getValue(mediaType));
            }
        }
        if (dataObj.has("queueStatus")) {
            JSONArray queueStatusAry = dataObj.getJSONArray("queueStatus");
            for (int k = 0; k < queueStatusAry.length(); ++k) {
                JSONObject obj2 = queueStatusAry.getJSONObject(k);
                long skillId = obj2.getLong("skillId");
                String skillName = obj2.getString("skillName");
                int requestSize = obj2.getInt("requestSize");
                long requestTime = obj2.getLong("requestTime");
                long currentTime = obj2.getLong("currentTime");
                QueueStatus queueStatus = new QueueStatus();
                queueStatus.setSkillId(skillId);
                queueStatus.setSkillName(skillName);
                queueStatus.setRequestSize(requestSize);
                queueStatus.setRequestTime(requestTime);
                queueStatus.setTimeShift(System.currentTimeMillis() - currentTime);
                WebAgent.queueStatusMap.put(skillId, queueStatus);
            }
            BroadcastUtil.sendQueueStateChangedEvent(this.context);
        }
        if (dataObj.has("queueLevels")) {
            PreferencesUtil.setAgentQueueInfo(dataObj.getJSONArray("queueLevels").toString());
        }
        if (dataObj.has("auxReasons")) {
            PreferencesUtil.setAuxReasonInfo(dataObj.getJSONArray("auxReasons").toString());
        }
        if (PreferencesUtil.isAutoLogin() && PreferencesUtil.isAgent() && WebAgent.agentState == AgentStatusType.LOGOUT && WebAgent.agentLoginMediaTypes.size() == 0) {
            HashSet<MediaType> tryLoginMediaSet = new HashSet<MediaType>();
            if (PreferencesUtil.isPhoneAgent()) {
                tryLoginMediaSet.add(MediaType.PHONE);
            }
            if (PreferencesUtil.isChatAgent()) {
                tryLoginMediaSet.add(MediaType.CHAT);
            }
            if (ApiVersion.isApi27Later()) {
                WebAgent.getInstance().agentLogin(tryLoginMediaSet, PreferencesUtil.getAgentQueueSelectedSet());
            } else {
                WebAgent.getInstance().agentLogin(tryLoginMediaSet);
            }
        }
        if (hasVoiceLicence = PreferencesUtil.getBoolean(this.context, "LICENSE_VOICE", true)) {
            if (dataObj.has("mySiteList")) {
                this.mySiteListResult(dataObj.getJSONArray("mySiteList"));
            } else {
                WebAgent.getInstance().getMySiteList();
            }
        }
        PreferencesUtil.setCompanyName(this.context, dataObj.getString("companyName"));
        if (dataObj.has("loginLogId")) {
            PreferencesUtil.putString(this.context, "LOGIN_SESSION_ID", dataObj.getString("loginLogId"));
        }
        if (dataObj.has("empExtendedSysPhoneConfig")) {
            obj = dataObj.getJSONObject("empExtendedSysPhoneConfig");
            PreferencesUtil.setEmpExtendedSysPhoneConfig(this.context, obj.toString());
        } else {
            PreferencesUtil.setEmpExtendedSysPhoneConfig(this.context, "");
        }
        if (dataObj.has("functionInfo")) {
            obj = dataObj.getJSONObject("functionInfo");
            if (obj.has("enableBulletinApi")) {
                PreferencesUtil.setBulletinApiEnabled(this.context, obj.getBoolean("enableBulletinApi"));
            }
            if (obj.has("enableLiteEventLog")) {
                PreferencesUtil.setLiteEventLogEnabled(this.context, obj.getBoolean("enableLiteEventLog"));
            }
            if (obj.has("recallDeadline")) {
                PreferencesUtil.setMsgRecallDeadline(this.context, obj.getInt("recallDeadline"));
            }
            if (obj.has("clientAppDeptMode")) {
                PreferencesUtil.setClientAppDeptMode(this.context, obj.getInt("clientAppDeptMode"));
            }
            boolean contactReportKeyDisp = false;
            if (obj.has("contactReportKeyDisp") && obj.getBoolean("contactReportKeyDisp")) {
                contactReportKeyDisp = true;
            }
            PreferencesUtil.setContactReportKeyDisp(this.context, contactReportKeyDisp);
        }
        if (dataObj.has("addressbookScope")) {
            AddressBookScopeManager.changeScope(this.context, dataObj.getJSONObject("addressbookScope"));
        } else {
            WebAgent.getInstance().getAddressBookScope();
        }
        UCUploadFileChooser.FAX_TYPES.clear();
        if (dataObj.has("faxAllowedFileTypes")) {
            JSONArray faxAllowedFileTypes = dataObj.getJSONArray("faxAllowedFileTypes");
            for (int i = 0; i < faxAllowedFileTypes.length(); ++i) {
                UCUploadFileChooser.FAX_TYPES.add(faxAllowedFileTypes.getString(i).toLowerCase());
            }
        } else {
            UCUploadFileChooser.FAX_TYPES.addAll(Arrays.asList("gif", "jpg", "jpeg", "png", "tiff", "txt", "pdf", "doc", "docx", "xls", "xlsx", "ppt", "pptx"));
        }
        SyncRemoteMarkTask syncRemoteMark = new SyncRemoteMarkTask(this.context);
        TaskController.getInstance().addTask(syncRemoteMark);
        syncRemoteMark.start();
        WebAgent.getInstance().getAllSiteList();
        WebAgent.getInstance().getAllOutboundPrefixList();
        Log.i(WebConnectionListener.class.getSimpleName(), "WebAgent try to set isLogin to true now ...");
        WebAgent.isLogin = true;
        ChatMsgQueueController.suspendInstance(false);
        this.handleCompanyLogo(dataObj);
        GetDataTask task2 = new GetDataTask(this.context);
        TaskController.getInstance().addTask(task2);
        task2.start();
        Log.i(WebConnectionListener.class.getSimpleName(), "================>WEB_LOGIN_DONE ===================================================================>xxxx");
        BroadcastUtil.sendPersonalInfoChanged(this.context);
        BroadcastUtil.sendLoginOKEvent(this.context);
    }

    private void handleCompanyLogo(JSONObject data) throws JSONException {
        boolean doDownloadPhoto = false;
        long savedPhotoTime = PreferencesUtil.getTenantPhotoTime(this.context);
        long newPhotoTime = 0L;
        if (data.has("tenantPhotoTime")) {
            newPhotoTime = data.getLong("tenantPhotoTime");
        }
        if (savedPhotoTime == 0L || newPhotoTime == 0L) {
            doDownloadPhoto = true;
        } else if (newPhotoTime > savedPhotoTime) {
            doDownloadPhoto = true;
        }
        if (doDownloadPhoto) {
            GetLogoTask task = new GetLogoTask(this.context, newPhotoTime);
            TaskController.getInstance().addTask(task);
            task.start();
        }
    }

    private void savePermissionInfo(JSONObject dataObj) throws JSONException {
        boolean hasCallTransferConfigPermisison = true;
        boolean hasChatActionPermisison = true;
        boolean hasChatPhotoActionPermisison = true;
        boolean hasChatVideoActionPermisison = true;
        boolean hasChatFileActionPermisison = true;
        boolean hasPhotoPermisison = true;
        boolean hasAddToInboundBlacklistPermisison = false;
        boolean hasOutboundPrefixPermisison = false;
        boolean fuzzyOutboundNumber = false;
        boolean faxEnabled = false;
        boolean checkRecording = false;
        if (dataObj.has("permission")) {
            JSONObject permissionObj = dataObj.getJSONObject("permission");
            if (permissionObj.has("callTransferConfig") && !permissionObj.getBoolean("callTransferConfig")) {
                hasCallTransferConfigPermisison = false;
            }
            if (permissionObj.has("chatAction") && !permissionObj.getBoolean("chatAction")) {
                hasChatActionPermisison = false;
            }
            if (permissionObj.has("chatPhotoAction") && !permissionObj.getBoolean("chatPhotoAction")) {
                hasChatPhotoActionPermisison = false;
            }
            if (permissionObj.has("chatVideoAction") && !permissionObj.getBoolean("chatVideoAction")) {
                hasChatVideoActionPermisison = false;
            }
            if (permissionObj.has("chatFileAction") && !permissionObj.getBoolean("chatFileAction")) {
                hasChatFileActionPermisison = false;
            }
            if (permissionObj.has("modifyPersonalPhoto") && !permissionObj.getBoolean("modifyPersonalPhoto")) {
                hasPhotoPermisison = false;
            }
            if (permissionObj.has("addToInboundBlacklist") && permissionObj.getBoolean("addToInboundBlacklist")) {
                hasAddToInboundBlacklistPermisison = true;
            }
            if (permissionObj.has("modifyOutboundPrefix") && permissionObj.getBoolean("modifyOutboundPrefix")) {
                hasOutboundPrefixPermisison = true;
            }
            if (permissionObj.has("fuzzyOutboundNumber") && permissionObj.getBoolean("fuzzyOutboundNumber")) {
                fuzzyOutboundNumber = true;
            }
            if (permissionObj.has("faxEnabled") && permissionObj.getBoolean("faxEnabled")) {
                faxEnabled = true;
            }
            if (permissionObj.has("checkRecording") && permissionObj.getBoolean("checkRecording")) {
                checkRecording = true;
            }
        }
        PreferencesUtil.putBoolean(this.context, "PERMISSION_CALL_TRANASFER_CONFIG", hasCallTransferConfigPermisison);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_CHAT_ACTION", hasChatActionPermisison);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_CHAT_PHOTO_ACTION", hasChatPhotoActionPermisison);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_CHAT_VIDEO_ACTION", hasChatVideoActionPermisison);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_CHAT_FILE_ACTION", hasChatFileActionPermisison);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_PHOTO_EDIT", hasPhotoPermisison);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_ADD_TO_INBOUND_BLACKLIST", hasAddToInboundBlacklistPermisison);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_OUTBOUND_PREFIX_EDIT", hasOutboundPrefixPermisison);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_FUZZY_OUTBOUND_NUMBER", fuzzyOutboundNumber);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_FAX_ENABLED", faxEnabled);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_CHECK_RECORDING", checkRecording);
        PreferencesUtil.putBoolean(this.context, "PERMISSION_CHECK_RECORDING", checkRecording);
    }

    @Override
    public void logoutResult(String result) {
        WebAgent.getInstance().logoutResultOK(result);
    }

    @Override
    public void changeAddressBookScope(JSONObject dataObj, Long returnTimeStamp) {
        AddressBookScopeManager.changeScope(this.context, dataObj);
    }

    @Override
    public void matchEmplyeeByPhoneNumber(JSONObject dataObj, JSONObject paraObj) {
        try {
            if (!paraObj.has("token") || dataObj == null || dataObj.length() == 0) {
                return;
            }
            String token = paraObj.getString("token");
            LiteContact liteContact = (LiteContact)new Gson().fromJson(dataObj.toString(), new TypeToken<LiteContact>(this){}.getType());
            if (liteContact == null || liteContact.getJid() == null) {
                return;
            }
            ArrayList<PhotoLoadTask> toGetPhotoEmpList = new ArrayList<PhotoLoadTask>();
            boolean hasPhotoUpdate = ContactManager.setWSContactWithPhotoCheckIfNotExist(this.context, liteContact, 0);
            if (hasPhotoUpdate) {
                EmpPhotoTask task = new EmpPhotoTask();
                task.setEmpKey(KeyUtil.genEmpKey(liteContact));
                toGetPhotoEmpList.add(task);
            }
            if (toGetPhotoEmpList != null && !toGetPhotoEmpList.isEmpty()) {
                ContactManager.refreshPhotoList(this.context, PhotoType.SMALL, toGetPhotoEmpList);
            }
            PhoneAgent.getInstance().onContactLoaded(token, liteContact);
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void changeEmployeeListByIds(JSONArray dataArray, JSONObject paraObj, Long returnTimeStamp) {
        try {
            String token = null;
            if (paraObj.has("token")) {
                token = paraObj.getString("token");
            }
            ContactManager.updateEmployeeListIds(this.context, dataArray, token);
            if (paraObj.has("chatRoomJid")) {
                String chatRoomJid = paraObj.getString("chatRoomJid");
                UCDBChatRoom.setMemberTimestamp(this.context, chatRoomJid, returnTimeStamp);
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void changeEmployeeListByJids(JSONObject dataObj, JSONObject paraObj) {
        try {
            if (dataObj.has("contactList")) {
                JSONArray dataArray = dataObj.getJSONArray("contactList");
                ContactManager.updateEmployeeListJids(this.context, dataArray);
            }
            if (dataObj.has("badJidList")) {
                JSONArray badJidArray = dataObj.getJSONArray("badJidList");
                ContactManager.handleBadJidList(this.context, badJidArray);
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void getAddExtraAddressBookByJidsReuslt(JSONObject dataObj, Long returnTimeStamp) {
        try {
            if (dataObj.has("badJidList")) {
                JSONArray badJidArray = dataObj.getJSONArray("badJidList");
                ContactManager.handleBadJidList(this.context, badJidArray);
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void getRemoveExtraAddressBookByJidsReuslt(JSONObject dataObj, Long returnTimeStamp) {
        try {
            if (dataObj.has("badJidList")) {
                JSONArray badJidArray = dataObj.getJSONArray("badJidList");
                ContactManager.handleBadJidList(this.context, badJidArray);
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void changeEmployeeList(JSONArray dataArray, JSONObject paraObj, Long returnTimeStamp) {
        ContactManager.updateEmployeeList(this.context, dataArray, paraObj, returnTimeStamp);
    }

    @Override
    public void deleteJidList(JSONArray dataArray, long returnTimeStamp) {
        LoadDeletedJidDataTask t = new LoadDeletedJidDataTask(this.context, dataArray, returnTimeStamp);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    @Override
    public void changeLocationList(JSONArray dataArray, long returnTimeStamp) {
        ContactManager.updateLocationList(this.context, dataArray, returnTimeStamp);
    }

    @Override
    public void changeMeetMeList(JSONObject dataObj) {
        MeetmeManager.updateMeetMeList(this.context, dataObj);
    }

    @Override
    public void changeOneMeetMe(JSONObject dataObj) {
        MeetmeManager.updateOneMeetMe(this.context, dataObj);
    }

    @Override
    public void changeMeetMeListUser(JSONObject dataObj) {
        MeetmeManager.updateMeetMeUserList(this.context, dataObj);
    }

    @Override
    public void meetMeJoinEvent(JSONObject dataObj) {
        MeetmeJoinTask task = new MeetmeJoinTask(this.context, dataObj);
        TaskController.getInstance().addTask(task);
        task.start();
    }

    @Override
    public void meetMeLeaveEvent(JSONObject dataObj) {
        MeetmeLeaveTask task = new MeetmeLeaveTask(this.context, dataObj);
        TaskController.getInstance().addTask(task);
        task.start();
    }

    @Override
    public void meetMeEndEvent(JSONObject dataObj) {
    }

    @Override
    public void meetMeTalkingEvent(JSONObject dataObj) {
    }

    @Override
    public void meetMeMuteEvent(JSONObject dataObj) {
        MeetmeMuteTask task = new MeetmeMuteTask(this.context, dataObj);
        TaskController.getInstance().addTask(task);
        task.start();
    }

    @Override
    public void meetMeLockEvent(JSONObject dataObj) {
        if (dataObj == null) {
            return;
        }
        try {
            long roomId = Long.parseLong(dataObj.getString("meetMe"));
            boolean status = dataObj.getBoolean("status");
            if (status) {
                UCDBConf.updateConfRoomLockState(this.context, roomId, status);
                BroadcastUtil.sendMeetmeLockEvent(this.context, roomId);
            } else {
                UCDBConf.updateConfRoomLockState(this.context, roomId, status);
                BroadcastUtil.sendMeetmeUnlockEvent(this.context, roomId);
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void meetMeLockResult(int returnCode, long roomId) {
        if (returnCode == 0) {
            Log.d(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " lock OK");
        } else {
            Log.e(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " lock Failed");
        }
    }

    @Override
    public void meetMeUnLockResult(int returnCode, long roomId) {
        if (returnCode == 0) {
            Log.d(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " unlock OK");
        } else {
            Log.e(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " unlock failed");
        }
    }

    @Override
    public void meetMeMuteAllResult(int returnCode, long roomId) {
        if (returnCode == 0) {
            Log.d(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " mute OK");
        } else {
            Log.e(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " mute failed");
        }
    }

    @Override
    public void meetMeUnMuteAllResult(int returnCode, long roomId) {
        if (returnCode == 0) {
            Log.d(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " unmute OK");
        } else {
            Log.e(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " unmute failed");
        }
    }

    @Override
    public void meetMeKickAllResult(int returnCode, long roomId) {
        if (returnCode == 0) {
            Log.d(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " kickall OK");
        } else {
            Log.e(WebConnectionListener.class.getSimpleName(), "Conf Room ID:" + roomId + " kickall failed");
        }
    }

    @Override
    public void allSiteListResult(JSONArray dataArray) {
        SiteManager.parseSiteListResult(this.context, dataArray);
    }

    @Override
    public void allOutboundPrefixListResult(JSONArray dataArray) {
        OutboundPrefixManager.parseOutboundPrefixListResult(this.context, dataArray);
    }

    @Override
    public void mySiteListResult(JSONArray dataArray) {
        PreferencesUtil.setSipMyPbxSiteList(this.context, dataArray.toString());
        this.processSiteListResult();
    }

    private void processSiteListResult() {
        String[] myPbxSiteIds = CommonUtil.getJsonDataArray(PreferencesUtil.getSipMyPbxSiteList(this.context), "id");
        if (myPbxSiteIds == null) {
            return;
        }
        WebAgent.siteSelectionListRequired = false;
        long targetSiteId = -1L;
        if (myPbxSiteIds.length > 1) {
            long selectedSiteId = PreferencesUtil.getSipUsePbxSite(this.context);
            if (selectedSiteId == -1L) {
                Log.i(WebConnectionListener.class.getSimpleName(), "multiSite siteSelectionListRequired site empty");
                WebAgent.siteSelectionListRequired = true;
                return;
            }
            for (int i = 0; i < myPbxSiteIds.length; ++i) {
                if (Long.parseLong(myPbxSiteIds[i]) != selectedSiteId) continue;
                targetSiteId = selectedSiteId;
            }
            if (targetSiteId == -1L) {
                WebAgent.siteSelectionListRequired = true;
                return;
            }
        } else if (myPbxSiteIds.length == 1) {
            Log.i(WebConnectionListener.class.getSimpleName(), "oneSite");
            targetSiteId = Long.parseLong(myPbxSiteIds[0]);
            if (targetSiteId == -1L) {
                Log.e(WebConnectionListener.class.getSimpleName(), "Not Set SIP PBX Site!!!!");
                return;
            }
        }
        PreferencesUtil.setSipUsePbxSite(this.context, String.valueOf(targetSiteId));
        WebAgent.getInstance().updateLoginSite();
        BroadcastUtil.sendCurrentSiteChanged(this.context);
        if (TextUtils.isBlank((CharSequence)PreferencesUtil.getSipUserName(this.context)) || TextUtils.isBlank((CharSequence)PreferencesUtil.getSipRealm(this.context)) || TextUtils.isBlank((CharSequence)PreferencesUtil.getSipPassword(this.context))) {
            Log.i(WebConnectionListener.class.getSimpleName(), "mySiteListResult getSipAccount");
            WebAgent.getInstance().startSipRequestProcess("processSiteListResult single");
        } else {
            Log.d(WebConnectionListener.class.getSimpleName(), "mySiteListResult PhoneAgent initSipEngineProfile isRegistered:" + PhoneAgent.isRegistered);
            if (PhoneAgent.isRegistered == PhoneAgent.STAT_NOT_REGISTERED) {
                BroadcastUtil.sendStartPhoneAfterWebLoginRequestEvent(this.context, "processSiteListResult single");
            } else {
                WebAgent.getInstance().updateLoginSip();
                PhoneAgent.getInstance().manualRegistSip();
            }
        }
    }

    @Override
    public void sipAccountResult(JSONObject dataObj) {
        Log.d(WebConnectionListener.class.getSimpleName(), "sipAccountResult data " + dataObj.toString());
        Log.d(WebConnectionListener.class.getSimpleName(), "sipAccountResult isGetSipAccount " + WebAgent.haveSipAccountReady);
        if (WebAgent.haveSipAccountReady) {
            return;
        }
        WebAgent.haveSipAccountReady = true;
        WebAgent.getInstance().stopSipRequestProcess();
        try {
            String sipUserName = dataObj.getString("userName");
            String sipPwd = dataObj.getString("password");
            String sipRealm = dataObj.getString("server");
            String sipRealmExternal = dataObj.getString("externalIp");
            Object sipPort = "5060";
            Object sipTlsPort = "5061";
            String sipExternalPort = null;
            try {
                if (dataObj.has("port")) {
                    sipPort = "" + dataObj.getLong("port");
                }
            }
            catch (Exception e) {
                Log.e(WebConnectionListener.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            try {
                if (dataObj.has("tlsPort")) {
                    sipTlsPort = "" + dataObj.getLong("tlsPort");
                }
            }
            catch (Exception e) {
                Log.e(WebConnectionListener.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            try {
                if (dataObj.has("externalPort")) {
                    sipExternalPort = "" + dataObj.getLong("externalPort");
                }
            }
            catch (Exception e) {
                Log.e(WebConnectionListener.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            PreferencesUtil.setSipPhoneInfo(this.context, sipUserName, sipPwd, sipRealm, sipRealmExternal, (String)sipPort, (String)sipTlsPort, sipExternalPort);
            if (sipUserName != null && sipPwd != null && sipRealm != null && sipPort != null) {
                Log.i(WebConnectionListener.class.getSimpleName(), "handlePhoneEngineConnect .............................................");
                BroadcastUtil.sendStartPhoneAfterWebLoginRequestEvent(this.context, "sipAccountResult==> getSipAccount");
            } else {
                Log.e(WebConnectionListener.class.getSimpleName(), "sipAccountResult data error " + dataObj.toString());
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "sipAccountResult error: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void dataChange(JSONObject dataObj) {
        try {
            if (dataObj == null) {
                return;
            }
            String type = dataObj.getString("type");
            if ("CHAT_EVENT_READ".equals(type) || "CHAT_EVENT_PLAYED".equals(type) || "CHAT_READER_COUNT".equals(type)) {
                ChatEventController.getInstance(this).addDataChangedEvent(dataObj);
            } else {
                DataChangeEventManager.receiveDataChangeEvent(this.context, dataObj);
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void listVoiceAndRecordMessageResult(JSONObject dataObj, long returnTimeStamp) {
        ContactManager.updateVoiceList(this.context, dataObj, returnTimeStamp);
    }

    @Override
    public void listDeletedVoiceAndRecordMessageResult(JSONObject dataObj, long returnTimeStamp) {
        ContactManager.updateDeletedVoiceList(this.context, dataObj, returnTimeStamp);
    }

    @Override
    public void changeCompanyName(JSONObject dataObj) {
        try {
            String companyName = dataObj.getString("companyName");
            PreferencesUtil.setCompanyName(this.context, companyName);
            BroadcastUtil.sendCompanyNameChangedEvent(this.context);
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void gotMessage(JSONObject data) {
        BroadcastUtil.sendMsgGotEvent(this.context, data.toString());
    }

    @Override
    public void updateRingSiteResult(int returnCode, String returnInfo) {
        if (returnCode != 0) {
            Log.e("WebConnectionListener.class.getSimpleName()", "updateRingSite fail:" + returnInfo);
        }
    }

    @Override
    public void getRingSiteResult(int returnCode, String returnInfo, JSONObject dataObj) {
    }

    @Override
    public void notifySendMsgFailed() {
        if (PreferencesUtil.isRemainLoggedIn(this.context)) {
            ToastUtil.show(this.context, String.format(I18NUtil.getString("network_server_connect_fail_try_later"), I18NUtil.getAppName()), 10);
        }
    }

    @Override
    public void updateLoginSipResult(int returnCode, String returnInfo) {
        if (returnCode == 0) {
            PhoneAgent.isUpdateLoginSip = true;
        }
    }

    @Override
    public void processChatEvent(JSONObject dataObj) {
        ChatEventManager.processChatEventLocal(this.context, dataObj, false, this.downloadFileTaskMap);
    }

    @Override
    public void processDataChangedEvent(JSONObject dataObj) {
        DataChangeEventManager.receiveDataChangeEvent(this.context, dataObj);
    }

    public static String trimQuote(String str) {
        if (TextUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String ret = str.trim();
        if (ret.startsWith("\"[") && ret.endsWith("]\"")) {
            return ret.substring(1, ret.length() - 1);
        }
        return ret;
    }

    @Override
    public void receiveOneRoomInfo(JSONObject dataObj, JSONObject paraObj) {
        Log.d(WebConnectionListener.class.getSimpleName(), "receiveOneRoomInfo");
        UpdateSingleChatRoomInfoTask task = new UpdateSingleChatRoomInfoTask(this.context, dataObj, paraObj);
        TaskController.getInstance().addTask(task);
        task.start();
    }

    @Override
    public void receiveRoomsUpdate(JSONArray dataArray, Long returnTimeStamp) {
        for (int i = 0; dataArray != null && i < dataArray.length(); ++i) {
            try {
                String chatRoomId = dataArray.getString(i);
                WebAgent.getInstance().getOneRoomSync(chatRoomId);
                continue;
            }
            catch (JSONException e) {
                Log.e(this.getClass().getSimpleName(), "receiveRoomsUpdate failed: " + e.getLocalizedMessage(), e);
            }
        }
        PreferencesUtil.setTimeStamp(this.context, "contact.getChatRoomInfo.TimeStamp", returnTimeStamp);
    }

    @Override
    public void getPhoneEmpStatusResult(int returnCode, String returnInfo, JSONArray dataArray) {
        if (returnCode == 0) {
            EventController.getInstance().addEvent(this.context, dataArray, 4);
        } else {
            Log.e(this.getClass().getSimpleName(), "getPhoneStatusResult fail!:" + returnInfo);
        }
    }

    @Override
    public void getPhoneLocStatusResult(int returnCode, String returnInfo, JSONArray dataArray) {
        if (returnCode == 0) {
            EventController.getInstance().addEvent(this.context, dataArray, 7);
        } else {
            Log.e(this.getClass().getSimpleName(), "getPhoneStatusResult fail!:" + returnInfo);
        }
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public void changeRoomSubjectResult(int returnCode, String roomJid) {
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("chatroom_notice_name_update_success"), 10);
        }
    }

    @Override
    public void disableChatRoomNoticeResult(int returnCode, String roomJid) {
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 20);
        }
    }

    @Override
    public void enableChatRoomNoticeResult(int returnCode, String roomJid, boolean hasPromptResult) {
        if (returnCode == 0 && hasPromptResult) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        }
    }

    @Override
    public void getDisableChatRoomNoticeListResult(int returnCode, JSONArray dataArray) {
        if (returnCode != 0) {
            return;
        }
        try {
            UserDatabase db = UserDatabase.getDB(this.context);
            db.clearDisableNotificationData();
            for (int i = 0; dataArray != null && i < dataArray.length(); ++i) {
                String roomJid = dataArray.getString(i);
                db.disableNotification(roomJid);
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "[ERROR] getDisableChatRoomNoticeListResult: " + dataArray.toString(), e);
        }
    }

    @Override
    public void receiveChatEvent(JSONObject dataObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "receive Chat Event  " + String.valueOf(dataObj));
        if (ChatEventController.getInstance(this).isActive()) {
            ChatEventController.getInstance(this).addChatEvent(dataObj);
        } else {
            ChatEventController.getInstance(this).queueChatEvent(dataObj);
        }
    }

    @Override
    public void receiveOldChatEventByEventId(JSONArray dataArray, long returnTimeStamp) {
        Log.d(WebConnectionListener.class.getSimpleName(), "------------> size:" + dataArray.length());
        Long recallTimestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getRecallInfo.TimeStamp");
        if (recallTimestamp == -1L) {
            PreferencesUtil.setTimeStamp(this.context, "contact.getRecallInfo.TimeStamp", returnTimeStamp);
        }
        boolean liteEventEnabled = PreferencesUtil.isLiteEventLogEnabled(this.context);
        boolean keepFetch = false;
        if (dataArray != null) {
            int size = dataArray.length();
            for (int i = 0; i < size; ++i) {
                try {
                    JSONObject obj = dataArray.getJSONObject(i);
                    this.handleTimestamp(obj);
                    ChatEventManager.processChatEventLocal(this.context, obj, true, this.downloadFileTaskMap);
                    ChatEventController.getInstance(this).unqueueChatEvent(obj);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (liteEventEnabled && dataArray.length() == 500 || !liteEventEnabled && dataArray.length() == 20) {
                keepFetch = true;
            }
        }
        if (keepFetch) {
            BroadcastUtil.sendDataDownloadProgressEvent(this.context);
            GetOldChatHistoryPageEventIdTask chatHistoryTask = new GetOldChatHistoryPageEventIdTask(this.context);
            TaskController.getInstance().addTask(chatHistoryTask);
            chatHistoryTask.start();
        } else {
            this.oldEventFetchAfterWork(returnTimeStamp);
            ChatEventController.getInstance(this).active();
            BroadcastUtil.sendContactHistoryChangedEvent(this.context);
            BroadcastUtil.sendMsgChangedEvent(this.context);
            BroadcastUtil.sendParticipantChangedEvent(this.context);
            BroadcastUtil.sendMeetmeListChangedEvent(this.context);
            BroadcastUtil.sendContactListChangedEvent(this.context, 0);
            BroadcastUtil.sendPhoneInfoChanged(this.context);
            BroadcastUtil.sendStatusBarUpdateEvent(this.context);
            BroadcastUtil.sendStatusButtonUpdateEvent(this.context);
            BroadcastUtil.sendCustomerStatusChangedEvent(this.context);
        }
    }

    @Override
    public void receiveChatEventDetailsByEventId(JSONArray dataArray, long returnTimeStamp) {
        if (dataArray != null) {
            int size = dataArray.length();
            for (int i = 0; i < size; ++i) {
                try {
                    JSONObject obj = dataArray.getJSONObject(i);
                    ChatEventManager.processChatEventDetails(this.context, obj);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void receiveRefChatEventDetailsByPacketId(JSONArray dataArray, long returnTimeStamp) {
        if (dataArray != null) {
            int size = dataArray.length();
            for (int i = 0; i < size; ++i) {
                try {
                    JSONObject obj = dataArray.getJSONObject(i);
                    System.out.println("=>" + String.valueOf(obj));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void handleTimestamp(JSONObject dataObj) {
        if (dataObj == null) {
            return;
        }
        try {
            JSONObject chatdata = dataObj.getJSONObject("data");
            if (chatdata.has("timestamp")) {
                long timestamp = chatdata.getLong("timestamp");
                PreferencesUtil.setSyncDataCurrentTime(this.context, timestamp);
            }
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "chatevent:" + e.getLocalizedMessage(), e);
        }
    }

    private void oldEventFetchAfterWork(long returnTimeStamp) {
        Log.i(WebConnectionListener.class.getSimpleName(), "oldEventFetchAfterWork ........................................................ ");
        PreferencesUtil.setSyncDataCurrentTime(this.context, System.currentTimeMillis());
        boolean isRoomApiReady = PreferencesUtil.isRoomUpdateApiReady(this.context);
        boolean syncDone = PreferencesUtil.isSyncOldChatEventDone(this.context);
        if (!isRoomApiReady || !syncDone) {
            SyncChatRoomInfoTask syncChatRoomInfoTask = new SyncChatRoomInfoTask(this.context);
            TaskController.getInstance().addTask(syncChatRoomInfoTask);
            syncChatRoomInfoTask.start();
        } else {
            long chatRoomInfoTimestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getChatRoomInfo.TimeStamp");
            if (chatRoomInfoTimestamp == -1L) {
                PreferencesUtil.setTimeStamp(this.context, "contact.getChatRoomInfo.TimeStamp", returnTimeStamp);
                SyncChatRoomInfoTask syncChatRoomInfoTask = new SyncChatRoomInfoTask(this.context);
                TaskController.getInstance().addTask(syncChatRoomInfoTask);
                syncChatRoomInfoTask.start();
            } else {
                WebAgent.getInstance().getRoomsForUpdate();
            }
        }
        long timestamp = PreferencesUtil.getTimeStamp(this.context, "contact.getChatMessageReaderInfo.TimeStamp");
        if (timestamp == -1L) {
            PreferencesUtil.setTimeStamp(this.context, "contact.getChatMessageReaderInfo.TimeStamp", returnTimeStamp);
        } else {
            WebAgent.getInstance().getChatMessageReaderInfo();
        }
        Long oldestEventId = UCDBMessage.getOldestEventId(this.context);
        if (oldestEventId != 0L) {
            WebAgent.getInstance().updateOldestChatEventId(oldestEventId);
        } else {
            WebAgent.getInstance().updateOldestChatEventIdToCurrent();
        }
        WebAgent.getInstance().getUnreadChatEventIdList();
        WebAgent.getInstance().getPlayedChatEventIdList();
        if (ApiVersion.isApi11Later()) {
            WebAgent.getInstance().getRecallInfo();
        }
        if (PreferencesUtil.isCheckRecording(this.context)) {
            WebAgent.getInstance().getEmpContactRecordsByPage();
        }
        if (ApiVersion.isApiLater(26)) {
            WebAgent.getInstance().getSatisfactionSurveyList();
        }
        this.downloadFileTaskMap.clear();
        if (syncDone) {
            BroadcastUtil.sendChatSyncAfterwork(this.context);
        }
    }

    @Override
    public void getSendMessageSucceed(String packetId, long chatEventId) {
        Log.i(WebConnectionListener.class.getSimpleName(), "Receive send message succeed event: packetId:" + packetId + ", chatEventId:" + chatEventId);
        UCDBMessage.updateChatEventId(this.context, packetId, chatEventId);
        UCDBMessage.updateSyncEventId(this.context, packetId, chatEventId);
    }

    @Override
    public void getSendRoomMessageSucceed(String packetId, long chatEventId) {
        Log.i(WebConnectionListener.class.getSimpleName(), "Receive send message succeed event: packetId:" + packetId + ", chatEventId:" + chatEventId);
        UCDBMessage.updateSyncEventId(this.context, packetId, chatEventId);
    }

    @Override
    public String getGcmRegistrationId() {
        return PreferencesUtil.getGcmRegId(this.context);
    }

    @Override
    public void makeTwoStepTransferResult(int returnCode, String returnInfo) {
        Log.i(WebConnectionListener.class.getSimpleName(), "returnCode:" + returnCode + " returnInfo:" + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("call_notice_two_step_transfer_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("call_notice_two_step_transfer_failed"), 20);
            BroadcastUtil.sendPhoneTwoLineOperFailedEvent(this.context);
        }
    }

    @Override
    public void makeThreeWayCallingResult(int returnCode, String returnInfo) {
        Log.i(WebConnectionListener.class.getSimpleName(), "returnCode:" + returnCode + " returnInfo:" + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("call_notice_make_three_way_calling_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("call_notice_make_three_way_calling_failed"), 20);
            BroadcastUtil.sendPhoneTwoLineOperFailedEvent(this.context);
        }
    }

    @Override
    public void makeInviteConferenceResult(int returnCode, String returnInfo) {
        Log.i(WebConnectionListener.class.getSimpleName(), "returnCode:" + returnCode + " returnInfo:" + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("call_notice_invite_join_conference_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("call_notice_invite_join_conference_failed"), 20);
            BroadcastUtil.sendPhoneTwoLineOperFailedEvent(this.context);
        }
    }

    @Override
    public void addPhoneNumToOutboundBlackList(int returnCode, String returnInfo, String phoneNum) {
        Log.i(WebConnectionListener.class.getSimpleName(), "returnCode:" + returnCode + " returnInfo:" + returnInfo);
        String msg = null;
        msg = returnCode == 0 ? String.format(I18NUtil.getString("phone_history_add_to_outbound_black_list_success"), phoneNum) : (returnCode == -1 ? I18NUtil.getString("agent_state_change_failed_not_login") : (returnCode == -2 ? String.format(I18NUtil.getString("phone_history_add_to_outbound_black_list_failed_number_empty"), phoneNum) : (returnCode == -3 ? String.format(I18NUtil.getString("phone_history_add_to_outbound_black_list_failed_reason_empty"), phoneNum) : (returnCode == -4 ? String.format(I18NUtil.getString("phone_history_add_to_outbound_black_list_failed_reason_too_long"), phoneNum) : (returnCode == -5 ? String.format(I18NUtil.getString("phone_history_add_to_outbound_black_list_failed_number_exist"), phoneNum) : (returnCode == -500 ? String.format(I18NUtil.getString("phone_history_add_to_outbound_black_list_failed_no_permission"), phoneNum) : String.format(I18NUtil.getString("phone_history_add_to_outbound_black_list_failed_general_error"), phoneNum)))))));
        ToastUtil.show(this.context, msg, 20);
    }

    @Override
    public void addPhoneNumToInboundBlackList(int returnCode, String returnInfo, String phoneNum) {
        Log.i(WebConnectionListener.class.getSimpleName(), "returnCode:" + returnCode + " returnInfo:" + returnInfo);
        String msg = null;
        msg = returnCode == 0 ? String.format(I18NUtil.getString("phone_history_add_to_inbound_black_list_success"), phoneNum) : (returnCode == -1 ? I18NUtil.getString("agent_state_change_failed_not_login") : (returnCode == -2 ? String.format(I18NUtil.getString("phone_history_add_to_inbound_black_list_failed_number_empty"), phoneNum) : (returnCode == -3 ? String.format(I18NUtil.getString("phone_history_add_to_inbound_black_list_failed_reason_empty"), phoneNum) : (returnCode == -4 ? String.format(I18NUtil.getString("phone_history_add_to_inbound_black_list_failed_reason_too_long"), phoneNum) : (returnCode == -5 ? String.format(I18NUtil.getString("phone_history_add_to_inbound_black_list_failed_number_exist"), phoneNum) : (returnCode == -500 ? String.format(I18NUtil.getString("phone_history_add_to_inbound_black_list_failed_no_permission"), phoneNum) : String.format(I18NUtil.getString("phone_history_add_to_inbound_black_list_failed_general_error"), phoneNum)))))));
        ToastUtil.show(this.context, msg, 20);
    }

    @Override
    public void checkRecentCallRecords(int returnCode, String returnInfo, final JSONObject dataObj, final JSONObject paraObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "returnCode:" + returnCode + " returnInfo:" + returnInfo);
        try {
            final String phoneNum = paraObj.getString("phoneNum");
            if (returnCode == 0) {
                boolean popForConfirm = false;
                try {
                    int size;
                    if (dataObj.has("blackList")) {
                        popForConfirm = true;
                    }
                    if (dataObj.has("contactRecordSize") && (size = dataObj.getInt("contactRecordSize")) > 0) {
                        popForConfirm = true;
                    }
                }
                catch (Exception e) {
                    Log.e(WebConnectionListener.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                }
                if (popForConfirm) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OutboundFilterDialog dialog = new OutboundFilterDialog((JFrame)UCChatClient.getInstance(), dataObj);
                            dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                            ToastUtil.hide();
                            int result = dialog.showDialog();
                            if (result == 1) {
                                DialoutManager.doDialOut(WebConnectionListener.this.context, paraObj);
                            } else if (result == 2) {
                                AddNumToOutboundBlackListConfirmDialog addBlackListDialog = new AddNumToOutboundBlackListConfirmDialog(UCChatClient.getInstance(), phoneNum);
                                addBlackListDialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                                boolean addBlackListResult = addBlackListDialog.showDialog();
                                if (addBlackListResult) {
                                    String phoneNum2 = addBlackListDialog.getPhoneNumber();
                                    String reason = addBlackListDialog.getReason();
                                    WebAgent.getInstance().addPhoneNumToOutboundBlackList(phoneNum2, reason);
                                }
                            }
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialoutManager.doDialOut(WebConnectionListener.this.context, paraObj);
                        }
                    });
                }
                return;
            }
            String msg = null;
            msg = returnCode == -1 ? I18NUtil.getString("agent_state_change_failed_not_login") : (returnCode == -2 ? String.format(I18NUtil.getString("outbound_check_contact_records_failed_number_empty"), phoneNum) : (returnCode == -500 ? String.format(I18NUtil.getString("outbound_check_contact_records_failed_no_permission"), phoneNum) : String.format(I18NUtil.getString("outbound_check_contact_records_failed_general_error"), phoneNum)));
            ToastUtil.show(this.context, msg, 20);
        }
        catch (Throwable t) {
            Log.e(this.getClass().getSimpleName(), t.getLocalizedMessage(), t);
        }
    }

    @Override
    public void fetchFreeSeatingList(int returnCode, String returnInfo, final JSONObject dataObj, JSONObject paraObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "returnCode:" + returnCode + " returnInfo:" + returnInfo);
        try {
            if (returnCode == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FreeSeatingSelectionDialog dialog = new FreeSeatingSelectionDialog((JFrame)UCChatClient.getInstance(), dataObj);
                        dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                        dialog.showDialog();
                    }
                });
            }
        }
        catch (Throwable t) {
            Log.e(this.getClass().getSimpleName(), t.getLocalizedMessage(), t);
        }
    }

    @Override
    public void getDeletedGroupListResult(int returnCode, JSONArray dataArray, long returnTimeStamp) {
        if (returnCode == 0) {
            int size;
            StringBuffer ids = new StringBuffer();
            if (dataArray != null && (size = dataArray.length()) > 0) {
                for (int i = 0; i < size; ++i) {
                    try {
                        String id = dataArray.getString(i);
                        if (i > 0) {
                            ids.append(",");
                        }
                        ids.append(id);
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                ContactManager.deleteGroup(this.context, ids.toString());
            }
            PreferencesUtil.setTimeStamp(this.context, "contact.getDeletedGroupList.TimeStamp", returnTimeStamp);
        }
    }

    @Override
    public void getRecallInfoByTimestamp(int returnCode, JSONArray dataArray, long returnTimeStamp) {
        if (returnCode == 0) {
            if (dataArray != null) {
                int size = dataArray.length();
                for (int i = 0; size > 0 && i < size; ++i) {
                    try {
                        JSONObject obj = dataArray.getJSONObject(i);
                        String packetId = obj.getString("packetId");
                        if (!StringUtils.isNotBlank((CharSequence)packetId)) continue;
                        ChatRoomManager.recallMsg(this.context, packetId);
                        if (!PreferencesUtil.isSyncOldChatEventDone(this.context)) continue;
                        BroadcastUtil.sendMsgRecalledEvent(this.context, packetId);
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            PreferencesUtil.setTimeStamp(this.context, "contact.getRecallInfo.TimeStamp", returnTimeStamp);
        }
    }

    @Override
    public void getChatMessageReaderInfoByTimestamp(int returnCode, JSONArray dataArray, long returnTimeStamp) {
        if (returnCode == 0) {
            if (dataArray != null) {
                int size = dataArray.length();
                for (int i = 0; size > 0 && i < size; ++i) {
                    try {
                        JSONObject obj = dataArray.getJSONObject(i);
                        String packetId = obj.getString("packetId");
                        int readCount = obj.getInt("readerCount");
                        String readerList = obj.getString("readerList");
                        UCDBMessage.updateChatMsgReadCountInfo(this.context, packetId, readCount, readerList);
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            BroadcastUtil.sendMsgStatusChangedEvent(this.context);
            PreferencesUtil.setTimeStamp(this.context, "contact.getChatMessageReaderInfo.TimeStamp", returnTimeStamp);
        }
    }

    @Override
    public void getDeletedContactListResult(int returnCode, JSONArray dataArray, long returnTimeStamp) {
        if (returnCode == 0) {
            int size;
            StringBuffer ids = new StringBuffer();
            if (dataArray != null && (size = dataArray.length()) > 0) {
                for (int i = 0; i < size; ++i) {
                    try {
                        String id = dataArray.getString(i);
                        if (i > 0) {
                            ids.append(",");
                        }
                        ids.append(id);
                        boolean isMyFavorite = ContactManager.isInMyFavorite(this.context, id, 2);
                        if (!isMyFavorite) continue;
                        WebAgent.getInstance().removeFavorite(id, 2);
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                ContactManager.removeExternalContacts(this.context, ids.toString());
            }
            PreferencesUtil.setTimeStamp(this.context, "contact.getDeletedContactList.TimeStamp", returnTimeStamp);
        }
    }

    @Override
    public void addGroupInfoResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "addGroupInfoResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void modifyGroupResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "modifyGroupResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void deleteGroupResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "modifyGroupResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void changeGroupList(JSONArray dataArray, long returnTimeStamp) {
        ContactManager.updateGroupList(this.context, dataArray, returnTimeStamp);
    }

    @Override
    public void deleteDeviceResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "deleteDeviceResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_delete_success"), 10);
            BroadcastUtil.sendDeviceDeleteDoneEvent(this.context);
        } else if (TextUtils.isBlank((CharSequence)returnInfo)) {
            ToastUtil.show(this.context, I18NUtil.getString("common_delete_failed"), 20);
        } else {
            ToastUtil.show(this.context, returnInfo, 20);
        }
    }

    @Override
    public void getLoginDeviceListResult(int returnCode, String returnInfo, JSONArray dataArray) {
        Log.w(this.getClass().getSimpleName(), "getLoginDeviceListResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            if (dataArray != null) {
                DeviceManager.updateLoginDeviceList(this.context, dataArray);
                BroadcastUtil.sendFetchLoginDeviceOKEvent(this.context);
            }
        } else {
            ToastUtil.show(this.context, returnInfo, 20);
        }
    }

    @Override
    public void updateRemoveLoginDeviceResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "updateRemoveLoginDeviceResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("logindevice_notice_remove_success"), 20);
            WebAgent.getInstance().queryLoginDeviceList();
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("logindevice_notice_remove_failed"), 20);
        }
    }

    @Override
    public void getDeviceInfoResult(int returnCode, String returnInfo, JSONArray dataArray) {
        Log.w(this.getClass().getSimpleName(), "getDeviceInfoResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            DeviceManager.updateDeviceInfoList(this.context, dataArray);
            BroadcastUtil.sendFetchDeviceInfoOKEvent(this.context);
        } else {
            ToastUtil.show(this.context, returnInfo, 20);
        }
    }

    @Override
    public void updateDeviceInfoResult(int returnCode, String returnInfo, JSONObject paraObj) {
        Log.w(this.getClass().getSimpleName(), "updateDeviceInfoResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            WebAgent.getInstance().getDeviceInfo();
            BroadcastUtil.sendDeviceInfoUpdateDoneEvent(this.context);
        } else {
            WebAgent.getInstance().getDeviceInfo();
            if (TextUtils.isBlank((CharSequence)returnInfo)) {
                ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed"), 20);
            } else {
                ToastUtil.show(this.context, returnInfo, 20);
            }
        }
    }

    @Override
    public void changePasswordResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "changePasswordResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("pw_notice_changepassword_success"), 10);
            BroadcastUtil.sendChangePasswordDoneEvent(this.context);
        } else {
            Object message = I18NUtil.getString("pw_notice_changepassword_fail");
            if (TextUtils.isNotBlank((CharSequence)returnInfo)) {
                message = (String)message + returnInfo;
            }
            ToastUtil.show(this.context, (String)message, 20);
            BroadcastUtil.sendChangePasswordFailedEvent(this.context);
        }
    }

    @Override
    public void changePersonalPhotoResult(JSONObject dataObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "OO==============changePersonalPhotoResult data " + dataObj.toString());
    }

    @Override
    public void updatePersonalPhonesResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "updatePersonalPhonesResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
            BroadcastUtil.sendPersonalPhonesUpdateEvent(this.context);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void updatePersonalBirthdayResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "updatePersonalBirthdayResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void updatePersonalBirthdayHideTypeResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "updatePersonalBirthdayHideTypeResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void updatePersonalGenderResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "updatePersonalGenderResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void setDNDFlagResult(int returnCode, String returnInfo, boolean trunOn) {
        Log.w(this.getClass().getSimpleName(), "setDNDFlagResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            if (trunOn) {
                ToastUtil.show(this.context, I18NUtil.getString("att_dnd_is_on"), 10);
            } else {
                ToastUtil.show(this.context, I18NUtil.getString("att_dnd_is_off"), 10);
            }
        } else {
            ToastUtil.show(this.context, returnInfo, 20);
        }
    }

    @Override
    public void getLanguageListResult(int returnCode, String returnInfo, JSONArray dataArray) {
        Log.w(this.getClass().getSimpleName(), "getLanguageListResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0 && dataArray != null) {
            PreferencesUtil.putString(this.context, "LANGUAGE_SETTING", dataArray.toString());
            BroadcastUtil.sendFetchLanguageListEvent(this.context);
        } else {
            ToastUtil.show(this.context, returnInfo, 20);
        }
    }

    @Override
    public void getVoiceConfigResult(int returnCode, String returnInfo, JSONObject dataObj) {
        Log.w(this.getClass().getSimpleName(), "getVoiceConfigResult returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0 && dataObj != null) {
            PreferencesUtil.saveVoiceSetting(this.context, dataObj.toString());
            BroadcastUtil.sendFetchVoiceConfigOKEvent(this.context);
        } else {
            ToastUtil.show(this.context, returnInfo, 20);
        }
    }

    @Override
    public void updateVoiceConfigResult(int returnCode, String returnInfo) {
        Log.w(this.getClass().getSimpleName(), "returnCode: " + returnCode + ", returnInfo: " + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
            BroadcastUtil.sendFetchVoiceConfigUpdateDoneEvent(this.context);
        } else {
            WebAgent.getInstance().getVoiceConfig();
            if (TextUtils.isBlank((CharSequence)returnInfo)) {
                ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed"), 10);
            } else {
                ToastUtil.show(this.context, returnInfo, 20);
            }
        }
    }

    @Override
    public void makeCallResult(int returnCode, String returnInfo, JSONObject dataObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "makeCallResult returnCode:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            String apiCallRefId;
            WebAgent.refCallId = apiCallRefId = dataObj.optString("apiCallRefId", null);
            BroadcastUtil.sendCallEmployeeDoneEvent(this.context);
        } else {
            ToastUtil.show(this.context, returnInfo, 20);
            BroadcastUtil.sendCallEmployeeFailedEvent(this.context);
        }
    }

    @Override
    public void joinConference(int returnCode, String returnInfo) {
        Log.i(WebConnectionListener.class.getSimpleName(), "joinConference returnCode:" + returnCode + " result:" + returnInfo);
        BroadcastUtil.sendJoinConfDoneEvent(this.context, returnCode, returnInfo);
    }

    @Override
    public void findDynamicConfRoom(int returnCode, String returnInfo, JSONObject dataObj) {
        try {
            MeetmeManager.updateOneMeetMe(this.context, dataObj.getJSONObject("conferenceRoom"));
            BroadcastUtil.sendDyncConfRoomFoundEvent(this.context);
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "getBulletinReadCountListResult fail!:" + returnInfo);
        }
    }

    @Override
    public void joinChatRoomResult(int returnCode, String returnInfo, String chatRoomId) {
        Log.i(WebConnectionListener.class.getSimpleName(), "joinChatRoomResult returnCode:" + returnCode + " result:" + returnInfo);
        ChatRoomManager.createRoomForSelfJoin(this.context, chatRoomId, System.currentTimeMillis(), false);
    }

    @Override
    public void verifyPinCodeResult(int returnCode, String returnInfo, JSONObject dataObj, JSONObject paraObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "verifyPinCodeResult returnCode:" + returnCode + " result:" + returnInfo);
        try {
            BroadcastUtil.sendVerifyPinCodeResultEvent(this.context, returnCode, returnInfo, dataObj, paraObj);
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void getConferenceRoomMemberListResult(int returnCode, String returnInfo, JSONArray dataArray, JSONObject paraObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "getConferenceRoomMemberListResult returnCode:" + returnCode + " result:" + returnInfo);
        try {
            BroadcastUtil.sendFetchConfRoomMemberListEvent(this.context, returnCode, returnInfo, dataArray, paraObj);
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void leaveConferenceResult(int returnCode, String returnInfo) {
        Log.i(WebConnectionListener.class.getSimpleName(), "leaveConferenceResult returnCode:" + returnCode + " result:" + returnInfo);
    }

    @Override
    public void deleteVoiceMessageResult(int returnCode, String returnInfo, long itemId) {
        Log.i(WebConnectionListener.class.getSimpleName(), "deleteVoiceMessageResult returnCode:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            UCDBRemoteMark.deleteRemoteMark(this.context, 11, itemId);
            ToastUtil.show(this.context, I18NUtil.getString("common_remove_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_remove_failed"), 20);
        }
    }

    @Override
    public void deletePersonalRecordResult(int returnCode, String returnInfo, long itemId) {
        Log.i(WebConnectionListener.class.getSimpleName(), "deletePersonalRecordResult returnCode:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            UCDBRemoteMark.deleteRemoteMark(this.context, 10, itemId);
            ToastUtil.show(this.context, I18NUtil.getString("common_remove_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_remove_failed"), 20);
        }
    }

    @Override
    public void addExternalContactResult(int returnCode, String returnInfo, JSONObject dataObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "addExternalContactResult returnCode:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
            BroadcastUtil.sendExternalContactAddDoneEvent(this.context, dataObj);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void modifyExternalContactResult(int returnCode, String returnInfo) {
        Log.i(WebConnectionListener.class.getSimpleName(), "modifyExternalContactResult returnCode:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void changeExternalContactList(int returnCode, String returnInfo, String jsonStr, long returnTimeStamp) {
        Log.i(WebConnectionListener.class.getSimpleName(), "changeExternalContactList returnCode:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            ContactManager.updateExternalContactList(this.context, jsonStr, returnTimeStamp);
        }
    }

    @Override
    public void changeExternalContactPhotoResult(int returnCode, String returnInfo, JSONObject dataObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "changeExternalContactPhotoResult returnCode:" + returnCode + " result:" + returnInfo);
    }

    @Override
    public void deleteExternalContactResult(int returnCode, String returnInfo) {
        Log.i(WebConnectionListener.class.getSimpleName(), "deleteExternalContactResult returnCode:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void getCustomerInfoResult(int returnCode, String returnInfo, JSONObject dataObj) {
        Log.d(WebConnectionListener.class.getSimpleName(), "getCustomerInfoResult:" + String.valueOf(dataObj));
        if (returnCode == 0 && dataObj != null) {
            LiteCustomer liteCustomer = (LiteCustomer)new Gson().fromJson(dataObj.toString(), new TypeToken<LiteCustomer>(this){}.getType());
            CustomerKey customerKey = null;
            LiteCustomer dbCustomer = UCDBCustomer.getCustomer(this.context, liteCustomer.getAccount());
            boolean tryGetPhoto = false;
            if (dbCustomer == null) {
                UCDBCustomer.addCustomer(this.context, liteCustomer);
                customerKey = KeyUtil.genCustomerKey(liteCustomer);
                tryGetPhoto = true;
            } else {
                if (liteCustomer.getPersonalPhotoTime() != -1L && liteCustomer.getPersonalPhotoTime().longValue() != dbCustomer.getPersonalPhotoTime().longValue()) {
                    customerKey = KeyUtil.genCustomerKey(liteCustomer.getId(), liteCustomer.getAccount());
                    tryGetPhoto = true;
                }
                UCDBCustomer.updateCustomer(this.context, liteCustomer);
            }
            if (tryGetPhoto) {
                ArrayList<PhotoLoadTask> list = new ArrayList<PhotoLoadTask>();
                CustomerPhotoTask task = new CustomerPhotoTask();
                task.setCustomerKey(customerKey);
                list.add(task);
                ContactManager.refreshPhotoList(this.context, PhotoType.SMALL, list);
            }
            if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                BroadcastUtil.sendCustomerStatusChangedEvent(this.context);
            }
        }
    }

    @Override
    public void getCustomerInfoListResult(int returnCode, String returnInfo, JSONArray dataArray, Long returnTimeStamp) {
        if (returnCode == 0) {
            List liteCustomerList = (List)new Gson().fromJson(dataArray.toString(), new TypeToken<List<LiteCustomer>>(this){}.getType());
            boolean doUpdate = false;
            ArrayList<PhotoLoadTask> photoUpdateList = new ArrayList<PhotoLoadTask>();
            for (int i = 0; liteCustomerList != null && i < liteCustomerList.size(); ++i) {
                LiteCustomer liteCustomer = (LiteCustomer)liteCustomerList.get(i);
                LiteCustomer dbCustomer = UCDBCustomer.getCustomer(this.context, liteCustomer.getAccount());
                if (dbCustomer == null) continue;
                doUpdate = true;
                if (liteCustomer.getPersonalPhotoTime() != -1L && liteCustomer.getPersonalPhotoTime().longValue() != dbCustomer.getPersonalPhotoTime().longValue()) {
                    CustomerKey customerKey = KeyUtil.genCustomerKey(liteCustomer.getId(), liteCustomer.getAccount());
                    CustomerPhotoTask photoUpdateTask = new CustomerPhotoTask();
                    photoUpdateTask.setCustomerKey(customerKey);
                    photoUpdateList.add(photoUpdateTask);
                }
                UCDBCustomer.updateCustomer(this.context, liteCustomer);
            }
            if (photoUpdateList.size() != 0) {
                ContactManager.refreshPhotoList(this.context, PhotoType.SMALL, photoUpdateList);
            }
            PreferencesUtil.setTimeStamp(this.context, "customer.getCustomerList.TimeStamp", returnTimeStamp);
            if (doUpdate && PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                BroadcastUtil.sendCustomerStatusChangedEvent(this.context);
            }
        } else {
            Log.e(this.getClass().getSimpleName(), "getDeletedApiUserListResult fail!:" + returnInfo);
        }
    }

    @Override
    public void updateCustomerLevelResult(int returnCode, String returnInfo, JSONObject dataObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "updateCustomerLevelResult:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
            if (!ApiVersion.isApi7Later() && dataObj != null) {
                LiteCustomer liteCustomer = (LiteCustomer)new Gson().fromJson(dataObj.toString(), new TypeToken<LiteCustomer>(this){}.getType());
                Log.d(WebConnectionListener.class.getSimpleName(), "updateCustomerLevelResult:" + liteCustomer.getLevel());
                UCDBCustomer.updateCustomerLevel(this.context, liteCustomer.getAccount(), liteCustomer.getLevel());
                if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                    BroadcastUtil.sendCustomerStatusChangedEvent(this.context);
                }
            }
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed"), 10);
            BroadcastUtil.sendCustomerLevelUpdateFailedEvent(this.context);
        }
    }

    @Override
    public void getCustomerHistoryLogResult(int returnCode, String returnInfo, JSONArray dataObj, JSONObject paraObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "getCustomerHistoryLogResult:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0 && dataObj != null) {
            String sessionId = paraObj.optString("sessionId", "");
            BroadcastUtil.sendFetchCustomerHistoryLogEvent(this.context, sessionId, dataObj);
        } else {
            ToastUtil.show(this.context, returnInfo, 20);
        }
    }

    @Override
    public void getCustomerServiceCategoryResult(int returnCode, String returnInfo, JSONObject dataObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "getCustomerServiceCategoryResult:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0 && dataObj != null && dataObj.has("categoryList")) {
            try {
                JSONArray dataArray = dataObj.getJSONArray("categoryList");
                PreferencesUtil.putString(this.context, "customer.service.cotegory", dataArray.toString());
                PreferencesUtil.putLong(this.context, "customer.service.cotegory.timestamp", System.currentTimeMillis());
            }
            catch (JSONException e) {
                Log.e(WebConnectionListener.class.getSimpleName(), "getCustomerServiceCategoryResult", e);
            }
        }
    }

    @Override
    public void setCustomerServiceDoneResult(int returnCode, String returnInfo, JSONObject paraObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "setCustomerServiceDoneResult:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            if (!ApiVersion.isApi7Later() && paraObj != null) {
                try {
                    String customerAccount = null;
                    if (paraObj.has("customerAccount")) {
                        customerAccount = paraObj.getString("customerAccount");
                    }
                    if (customerAccount != null) {
                        UCDBCustomer.updateCustomerSessionClose(this.context, customerAccount, 1);
                    }
                    if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                        BroadcastUtil.sendCustomerStatusChangedEvent(this.context);
                    }
                }
                catch (JSONException e) {
                    Log.e(WebConnectionListener.class.getSimpleName(), "setCustomerServiceDoneResult", e);
                }
            }
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed"), 10);
            BroadcastUtil.sendCustomerLevelUpdateFailedEvent(this.context);
        }
    }

    @Override
    public void setCustomerManualTransferResult(int returnCode, String returnInfo, JSONObject paraObj) {
        Log.i(WebConnectionListener.class.getSimpleName(), "setCustomerManualTransferResult:" + returnCode + " result:" + returnInfo);
        if (returnCode == 0) {
            if (!ApiVersion.isApi7Later() && paraObj != null) {
                try {
                    String customerAccount = null;
                    if (paraObj.has("customerAccount")) {
                        customerAccount = paraObj.getString("customerAccount");
                    }
                    if (customerAccount != null) {
                        UCDBCustomer.updateCustomerSessionClose(this.context, customerAccount, 1);
                    }
                    if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                        BroadcastUtil.sendCustomerStatusChangedEvent(this.context);
                    }
                }
                catch (JSONException e) {
                    Log.e(WebConnectionListener.class.getSimpleName(), "setCustomerServiceDoneResult", e);
                }
            }
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed"), 10);
            BroadcastUtil.sendCustomerLevelUpdateFailedEvent(this.context);
        }
    }

    @Override
    public void getValidCustomersResult(int returnCode, String returnInfo, JSONObject dataObj) {
    }

    @Override
    public void updateOutboundPrefixResult(int returnCode, String returnInfo) {
        if (returnCode == 0) {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void getUnreadChatEventIdList(int returnCode, String returnInfo, JSONArray dataArray) {
        if (returnCode == 0) {
            EventController.getInstance().addEvent(this.context, dataArray, 6);
        } else {
            Log.e(this.getClass().getSimpleName(), "getUnreadChatEventIdList fail!:" + returnInfo);
        }
    }

    @Override
    public void getSendMessageFailed(String packetId, String receiverJid, String errorMsg) {
        Log.i(WebConnectionListener.class.getSimpleName(), "Receive send message failed event: packetId:" + packetId);
        UCDBMessage.updateChatMsgStatus(this.context, packetId, "E");
        BroadcastUtil.sendMsgStatusChangedEvent(this.context, receiverJid, packetId, "E", errorMsg);
    }

    @Override
    public void getPlayedChatEventIdList(int returnCode, String returnInfo, JSONArray dataArray, Long timestamp) {
        if (returnCode == 0) {
            if (dataArray != null) {
                int size = dataArray.length();
                for (int i = 0; i < size; ++i) {
                    try {
                        long eventId = dataArray.getLong(i);
                        UCDBMessage.updateChatRoomMsgPlayedStatusByChatEventId(this.context, eventId);
                        continue;
                    }
                    catch (JSONException e) {
                        Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            }
            PreferencesUtil.setTimeStamp(this.context, "chat.getPlayedChatEventList.TimeStamp", timestamp);
        } else {
            Log.e(this.getClass().getSimpleName(), "getUnreadChatEventIdList fail!:" + returnInfo);
        }
    }

    @Override
    public void getPublishBulletinListResult(int returnCode, String returnInfo, JSONArray dataArray, Long returnTimeStamp) {
        if (returnCode == 0) {
            boolean doUpdate = false;
            int hasNewCount = 0;
            List<LiteBulletinHeader> bulletinHeaderList = BulletinManager.parseLiteBulletinJson(dataArray);
            for (int i = 0; bulletinHeaderList != null && i < bulletinHeaderList.size(); ++i) {
                LiteBulletinHeader header = bulletinHeaderList.get(i);
                doUpdate = true;
                if (!UCDBBulletin.existBulletinById(this.context, header.getId())) {
                    if (!header.isRead()) {
                        ++hasNewCount;
                    }
                    UCDBBulletin.addBulletinHeader(this.context, header);
                    continue;
                }
                UCDBBulletin.updateBulletinHeader(this.context, header);
            }
            if (doUpdate) {
                BroadcastUtil.sendBulletinListChangedEvent(this.context);
            }
            if (hasNewCount > 0) {
                BroadcastUtil.sendBulletinListAddEvent(this.context, hasNewCount);
            }
            PreferencesUtil.setTimeStamp(this.context, "bulletin.getPublishBulletinList.TimeStamp", returnTimeStamp);
            WebAgent.getInstance().getSuppressBulletinList();
            WebAgent.getInstance().getBulletinReadCountList();
        } else {
            Log.e(this.getClass().getSimpleName(), "getPublishBulletinListResult fail!:" + returnInfo);
        }
    }

    @Override
    public void getSuppressBulletinListResult(int returnCode, String returnInfo, JSONArray dataArray, Long returnTimeStamp) {
        if (returnCode == 0) {
            boolean doDelete = false;
            List<Long> idList = BulletinManager.parseSupressJson(dataArray);
            for (int i = 0; idList != null && i < idList.size(); ++i) {
                Long bulletinId = idList.get(i);
                LiteBulletinDetail detail = UCDBBulletin.getBulletinDetail(this.context, bulletinId);
                if (detail == null) continue;
                doDelete = true;
                for (int j = 0; detail.getFiles() != null && j < detail.getFiles().size(); ++j) {
                    LiteBulletinAttachment att = detail.getFiles().get(j);
                    FileUtil.deleteBulletinAttachment(bulletinId, att.getIndex());
                }
                UCDBBulletin.deleteBulletin(this.context, bulletinId);
                FileUtil.deleteBulletinSubjectPhoto(bulletinId);
            }
            if (doDelete) {
                BroadcastUtil.sendBulletinListChangedEvent(this.context);
            }
            PreferencesUtil.setTimeStamp(this.context, "bulletin.getSuppressBulletinList.TimeStamp", returnTimeStamp);
        } else {
            Log.e(this.getClass().getSimpleName(), "getSuppressBulletinListResult fail!:" + returnInfo);
        }
        SyncBulletinDetailsTask syncBulletinDetailsTask = new SyncBulletinDetailsTask(this.context);
        TaskController.getInstance().addTask(syncBulletinDetailsTask);
        syncBulletinDetailsTask.start();
    }

    @Override
    public void getBulletinInfoResult(int returnCode, String returnInfo, JSONObject dataObj, Long returnTimeStamp) {
        if (returnCode == 0) {
            LiteBulletinDetail bulletinDetail = BulletinManager.parseBulletinDetilJson(dataObj);
            if (bulletinDetail != null) {
                if (UCDBBulletin.existBulletinById(this.context, bulletinDetail.getId())) {
                    UCDBBulletin.saveBulletinDetails(this.context, bulletinDetail);
                }
                BroadcastUtil.sendBulletinDetailReadyEvent(this.context, bulletinDetail.getId());
                if (TextUtils.isNotBlank((CharSequence)bulletinDetail.getSubjectPhoto()) && !FileUtil.existBulletinSubjectPhoto(bulletinDetail.getId())) {
                    GetBulletinSubjectPhotoTask task = new GetBulletinSubjectPhotoTask(this.context, bulletinDetail.getId(), bulletinDetail.getSubjectPhoto());
                    TaskController.getInstance().addTask(task);
                    task.start();
                }
            }
        } else {
            Log.e(this.getClass().getSimpleName(), "getBulletinInfoResult fail!:" + returnInfo);
        }
    }

    @Override
    public void markBulletinAsRead(int returnCode, String returnInfo, long bulletinId) {
        if (returnCode == 0) {
            UCDBRemoteMark.deleteRemoteMark(this.context, 0, bulletinId);
        } else {
            Log.e(this.getClass().getSimpleName(), "markBulletinAsRead fail!:" + returnInfo);
        }
    }

    @Override
    public void markBulletinAsMark(int returnCode, String returnInfo, long bulletinId, boolean isMarked) {
        if (returnCode == 0) {
            if (isMarked) {
                UCDBRemoteMark.deleteRemoteMark(this.context, 4, bulletinId);
            } else {
                UCDBRemoteMark.deleteRemoteMark(this.context, 5, bulletinId);
            }
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_success"), 10);
        } else {
            Log.e(this.getClass().getSimpleName(), "markBulletinAsMark fail!:" + returnInfo);
            ToastUtil.show(this.context, I18NUtil.getString("common_notice_update_failed") + " err:" + returnInfo, 20);
        }
    }

    @Override
    public void getBulletinReadCountListResult(int returnCode, String returnInfo, JSONArray dataArray, Long returnTimeStamp) {
        if (returnCode == 0) {
            for (int i = 0; dataArray != null && i < dataArray.length(); ++i) {
                try {
                    JSONObject item = dataArray.getJSONObject(i);
                    long bulletinId = item.getLong("id");
                    int readCount = item.getInt("count");
                    UCDBBulletin.saveBulletinReadcount(this.context, bulletinId, readCount);
                    BroadcastUtil.sendBulletinStatusChangedEvent(this.context, bulletinId);
                    continue;
                }
                catch (JSONException e) {
                    Log.e(this.getClass().getSimpleName(), "getBulletinReadCountListResult fail!:" + returnInfo);
                }
            }
            PreferencesUtil.setTimeStamp(this.context, "bulletin.getBulletinReadCountList.TimeStamp", returnTimeStamp);
        } else {
            Log.e(this.getClass().getSimpleName(), "getPublishBulletinListResult fail!:" + returnInfo);
        }
    }

    @Override
    public void recordUpdateReadStatusForPersonalRecord(int returnCode, String returnInfo, String ids) {
        if (returnCode == 0 && TextUtils.isNotBlank((CharSequence)ids)) {
            String[] idAry = ids.split(",");
            for (int i = 0; idAry != null && i < idAry.length; ++i) {
                long recordId = Long.parseLong(idAry[i]);
                UCDBRemoteMark.deleteRemoteMark(this.context, 1, recordId);
            }
        }
    }

    @Override
    public void recordUpdateReadStatusForVoiceMessage(int returnCode, String returnInfo, String ids) {
        if (returnCode == 0 && TextUtils.isNotBlank((CharSequence)ids)) {
            String[] idAry = ids.split(",");
            for (int i = 0; idAry != null && i < idAry.length; ++i) {
                long recordId = Long.parseLong(idAry[i]);
                UCDBRemoteMark.deleteRemoteMark(this.context, 2, recordId);
            }
        }
    }

    @Override
    public void markChatEventRead(int returnCode, String returnInfo, String ids, Long chatEventId) {
        if (returnCode == 0) {
            if (chatEventId != null) {
                UCDBRemoteMark.deleteRemoteMark(this.context, 3, chatEventId);
            }
            if (TextUtils.isNotBlank((CharSequence)ids)) {
                String[] idAry = ids.split(",");
                for (int i = 0; idAry != null && i < idAry.length; ++i) {
                    long xchatEventId = Long.parseLong(idAry[i]);
                    UCDBRemoteMark.deleteRemoteMark(this.context, 3, xchatEventId);
                }
            }
        }
    }

    @Override
    public void markChatEventPlayed(int returnCode, String returnInfo, String ids, Long chatEventId) {
        if (returnCode == 0) {
            if (chatEventId != null) {
                UCDBRemoteMark.deleteRemoteMark(this.context, 9, chatEventId);
            }
            if (TextUtils.isNotBlank((CharSequence)ids)) {
                String[] idAry = ids.split(",");
                for (int i = 0; idAry != null && i < idAry.length; ++i) {
                    long xchatEventId = Long.parseLong(idAry[i]);
                    UCDBRemoteMark.deleteRemoteMark(this.context, 9, xchatEventId);
                }
            }
        }
    }

    @Override
    public void markChatMsgRecalled(int returnCode, String returnInfo, String packetId) {
        if (returnCode != 0) {
            ToastUtil.show(this.context, I18NUtil.getString("recall_msg_failed"), 20);
        }
    }

    @Override
    public void getApiUserListResult(int returnCode, String returnInfo, JSONArray dataArray, Long returnTimeStamp) {
        if (returnCode == 0) {
            ArrayList<PhotoLoadTask> toGetPhotoList = new ArrayList<PhotoLoadTask>();
            List<MessageChannel> messageChannelList = MessageChannelManager.parseApiUserJson(dataArray);
            boolean doUpdate = false;
            for (int i = 0; messageChannelList != null && i < messageChannelList.size(); ++i) {
                doUpdate = true;
                MessageChannel newChannelInfo = messageChannelList.get(i);
                boolean hasPhotoUpdate = false;
                if (!UCDBMessageChannel.existChannelById(this.context, newChannelInfo.getId())) {
                    if (newChannelInfo.isPhotoFlag()) {
                        hasPhotoUpdate = true;
                    }
                    UCDBMessageChannel.addMessageChannel(this.context, newChannelInfo);
                } else {
                    long existTimestamp = UCDBMessageChannel.getPhotoTimestamp(this.context, newChannelInfo.getId());
                    if (newChannelInfo.getLastUpdateIcon() != existTimestamp) {
                        hasPhotoUpdate = true;
                    }
                    UCDBMessageChannel.updateMessageChannel(this.context, newChannelInfo);
                }
                if (JidUtil.isAPI000001UserJid(newChannelInfo.getJid()) || !hasPhotoUpdate) continue;
                MessageChannelPhotoTask task = new MessageChannelPhotoTask();
                task.setId(newChannelInfo.getId());
                toGetPhotoList.add(task);
            }
            if (toGetPhotoList != null && !toGetPhotoList.isEmpty()) {
                MessageChannelManager.refreshPhotoList(this.context, toGetPhotoList);
            }
            if (doUpdate) {
                BroadcastUtil.sendApiListListChangedEvent(this.context);
            }
            PreferencesUtil.setTimeStamp(this.context, "apiUser.getApiUserList.TimeStamp", returnTimeStamp);
            WebAgent.getInstance().getDeletedApiUserList();
        } else {
            Log.e(this.getClass().getSimpleName(), "getApiUserListResult fail!:" + returnInfo);
        }
    }

    @Override
    public void getDeletedApiUserListResult(int returnCode, String returnInfo, JSONArray dataArray, Long returnTimeStamp) {
        if (returnCode == 0) {
            boolean doUpdate = false;
            List<Long> idList = MessageChannelManager.parseDeletedApiUserJson(dataArray);
            for (int i = 0; idList != null && i < idList.size(); ++i) {
                Long channelId = idList.get(i);
                doUpdate = true;
                UCDBMessageChannel.deleteMessageChannel(this.context, channelId);
                FileUtil.deleteMessageChannelPhoto(channelId);
            }
            if (doUpdate) {
                BroadcastUtil.sendBulletinListChangedEvent(this.context);
            }
            PreferencesUtil.setTimeStamp(this.context, "apiUser.getDeletedApiUserList.TimeStamp", returnTimeStamp);
        } else {
            Log.e(this.getClass().getSimpleName(), "getDeletedApiUserListResult fail!:" + returnInfo);
        }
    }

    @Override
    public void getChatEventBeginTime(int returnCode, String returnInfo, long beginTime, Long returnTimeStamp) {
        block7: {
            if (returnCode == 0) {
                try {
                    long daysAgo = 0L;
                    if (beginTime > 0L) {
                        daysAgo = (System.currentTimeMillis() - beginTime) / 86400000L + 1L;
                    }
                    Log.i(this.getClass().getSimpleName(), "getChatEventBeginTime daysAgo ==>" + daysAgo);
                    PreferencesUtil.setSyncDaysCount(this.context, daysAgo);
                    if (daysAgo == 0L) {
                        WebAgent.getInstance().calculateOldestChatEventId(0L);
                        break block7;
                    }
                    if (daysAgo <= 7L) {
                        UCChatClient.getInstance().showDataImportProgress();
                        PreferencesUtil.setSyncDataFlag(this.context, true);
                        BroadcastUtil.sendDataDownloadStartEvent(this.context);
                        SyncChatHistoryTask task = new SyncChatHistoryTask(this.context, daysAgo);
                        TaskController.getInstance().addTask(task);
                        task.start();
                        break block7;
                    }
                    BroadcastUtil.sendDataDownloadDataReadyEvent(this.context);
                }
                catch (Throwable t) {
                    Log.e(this.getClass().getSimpleName(), t.getLocalizedMessage(), t);
                    this.initChatEventDone();
                }
            } else {
                this.initChatEventDone();
            }
        }
    }

    @Override
    public void getCalculateOldestChatEventId(int returnCode, String returnInfo, long eventId, Long returnTimeStamp) {
        if (returnCode == 0) {
            try {
                Log.i(this.getClass().getSimpleName(), "getCalculateOldestChatEventId eventId ==>" + eventId);
                WebAgent.getInstance().getOldChatEventByEventId(eventId);
            }
            catch (Throwable t) {
                Log.e(this.getClass().getSimpleName(), t.getLocalizedMessage(), t);
                this.initChatEventDone();
            }
        } else {
            this.initChatEventDone();
        }
    }

    @Override
    public void getCalculateCurrentChatEventId(int returnCode, String returnInfo, long eventId, Long returnTimeStamp) {
        if (returnCode == 0) {
            try {
                PreferencesUtil.setLastChatEventId(this.context, eventId);
                if (!PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                    PreferencesUtil.setSyncOldChatEventDone(this.context, true);
                    PreferencesUtil.setSyncDataFlag(this.context, false);
                    BroadcastUtil.sendDataDownloadEndEvent(this.context);
                }
                long lastEventId = PreferencesUtil.getLastChatEventId(this.context);
                WebAgent.getInstance().getOldChatEventByEventId(lastEventId);
            }
            catch (Throwable t) {
                Log.e(this.getClass().getSimpleName(), t.getLocalizedMessage(), t);
                this.initChatEventDone();
            }
        } else {
            this.initChatEventDone();
        }
    }

    private void initChatEventDone() {
        if (!PreferencesUtil.isSyncOldChatEventDone(this.context)) {
            PreferencesUtil.setSyncOldChatEventDone(this.context, true);
        }
        PreferencesUtil.setSyncDataFlag(this.context, false);
        BroadcastUtil.sendDataDownloadEndEvent(this.context);
    }

    @Override
    public void deleteChatEventByEventIdsResult(int returnCode, String returnInfo, ArrayList<Long> eventIds) {
        for (int i = 0; eventIds != null && i < eventIds.size(); ++i) {
            UCDBRemoteMark.deleteRemoteMark(this.context, 8, eventIds.get(i));
        }
    }

    @Override
    public void deleteChatEventByRoomJidResult(int returnCode, String returnInfo, String roomJid) {
        UCDBRemoteMark.deleteRemoteMark(this.context, 6, roomJid);
    }

    @Override
    public void deleteChatEventByUserJidResult(int returnCode, String returnInfo, String userJid) {
        UCDBRemoteMark.deleteRemoteMark(this.context, 7, userJid);
    }

    @Override
    public void agentLoginResult(int returnCode, String returnInfo) {
        if (returnCode == 0) {
            Log.d(WebConnectionListener.class.getSimpleName(), "agentLogin OK");
        } else {
            ToastUtil.show(this.context, this.getAgentStateMsg(returnCode, true), 10);
            Log.e(WebConnectionListener.class.getSimpleName(), "agentLogin Failed");
        }
    }

    @Override
    public void agentLogoutResult(int returnCode, String returnInfo) {
        if (returnCode == 0) {
            Log.d(WebConnectionListener.class.getSimpleName(), "agentLogout OK");
        } else {
            ToastUtil.show(this.context, this.getAgentStateMsg(returnCode, false), 10);
            Log.e(WebConnectionListener.class.getSimpleName(), "agentLogout Failed");
        }
    }

    private String getAgentStateMsg(int returnCode, boolean isLogin) {
        String msg;
        String string = msg = isLogin ? I18NUtil.getString("agent_login_failed_general") : I18NUtil.getString("agent_logout_failed_general");
        if (returnCode == -1) {
            msg = I18NUtil.getString("agent_login_failed_missing_id");
        } else if (returnCode == -2) {
            msg = I18NUtil.getString("agent_login_failed_missing_media_types");
        } else if (returnCode == -3) {
            msg = I18NUtil.getString("agent_login_failed_no_agent_role");
        } else if (returnCode == -4) {
            msg = I18NUtil.getString("agent_logout_failed_not_login");
        } else if (returnCode == -5) {
            msg = I18NUtil.getString("agent_logout_failed_not_allowed");
        } else if (returnCode == -6) {
            msg = I18NUtil.getString("agent_login_failed_emp_not_found");
        } else if (returnCode == -7) {
            msg = I18NUtil.getString("agent_login_failed_emp_off_duty");
        } else if (returnCode == -8) {
            msg = I18NUtil.getString("agent_login_failed_pbx_not_ready");
        } else if (returnCode == -9) {
            msg = I18NUtil.getString("agent_login_failed_skill_not_selected");
        }
        return msg;
    }

    @Override
    public void agentChangeStateResult(int returnCode, String returnInfo, JSONObject paraObj) {
        if (returnCode == 0) {
            Log.d(WebConnectionListener.class.getSimpleName(), "agentChangeState OK");
        } else {
            try {
                Object errorMsg = "Failed, error:" + String.valueOf(returnCode);
                if (returnCode == -1) {
                    errorMsg = "Agent not exist.";
                } else if (returnCode == -2) {
                    errorMsg = "Action code not exist.";
                } else if (returnCode == -3) {
                    errorMsg = "Action code not exist.";
                } else if (returnCode == -4) {
                    errorMsg = I18NUtil.getString("agent_state_change_failed_not_login");
                } else if (returnCode == -5) {
                    errorMsg = I18NUtil.getString("agent_state_change_failed_aux_or_ready");
                } else if (returnCode == -6) {
                    errorMsg = I18NUtil.getString("agent_state_change_failed_devices_not_ready");
                } else if (returnCode == -7) {
                    errorMsg = I18NUtil.getString("agent_state_change_failed_on_assignment");
                } else if (returnCode == -9) {
                    errorMsg = I18NUtil.getString("agent_state_change_failed_pbx_not_ready");
                } else if (returnCode == -8) {
                    String actionCode = paraObj.getString("actionCode");
                    AgentAction targetAction = AgentAction.valueOf(actionCode);
                    String actionName = actionCode;
                    if (AgentAction.READY == targetAction) {
                        actionName = I18NUtil.getString("agent_state_dialog_option_ready");
                    } else if (AgentAction.AUX == targetAction) {
                        actionName = I18NUtil.getString("agent_state_dialog_option_aux");
                        String auxReasonInfo = PreferencesUtil.getAuxReasonInfo();
                        if (StringUtils.isNotBlank((CharSequence)auxReasonInfo) && paraObj.has("auxReasonId")) {
                            long auxReasonId = paraObj.getLong("auxReasonId");
                            JSONArray ary = new JSONArray(auxReasonInfo);
                            for (int i = 0; i < ary.length(); ++i) {
                                JSONObject obj = ary.getJSONObject(i);
                                Long reasonId = obj.getLong("id");
                                if (reasonId != auxReasonId) continue;
                                actionName = obj.getString("name");
                            }
                        }
                    }
                    errorMsg = String.format(I18NUtil.getString("agent_state_change_failed_state"), actionName);
                }
                ToastUtil.show(this.context, (String)errorMsg, 10);
                Log.e(WebConnectionListener.class.getSimpleName(), "agentChangeState Failed");
            }
            catch (JSONException e) {
                Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void getReaderTimeListResult(int returnCode, String returnInfo, JSONArray dataArray, JSONObject paraObj) {
        if (returnCode == 0) {
            try {
                if (dataArray == null || dataArray.length() == 0) {
                    return;
                }
                String packetId = paraObj.getString("packetId");
                for (int i = 0; dataArray != null && i < dataArray.length(); ++i) {
                    JSONObject readerObj = dataArray.getJSONObject(i);
                    MsgReaderTime timeBean = new MsgReaderTime();
                    long logId = readerObj.getLong("id");
                    timeBean.setId(logId);
                    timeBean.setPacketId(packetId);
                    timeBean.setChatEventId(-1L);
                    timeBean.setReaderEmpId(readerObj.getLong("readerEmployeeId"));
                    timeBean.setReaderTimestamp(readerObj.getLong("readerTime"));
                    if (UCDBReaderLog.isLogExist(this.context, logId)) {
                        UCDBReaderLog.updateReaderLog(this.context, timeBean);
                        continue;
                    }
                    UCDBReaderLog.addReaderLog(this.context, timeBean);
                }
                BroadcastUtil.sendChatMsgReaderListChanged(this.context, packetId);
                if (dataArray.length() == 300 && ApiVersion.isApi14Later()) {
                    WebAgent.getInstance().getReaderTime(packetId);
                }
            }
            catch (JSONException e) {
                Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
            }
        } else {
            ToastUtil.show(this.context, I18NUtil.getString("readertime_fetch_failed"), 20);
        }
    }

    @Override
    public void getEmpContactRecordsResult(int returnCode, String returnInfo, JSONArray dataArray, JSONObject paraObj) {
        if (returnCode != 0) {
            Log.e(this.getClass().getSimpleName(), "getEmpContactRecordsResult fail!:" + returnInfo);
            return;
        }
        try {
            int requestSeq = paraObj.getInt("requestSeq");
            int currentRequestSeq = PreferencesUtil.getInt(this.context, "SYNC_CONTACT_RECORD_SEQ", 0);
            if (currentRequestSeq != requestSeq) {
                Log.e(WebConnectionListener.class.getSimpleName(), "record sequence (local:incoming) = (" + currentRequestSeq + ":" + requestSeq + ") skip!");
                return;
            }
            if (dataArray != null) {
                int size = dataArray.length();
                for (int i = 0; i < size; ++i) {
                    try {
                        JSONObject recordObject = dataArray.getJSONObject(i);
                        Long contactLogId = recordObject.getLong("contactLogId");
                        SysRecordingItem item = UCDBRecording.getRecordingInfoByContactLogId(this.context, contactLogId);
                        if (item == null) {
                            UCDBRecording.addRecording(this.context, recordObject);
                        } else {
                            UCDBRecording.updateRecording(this.context, contactLogId, recordObject);
                        }
                        PreferencesUtil.setLastContactLogId(this.context, contactLogId);
                        continue;
                    }
                    catch (JSONException e) {
                        Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
                if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                    BroadcastUtil.sendContactHistoryChangedEvent(this.context);
                    BroadcastUtil.sendMsgChangedEvent(this.context);
                }
            }
            if (dataArray.length() != 0) {
                WebAgent.getInstance().getEmpContactRecordsByPageLocal(requestSeq);
            }
        }
        catch (JSONException e) {
            Log.e(WebConnectionListener.class.getSimpleName(), "ERROR: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void getFaxDocList(int returnCode, String returnInfo, JSONArray dataArray, Long timestamp) {
        if (returnCode == 0) {
            int incomingUnreadCount = 0;
            if (dataArray != null) {
                int size = dataArray.length();
                for (int i = 0; i < size; ++i) {
                    try {
                        JSONObject faxDocObj = dataArray.getJSONObject(i);
                        long docId = faxDocObj.getLong("id");
                        if (!UCDBFaxDoc.isFaxDocExist(this.context, docId)) {
                            UCDBFaxDoc.addFaxDoc(this.context, faxDocObj);
                            LiteFaxDoc faxDoc = UCDBFaxDoc.getFaxDoc(this.context, docId);
                            if (faxDoc == null || faxDoc.getDirection() != 0 || faxDoc.isReadFlag()) continue;
                            ++incomingUnreadCount;
                            continue;
                        }
                        UCDBFaxDoc.updateFaxDoc(this.context, docId, faxDocObj);
                        continue;
                    }
                    catch (JSONException e) {
                        Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            }
            PreferencesUtil.setTimeStamp(this.context, "fax.getFaxDocList.TimeStamp", timestamp);
            if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                BroadcastUtil.sendContactHistoryChangedEvent(this.context);
                BroadcastUtil.sendMsgChangedEvent(this.context, "__FAX_DOC_GROUP__");
            }
            if (incomingUnreadCount > 0) {
                BroadcastUtil.sendNewFaxNoticeEvent(this.context, incomingUnreadCount);
            }
        } else {
            Log.e(this.getClass().getSimpleName(), "getFaxDocList fail!:" + returnInfo);
        }
    }

    @Override
    public void getFaxDocDeletedList(int returnCode, String returnInfo, JSONArray dataArray, Long timestamp) {
        if (returnCode == 0) {
            if (dataArray != null) {
                int size = dataArray.length();
                for (int i = 0; i < size; ++i) {
                    try {
                        long docId = dataArray.getLong(i);
                        UCDBFaxDoc.deleteFaxDoc(this.context, docId);
                        continue;
                    }
                    catch (JSONException e) {
                        Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            }
            PreferencesUtil.setTimeStamp(this.context, "fax.getFaxDocDeletedList.TimeStamp", timestamp);
            if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                BroadcastUtil.sendMsgChangedEvent(this.context, "__FAX_DOC_GROUP__");
                BroadcastUtil.sendContactHistoryChangedEvent(this.context);
            }
        } else {
            Log.e(this.getClass().getSimpleName(), "getFaxDocList fail!:" + returnInfo);
        }
    }

    @Override
    public void faxUpdateReadStatus(int returnCode, String returnInfo, String ids) {
        if (returnCode == 0 && TextUtils.isNotBlank((CharSequence)ids)) {
            String[] idAry = ids.split(",");
            for (int i = 0; idAry != null && i < idAry.length; ++i) {
                long faxDocId = Long.parseLong(idAry[i]);
                UCDBRemoteMark.deleteRemoteMark(this.context, 13, faxDocId);
            }
        }
    }

    @Override
    public void faxDeleteFaxDoc(int returnCode, String returnInfo, String ids) {
        if (returnCode == 0 && TextUtils.isNotBlank((CharSequence)ids)) {
            String[] idAry = ids.split(",");
            for (int i = 0; idAry != null && i < idAry.length; ++i) {
                long faxDocId = Long.parseLong(idAry[i]);
                UCDBRemoteMark.deleteRemoteMark(this.context, 14, faxDocId);
            }
        }
    }

    @Override
    public void faxResendFaxDoc(int returnCode, String returnInfo, String ids) {
        if (returnCode == 0) {
            String msg = I18NUtil.getString("fax_doc_label_resend_done");
            ToastUtil.show(this.context, msg, 10);
        }
    }

    @Override
    public void faxCancelFaxDoc(int returnCode, String returnInfo, String ids) {
        if (returnCode == 0) {
            String msg = I18NUtil.getString("fax_doc_label_cancel_done");
            ToastUtil.show(this.context, msg, 10);
        }
    }

    @Override
    public void getSatisfactionSurveyList(int returnCode, String returnInfo, JSONObject dataObj) {
        if (returnCode == 0) {
            PreferencesUtil.saveSatisfactionSetting(this.context, dataObj.toString());
            BroadcastUtil.sendSatisfactionSurveyListUpdateEvent(this.context);
        } else {
            Log.e(this.getClass().getSimpleName(), "getSatisfactionSurveyList fail!:" + returnInfo);
        }
    }

    @Override
    public void getAllDepartmentList(int returnCode, String returnInfo, JSONArray dataArray) {
        if (returnCode == 0) {
            List deptList = null;
            if (dataArray != null) {
                Gson gson = new Gson();
                deptList = (List)gson.fromJson(dataArray.toString(), new TypeToken<List<LiteDepartment>>(this){}.getType());
            } else {
                deptList = new ArrayList();
            }
            List<Long> oldDeptIdList = UCDBDept.getAllDeptList(this.context);
            for (LiteDepartment dept : deptList) {
                Log.i(this.getClass().getSimpleName(), "handle dept:" + String.valueOf(dept));
                long deptId = dept.getId();
                oldDeptIdList.remove(deptId);
                if (!UCDBDept.isDeptExist(this.context, deptId)) {
                    UCDBDept.addDept(this.context, dept);
                    continue;
                }
                UCDBDept.updateDept(this.context, deptId, dept);
            }
            for (Long deptId : oldDeptIdList) {
                Log.i(this.getClass().getSimpleName(), "delete dept:" + deptId);
                UCDBDept.deleteDept(this.context, deptId);
            }
            if (PreferencesUtil.isSyncOldChatEventDone(this.context)) {
                BroadcastUtil.sendContactListChangedEvent(this.context, 0);
            }
        } else {
            Log.e(this.getClass().getSimpleName(), "getFaxDocList fail!:" + returnInfo);
        }
    }

    @Override
    public void parkCall(int returnCode, String returnInfo) {
        if (returnCode != 0) {
            Log.e(this.getClass().getSimpleName(), "parkCall fail, returnCode:" + returnCode + " returnInfo:" + returnInfo);
            this.checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                @Override
                public void doRun() {
                    ToastUtil.show(WebConnectionListener.this.context, I18NUtil.getString("cmd_phone_parkCall_failed"), 20);
                }
            }, 1000L);
        }
    }

    @Override
    public void cancelFreeSeating(int returnCode, String returnInfo) {
        if (returnCode != 0) {
            Log.e(this.getClass().getSimpleName(), "cancelFreeSeating fail, returnCode:" + returnCode + " returnInfo:" + returnInfo);
        }
        BroadcastUtil.sendCancelFreeSeatingResult(this.context, returnCode);
    }

    @Override
    public void requestFreeSeating(int returnCode, String returnInfo) {
        if (returnCode != 0) {
            Log.e(this.getClass().getSimpleName(), "requestFreeSeating fail, returnCode:" + returnCode + " returnInfo:" + returnInfo);
        }
        BroadcastUtil.sendRequestFreeSeatingResult(this.context, returnCode);
    }
}

