/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.connection.web;

import com.blisscloud.ezuc.WsEncryption;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Base64;
import com.blisscloud.ezuc.client.util.simulate.Handler;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.callback.WebCallBack;
import com.blisscloud.mobile.ezuc.connection.web.ActionObj;
import com.blisscloud.mobile.ezuc.connection.web.CommandResultHandler;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.java_websocket.client.DefaultSSLWebSocketClientFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;

public class WebConnectionImpl {
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final int SECOND = 1000;
    private static final int DURATION_2_RECONNECT = 60000;
    private static final int HEARTBEAT_PERIOD = 30000;
    private static boolean isConnecting = false;
    private EZWebSocketClient wsConnection;
    private Handler heartBeatHandler = new Handler("HeartBeatHandler");
    protected long lastIncomingMessageTime = System.currentTimeMillis();
    protected long lastHeartBeatSentTime = System.currentTimeMillis();
    private Runnable heartBeatTimer = null;
    protected final WebCallBack mCallback;
    private final CommandResultHandler mResultHandler;

    public WebConnectionImpl(WebCallBack callBack) {
        this.mCallback = callBack;
        this.mResultHandler = new CommandResultHandler(this, callBack);
    }

    public boolean isConnected() {
        return this.wsConnection != null && this.wsConnection.isConnected();
    }

    public boolean isConnecting() {
        return isConnecting;
    }

    private void init() {
        this.heartBeatTimer = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean isServiceConnected = WebConnectionImpl.this.isConnected();
                    if (isServiceConnected) {
                        ActionObj action = new ActionObj("hb");
                        WebConnectionImpl.this.sendTextMessage(action.toJSONString());
                        WebConnectionImpl.this.doCheckCheckAction();
                        WebConnectionImpl.this.heartBeatHandler.postDelayed(this, 30000L);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
    }

    public void doCheckCheckAction() {
        Log.d("UC_HEARTBEAT", "HEARTBEAT CHEACK ...............");
        long diff = System.currentTimeMillis() - this.lastIncomingMessageTime;
        Log.d("UC_HEARTBEAT", "HEARTBEAT check diff: " + diff);
        if (diff > 60000L) {
            Log.w("UC_HEARTBEAT", "HEARTBEAT check failed .... reconnect, diff:" + diff);
            this.mCallback.notifyTimeout();
        }
    }

    public void onStart() {
        Log.d(WebConnectionImpl.class.getSimpleName(), "Web Connection onStart .............");
        this.init();
    }

    public void onDestroy() {
        Log.d(WebConnectionImpl.class.getSimpleName(), "Web Connection onDestroy .............");
        if (this.mCallback != null) {
            this.mCallback.onDestroy();
        }
        this.cleanConnection();
        if (this.wsConnection != null) {
            this.wsConnection = null;
        }
        this.heartBeatHandler = null;
    }

    public void cleanConnection() {
        Log.d(WebConnectionImpl.class.getSimpleName(), "cleanConnection .............");
        this.heartBeatHandler.removeCallbacks(this.heartBeatTimer);
        this.manuallyDisconnect();
    }

    private synchronized void manuallyDisconnect() {
        isConnecting = false;
        if (this.wsConnection == null) {
            return;
        }
        Log.i(WebConnectionImpl.class.getSimpleName(), "manuallyDisconnect isConnected:" + this.isConnected());
        if (this.isConnected()) {
            try {
                Log.i(WebConnectionImpl.class.getSimpleName(), "try to disconnect " + this.mCallback.getURI() + " now .............");
                this.wsConnection.disconnect();
                Log.i(WebConnectionImpl.class.getSimpleName(), "try to disconnect " + this.mCallback.getURI() + " end .............");
            }
            catch (Throwable e) {
                Log.e(WebConnectionImpl.class.getSimpleName(), "try to disconnect but failed:" + e.getLocalizedMessage());
            }
        }
        try {
            Log.i(WebConnectionImpl.class.getSimpleName(), "try to cleanup " + this.mCallback.getURI() + " now .............");
            this.wsConnection.cleanup();
            Log.i(WebConnectionImpl.class.getSimpleName(), "try to cleanup " + this.mCallback.getURI() + " end .............");
        }
        catch (Throwable e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "try to cleanup but failed:" + e.getLocalizedMessage());
        }
        Log.i(WebConnectionImpl.class.getSimpleName(), "set connection state to stop !");
    }

    public synchronized void connect() {
        Log.i(WebConnectionImpl.class.getSimpleName(), "web socket connecting isConnected:" + this.isConnected());
        try {
            Locale locale = I18NUtil.getAppLocale();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("Accept-Language", locale.getLanguage() + "-" + locale.getCountry());
            String uri = this.mCallback.getURI();
            Log.i(WebConnectionImpl.class.getSimpleName(), "Connect " + uri);
            this.wsConnection = new EZWebSocketClient(new URI(uri), new Draft_17(), param);
        }
        catch (Throwable e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "try to cleanup but failed:" + e.getLocalizedMessage());
        }
        try {
            isConnecting = true;
            this.wsConnection.connect();
        }
        catch (Exception e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage());
            isConnecting = false;
        }
    }

    private synchronized void _login() {
        Log.i(WebConnectionImpl.class.getSimpleName(), "login() .....");
        if (StringUtils.isNotBlank((CharSequence)this.mCallback.getLoginID()) && (StringUtils.isNotBlank((CharSequence)this.mCallback.getLoginPWD()) || StringUtils.isNotBlank((CharSequence)this.mCallback.getLoginToken()))) {
            String sipAccount;
            ActionObj action = new ActionObj("login.auth");
            action.setValue("enableProxy", true);
            action.setValue("loginType", "user");
            action.setValue("username", this.mCallback.getLoginID());
            action.setValue("password", this.mCallback.getLoginPWD());
            action.setValue("kerberosToken", this.mCallback.getLoginToken());
            String enterpriseNo = this.mCallback.getEnterpriseNo();
            if (enterpriseNo != null) {
                action.setValue("enterpriseNo", enterpriseNo);
            }
            action.setValue("appType", this.mCallback.getAppType());
            action.setValue("appVersionCode", this.mCallback.getVersionCode());
            action.setValue("appVersionName", this.mCallback.getVersionName());
            action.setValue("appVersionDate", this.mCallback.getVersionDate());
            action.setValue("deviceName", this.mCallback.getDeviceName());
            action.setValue("deviceOs", this.mCallback.getDeviceOS());
            action.setValue("deviceUniqueId", this.mCallback.getDeviceId());
            action.setValue("macAddr", this.mCallback.getMacAddress());
            action.setValue("deviceType", this.mCallback.getDeviceType());
            action.setValue("nsCode", this.mCallback.getGcmRegistrationId());
            action.setValue("productType", this.mCallback.getProductType());
            action.setValue("addIgnoreDataChangeEvents", "CHAT_ROOM,CHAT_ROOM_NEW,CHAT_PROXY_READY,CHAT_PRESENCE");
            String sessionId = this.mCallback.getLoginSessionId();
            if (TextUtils.isNotBlank((CharSequence)sessionId)) {
                action.setValue("loginLogId", sessionId);
            }
            if (TextUtils.isNotBlank((CharSequence)(sipAccount = this.mCallback.getLoginSip()))) {
                action.setValue("loginSip", sipAccount);
            }
            this.wsConnection.sendTextMessage(this.encryptString(action.toJSONString()));
        } else {
            Log.w(WebConnectionImpl.class.getSimpleName(), "login() \u767b\u5165\u8cc7\u8a0a\u4e0d\u8db3\uff1ausername:[" + this.mCallback.getLoginID() + "] password:[NotTellU]");
        }
    }

    public void logout() {
        ActionObj action = new ActionObj("logout.auth");
        this.wsConnection.sendTextMessage(this.encryptString(action.toJSONString()));
    }

    public boolean sendTextMessage(String msg) {
        if (this.isConnected()) {
            this.wsConnection.sendTextMessage(this.encryptString(msg));
            return true;
        }
        return false;
    }

    protected String encryptString(String str) {
        try {
            byte[] b = WsEncryption._encryptString(str.getBytes(ENCODING_UTF8));
            return Base64.encodeToString(b, 0);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "encryptString:[" + e.getLocalizedMessage() + "]", e);
            return null;
        }
    }

    protected String decryptString(String str) {
        byte[] b = Base64.decode(str, 0);
        try {
            return new String(WsEncryption._encryptString(b), ENCODING_UTF8);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), "decryptString:[" + e.getLocalizedMessage() + "]", e);
            return null;
        }
    }

    private static void trustAllHosts(WebSocketClient appClient) {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            appClient.setWebSocketFactory(new DefaultSSLWebSocketClientFactory(sc));
        }
        catch (Exception e) {
            Log.e(WebConnectionImpl.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    class EZWebSocketClient
    extends WebSocketClient {
        private ExecutorService executorService;

        public EZWebSocketClient(URI serverURI) {
            super(serverURI);
            this.executorService = Executors.newSingleThreadExecutor();
            WebConnectionImpl.trustAllHosts(this);
        }

        public EZWebSocketClient(URI serverUri, Draft draft, Map<String, String> param) {
            super(serverUri, draft, param);
            this.executorService = Executors.newSingleThreadExecutor();
            WebConnectionImpl.trustAllHosts(this);
        }

        public void sendTextMessage(String payload) {
            this.send(payload);
        }

        public boolean isConnected() {
            return this.getConnection() != null && this.getConnection().isOpen();
        }

        public void disconnect() {
            super.close();
        }

        public void cleanup() {
        }

        @Override
        public void onOpen(ServerHandshake handshakedata) {
            Log.w(WebConnectionImpl.class.getSimpleName(), "onOpen() ......\u9023\u7dda\u5df2\u958b\u555f ...............");
            this.executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    WebConnectionImpl webConnectionImpl = WebConnectionImpl.this;
                    synchronized (webConnectionImpl) {
                        isConnecting = false;
                        WebConnectionImpl.this.mCallback.notifyOnOpen();
                        WebConnectionImpl.this.lastIncomingMessageTime = System.currentTimeMillis();
                        WebConnectionImpl.this.heartBeatHandler.removeCallbacks(WebConnectionImpl.this.heartBeatTimer);
                        WebConnectionImpl.this.heartBeatHandler.postDelayed(WebConnectionImpl.this.heartBeatTimer, 30000L);
                        WebConnectionImpl.this._login();
                    }
                }
            });
        }

        @Override
        public void onMessage(final String msg) {
            this.executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    WebConnectionImpl webConnectionImpl = WebConnectionImpl.this;
                    synchronized (webConnectionImpl) {
                        String newMsg = WebConnectionImpl.this.decryptString(msg);
                        WebConnectionImpl.this.lastIncomingMessageTime = System.currentTimeMillis();
                        WebConnectionImpl.this.mResultHandler.processMessagesReceived(newMsg);
                    }
                }
            });
        }

        @Override
        public void onMessage(ByteBuffer byteBuf) {
            Log.d(WebConnectionImpl.class.getSimpleName(), "onBinaryMessage() \u6536\u5230\u56de\u50b3");
        }

        @Override
        public void onClose(int code, final String reason, boolean remote) {
            if (WebConnectionImpl.this.wsConnection != this) {
                return;
            }
            this.executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    WebConnectionImpl webConnectionImpl = WebConnectionImpl.this;
                    synchronized (webConnectionImpl) {
                        Log.w(WebConnectionImpl.class.getSimpleName(), "onClose() ......\u9023\u7dda\u5df2\u95dc\u9589 ..............." + reason);
                        WebConnectionImpl webConnectionImpl2 = WebConnectionImpl.this;
                        synchronized (webConnectionImpl2) {
                            if (WebConnectionImpl.this.heartBeatHandler != null) {
                                WebConnectionImpl.this.heartBeatHandler.removeCallbacks(WebConnectionImpl.this.heartBeatTimer);
                            }
                            boolean tryConnectFail = false;
                            if (isConnecting) {
                                tryConnectFail = true;
                            }
                            isConnecting = false;
                            WebConnectionImpl.this.mCallback.notifyOnClose(0, reason, tryConnectFail);
                        }
                    }
                }
            });
        }

        @Override
        public void onError(final Exception ex) {
            ex.printStackTrace();
            if (WebConnectionImpl.this.wsConnection != this) {
                return;
            }
            this.executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    WebConnectionImpl webConnectionImpl = WebConnectionImpl.this;
                    synchronized (webConnectionImpl) {
                        isConnecting = false;
                        String errorMessage = ex.getLocalizedMessage();
                        Log.w(WebConnectionImpl.class.getSimpleName(), "onException() ......\u9023\u7dda\u767c\u751f\u554f\u984c ..............." + errorMessage);
                        WebConnectionImpl.this.mCallback.notifyException(errorMessage);
                    }
                }
            });
        }
    }
}

