/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class UCDBBase {
    protected static void _log(String tag, String string) {
    }

    protected static void closeCursor(Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Throwable t) {
            Log.e(UCDBBase.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    protected static void closeDb(SQLiteDatabase db) {
        try {
            if (db != null) {
                if (!db.isReadonly()) {
                    db.endTransaction();
                }
                db.close();
            }
        }
        catch (Throwable t) {
            Log.e(UCDBBase.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    protected static String prepareInSql(int[] data) {
        StringBuilder builder = new StringBuilder();
        if (data != null && data.length != 0) {
            for (int i : data) {
                builder.append(i);
                builder.append(",");
            }
        }
        if (builder.length() > 0) {
            int length = builder.length();
            builder.delete(length - 1, length);
        }
        return builder.toString();
    }

    protected static String prepareInSql(Set<String> data) {
        StringBuilder builder = new StringBuilder();
        if (data != null && data.size() > 0) {
            for (String i : data) {
                builder.append("'");
                builder.append(i);
                builder.append("'");
                builder.append(",");
            }
        }
        if (builder.length() > 0) {
            int length = builder.length();
            builder.delete(length - 1, length);
        }
        return builder.toString();
    }

    protected static String prepareInSql(List<String> data) {
        StringBuilder builder = new StringBuilder();
        if (data != null && data.size() > 0) {
            for (String i : data) {
                builder.append("'");
                builder.append(i);
                builder.append("'");
                builder.append(",");
            }
        }
        if (builder.length() > 0) {
            int length = builder.length();
            builder.delete(length - 1, length);
        }
        return builder.toString();
    }

    protected static void setSelectionCloumns(StringBuilder builder, String[] cloumns, String prefix) {
        if (cloumns != null && cloumns.length > 0) {
            for (String col : cloumns) {
                builder.append(prefix);
                builder.append(col);
                builder.append(",");
            }
            builder.delete(builder.length() - 1, builder.length());
        }
    }

    protected static boolean isBlank(String data) {
        return data == null || "".equals(data.trim());
    }

    protected static String jidsLongToQueryStr(Collection<Long> jidList) {
        if (jidList == null || jidList.size() == 0) {
            return "NULL";
        }
        StringBuffer jids = new StringBuffer();
        int i = 0;
        for (Long jid : jidList) {
            if (i != 0) {
                jids.append(",");
            }
            jids.append(jid);
            ++i;
        }
        return jids.toString();
    }

    protected static String jidsStrToQueryStr(Collection<String> jidList) {
        if (jidList == null || jidList.size() == 0) {
            return "NULL";
        }
        StringBuffer jids = new StringBuffer();
        int i = 0;
        for (String jid : jidList) {
            if (i != 0) {
                jids.append(",");
            }
            jids.append("'" + jid + "'");
            ++i;
        }
        return jids.toString();
    }

    protected static String jidsIntegerToQueryStr(Set<Integer> jidList) {
        if (jidList == null || jidList.size() == 0) {
            return "NULL";
        }
        StringBuffer jids = new StringBuffer();
        int i = 0;
        for (Integer jid : jidList) {
            if (i != 0) {
                jids.append(",");
            }
            jids.append(jid);
            ++i;
        }
        return jids.toString();
    }
}

