/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.db.CacheEntry;
import com.blisscloud.mobile.ezuc.db.ChatDataHelper;
import com.blisscloud.mobile.ezuc.db.ContactDataHelper;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UCDBChatRoom
extends UCDBBase {
    public static final String TABLE_CHAT_ROOM = "ChatRoom";
    public static final String TABLE_CHAT_ROOM_PARTICIPANT = "ChatRoomParticipant";
    private static ConcurrentHashMap<String, CacheEntry> existHashMap = new ConcurrentHashMap();

    public static void checkCache() {
        Log.d(UCDBChatRoom.class.getSimpleName(), "checkCache UCDBChatRoom existHashMap size is " + existHashMap.size());
        long currentTime = System.currentTimeMillis();
        for (String roomJid : existHashMap.keySet()) {
            CacheEntry entry = existHashMap.get(roomJid);
            if (currentTime - entry.getTimestamp() <= 30000L) continue;
            existHashMap.remove(roomJid);
            Log.d(UCDBChatRoom.class.getSimpleName(), "clean UCDBChatRoom cache roomJid:" + roomJid + " hitCount:" + entry.getHitCount() + " existHashMap size is " + existHashMap.size());
        }
    }

    public static void createChatRoomTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ChatRoom");
        String CREATE_CHAT_ROOM_TABLE = "CREATE TABLE ChatRoom(chatRoomId LONGVARCHAR,subject LONGVARCHAR,subjectOwnerId LONGVARCHAR,type INTEGER,errorMsg LONGVARCHAR,lastNotifyTime NUMERIC DEFAULT 0,memberTimestamp NUMERIC DEFAULT -1,onTop TINYINT DEFAULT 0)";
        db.execSQL(CREATE_CHAT_ROOM_TABLE);
    }

    public static void createChatRoomParticipantTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ChatRoomParticipant");
        String CREATE_CHAT_ROOM_PARTICIPANT_TABLE = "CREATE TABLE ChatRoomParticipant(chatRoomId LONGVARCHAR,role INTEGER,jid LONGVARCHAR,status INTEGER)";
        db.execSQL(CREATE_CHAT_ROOM_PARTICIPANT_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomOnTopFlag(Context ctx, String chatRoomId, boolean isOnTop) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("onTop", isOnTop ? 1 : 0);
                db.update(TABLE_CHAT_ROOM, values, "chatRoomId=?", new String[]{chatRoomId});
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existChatRoomParticipantById(Context ctx, String chatRoomId, String jid) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "existChatRoomParticipantById...." + chatRoomId + "," + jid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_CHAT_ROOM_PARTICIPANT, "chatRoomId=? and jid=?", new String[]{chatRoomId, jid});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChatRoomParticipant(Context ctx, String chatRoomId, int type, String jid) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "addChatRoomParticipant...." + chatRoomId + "," + jid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("chatRoomId", chatRoomId);
                values.put("role", type);
                values.put("jid", jid);
                db.insert(TABLE_CHAT_ROOM_PARTICIPANT, null, values);
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomParticipant(Context ctx, String chatRoomId, int type, String jid, int status) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "updateChatRoomParticipant...." + chatRoomId + "," + type + "," + jid + "," + status);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("role", type);
                values.put("status", status);
                db.update(TABLE_CHAT_ROOM_PARTICIPANT, values, "chatRoomId=? and jid=?", new String[]{chatRoomId, jid});
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> findChatRoomParticipants(Context ctx, Set<String> jidsSet) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "findChatRoomParticipants...." + String.valueOf(jidsSet));
        HashMap<String, List<String>> chatRoomParticipantMap = new HashMap<String, List<String>>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<String, List<String>> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CHAT_ROOM_PARTICIPANT, new String[]{"chatRoomId", "jid"}, "chatRoomId IN (" + UCDBChatRoom.jidsStrToQueryStr(jidsSet) + ")", null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String chatRoomId;
                        if (!chatRoomParticipantMap.containsKey(chatRoomId = cursor.getString(0))) {
                            chatRoomParticipantMap.put(chatRoomId, new ArrayList());
                        }
                        List<String> list = chatRoomParticipantMap.get(chatRoomId);
                        list.add(cursor.getString(1));
                    } while (cursor.moveToNext());
                }
                hashMap = chatRoomParticipantMap;
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findThreeWayCallingChatRoom(Context ctx, Set<String> deletedJidSet) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "findThreeWayCallingChatRoom...." + String.valueOf(deletedJidSet));
        ArrayList<String> roomIdList = new ArrayList<String>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "jids:" + String.valueOf(deletedJidSet));
                int size = deletedJidSet.size();
                cursor = db.rawQuery("select chatRoomId from ChatRoomParticipant where jid in (" + UCDBChatRoom.jidsStrToQueryStr(deletedJidSet) + ") and chatRoomId in (select chatRoomId from ChatRoomParticipant group by chatRoomId having count(chatRoomId)=" + size + ") group by chatRoomId having count(chatRoomId)=" + size, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Log.i(UCDBChatRoom.class.getSimpleName(), "chatRoomId:" + cursor.getString(0));
                        String roomId = cursor.getString(0);
                        if (!TextUtils.isNotBlank((CharSequence)roomId)) continue;
                        roomIdList.add(roomId.trim());
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
        }
        String targetRoomId = null;
        for (String roomId : roomIdList) {
            ChatRoomInfo info = UCDBChatRoom.getChatRoom(ctx, roomId);
            if (info == null || info.getType() != 1) continue;
            targetRoomId = roomId;
            break;
        }
        return targetRoomId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> findChatRoomParticipants(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "findChatRoomParticipants...." + chatRoomId);
        ArrayList<String> chatRoomParticipantList = new ArrayList<String>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CHAT_ROOM_PARTICIPANT, new String[]{"jid"}, "chatRoomId=?", new String[]{chatRoomId}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        chatRoomParticipantList.add(cursor.getString(0));
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
        }
        return chatRoomParticipantList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteContact> findChatRoomParticipantsWithoutNumber(Context ctx, String chatRoomId, List<String> jidList, List<Long> empIdList) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "findChatRoomParticipantsWithoutNumber ......... " + chatRoomId);
        ArrayList<LiteContact> chatRoomParticipantList = null;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT ");
                for (String i : ContactDataHelper.contactSelectColumns) {
                    sql.append(" A.");
                    sql.append(i);
                    sql.append(",");
                }
                sql.replace(sql.length() - 1, sql.length(), " ");
                sql.append(" FROM ");
                sql.append("Contact");
                sql.append(" A,");
                sql.append(TABLE_CHAT_ROOM_PARTICIPANT);
                sql.append(" B WHERE B.");
                sql.append("chatRoomId");
                sql.append("=? AND A.");
                sql.append("jid");
                sql.append("=B.");
                sql.append("jid");
                cursor = db.rawQuery(sql.toString(), new String[]{chatRoomId});
                int count = cursor.getCount();
                chatRoomParticipantList = new ArrayList<LiteContact>(count);
                jidList.clear();
                empIdList.clear();
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteContact contact = new LiteContact();
                        ContactDataHelper.setContactValue(cursor, contact);
                        chatRoomParticipantList.add(contact);
                        jidList.add(contact.getJid());
                        if (contact.getId() != null) {
                            empIdList.add(contact.getId());
                            continue;
                        }
                        empIdList.add(-1L);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
        }
        return chatRoomParticipantList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteChatRoomParticipants(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "deleteChatRoomParticipants...." + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CHAT_ROOM_PARTICIPANT, "chatRoomId=?", new String[]{chatRoomId});
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteChatRoomParticipants(Context ctx, Set<String> chatRoomIds) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "deleteChatRoomParticipants...." + String.valueOf(chatRoomIds));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CHAT_ROOM_PARTICIPANT, "chatRoomId IN (" + UCDBChatRoom.jidsStrToQueryStr(chatRoomIds) + ") ", null);
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteChatRoomParticipant(Context ctx, String chatRoomId, String participantJid) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "deleteChatRoomParticipant...." + chatRoomId + "," + participantJid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CHAT_ROOM_PARTICIPANT, "chatRoomId=? and jid=?", new String[]{chatRoomId, participantJid});
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChatRoom(Context ctx, ChatRoomInfo chatRoomInfo) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "addChatRoom...." + String.valueOf(chatRoomInfo));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("chatRoomId", chatRoomInfo.getChatRoomId());
                values.put("subject", chatRoomInfo.getSubject());
                values.put("type", chatRoomInfo.getType());
                values.put("errorMsg", chatRoomInfo.getErrorMsg());
                values.put("subjectOwnerId", chatRoomInfo.getSubjectOwnerId());
                values.put("lastNotifyTime", 0);
                db.insert(TABLE_CHAT_ROOM, null, values);
                existHashMap.put(chatRoomInfo.getChatRoomId(), new CacheEntry(true));
                Log.d(UCDBChatRoom.class.getSimpleName(), "existHashMapMap size:" + existHashMap.size());
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChatRoomInfo getChatRoom(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "getChatRoom...." + chatRoomId);
        ChatRoomInfo chatRoom = null;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CHAT_ROOM, ChatDataHelper.chatRoomSelectColumns, "chatRoomId=?", new String[]{chatRoomId}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    chatRoom = new ChatRoomInfo();
                    ChatDataHelper.setChatRoomValue(cursor, chatRoom);
                }
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
        }
        return chatRoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ChatRoomInfo> getChatRoomByName(Context ctx, String name) {
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "getChatRoomByName...." + name);
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        ArrayList<ChatRoomInfo> chatRoomList = new ArrayList<ChatRoomInfo>();
        UCDBHelper uCDBHelper = helper;
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CHAT_ROOM, ChatDataHelper.chatRoomSelectColumns, "subject like ?", new String[]{"%" + name + "%"}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        ChatRoomInfo chatRoom = new ChatRoomInfo();
                        ChatDataHelper.setChatRoomValue(cursor, chatRoom);
                        chatRoomList.add(chatRoom);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
        }
        return chatRoomList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getMemberTimestamp(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                long l;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(true, TABLE_CHAT_ROOM, new String[]{"memberTimestamp"}, "chatRoomId=?", new String[]{chatRoomId}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    l = cursor.getLong(0);
                }
                catch (Throwable throwable) {
                    UCDBChatRoom.closeCursor(cursor);
                    UCDBChatRoom.closeDb(db);
                    throw throwable;
                }
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                return l;
            }
            long l = -1L;
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMemberTimestamp(Context ctx, String chatRoomId, long timestamp) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("memberTimestamp", timestamp);
                db.update(TABLE_CHAT_ROOM, values, "chatRoomId=?", new String[]{chatRoomId});
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ChatRoomInfo> getMultiChatRooms(Context ctx) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "getMultiChatRooms....");
        ArrayList<ChatRoomInfo> chatRoomList = new ArrayList<ChatRoomInfo>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String selection = "type=? or type=?";
                String[] selectionArgs = new String[]{String.valueOf(1), String.valueOf(2)};
                cursor = db.query(TABLE_CHAT_ROOM, ChatDataHelper.chatRoomSelectColumns, selection, selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        ChatRoomInfo chatRoom = new ChatRoomInfo();
                        ChatDataHelper.setChatRoomValue(cursor, chatRoom);
                        chatRoomList.add(chatRoom);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
        }
        return chatRoomList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ChatRoomInfo> getChatRoomsByContactJids(Context ctx, Set<String> jidList) {
        UCDBHelper helper;
        ArrayList<ChatRoomInfo> chatRoomList = new ArrayList<ChatRoomInfo>();
        if (jidList == null || jidList.size() == 0) {
            return chatRoomList;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CHAT_ROOM, ChatDataHelper.chatRoomSelectColumns, "chatRoomId IN (" + UCDBChatRoom.jidsStrToQueryStr(jidList) + ")", null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        ChatRoomInfo chatRoom = new ChatRoomInfo();
                        ChatDataHelper.setChatRoomValue(cursor, chatRoom);
                        chatRoomList.add(chatRoom);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
        }
        return chatRoomList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomSubject(Context ctx, String chatRoomId, String subject, String byParticipantJid) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "updateChatRoomSubject...." + chatRoomId + "," + subject + "," + byParticipantJid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("subject", subject);
                values.put("subjectOwnerId", byParticipantJid);
                db.update(TABLE_CHAT_ROOM, values, "chatRoomId=?", new String[]{chatRoomId});
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomSubject(Context ctx, String chatRoomId, String subject) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "updateChatRoomSubject...." + chatRoomId + "," + subject);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("subject", subject);
                db.update(TABLE_CHAT_ROOM, values, "chatRoomId=?", new String[]{chatRoomId});
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteChatRoom(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "deleteChatRoom...." + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CHAT_ROOM, "chatRoomId =?", new String[]{chatRoomId});
                existHashMap.put(chatRoomId, new CacheEntry(false));
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomType(Context ctx, String chatRoomId, int type) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "updateChatRoomType single...." + chatRoomId + "," + type);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("type", type);
                db.update(TABLE_CHAT_ROOM, values, "chatRoomId=?", new String[]{chatRoomId});
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllChatRooms(Context ctx) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "deleteAllChatRooms ......... ");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CHAT_ROOM, null, null);
                db.delete(TABLE_CHAT_ROOM_PARTICIPANT, null, null);
                existHashMap.clear();
            }
            finally {
                UCDBChatRoom.closeDb(db);
            }
        }
    }

    public static String existPhoneHistoryByNumber(Context ctx, String phoneNo) {
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "existPhoneHistoryByNumber...." + phoneNo);
        String cleanPhoneNo = PhoneNoUtil.cleanPhoneNo(phoneNo);
        if (TextUtils.isEmpty((CharSequence)cleanPhoneNo)) {
            return null;
        }
        if (cleanPhoneNo.length() <= 8) {
            String jid = UCDBChatRoom.tryToMatchPhone(ctx, cleanPhoneNo);
            if (jid != null) {
                return jid;
            }
        } else {
            for (int i = cleanPhoneNo.length(); i >= 8; --i) {
                String fuzzyNum = PhoneNoUtil.getLastDigit(cleanPhoneNo, i);
                String jid = UCDBChatRoom.tryToMatchPhone(ctx, fuzzyNum);
                if (jid == null) continue;
                return jid;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String tryToMatchPhone(Context ctx, String phoneNumber) {
        UCDBHelper helper;
        if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
            return null;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block6: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CHAT_ROOM, new String[]{"chatRoomId"}, "chatRoomId = ?", new String[]{phoneNumber}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block6;
                    String no = cursor.getString(0);
                    String testNo = no;
                    if (testNo.indexOf("_@@_") != -1) {
                        String[] xx = testNo.split("_@@_");
                        testNo = xx[xx.length - 1];
                    }
                    string = testNo;
                }
                catch (Throwable throwable) {
                    UCDBChatRoom.closeCursor(cursor);
                    UCDBChatRoom.closeDb(db);
                    throw throwable;
                }
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                return string;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existChatRoomById(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        CacheEntry entry;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "existChatRoomById...." + chatRoomId);
        if (existHashMap.containsKey(chatRoomId) && (entry = existHashMap.get(chatRoomId)) != null) {
            entry.hit();
            return entry.isExist();
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_CHAT_ROOM, "chatRoomId=?", new String[]{chatRoomId});
                boolean exist = count > 0L;
                existHashMap.put(chatRoomId, new CacheEntry(exist));
                bl = exist;
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasParticipants(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "isJoinChatRoomNow...." + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_CHAT_ROOM_PARTICIPANT, "chatRoomId=?", new String[]{chatRoomId});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> hasParticipantChatRoomIds(Context ctx) {
        UCDBHelper helper;
        UCDBChatRoom._log(UCDBChatRoom.class.getSimpleName(), "isJoinChatRoomNow....");
        HashSet<String> set = new HashSet<String>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.rawQuery("select chatRoomId from ChatRoomParticipant group by chatRoomId having count(chatRoomId)>0", null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Log.i(UCDBChatRoom.class.getSimpleName(), "chatRoomId:" + cursor.getString(0));
                        String roomId = cursor.getString(0);
                        if (!TextUtils.isNotBlank((CharSequence)roomId)) continue;
                        set.add(roomId.trim());
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findPhoneAddressBookChatRoomJids(Context ctx) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<String> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<String> chatRoomIdList = new ArrayList<String>();
                cursor = db.query(true, TABLE_CHAT_ROOM, new String[]{"chatRoomId"}, "chatRoomId like ?", new String[]{"%@mobilecontact"}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String chatRoomId = cursor.getString(0);
                        chatRoomIdList.add(chatRoomId);
                    } while (cursor.moveToNext());
                }
                arrayList = chatRoomIdList;
            }
            catch (Throwable throwable) {
                UCDBChatRoom.closeCursor(cursor);
                UCDBChatRoom.closeDb(db);
                throw throwable;
            }
            UCDBChatRoom.closeCursor(cursor);
            UCDBChatRoom.closeDb(db);
            return arrayList;
        }
    }
}

