/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.DeletedContact;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class UCDBDeletedJidContact
extends UCDBBase {
    private static Set<String> existHashSet = Collections.synchronizedSet(new HashSet());
    public static final String TABLE_DELETED_JID_CONTACT = "DeletedJidContact";
    public static final String FIELD_ID = "id";
    public static final String FIELD_JID = "jid";
    public static final String FIELD_OTHER_NAME = "otherName";
    public static final String FIELD_SUR_NAME = "surName";
    public static final String FIELD_GIVEN_NAME = "givenName";
    public static final String[] selectJidColumns = new String[]{"jid", "otherName", "surName", "givenName"};

    public static void createDeletedContact(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS DeletedJidContact");
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(TABLE_DELETED_JID_CONTACT);
        sql.append("(");
        sql.append(FIELD_ID);
        sql.append(" NUMERIC PRIMARY KEY IDENTITY, ");
        sql.append(FIELD_JID);
        sql.append(" LONGVARCHAR, ");
        sql.append(FIELD_OTHER_NAME);
        sql.append(" LONGVARCHAR, ");
        sql.append(FIELD_SUR_NAME);
        sql.append(" LONGVARCHAR, ");
        sql.append(FIELD_GIVEN_NAME);
        sql.append(" LONGVARCHAR");
        sql.append(")");
        db.execSQL(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existDeletedJidContact(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBDeletedJidContact._log(UCDBDeletedJidContact.class.getSimpleName(), "existDelectedContact...." + jid);
        if (existHashSet.contains(jid)) {
            return true;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                boolean result;
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_DELETED_JID_CONTACT, "jid=?", new String[]{jid});
                boolean bl2 = result = count > 0L;
                if (result) {
                    existHashSet.add(jid);
                }
                bl = result;
            }
            catch (Throwable throwable) {
                UCDBDeletedJidContact.closeDb(db);
                throw throwable;
            }
            UCDBDeletedJidContact.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeletedContact getDeletedJidContact(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBDeletedJidContact._log(UCDBDeletedJidContact.class.getSimpleName(), "getDeletedJidContact...." + jid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            DeletedContact deletedContact;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            DeletedContact deletedContact2 = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_DELETED_JID_CONTACT, selectJidColumns, "jid=?", new String[]{jid}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    deletedContact2 = new DeletedContact();
                    UCDBDeletedJidContact.setContactValue(cursor, deletedContact2);
                }
                deletedContact = deletedContact2;
            }
            catch (Throwable throwable) {
                UCDBDeletedJidContact.closeCursor(cursor);
                UCDBDeletedJidContact.closeDb(db);
                throw throwable;
            }
            UCDBDeletedJidContact.closeCursor(cursor);
            UCDBDeletedJidContact.closeDb(db);
            return deletedContact;
        }
    }

    private static void setContactValue(Cursor cursor, DeletedContact deletedContact) {
        deletedContact.setJid(cursor.getString(0));
        deletedContact.setOtherName(cursor.getString(1));
        deletedContact.setSurName(cursor.getString(2));
        deletedContact.setGivenName(cursor.getString(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdateDeletedJidContact(Context ctx, String jid, String otherName, String surName, String givenName) {
        UCDBHelper helper;
        UCDBDeletedJidContact._log(UCDBDeletedJidContact.class.getSimpleName(), "addDeletedJidContact" + jid + ")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                boolean result;
                db = helper.getWritableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_DELETED_JID_CONTACT, "jid=?", new String[]{jid});
                boolean bl = result = count > 0L;
                if (result) {
                    ContentValues values = new ContentValues();
                    values.put(FIELD_OTHER_NAME, otherName);
                    values.put(FIELD_SUR_NAME, surName);
                    values.put(FIELD_GIVEN_NAME, givenName);
                    db.update(TABLE_DELETED_JID_CONTACT, values, "jid=?", new String[]{jid});
                } else {
                    ContentValues values = new ContentValues();
                    values.put(FIELD_JID, jid);
                    values.put(FIELD_OTHER_NAME, otherName);
                    values.put(FIELD_SUR_NAME, surName);
                    values.put(FIELD_GIVEN_NAME, givenName);
                    db.insert(TABLE_DELETED_JID_CONTACT, null, values);
                }
                existHashSet.add(jid);
            }
            finally {
                UCDBDeletedJidContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdateDeletedJidContact(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBDeletedJidContact._log(UCDBDeletedJidContact.class.getSimpleName(), "addDeletedJidContact" + jid + ")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_DELETED_JID_CONTACT, "jid=?", new String[]{jid});
                if (count == 0L) {
                    ContentValues values = new ContentValues();
                    values.put(FIELD_JID, jid);
                    db.insert(TABLE_DELETED_JID_CONTACT, null, values);
                }
                existHashSet.add(jid);
            }
            finally {
                UCDBDeletedJidContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDeletedJidContact(Context ctx, String jid) {
        UCDBHelper helper;
        UCDBDeletedJidContact._log(UCDBDeletedJidContact.class.getSimpleName(), "removeDeletedJidContact" + jid + ")");
        existHashSet.remove(jid);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_DELETED_JID_CONTACT, "jid=?", new String[]{jid});
            }
            finally {
                UCDBDeletedJidContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllDeletedJidContacts(Context ctx) {
        UCDBHelper helper;
        UCDBDeletedJidContact._log(UCDBDeletedJidContact.class.getSimpleName(), "deleteAllDeletedJidContacts....");
        existHashSet.clear();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_DELETED_JID_CONTACT, null, null);
            }
            finally {
                UCDBDeletedJidContact.closeDb(db);
            }
        }
    }
}

