/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.web.LiteDepartment;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBFaxDoc;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public class UCDBDept
extends UCDBBase {
    public static final String TABLE_DEPT = "Department";
    public static final String KEY_DEPT_ID = "id";
    public static final String KEY_DEPT_NAME = "name";
    public static final String KEY_DEPT_PARENT_ID = "parentId";
    public static final String KEY_DEPT_DESCR = "descr";
    public static final String KEY_DEPT_DISP_TYPE = "displayType";
    public static final String KEY_DEPT_NAME_PATH = "namePath";
    public static final String KEY_DEPT_ID_PATH = "idPath";
    public static final String[] selectColumns = new String[]{"id", "name", "parentId", "descr", "displayType", "namePath", "idPath"};

    public static void createDeptTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS Department");
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(TABLE_DEPT);
        sql.append("(");
        sql.append(KEY_DEPT_ID);
        sql.append(" INTEGER, ");
        sql.append(KEY_DEPT_NAME);
        sql.append(" LONGVARCHAR, ");
        sql.append(KEY_DEPT_PARENT_ID);
        sql.append(" INTEGER, ");
        sql.append(KEY_DEPT_DESCR);
        sql.append(" LONGVARCHAR, ");
        sql.append(KEY_DEPT_DISP_TYPE);
        sql.append(" INTEGER, ");
        sql.append(KEY_DEPT_NAME_PATH);
        sql.append(" LONGVARCHAR, ");
        sql.append(KEY_DEPT_ID_PATH);
        sql.append(" LONGVARCHAR, ");
        sql.append(")");
        db.execSQL(sql.toString());
    }

    public static ContentValues createContentValues(LiteDepartment department) throws JSONException {
        ContentValues values = new ContentValues();
        values.put(KEY_DEPT_ID, department.getId());
        values.put(KEY_DEPT_NAME, department.getName());
        values.put(KEY_DEPT_PARENT_ID, department.getParentId());
        values.put(KEY_DEPT_DESCR, department.getDescr());
        values.put(KEY_DEPT_DISP_TYPE, department.getDisplayType());
        values.put(KEY_DEPT_NAME_PATH, department.getDepartmentNamePath());
        values.put(KEY_DEPT_ID_PATH, department.getDepartmentIdPath());
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDept(Context ctx, LiteDepartment department) {
        UCDBHelper helper;
        UCDBDept._log(UCDBFaxDoc.class.getSimpleName(), "addDept....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.insert(TABLE_DEPT, null, UCDBDept.createContentValues(department));
            }
            catch (JSONException e) {
                Log.w(UCDBFaxDoc.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            finally {
                UCDBDept.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDept(Context ctx, long deptId, LiteDepartment department) {
        UCDBHelper helper;
        UCDBDept._log(UCDBFaxDoc.class.getSimpleName(), "updateDept....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = UCDBDept.createContentValues(department);
                db.update(TABLE_DEPT, values, "id=?", new String[]{String.valueOf(deptId)});
            }
            catch (JSONException e) {
                Log.w(UCDBFaxDoc.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            finally {
                UCDBDept.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getAllDeptList(Context ctx) {
        UCDBHelper helper;
        UCDBDept._log(UCDBFaxDoc.class.getSimpleName(), "geAllDeptIdList....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Long> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            ArrayList<Long> deptList = new ArrayList<Long>();
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_DEPT, new String[]{KEY_DEPT_ID}, null, null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        deptList.add(cursor.getLong(0));
                    } while (cursor.moveToNext());
                }
                arrayList = deptList;
            }
            catch (Throwable throwable) {
                UCDBDept.closeCursor(cursor);
                UCDBDept.closeDb(db);
                throw throwable;
            }
            UCDBDept.closeCursor(cursor);
            UCDBDept.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDept(Context context, long deptId) {
        UCDBHelper helper;
        UCDBDept._log(UCDBFaxDoc.class.getSimpleName(), "deleteDept...." + deptId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(context);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_DEPT, "id = ?", new String[]{String.valueOf(deptId)});
            }
            finally {
                UCDBDept.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDeptExist(Context ctx, long deptId) {
        UCDBHelper helper;
        UCDBDept._log(UCDBFaxDoc.class.getSimpleName(), "isDeptExist ..." + deptId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_DEPT, "id=? ", new String[]{String.valueOf(deptId)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBDept.closeCursor(cursor);
                UCDBDept.closeDb(db);
                throw throwable;
            }
            UCDBDept.closeCursor(cursor);
            UCDBDept.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteDepartment getDept(Context ctx, long deptId) {
        UCDBHelper helper;
        UCDBDept._log(UCDBFaxDoc.class.getSimpleName(), "getDept....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteDepartment liteDepartment;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_DEPT, selectColumns, "id=?", new String[]{String.valueOf(deptId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteDepartment liteDept = new LiteDepartment();
                    UCDBDept.setDeptValue(cursor, liteDept);
                    liteDepartment = liteDept;
                }
                catch (Throwable throwable) {
                    UCDBDept.closeCursor(cursor);
                    UCDBDept.closeDb(db);
                    throw throwable;
                }
                UCDBDept.closeCursor(cursor);
                UCDBDept.closeDb(db);
                return liteDepartment;
            }
            LiteDepartment liteDepartment = null;
            UCDBDept.closeCursor(cursor);
            UCDBDept.closeDb(db);
            return liteDepartment;
        }
    }

    private static void setDeptValue(Cursor cursor, LiteDepartment liteDept) {
        liteDept.setId(cursor.getLong(0));
        liteDept.setName(cursor.getString(1));
        liteDept.setParentId(cursor.getLong(2));
        liteDept.setDescr(cursor.getString(3));
        liteDept.setDisplayType(cursor.getInt(4));
        liteDept.setDepartmentIdPath(cursor.getString(5));
        liteDept.setDepartmentNamePath(cursor.getString(6));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteDepartment getDeptByNamePath(Context ctx, String namePath) {
        UCDBHelper helper;
        UCDBDept._log(UCDBFaxDoc.class.getSimpleName(), "getDeptByNamePath....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteDepartment liteDepartment;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_DEPT, selectColumns, "namePath=?", new String[]{namePath}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteDepartment liteDept = new LiteDepartment();
                    UCDBDept.setDeptValue(cursor, liteDept);
                    liteDepartment = liteDept;
                }
                catch (Throwable throwable) {
                    UCDBDept.closeCursor(cursor);
                    UCDBDept.closeDb(db);
                    throw throwable;
                }
                UCDBDept.closeCursor(cursor);
                UCDBDept.closeDb(db);
                return liteDepartment;
            }
            LiteDepartment liteDepartment = null;
            UCDBDept.closeCursor(cursor);
            UCDBDept.closeDb(db);
            return liteDepartment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllDepts(Context ctx) {
        UCDBHelper helper;
        UCDBDept._log(UCDBFaxDoc.class.getSimpleName(), "deleteAllDepts....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_DEPT, null, null);
            }
            finally {
                UCDBDept.closeDb(db);
            }
        }
    }
}

