/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteOutboundPrefix;
import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.ContactDataHelper;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class UCDBExternalContact
extends UCDBBase {
    public static final String TABLE_EXTERNAL_CONTACT = "ExternalContact";
    public static final String TABLE_EXTERNAL_NUMBER = "ContactExternalNumber";

    public static void createExternalContactTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ExternalContact");
        String CREATE_EXTERNAL_CONTACT_TABLE = "CREATE TABLE ExternalContact(id NUMERIC,name LONGVARCHAR,nameForPinYin LONGVARCHAR,company LONGVARCHAR,comapnytel LONGVARCHAR,title LONGVARCHAR,organization LONGVARCHAR,siteId INTEGER,photoFlag LONGVARCHAR,personalPhoto LONGVARCHAR,personalPhotoTimestamp NUMERIC,email LONGVARCHAR,birthday LONGVARCHAR,contactCount INTEGER DEFAULT 0,currentPhotoTimestamp NUMERIC)";
        db.execSQL(CREATE_EXTERNAL_CONTACT_TABLE);
    }

    public static void createExternalNumberTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ContactExternalNumber");
        String CREATE_EXTERNAL_NUMBER_TABLE = "CREATE TABLE ContactExternalNumber(id NUMERIC,type INTEGER,number LONGVARCHAR)";
        db.execSQL(CREATE_EXTERNAL_NUMBER_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addContact(Context ctx, LiteMyContact contact) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "addContact...." + String.valueOf(contact));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.insert(TABLE_EXTERNAL_CONTACT, null, ContactDataHelper.createContactAddValues(contact));
                for (int i = 0; contact.getTelephones() != null && i < contact.getTelephones().size(); ++i) {
                    LiteTeleNumber number = contact.getTelephones().get(i);
                    db.insert(TABLE_EXTERNAL_NUMBER, null, ContactDataHelper.createNumberAddValues(contact, number));
                }
            }
            finally {
                UCDBExternalContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LiteMyContact getExternalContactById(Context ctx, long id) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "getExteranalContactByid...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            LiteMyContact liteMyContact;
            SQLiteDatabase db = null;
            Cursor cursor1 = null;
            Cursor cursor2 = null;
            try {
                db = helper.getReadableDatabase();
                LiteMyContact contact = null;
                String idStr = String.valueOf(id);
                cursor1 = db.query(TABLE_EXTERNAL_CONTACT, ContactDataHelper.externalContactSelectColumns, "id=?", new String[]{idStr}, null, null, null, null);
                if (cursor1 != null && cursor1.moveToFirst()) {
                    contact = new LiteMyContact();
                    ContactDataHelper.setContactValue(cursor1, contact);
                }
                if (contact != null) {
                    ArrayList<LiteTeleNumber> numbers = new ArrayList<LiteTeleNumber>();
                    cursor2 = db.query(TABLE_EXTERNAL_NUMBER, null, "id=?", new String[]{idStr}, null, null, null, null);
                    if (cursor2 != null && cursor2.moveToFirst()) {
                        do {
                            LiteTeleNumber number = new LiteTeleNumber();
                            ContactDataHelper.setNumberValue(cursor2, number);
                            numbers.add(number);
                        } while (cursor2.moveToNext());
                    }
                    contact.setTelephones(numbers);
                }
                liteMyContact = contact;
            }
            catch (Throwable throwable) {
                UCDBExternalContact.closeCursor(cursor1);
                UCDBExternalContact.closeCursor(cursor2);
                UCDBExternalContact.closeDb(db);
                throw throwable;
            }
            UCDBExternalContact.closeCursor(cursor1);
            UCDBExternalContact.closeCursor(cursor2);
            UCDBExternalContact.closeDb(db);
            return liteMyContact;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, LiteMyContact> getAllExternalContactHeaders(Context ctx) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<String, LiteMyContact> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                HashMap<String, LiteMyContact> myMap = new HashMap<String, LiteMyContact>();
                cursor = db.query(TABLE_EXTERNAL_CONTACT, ContactDataHelper.externalContactSelectColumns, null, null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteMyContact liteMyContact = new LiteMyContact();
                        ContactDataHelper.setContactValue(cursor, liteMyContact);
                        myMap.put(liteMyContact.getName(), liteMyContact);
                    } while (cursor.moveToNext());
                }
                hashMap = myMap;
            }
            catch (Throwable throwable) {
                UCDBExternalContact.closeCursor(cursor);
                UCDBExternalContact.closeDb(db);
                throw throwable;
            }
            UCDBExternalContact.closeCursor(cursor);
            UCDBExternalContact.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<AddressBookGroup<T>> findExternalContacts(Context ctx, String searchKey) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "findExternalContacts...." + searchKey);
        ArrayList<AddressBookGroup<T>> dataList = new ArrayList<AddressBookGroup<T>>();
        AddressBookGroup unKnownGroup = new AddressBookGroup("#", "#");
        AddressBookGroup currentGroup = null;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<AddressBookGroup<T>> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                boolean blank = UCDBExternalContact.isBlank(searchKey);
                String[] selectionArgs = null;
                String selection = null;
                String orderby = "UPPER( name) ASC";
                Locale locale = I18NUtil.getAppLocale();
                if (!Locale.TAIWAN.equals(locale)) {
                    orderby = "UPPER( nameForPinYin) ASC";
                }
                if (!blank) {
                    String searchKeyUpper = searchKey.toUpperCase();
                    if (Locale.TAIWAN.equals(locale)) {
                        selection = "(UPPER(name) like ? OR UPPER(organization) like ? OR UPPER(comapnytel) like ?)";
                        selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                    } else {
                        selection = "(UPPER(name) like ? OR UPPER(nameForPinYin) like ? OR UPPER(organization) like ? OR UPPER(comapnytel) like ?)";
                        selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                    }
                }
                if ((cursor = db.query(TABLE_EXTERNAL_CONTACT, ContactDataHelper.externalContactSelectColumns, selection, selectionArgs, null, null, orderby, null)) != null && cursor.moveToFirst()) {
                    do {
                        LiteMyContact contact = new LiteMyContact();
                        ContactDataHelper.setContactValue(cursor, contact);
                        LiteMyContact record = contact;
                        String dispName = contact.getName();
                        if (!Locale.TAIWAN.equals(locale)) {
                            dispName = contact.getNameForPinYin();
                        }
                        if (blank) {
                            if (TextUtils.isBlank((CharSequence)dispName) || !dispName.matches("[a-zA-Z].*")) {
                                unKnownGroup.getDataList().add(record);
                                continue;
                            }
                            String indexChar = dispName.substring(0, 1).toUpperCase();
                            if (currentGroup == null) {
                                currentGroup = new AddressBookGroup(indexChar, indexChar);
                                dataList.add(currentGroup);
                                currentGroup.getDataList().add(record);
                                continue;
                            }
                            if (!currentGroup.getId().equals(indexChar)) {
                                currentGroup = new AddressBookGroup(indexChar, indexChar);
                                dataList.add(currentGroup);
                                currentGroup.getDataList().add(record);
                                continue;
                            }
                            currentGroup.getDataList().add(record);
                            continue;
                        }
                        unKnownGroup.getDataList().add(record);
                    } while (cursor.moveToNext());
                    dataList.add(unKnownGroup);
                } else {
                    UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "search " + searchKey + ", size is 0");
                }
                arrayList = dataList;
            }
            catch (Throwable throwable) {
                UCDBExternalContact.closeCursor(cursor);
                UCDBExternalContact.closeDb(db);
                throw throwable;
            }
            UCDBExternalContact.closeCursor(cursor);
            UCDBExternalContact.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getExternalContactByPhoneNo(Context ctx, String phoneNo) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "getExternalContactByPhoneNo...." + phoneNo);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                long l;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_EXTERNAL_NUMBER, new String[]{"id"}, "number=?", new String[]{String.valueOf(phoneNo)}, null, null, null, null);
                    if (cursor == null || cursor.getCount() <= 0) break block5;
                    cursor.moveToFirst();
                    l = cursor.getLong(0);
                }
                catch (Throwable throwable) {
                    UCDBExternalContact.closeCursor(cursor);
                    UCDBExternalContact.closeDb(db);
                    throw throwable;
                }
                UCDBExternalContact.closeCursor(cursor);
                UCDBExternalContact.closeDb(db);
                return l;
            }
            long l = -1L;
            UCDBExternalContact.closeCursor(cursor);
            UCDBExternalContact.closeDb(db);
            return l;
        }
    }

    public static long getMatchedExternalContactIdByPhoneNo(Context ctx, String phoneNo, boolean isOutbound) {
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "getExternalContactIdByPhoneNo...." + phoneNo);
        String cleanPhoneNo = PhoneNoUtil.cleanPhoneNo(phoneNo);
        if (TextUtils.isEmpty((CharSequence)cleanPhoneNo)) {
            return -1L;
        }
        if (isOutbound) {
            List<LiteOutboundPrefix> outboundPrefixList = UCDBSite.getAllOutboundPrefixs(ctx);
            for (LiteOutboundPrefix prefix : outboundPrefixList) {
                long id;
                String prefixStr = prefix.getPrefix();
                if (!TextUtils.isNotEmpty((CharSequence)prefixStr)) continue;
                String phoneNumberNoPrefix = cleanPhoneNo;
                if (phoneNumberNoPrefix.startsWith(prefixStr)) {
                    phoneNumberNoPrefix = PhoneNoUtil.getLastDigit(cleanPhoneNo, cleanPhoneNo.length() - prefixStr.length());
                }
                if ((id = UCDBExternalContact.tryToMatchExternalContactPhone(ctx, phoneNumberNoPrefix)) == -1L) continue;
                return id;
            }
        }
        if (cleanPhoneNo.length() <= 8) {
            long id = UCDBExternalContact.tryToMatchExternalContactPhone(ctx, cleanPhoneNo);
            if (id != -1L) {
                return id;
            }
        } else {
            for (int i = cleanPhoneNo.length(); i >= 8; --i) {
                String fuzzyNum = PhoneNoUtil.getLastDigit(cleanPhoneNo, i);
                long id = UCDBExternalContact.tryToMatchExternalContactPhone(ctx, fuzzyNum);
                if (id == -1L) continue;
                return id;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long tryToMatchExternalContactPhone(Context ctx, String phoneNumber) {
        UCDBHelper helper;
        if (TextUtils.isEmpty((CharSequence)phoneNumber)) {
            return -1L;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block6: {
                long l;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_EXTERNAL_NUMBER, new String[]{"id"}, "number = ?", new String[]{phoneNumber}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block6;
                    l = cursor.getLong(0);
                }
                catch (Throwable throwable) {
                    UCDBExternalContact.closeCursor(cursor);
                    UCDBExternalContact.closeDb(db);
                    throw throwable;
                }
                UCDBExternalContact.closeCursor(cursor);
                UCDBExternalContact.closeDb(db);
                return l;
            }
            long l = -1L;
            UCDBExternalContact.closeCursor(cursor);
            UCDBExternalContact.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateContact(Context ctx, LiteMyContact contact) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "updateContact...." + String.valueOf(contact));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String idStr = String.valueOf(contact.getId());
                db.update(TABLE_EXTERNAL_CONTACT, ContactDataHelper.createContactUpdateValues(contact), "id = ?", new String[]{idStr});
                db.delete(TABLE_EXTERNAL_NUMBER, "id = ?", new String[]{idStr});
                for (int i = 0; contact.getTelephones() != null && i < contact.getTelephones().size(); ++i) {
                    LiteTeleNumber number = contact.getTelephones().get(i);
                    db.insert(TABLE_EXTERNAL_NUMBER, null, ContactDataHelper.createNumberAddValues(contact, number));
                }
            }
            finally {
                UCDBExternalContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCurrentPhotoTimestamp(Context ctx, long id, long timestamp) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "updateCurrentPhotoTimestamp...." + id + "," + timestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("photoFlag", true);
                values.put("currentPhotoTimestamp", timestamp);
                db.update(TABLE_EXTERNAL_CONTACT, values, "id = ?", new String[]{String.valueOf(id)});
            }
            finally {
                UCDBExternalContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateContactPhotoTimestamp(Context ctx, long id, long timestamp) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "updateContactPhotoTimestamp...." + id + "," + timestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("photoFlag", true);
                values.put("personalPhotoTimestamp", timestamp);
                db.update(TABLE_EXTERNAL_CONTACT, values, "id = ?", new String[]{String.valueOf(id)});
            }
            finally {
                UCDBExternalContact.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getContactPhotoTimestamp(Context ctx, long id) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "getContactPhotoTimestamp...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String selection = "id = ?";
                String[] selectionArgs = new String[]{String.valueOf(id)};
                String[] columns = new String[]{"personalPhotoTimestamp"};
                Cursor cursor = null;
                long timestamp = -1L;
                cursor = db.query(TABLE_EXTERNAL_CONTACT, columns, selection, selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    timestamp = cursor.getLong(0);
                }
                l = timestamp;
            }
            catch (Throwable throwable) {
                UCDBExternalContact.closeDb(db);
                throw throwable;
            }
            UCDBExternalContact.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getContactPhotoTimestamps(Context ctx, long id) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "getContactPhotoTimestamps...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long[] lArray;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String selection = "id = ?";
                String[] selectionArgs = new String[]{String.valueOf(id)};
                String[] columns = new String[]{"personalPhotoTimestamp", "currentPhotoTimestamp"};
                Cursor cursor = null;
                long[] timestamps = new long[]{-1L, -1L};
                cursor = db.query(TABLE_EXTERNAL_CONTACT, columns, selection, selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    timestamps[0] = cursor.getLong(0);
                    timestamps[1] = cursor.getLong(1);
                }
                lArray = timestamps;
            }
            catch (Throwable throwable) {
                UCDBExternalContact.closeDb(db);
                throw throwable;
            }
            UCDBExternalContact.closeDb(db);
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCurrentPhotoTimestamp(Context ctx, long id) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "getCurrentPhotoTimestamp...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String selection = "id = ?";
                String[] selectionArgs = new String[]{String.valueOf(id)};
                String[] columns = new String[]{"currentPhotoTimestamp"};
                Cursor cursor = null;
                long timestamp = -1L;
                cursor = db.query(TABLE_EXTERNAL_CONTACT, columns, selection, selectionArgs, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    timestamp = cursor.getLong(0);
                }
                l = timestamp;
            }
            catch (Throwable throwable) {
                UCDBExternalContact.closeDb(db);
                throw throwable;
            }
            UCDBExternalContact.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteExternalContact(Context ctx, long id) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "deleteExternalContact...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String whereCause = "id=? ";
                String[] whereArgs = new String[]{String.valueOf(id)};
                int rows = db.delete(TABLE_EXTERNAL_CONTACT, whereCause, whereArgs);
                db.delete(TABLE_EXTERNAL_NUMBER, whereCause, whereArgs);
                bl = rows > 0;
            }
            catch (Throwable throwable) {
                UCDBExternalContact.closeDb(db);
                throw throwable;
            }
            UCDBExternalContact.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllExternalContacts(Context ctx) {
        UCDBHelper helper;
        UCDBExternalContact._log(UCDBExternalContact.class.getSimpleName(), "deleteAllExternalContacts....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_EXTERNAL_CONTACT, null, null);
                db.delete(TABLE_EXTERNAL_NUMBER, null, null);
            }
            finally {
                UCDBExternalContact.closeDb(db);
            }
        }
    }
}

