/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.bean.SysRecordingItem;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class UCDBRecording
extends UCDBBase {
    public static final String TABLE_RECORDING_DOC = "Recording";
    public static final String KEY_RECORDING_RECORD_ID = "recordId";
    public static final String KEY_RECORDING_RECORD_SITE_ID = "recordSiteId";
    public static final String KEY_RECORDING_CONTACT_LOG_ID = "contactLogId";
    public static final String KEY_RECORDING_UNIQUE_ID = "uniqueId";
    public static final String KEY_RECORDING_START = "start";
    public static final String KEY_RECORDING_ANSWER = "answer";
    public static final String KEY_RECORDING_END = "end";
    public static final String KEY_RECORDING_DIAL_RESULT = "dialResult";
    public static final String KEY_RECORDING_CALL_TYPE = "callType";
    public static final String KEY_RECORDING_FILE_SIZE = "fileSize";
    public static final String KEY_RECORDING_SRC_TYPE = "srcType";
    public static final String KEY_RECORDING_SRC_EXT = "srcExt";
    public static final String KEY_RECORDING_SRC_DB_ID = "srcDbid";
    public static final String KEY_RECORDING_DST_TYPE = "dstType";
    public static final String KEY_RECORDING_DST_EXT = "dstExt";
    public static final String KEY_RECORDING_DST_DB_ID = "dstDbid";
    public static final String KEY_RECORDING_ENCODED_RECORD_KEY = "encodedRecordKey";
    public static final String[] selectColumns = new String[]{"recordId", "recordSiteId", "contactLogId", "uniqueId", "start", "answer", "end", "dialResult", "callType", "fileSize", "srcType", "srcExt", "srcDbid", "dstType", "dstExt", "dstDbid", "encodedRecordKey"};

    public static void createRecordingTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS Recording");
        String CREATE_RECORDING = "CREATE TABLE Recording(contactLogId INTEGER PRIMARY KEY IDENTITY, recordId INTEGER, recordSiteId INTEGER, uniqueId LONGVARCHAR, start LONGVARCHAR, answer LONGVARCHAR, end LONGVARCHAR, dialResult INTEGER, callType INTEGER, fileSize INTEGER, srcType LONGVARCHAR, srcExt LONGVARCHAR, srcDbid INTEGER, dstType LONGVARCHAR, dstExt LONGVARCHAR, dstDbid INTEGER, encodedRecordKey LONGVARCHAR)";
        db.execSQL(CREATE_RECORDING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecording(Context ctx, JSONObject liteRecordingDoc) {
        UCDBHelper helper;
        UCDBRecording._log(UCDBRecording.class.getSimpleName(), "addRecording");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.insert(TABLE_RECORDING_DOC, null, UCDBRecording.createContentValues(liteRecordingDoc));
            }
            catch (Throwable e) {
                Log.w(UCDBRecording.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            finally {
                UCDBRecording.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRecording(Context ctx, Long contactLogId, JSONObject liteRecordingDoc) {
        UCDBHelper helper;
        UCDBRecording._log(UCDBRecording.class.getSimpleName(), "updateRecording");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_RECORDING_DOC, UCDBRecording.createContentValues(liteRecordingDoc), "contactLogId = ?", new String[]{String.valueOf(contactLogId)});
            }
            catch (Throwable e) {
                Log.w(UCDBRecording.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            finally {
                UCDBRecording.closeDb(db);
            }
        }
    }

    public static ContentValues createContentValues(JSONObject liteRecordingDoc) throws JSONException {
        ContentValues values = new ContentValues();
        values.put(KEY_RECORDING_CONTACT_LOG_ID, liteRecordingDoc.getLong(KEY_RECORDING_CONTACT_LOG_ID));
        values.put(KEY_RECORDING_RECORD_ID, liteRecordingDoc.getLong(KEY_RECORDING_RECORD_ID));
        values.put(KEY_RECORDING_RECORD_SITE_ID, liteRecordingDoc.getLong(KEY_RECORDING_RECORD_SITE_ID));
        values.put(KEY_RECORDING_UNIQUE_ID, liteRecordingDoc.getString(KEY_RECORDING_UNIQUE_ID));
        values.put(KEY_RECORDING_ENCODED_RECORD_KEY, liteRecordingDoc.getString(KEY_RECORDING_ENCODED_RECORD_KEY));
        values.put(KEY_RECORDING_START, liteRecordingDoc.getString("startTime"));
        values.put(KEY_RECORDING_ANSWER, liteRecordingDoc.getString("answerTime"));
        values.put(KEY_RECORDING_END, liteRecordingDoc.getString("endTime"));
        values.put(KEY_RECORDING_DIAL_RESULT, liteRecordingDoc.getInt(KEY_RECORDING_DIAL_RESULT));
        values.put(KEY_RECORDING_CALL_TYPE, liteRecordingDoc.getInt(KEY_RECORDING_CALL_TYPE));
        values.put(KEY_RECORDING_FILE_SIZE, liteRecordingDoc.getLong(KEY_RECORDING_FILE_SIZE));
        values.put(KEY_RECORDING_SRC_TYPE, liteRecordingDoc.getString(KEY_RECORDING_SRC_TYPE));
        values.put(KEY_RECORDING_SRC_EXT, liteRecordingDoc.getString(KEY_RECORDING_SRC_EXT));
        values.put(KEY_RECORDING_SRC_DB_ID, liteRecordingDoc.getInt(KEY_RECORDING_SRC_DB_ID));
        values.put(KEY_RECORDING_DST_TYPE, liteRecordingDoc.getString(KEY_RECORDING_DST_TYPE));
        values.put(KEY_RECORDING_DST_EXT, liteRecordingDoc.getString(KEY_RECORDING_DST_EXT));
        values.put(KEY_RECORDING_DST_DB_ID, liteRecordingDoc.getInt(KEY_RECORDING_DST_DB_ID));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SysRecordingItem getRecordingInfoByContactLogId(Context ctx, Long contactLogId) {
        UCDBHelper helper;
        UCDBRecording._log(UCDBRecording.class.getSimpleName(), "getRecordingInfoByContactLogId....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                SysRecordingItem sysRecordingItem;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_RECORDING_DOC, new String[]{KEY_RECORDING_ENCODED_RECORD_KEY, KEY_RECORDING_RECORD_SITE_ID, KEY_RECORDING_FILE_SIZE}, "contactLogId=?", new String[]{contactLogId.toString()}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    SysRecordingItem item = new SysRecordingItem();
                    item.setEncodedRecordKey(cursor.getString(0));
                    item.setRecordSiteId(cursor.getLong(1));
                    item.setFileSize(cursor.getLong(2));
                    sysRecordingItem = item;
                }
                catch (Throwable throwable) {
                    UCDBRecording.closeCursor(cursor);
                    UCDBRecording.closeDb(db);
                    throw throwable;
                }
                UCDBRecording.closeCursor(cursor);
                UCDBRecording.closeDb(db);
                return sysRecordingItem;
            }
            SysRecordingItem sysRecordingItem = null;
            UCDBRecording.closeCursor(cursor);
            UCDBRecording.closeDb(db);
            return sysRecordingItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllRecording(Context ctx) {
        UCDBHelper helper;
        UCDBRecording._log(UCDBRecording.class.getSimpleName(), "deleteAllRecording....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_RECORDING_DOC, null, null);
            }
            finally {
                UCDBRecording.closeDb(db);
            }
        }
    }
}

