/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.AssetManager;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabaseImpl;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@MigratedFromMobileApp
public class UserDatabase {
    public static final String DATABASE_NAME = "ucUserData.db";
    public static final String DATABASE_URL = FileUtil.getDatabaseDir().toURI().getPath().toString() + "ucUserData.db";
    private final Context mCtx;
    public static volatile UserDatabase db;
    private static Object lock;
    SQLiteDatabase readableDB;
    SQLiteDatabase writableDB;

    private UserDatabase(Context context) {
        this.mCtx = context;
        this.createWritableDatabase();
        this.createReadableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserDatabase getDB(Context context) {
        if (db == null) {
            Object object = lock;
            synchronized (object) {
                if (db == null) {
                    db = new UserDatabase(context);
                    db.createWritableDatabase();
                    db.createReadableDatabase();
                }
            }
        }
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabase(Context context) {
        if (db != null) {
            Object object = lock;
            synchronized (object) {
                UserDatabase.db.readableDB.closeDatabase();
                UserDatabase.db.readableDB = null;
                UserDatabase.db.writableDB.closeDatabase();
                UserDatabase.db.writableDB = null;
                db = null;
            }
        }
    }

    private void createReadableDatabase() {
        try {
            Properties prop = new Properties();
            prop.setProperty("shutdown", "true");
            prop.setProperty("readonly", "true");
            prop.setProperty("hsqldb.lock_file", "false");
            this.readableDB = new SQLiteDatabaseImpl(DATABASE_URL, prop, true);
        }
        catch (Exception e) {
            Log.e(UserDatabase.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private void createWritableDatabase() {
        try {
            Properties prop = new Properties();
            prop.setProperty("shutdown", "true");
            prop.setProperty("hsqldb.lock_file", "false");
            this.writableDB = new SQLiteDatabaseImpl(DATABASE_URL, prop, false);
        }
        catch (Exception e) {
            Log.e(UserDatabase.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private SQLiteDatabase getReadableDatabase() throws SQLException {
        return this.readableDB;
    }

    private SQLiteDatabase getWritableDatabase() throws SQLException {
        this.writableDB.beginTransaction();
        return this.writableDB;
    }

    public void onCreate(SQLiteDatabase database) {
        Log.i(this.getClass().getSimpleName(), "onCreate");
        database.execSQL("create table uc_conferenceroom (id integer primary key IDENTITY, roomid NUMERIC , role LONGVARCHAR not null);");
        database.execSQL("create table uc_sentance (id integer primary key IDENTITY, content LONGVARCHAR not null, hitrate NUMERIC DEFAULT 0);");
        database.execSQL("create table uc_symbol(id integer primary key IDENTITY, content LONGVARCHAR not null, hitrate NUMERIC DEFAULT 0);");
        database.execSQL("create table uc_sticker(id integer primary key IDENTITY, content LONGVARCHAR not null, hitrate NUMERIC DEFAULT 0);");
        database.execSQL("create table notifications_settings(id integer primary key IDENTITY, setting NUMERIC DEFAULT 0, value LONGVARCHAR);");
        database.execSQL("create table notifications_disable_list(id integer primary key IDENTITY, chatroomid LONGVARCHAR not null);");
        database.execSQL("create table pending_message(id integer primary key IDENTITY, chatroomid LONGVARCHAR not null , message LONGVARCHAR);");
    }

    public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        try {
            database = this.getWritableDatabase();
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "onUpgrade", e);
        }
        Log.i(this.getClass().getSimpleName(), "onUpgrade " + oldVersion + " new " + newVersion);
        database.execSQL("DROP TABLE IF EXISTS uc_conferenceroom");
        database.execSQL("DROP TABLE IF EXISTS uc_sentance");
        database.execSQL("DROP TABLE IF EXISTS uc_symbol");
        database.execSQL("DROP TABLE IF EXISTS uc_sticker");
        database.execSQL("DROP TABLE IF EXISTS notifications_settings");
        database.execSQL("DROP TABLE IF EXISTS notifications_disable_list");
        database.execSQL("DROP TABLE IF EXISTS pending_message");
        this.onCreate(database);
    }

    public void clearDatabase() {
        Log.i(this.getClass().getSimpleName(), "clearDatabase");
        this.writableDB.execSQL("DROP TABLE IF EXISTS uc_conferenceroom");
        this.writableDB.execSQL("DROP TABLE IF EXISTS uc_sentance");
        this.writableDB.execSQL("DROP TABLE IF EXISTS uc_symbol");
        this.writableDB.execSQL("DROP TABLE IF EXISTS uc_sticker");
        this.writableDB.execSQL("DROP TABLE IF EXISTS notifications_settings");
        this.writableDB.execSQL("DROP TABLE IF EXISTS notifications_disable_list");
        this.writableDB.execSQL("DROP TABLE IF EXISTS pending_message");
        this.onCreate(this.writableDB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertConferenceRoleInfo(String role, long roomid) {
        SQLiteDatabase database = null;
        ContentValues values = new ContentValues();
        values.put("role", role);
        values.put("roomid", roomid);
        long id = -1L;
        try {
            database = this.getWritableDatabase();
            id = database.insertOrThrow("uc_conferenceroom", null, values);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "insertConference", e);
        }
        finally {
            this.close(database);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConferenceRoleInfo(String role, long roomid) {
        SQLiteDatabase database = null;
        String whereClause = "roomid=?";
        String[] whereArgs = new String[]{String.valueOf(roomid)};
        ContentValues values = new ContentValues();
        values.put("role", role);
        values.put("roomid", roomid);
        try {
            database = this.getWritableDatabase();
            database.update("uc_conferenceroom", values, whereClause, whereArgs);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "updateConference", e);
        }
        finally {
            this.close(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> queryConferenceRoleInfo(long roomid) {
        SQLiteDatabase database = null;
        String selection = "roomid=?";
        String[] selectionArg = new String[]{String.valueOf(roomid)};
        Cursor cursor = null;
        HashMap<String, Object> data = null;
        try {
            database = this.getReadableDatabase();
            cursor = database.query("uc_conferenceroom", null, selection, selectionArg, null, null, null);
            if (cursor != null) {
                int count = cursor.getCount();
                if (count > 0 && !cursor.isLast()) {
                    cursor.moveToNext();
                    int roleIndex = cursor.getColumnIndexOrThrow("role");
                    int idIndex = cursor.getColumnIndexOrThrow("id");
                    int roomIdIndex = cursor.getColumnIndexOrThrow("roomid");
                    data = new HashMap<String, Object>();
                    data.put("role", cursor.getString(roleIndex));
                    data.put("id", cursor.getInt(idIndex));
                    data.put("roomid", cursor.getInt(roomIdIndex));
                }
            } else {
                Log.e(this.getClass().getSimpleName(), "queryConference fail!");
            }
            this.close(cursor);
            this.close(database);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "queryConference", e);
        }
        finally {
            this.close(cursor);
            this.close(database);
        }
        return data;
    }

    public static String[] getTimes(String time) {
        String[] result = null;
        if (TextUtils.isBlank((CharSequence)time)) {
            return null;
        }
        result = time.split("-");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConferenceRoleInfo(long roomid) {
        SQLiteDatabase database = null;
        String whereClause = "roomid=?";
        String[] whereArgs = new String[]{String.valueOf(roomid)};
        int index = -1;
        try {
            database = this.getWritableDatabase();
            index = database.delete("uc_conferenceroom", whereClause, whereArgs);
            Log.i(this.getClass().getSimpleName(), " deleteConference :" + index);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "queryConference", e);
        }
        finally {
            this.close(database);
        }
    }

    private boolean importSentanceData(SQLiteDatabase db, String filename, String tableName, String[] sentance) {
        ArrayList<String> data = new ArrayList<String>();
        boolean inserted = false;
        if (sentance != null && sentance.length > 0) {
            for (String i : sentance) {
                data.add(i);
            }
            if (data.size() > 0) {
                inserted = this.batchInsert(db, data, tableName);
            }
        }
        return inserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importAssertData(SQLiteDatabase db, String filename, String tableName) {
        AssetManager asset = this.mCtx.getAssets();
        InputStream in = null;
        InputStreamReader inReader = null;
        BufferedReader bReader = null;
        ArrayList<String> data = new ArrayList<String>();
        boolean inserted = false;
        try {
            in = asset.open(filename);
            inReader = new InputStreamReader(in, "UTF-8");
            bReader = new BufferedReader(inReader);
            String line = bReader.readLine();
            while (line != null) {
                data.add(line);
                line = bReader.readLine();
            }
            this.close(bReader);
            this.close(inReader);
            this.close(in);
        }
        catch (IOException e) {
            try {
                Log.e(this.getClass().getSimpleName(), "importFromFile", e);
                this.close(bReader);
                this.close(inReader);
                this.close(in);
            }
            catch (Throwable throwable) {
                this.close(bReader);
                this.close(inReader);
                this.close(in);
                throw throwable;
            }
        }
        if (data.size() > 0) {
            inserted = this.batchInsert(db, data, tableName);
        }
        return inserted;
    }

    public boolean batchInsert(SQLiteDatabase database, ArrayList<String> data, String table) {
        boolean inserted = false;
        try {
            for (String line : data) {
                ContentValues values = new ContentValues();
                values.put("content", line);
                database.insertOrThrow(table, null, values);
            }
            inserted = true;
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "batchInsert", e);
        }
        return inserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, ArrayList<ContentValues>> queryAll() {
        HashMap<String, ArrayList<ContentValues>> result = new HashMap<String, ArrayList<ContentValues>>();
        SQLiteDatabase database = null;
        try {
            database = this.getReadableDatabase();
            ArrayList<ContentValues> symbol = this.queryData(database, "uc_symbol");
            ArrayList<ContentValues> sentance = this.queryData(database, "uc_sentance");
            ArrayList<ContentValues> sticker = this.queryData(database, "uc_sticker");
            result.put("uc_symbol", symbol);
            result.put("uc_sentance", sentance);
            result.put("uc_sticker", sticker);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "queryAll", e);
        }
        finally {
            this.close(database);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ContentValues> queryData(SQLiteDatabase database, String table) {
        String orderby = "hitrate desc";
        Cursor cursor = null;
        ArrayList<ContentValues> data = new ArrayList<ContentValues>();
        try {
            cursor = database.query(table, null, null, null, null, null, orderby);
            if (cursor != null) {
                int count = cursor.getCount();
                if (count > 0) {
                    while (!cursor.isLast()) {
                        cursor.moveToNext();
                        int contentIndex = cursor.getColumnIndexOrThrow("content");
                        int idIndex = cursor.getColumnIndexOrThrow("id");
                        int hitrateIndex = cursor.getColumnIndexOrThrow("hitrate");
                        ContentValues value = new ContentValues();
                        value.put("content", cursor.getString(contentIndex));
                        value.put("id", cursor.getInt(idIndex));
                        value.put("hitrate", cursor.getInt(hitrateIndex));
                        data.add(value);
                    }
                }
            } else {
                Log.e(this.getClass().getSimpleName(), "queryData fail!");
            }
            this.close(cursor);
        }
        catch (Throwable throwable) {
            this.close(cursor);
            throw throwable;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ContentValues> updateSentance(String content, int id) {
        SQLiteDatabase database = null;
        String whereClause = "id=?";
        String[] whereArgs = new String[]{String.valueOf(id)};
        ContentValues values = new ContentValues();
        values.put("content", content);
        ArrayList<ContentValues> data = null;
        try {
            database = this.getWritableDatabase();
            database.update("uc_sentance", values, whereClause, whereArgs);
            data = this.queryData(database, "uc_sentance");
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "updateSentance", e);
        }
        finally {
            this.close(database);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHitCountSticker(int id, String table) {
        SQLiteDatabase database = null;
        String query = "Select hitrate from " + table + " where id=?";
        String[] selectionArgs = new String[]{String.valueOf(id)};
        String whereClause = "id=?";
        String[] whereArgs = new String[]{String.valueOf(id)};
        ContentValues values = new ContentValues();
        try {
            database = this.getWritableDatabase();
            long hitCount = DatabaseUtils.longForQuery(database, query, selectionArgs);
            values.put("hitrate", hitCount + 1L);
            database.update(table, values, whereClause, whereArgs);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "updateSentance", e);
        }
        finally {
            this.close(database);
        }
    }

    private void close(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
            cursor = null;
        }
    }

    private void close(SQLiteDatabase database) {
        if (database != null) {
            if (!database.isReadonly()) {
                database.endTransaction();
            }
            database.close();
        }
    }

    private void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                Log.e(this.getClass().getSimpleName(), "closeStream", e);
            }
            finally {
                in = null;
            }
        }
    }

    private void close(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                Log.e(this.getClass().getSimpleName(), "closeStream", e);
            }
            finally {
                in = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String querySettings(int settingitem) {
        SQLiteDatabase database = null;
        String selection = "setting=?";
        String[] selectionArgs = new String[]{String.valueOf(settingitem)};
        String[] columns = new String[]{"value"};
        String settingValue = null;
        Cursor cursor = null;
        try {
            int count;
            database = this.getReadableDatabase();
            cursor = database.query("notifications_settings", columns, selection, selectionArgs, null, null, null);
            if (cursor != null && (count = cursor.getCount()) > 0) {
                cursor.moveToFirst();
                settingValue = cursor.getString(0);
            }
            this.close(cursor);
            this.close(database);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "updateSentance", e);
        }
        finally {
            this.close(cursor);
            this.close(database);
        }
        return settingValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings(int settingitem, boolean on) {
        SQLiteDatabase database = null;
        String selection = "setting=?";
        String[] selectionArgs = new String[]{String.valueOf(settingitem)};
        ContentValues values = null;
        try {
            database = this.getWritableDatabase();
            values = new ContentValues();
            values.put("value", on ? "0" : "1");
            values.put("setting", settingitem);
            long rows = DatabaseUtils.queryNumEntries(database, "notifications_settings", selection, selectionArgs);
            long index = 0L;
            if (rows > 0L) {
                index = database.update("notifications_settings", values, selection, selectionArgs);
                Log.i(this.getClass().getSimpleName(), "update settings index:" + index);
            } else {
                index = database.insert("notifications_settings", null, values);
                Log.d(this.getClass().getSimpleName(), "insert settings rowid:" + index);
            }
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "updateSentance", e);
        }
        finally {
            this.close(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings(int settingitem, int option) {
        SQLiteDatabase database = null;
        String selection = "setting=?";
        String[] selectionArgs = new String[]{String.valueOf(settingitem)};
        ContentValues values = null;
        try {
            database = this.getWritableDatabase();
            values = new ContentValues();
            values.put("value", String.valueOf(option));
            values.put("setting", settingitem);
            long rows = DatabaseUtils.queryNumEntries(database, "notifications_settings", selection, selectionArgs);
            long index = 0L;
            if (rows > 0L) {
                index = database.update("notifications_settings", values, selection, selectionArgs);
                Log.d(this.getClass().getSimpleName(), "update settings index:" + index);
            } else {
                index = database.insert("notifications_settings", null, values);
                Log.i(this.getClass().getSimpleName(), "insert settings rowid:" + index);
            }
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "updateSentance", e);
        }
        finally {
            this.close(database);
        }
    }

    public void setDisplayPhoneHistoryOutboundAnsweredOn(boolean on) {
        this.updateSettings(11, on);
    }

    public boolean isDisplayPhoneHistoryOutboundAnsweredOn() {
        String value = this.querySettings(11);
        return !"1".equals(value);
    }

    public void setDisplayPhoneHistoryInboundAnsweredOn(boolean on) {
        this.updateSettings(12, on);
    }

    public boolean isDisplayPhoneHistoryInboundAnsweredOn() {
        String value = this.querySettings(12);
        return !"1".equals(value);
    }

    public void setDisplayPhoneHistoryOutboundCanceledOn(boolean on) {
        this.updateSettings(13, on);
    }

    public boolean isDisplayPhoneHistoryOutboundCanceledOn() {
        String value = this.querySettings(13);
        return !"1".equals(value);
    }

    public void setDisplayPhoneHistoryInboundMissedOn(boolean on) {
        this.updateSettings(14, on);
    }

    public boolean isDisplayPhoneHistoryInboundMissedOn() {
        String value = this.querySettings(14);
        return !"1".equals(value);
    }

    public void setDisplayPhoneHistoryRecordingOn(boolean on) {
        this.updateSettings(15, on);
    }

    public boolean isDisplayPhoneHistoryRecordingOn() {
        String value = this.querySettings(15);
        return !"1".equals(value);
    }

    public void setDisplayPhoneHistoryVoicemailOn(boolean on) {
        this.updateSettings(16, on);
    }

    public boolean isDisplayPhoneHistoryVoicemailOn() {
        String value = this.querySettings(16);
        return !"1".equals(value);
    }

    public void setDisplayPhoneHistoryTimeType(int timeType) {
        this.updateSettings(17, timeType);
    }

    public int getDisplayPhoneHistoryTimeType() {
        String option = this.querySettings(17);
        if (option != null) {
            return Integer.parseInt(option);
        }
        return 0;
    }

    public void setDisplayPhoneHistoryPageSize(int timeType) {
        this.updateSettings(18, timeType);
    }

    public int getDisplayPhoneHistoryPageSize() {
        String option = this.querySettings(18);
        if (option != null) {
            return Integer.parseInt(option);
        }
        return 0;
    }

    public void setDisplayFaxHistoryFaxOption(int option) {
        this.updateSettings(23, option);
    }

    public int getDisplayFaxHistoryFaxOption() {
        String option = this.querySettings(23);
        if (option != null) {
            return Integer.parseInt(option);
        }
        return 0;
    }

    public void setDisplayFaxHistoryTimeType(int timeType) {
        this.updateSettings(24, timeType);
    }

    public int getDisplayFaxHistoryTimeType() {
        String option = this.querySettings(24);
        if (option != null) {
            return Integer.parseInt(option);
        }
        return 0;
    }

    public void setDisplayFaxHistoryPageSize(int timeType) {
        this.updateSettings(18, timeType);
    }

    public int getDisplayFaxHistoryPageSize() {
        String option = this.querySettings(18);
        if (option != null) {
            return Integer.parseInt(option);
        }
        return 0;
    }

    public void setNotifyMessageOn(boolean on) {
        this.updateSettings(6, on);
    }

    public boolean isNotifyMessageOn() {
        String value = this.querySettings(6);
        return !"1".equals(value);
    }

    public void setDisplayContent(boolean on) {
        this.updateSettings(3, on);
    }

    public boolean isShowContent() {
        String value = this.querySettings(3);
        return !"1".equals(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDisableNotificationData() {
        SQLiteDatabase database = null;
        int index = -1;
        try {
            database = this.getWritableDatabase();
            index = database.delete("notifications_disable_list", null, null);
            Log.i(this.getClass().getSimpleName(), " clearDisableNotificationData :" + index);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "queryConference", e);
        }
        finally {
            this.close(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisableNotification(String chatRoomid) {
        SQLiteDatabase database = null;
        String selection = "chatroomid=?";
        String[] selectionArgs = new String[]{String.valueOf(chatRoomid)};
        long rowCount = 0L;
        try {
            database = this.getReadableDatabase();
            rowCount = DatabaseUtils.queryNumEntries(database, "notifications_disable_list", selection, selectionArgs);
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "updateSentance", e);
        }
        finally {
            this.close(database);
        }
        return rowCount > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableNotification(String chatRoomid) {
        SQLiteDatabase database = null;
        ContentValues values = null;
        String selection = "chatroomid=?";
        String[] selectionArgs = new String[]{String.valueOf(chatRoomid)};
        long rowCount = 0L;
        long id = -1L;
        try {
            database = this.getWritableDatabase();
            rowCount = DatabaseUtils.queryNumEntries(database, "notifications_disable_list", selection, selectionArgs);
            if (rowCount == 0L) {
                values = new ContentValues();
                values.put("chatroomid", chatRoomid);
                id = database.insertOrThrow("notifications_disable_list", null, values);
                Log.i(this.getClass().getSimpleName(), "insert diasble notification list id:" + id);
            } else {
                Log.i(this.getClass().getSimpleName(), "already in block list");
            }
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "addDisableNotification", e);
        }
        finally {
            this.close(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableNotification(String chatRoomid) {
        SQLiteDatabase database = null;
        String whereClause = "chatroomid=?";
        String[] whereArgs = new String[]{String.valueOf(chatRoomid)};
        int rowCount = 0;
        try {
            database = this.getWritableDatabase();
            rowCount = database.delete("notifications_disable_list", whereClause, whereArgs);
            if (rowCount == 0) {
                Log.i(this.getClass().getSimpleName(), "remove from diasble notification list row count:" + rowCount);
            } else {
                Log.d(this.getClass().getSimpleName(), "no match chatid");
            }
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "addDisableNotification", e);
        }
        finally {
            this.close(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePendingMessage(String chatRoomid) {
        SQLiteDatabase database = null;
        String whereClause = "chatroomid=?";
        String[] whereArgs = new String[]{String.valueOf(chatRoomid)};
        int rowCount = 0;
        try {
            database = this.getWritableDatabase();
            rowCount = database.delete("pending_message", whereClause, whereArgs);
            if (rowCount != 0) {
                Log.i(this.getClass().getSimpleName(), "remove from pending msg list row count:" + rowCount);
            } else {
                Log.d(this.getClass().getSimpleName(), "no match chatid");
            }
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "deletePendingMessage", e);
        }
        finally {
            this.close(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePendingMessage(String chatRoomid, String message) {
        SQLiteDatabase database = null;
        String whereClause = "chatroomid=?";
        String[] whereArgs = new String[]{String.valueOf(chatRoomid)};
        long recordCount = 0L;
        ContentValues values = null;
        try {
            database = this.getWritableDatabase();
            recordCount = DatabaseUtils.queryNumEntries(database, "pending_message", whereClause, whereArgs);
            if (recordCount == 0L) {
                values = new ContentValues();
                values.put("chatroomid", chatRoomid);
                values.put("message", message);
                database.insert("pending_message", null, values);
            } else {
                values = new ContentValues();
                values.put("message", message);
                database.update("pending_message", values, whereClause, whereArgs);
            }
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "addDisableNotification", e);
        }
        finally {
            this.close(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPendingMessage(Set<String> chatRoomJidSet) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (chatRoomJidSet == null || chatRoomJidSet.size() == 0) {
            return resultMap;
        }
        SQLiteDatabase database = null;
        Cursor cursor = null;
        String[] columns = new String[]{"chatroomid", "message"};
        String selection = "chatroomid IN (" + this.jidsStrToQueryStr(chatRoomJidSet) + ")";
        try {
            database = this.getWritableDatabase();
            cursor = database.query("pending_message", columns, selection, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    String chatJid = cursor.getString(0);
                    String text = cursor.getString(1);
                    resultMap.put(chatJid, text);
                } while (cursor.moveToNext());
            }
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "addDisableNotification", e);
        }
        finally {
            this.close(database);
        }
        return resultMap;
    }

    private String jidsStrToQueryStr(Collection<String> jidList) {
        StringBuffer jids = new StringBuffer();
        int i = 0;
        for (String jid : jidList) {
            if (i != 0) {
                jids.append(",");
            }
            jids.append("'" + jid + "'");
            ++i;
        }
        return jids.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPendingMessage(String chatRoomid) {
        SQLiteDatabase database = null;
        Cursor cursor = null;
        String[] columns = new String[]{"message"};
        String selection = "chatroomid=?";
        String[] selectionArgs = new String[]{String.valueOf(chatRoomid)};
        String value = null;
        try {
            database = this.getWritableDatabase();
            cursor = database.query("pending_message", columns, selection, selectionArgs, null, null, null);
            if (cursor.moveToNext()) {
                value = cursor.getString(0);
            }
        }
        catch (SQLException e) {
            Log.e(this.getClass().getSimpleName(), "addDisableNotification", e);
        }
        finally {
            this.close(database);
        }
        return value;
    }

    public int getMapOption() {
        String option = this.querySettings(10);
        if (option != null) {
            return Integer.parseInt(option);
        }
        return 0;
    }

    public void setMapOption(int option) {
        this.updateSettings(10, option);
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        db = null;
        lock = new Object();
    }
}

