/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoomAuthType;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.List;
import java.util.Map;

public class ConferenceUtil {
    public static boolean isShowJoinBtn(LiteConferenceRoom confRoom) {
        long userId = PreferencesUtil.getUserId(UCChatClient.context);
        boolean isAdmin = ConferenceUtil.isConferenceAdmin(confRoom, userId);
        if (isAdmin) {
            return true;
        }
        LiteConferenceRoomAuthType type = confRoom.getAuthType();
        if (type == LiteConferenceRoomAuthType.NONE) {
            return !confRoom.isLocked();
        }
        if (type == LiteConferenceRoomAuthType.PIN_CODE) {
            return true;
        }
        if (type == LiteConferenceRoomAuthType.MEMBER_COMPARE) {
            return !confRoom.isLocked();
        }
        return false;
    }

    public static boolean isConferenceAdmin(LiteConferenceRoom meetmeRoom, long userid) {
        if (meetmeRoom == null) {
            return false;
        }
        if (meetmeRoom.getManagerId() != null && meetmeRoom.getManagerId() == userid) {
            return true;
        }
        List<Long> chairmainIdList = meetmeRoom.getChairmanIds();
        if (chairmainIdList != null) {
            int size = chairmainIdList.size();
            for (int i = 0; i < size; ++i) {
                Long chairdbid = chairmainIdList.get(i);
                if (chairdbid != userid) continue;
                return true;
            }
        }
        return false;
    }

    public static String getRole(LiteConferenceRoom meetmeRoom, Context ctx, long userid) {
        String chatRoomId = meetmeRoom.getChatRoomId();
        if (chatRoomId == null) {
            ToastUtil.debug(ctx, "ChatRoomId is null !!", 20);
            return null;
        }
        long roomid = meetmeRoom.getRoomId();
        boolean admin = ConferenceUtil.isConferenceAdmin(meetmeRoom, userid);
        if (admin) {
            return "admin";
        }
        UserDatabase database = UserDatabase.getDB(ctx);
        Map<String, Object> value = database.queryConferenceRoleInfo(roomid);
        String roleValue = null;
        if (value != null) {
            roleValue = (String)value.get("role");
        }
        if (TextUtils.isNotBlank(roleValue)) {
            return roleValue;
        }
        LiteConferenceRoomAuthType type = meetmeRoom.getAuthType();
        if (type == LiteConferenceRoomAuthType.NONE) {
            return "user";
        }
        return null;
    }
}

