/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.AgentStatusType;
import com.blisscloud.mobile.ezuc.bean.AuthOption;
import com.blisscloud.mobile.ezuc.bean.MediaType;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.QueueStatus;
import com.blisscloud.mobile.ezuc.db.UCDBBulletin;
import com.blisscloud.mobile.ezuc.db.UCDBCustomer;
import com.blisscloud.mobile.ezuc.db.UCDBFaxDoc;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.AddressBookScopeManager;
import com.blisscloud.mobile.ezuc.manager.ChatEventManager;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.manager.task.EventController;
import com.blisscloud.mobile.ezuc.manager.task.GetLogoTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.Desktop;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataChangeEventManager {
    private static final long DELAY_PERIOD = 3000L;
    private static Timer checkLocalTimer = new Timer("DataChangeEventManagerTimer");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void receiveDataChangeEvent(final Context context, final JSONObject dataObj) {
        try {
            String type = dataObj.getString("type");
            String reason = dataObj.getString("reason");
            String ids = dataObj.getString("ids");
            if ("EXTENDED_SYS_PHONE".equals(type)) {
                JSONObject extraJson = dataObj.getJSONObject("extra");
                if (extraJson != null && extraJson.has("empExtendedSysPhoneConfig")) {
                    JSONObject obj = extraJson.getJSONObject("empExtendedSysPhoneConfig");
                    PreferencesUtil.setEmpExtendedSysPhoneConfig(context, obj.toString());
                } else {
                    PreferencesUtil.setEmpExtendedSysPhoneConfig(context, "");
                }
                BroadcastUtil.sendEmpExtendedSysModeChanged(context);
                return;
            }
            if ("AUTH_OPTION".equals(type)) {
                JSONObject extraJson = dataObj.getJSONObject("extra");
                if (extraJson == null || !extraJson.has("authOption")) return;
                int authOption = extraJson.getInt("authOption");
                PreferencesUtil.setAuthOption(context, AuthOption.getValue(authOption));
                BroadcastUtil.sendAuthOptionChanged(context);
                return;
            }
            if ("CHAT_MSG_RECALL".equals(type)) {
                String packetId = ids;
                if (!StringUtils.isNotBlank((CharSequence)packetId)) return;
                ChatRoomManager.recallMsg(UCChatClient.context, packetId);
                if (!PreferencesUtil.isSyncOldChatEventDone(context)) return;
                BroadcastUtil.sendMsgRecalledEvent(UCChatClient.context, packetId);
                BroadcastUtil.sendContactHistoryChangedEvent(context);
                BroadcastUtil.sendMsgChangedEvent(context);
                return;
            }
            if ("AGENT_ROLE_CHANGED".equals(type)) {
                boolean newIsAgent;
                JSONObject extraJson = dataObj.getJSONObject("extra");
                if (extraJson == null) return;
                boolean oldIsAgent = PreferencesUtil.isAgent();
                if (extraJson.has("agentRole")) {
                    PreferencesUtil.setAgentRole(extraJson.getString("agentRole"));
                } else {
                    PreferencesUtil.setAgentRole(null);
                }
                if (extraJson.has("selectedSkills")) {
                    JSONArray ary = extraJson.getJSONArray("selectedSkills");
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < ary.length(); ++i) {
                        list.add(ary.getString(i));
                    }
                    String selectedSkillsStr = String.join((CharSequence)",", list);
                    PreferencesUtil.setAgentQueueSelectedInfo(selectedSkillsStr);
                }
                if (oldIsAgent != (newIsAgent = PreferencesUtil.isAgent())) {
                    BroadcastUtil.sendAgentRoleChangedEvent(context);
                }
                boolean queueDoChanged = false;
                queueDoChanged = extraJson.has("queueLevels") ? PreferencesUtil.setAgentQueueInfo(extraJson.getJSONArray("queueLevels").toString()) : PreferencesUtil.setAgentQueueInfo("[]");
                BroadcastUtil.sendAgentStateChangedEvent(context);
                if (PreferencesUtil.isAgentQueueEmpty()) {
                    if (WebAgent.agentState == AgentStatusType.LOGOUT) {
                        return;
                    }
                    checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                        @Override
                        public void doRun() {
                            if (WebAgent.agentState != AgentStatusType.LOGOUT) {
                                WebAgent.getInstance().agentLogout();
                            }
                        }
                    }, 1000L);
                    return;
                } else {
                    if (!queueDoChanged) return;
                    if (WebAgent.agentState == AgentStatusType.LOGOUT) {
                        return;
                    }
                    checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                        @Override
                        public void doRun() {
                            HashSet<MediaType> newLoginTypes = new HashSet<MediaType>();
                            if (PreferencesUtil.isPhoneAgent()) {
                                newLoginTypes.add(MediaType.PHONE);
                            }
                            if (PreferencesUtil.isChatAgent()) {
                                newLoginTypes.add(MediaType.CHAT);
                            }
                            if (ApiVersion.isApi27Later()) {
                                Set<Long> selectedSkillSize = PreferencesUtil.getAgentQueueSelectedSet();
                                WebAgent.getInstance().agentLogin(newLoginTypes, selectedSkillSize);
                            } else {
                                WebAgent.getInstance().agentLogin(newLoginTypes);
                            }
                        }
                    }, 1000L);
                }
                return;
            }
            if ("QUEUE_STATE_CHANGED".equals(type)) {
                JSONObject extraJson = dataObj.getJSONObject("extra");
                if ("UPD".equals(reason)) {
                    long skillId = extraJson.getLong("skillId");
                    String skillName = extraJson.getString("skillName");
                    int requestSize = extraJson.getInt("requestSize");
                    long requestTime = extraJson.getLong("requestTime");
                    long currentTime = extraJson.getLong("currentTime");
                    QueueStatus queueStatus = null;
                    boolean hasQueueInfo = WebAgent.queueStatusMap.containsKey(skillId);
                    queueStatus = hasQueueInfo ? WebAgent.queueStatusMap.get(skillId) : new QueueStatus();
                    queueStatus.setSkillId(skillId);
                    queueStatus.setSkillName(skillName);
                    queueStatus.setRequestSize(requestSize);
                    queueStatus.setRequestTime(requestTime);
                    queueStatus.setTimeShift(System.currentTimeMillis() - currentTime);
                    if (!hasQueueInfo) {
                        WebAgent.queueStatusMap.put(skillId, queueStatus);
                    }
                    BroadcastUtil.sendQueueStateChangedEvent(context);
                    return;
                } else {
                    if (!"DEL".equals(reason)) return;
                    long skillId = extraJson.getLong("skillId");
                    WebAgent.queueStatusMap.remove(skillId);
                    BroadcastUtil.sendQueueStateChangedEvent(context);
                }
                return;
            }
            if ("AGENT_STATE_CHANGED".equals(type)) {
                boolean hasUrl;
                String agentLoginMediaTypes;
                JSONObject extraJson = dataObj.getJSONObject("extra");
                String agentStateCode = extraJson.getString("agentState");
                Long auxReasonId = null;
                if (extraJson.has("auxReasonId")) {
                    auxReasonId = extraJson.getLong("auxReasonId");
                }
                if (extraJson.has("selectedSkills")) {
                    JSONArray ary = extraJson.getJSONArray("selectedSkills");
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < ary.length(); ++i) {
                        list.add(ary.getString(i));
                    }
                    String[] selectedSkillsStr = String.join((CharSequence)",", list);
                    PreferencesUtil.setAgentQueueSelectedInfo((String)selectedSkillsStr);
                }
                WebAgent.agentState = AgentStatusType.getValue(agentStateCode);
                WebAgent.auxReasonId = auxReasonId;
                WebAgent.agentLoginMediaTypes.clear();
                if (extraJson.has("agentLoginMediaTypes") && StringUtils.isNotBlank((CharSequence)(agentLoginMediaTypes = extraJson.getString("agentLoginMediaTypes")))) {
                    String[] loginTypes;
                    for (String mediaType : loginTypes = agentLoginMediaTypes.split(",")) {
                        WebAgent.agentLoginMediaTypes.add(MediaType.getValue(mediaType));
                    }
                }
                String ani = "";
                if (dataObj.has("attributes") && (WebAgent.callAttachData = dataObj.getJSONObject("attributes")).has("ANI")) {
                    ani = WebAgent.callAttachData.getString("ANI");
                }
                BroadcastUtil.sendAgentStateChangedEvent(context);
                boolean inService = extraJson.optBoolean("inService", false);
                if (inService) {
                    String popupExe = PreferencesUtil.getScrenPopExe();
                    Log.i(DataChangeEventManager.class.getSimpleName(), "command: " + popupExe);
                    if (StringUtils.isNotBlank((CharSequence)popupExe)) {
                        try {
                            popupExe = popupExe.replaceAll("%m", ani);
                            Log.i(DataChangeEventManager.class.getSimpleName(), "command with ani: " + popupExe);
                            Process p = Runtime.getRuntime().exec(popupExe);
                            Log.i(DataChangeEventManager.class.getSimpleName(), p.toString());
                        }
                        catch (Throwable t) {
                            Log.e(DataChangeEventManager.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                        }
                    }
                }
                if (!(hasUrl = extraJson.has("url"))) return;
                try {
                    String url = extraJson.getString("url");
                    Desktop.getDesktop().browse(new URL(url).toURI());
                    return;
                }
                catch (Throwable t) {
                    Log.e(DataChangeEventManager.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
                return;
            }
            if ("SERVICE_CATEGORY_CHANGED".equals(type)) {
                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        WebAgent.getInstance().getCustomerServiceCategory();
                    }
                }, 3000L);
                return;
            } else if ("FAX_DOC".equals(type)) {
                if ("UPD".equals(reason) || "INS".equals(reason)) {
                    checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                        @Override
                        public void doRun() {
                            WebAgent.getInstance().getFaxDocList();
                        }
                    }, 3000L);
                    return;
                } else {
                    if (!"DEL".equals(reason)) return;
                    String[] idAry = ids.split(",");
                    for (int i = 0; idAry != null && i < idAry.length; ++i) {
                        if (idAry[i] == null) continue;
                        String faxDocIdStr = idAry[i].trim();
                        long faxDocId = -1L;
                        try {
                            faxDocId = Long.parseLong(faxDocIdStr);
                            UCDBFaxDoc.deleteFaxDoc(context, faxDocId);
                            continue;
                        }
                        catch (Throwable t) {
                            Log.e(DataChangeEventManager.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                        }
                    }
                    if (!PreferencesUtil.isSyncOldChatEventDone(context)) return;
                    BroadcastUtil.sendMsgChangedEvent(context, "__FAX_DOC_GROUP__");
                    BroadcastUtil.sendContactHistoryChangedEvent(context);
                }
                return;
            } else if ("SOCIAL_CUSTOMER_CHANGED".equals(type)) {
                JSONObject extraJson = dataObj.getJSONObject("extra");
                if (extraJson == null || !extraJson.has("customerAccount")) return;
                String account = extraJson.getString("customerAccount");
                long expireTime = extraJson.has("expireTime") ? extraJson.getLong("expireTime") : 0L;
                boolean isTransfferd = extraJson.has("transferred") ? extraJson.getBoolean("transferred") : false;
                boolean sessionClose = extraJson.has("sessionClose") ? extraJson.getBoolean("sessionClose") : true;
                String sessionId = extraJson.has("sessionId") ? extraJson.getString("sessionId") : null;
                String assigner = extraJson.has("assigner") ? extraJson.getString("assigner") : null;
                int level = extraJson.optInt("level", 0);
                int status = extraJson.optInt("status", 0);
                String nickName = extraJson.has("nickName") ? extraJson.getString("nickName") : null;
                UCDBCustomer.updateCustomerStatusInfo(context, account, expireTime, sessionId, isTransfferd, sessionClose, assigner, level, status, nickName);
                if (!PreferencesUtil.isSyncOldChatEventDone(context)) return;
                BroadcastUtil.sendCustomerStatusChangedEvent(context);
                return;
            } else if ("CUSTOMER".equals(type)) {
                CustomerManager.onCustomerDataChange(context, dataObj);
                return;
            } else if ("JID_DELETED".equals(type)) {
                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        DeletedContactManager.getDeletedContact(context);
                    }
                }, 3000L);
                return;
            } else if ("SYSTEM_RECORDING".equals(type)) {
                if (!PreferencesUtil.isCheckRecording(context)) {
                    return;
                }
                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        WebAgent.getInstance().getEmpContactRecordsByPage();
                    }
                }, 3000L);
                return;
            } else if ("PERSONAL_FUNCTION".equals(type)) {
                JSONObject extraJson = dataObj.getJSONObject("extra");
                if (extraJson.has("enableBulletinApi")) {
                    PreferencesUtil.setBulletinApiEnabled(context, extraJson.getBoolean("enableBulletinApi"));
                }
                if (extraJson.has("enableLiteEventLog")) {
                    PreferencesUtil.setLiteEventLogEnabled(context, extraJson.getBoolean("enableLiteEventLog"));
                }
                if (extraJson.has("recallDeadline")) {
                    PreferencesUtil.setMsgRecallDeadline(context, extraJson.getInt("recallDeadline"));
                }
                if (extraJson.has("clientAppDeptMode")) {
                    PreferencesUtil.setClientAppDeptMode(context, extraJson.getInt("clientAppDeptMode"));
                }
                if (extraJson.has("fileUploadUpperLimit")) {
                    PreferencesUtil.setFileUploadUpperLimit(context, extraJson.getInt("fileUploadUpperLimit"));
                }
                if (extraJson.has("textUploadUpperLimit")) {
                    PreferencesUtil.setTextUploadUpperLimit(context, extraJson.getInt("textUploadUpperLimit"));
                }
                if (PreferencesUtil.isSyncOldChatEventDone(context)) {
                    BroadcastUtil.sendContactListChangedEvent(context, 0);
                }
                boolean contactReportKeyDisp = false;
                if (extraJson.has("contactReportKeyDisp") && extraJson.getBoolean("contactReportKeyDisp")) {
                    contactReportKeyDisp = true;
                }
                PreferencesUtil.setContactReportKeyDisp(context, contactReportKeyDisp);
                BroadcastUtil.sendPersonalInfoChanged(context);
                return;
            } else if ("PERSONAL_PERMISSION".equals(type)) {
                JSONObject extraJson = dataObj.getJSONObject("extra");
                boolean hasCallTransferConfigPermisison = true;
                boolean hasChatActionPermisison = true;
                boolean hasChatPhotoActionPermisison = true;
                boolean hasChatVideoActionPermisison = true;
                boolean hasChatFileActionPermisison = true;
                boolean hasPhotoPermisison = true;
                boolean hasAddToInboundBlacklistPermisison = false;
                boolean hasOutboundPrefixPermisison = false;
                boolean fuzzyOutboundNumber = false;
                boolean faxEnabled = false;
                boolean checkRecording = false;
                if (extraJson.has("callTransferConfig") && !extraJson.getBoolean("callTransferConfig")) {
                    hasCallTransferConfigPermisison = false;
                }
                if (extraJson.has("chatAction") && !extraJson.getBoolean("chatAction")) {
                    hasChatActionPermisison = false;
                }
                if (extraJson.has("chatPhotoAction") && !extraJson.getBoolean("chatPhotoAction")) {
                    hasChatPhotoActionPermisison = false;
                }
                if (extraJson.has("chatVideoAction") && !extraJson.getBoolean("chatVideoAction")) {
                    hasChatVideoActionPermisison = false;
                }
                if (extraJson.has("chatFileAction") && !extraJson.getBoolean("chatFileAction")) {
                    hasChatFileActionPermisison = false;
                }
                if (extraJson.has("modifyPersonalPhoto") && !extraJson.getBoolean("modifyPersonalPhoto")) {
                    hasPhotoPermisison = false;
                }
                if (extraJson.has("addToInboundBlacklist") && extraJson.getBoolean("addToInboundBlacklist")) {
                    hasAddToInboundBlacklistPermisison = true;
                }
                if (extraJson.has("modifyOutboundPrefix") && extraJson.getBoolean("modifyOutboundPrefix")) {
                    hasOutboundPrefixPermisison = true;
                }
                if (extraJson.has("fuzzyOutboundNumber") && extraJson.getBoolean("fuzzyOutboundNumber")) {
                    fuzzyOutboundNumber = true;
                }
                if (extraJson.has("faxEnabled") && extraJson.getBoolean("faxEnabled")) {
                    faxEnabled = true;
                }
                if (extraJson.has("checkRecording") && extraJson.getBoolean("checkRecording")) {
                    checkRecording = true;
                }
                PreferencesUtil.putBoolean(context, "PERMISSION_CALL_TRANASFER_CONFIG", hasCallTransferConfigPermisison);
                PreferencesUtil.putBoolean(context, "PERMISSION_CHAT_ACTION", hasChatActionPermisison);
                PreferencesUtil.putBoolean(context, "PERMISSION_CHAT_PHOTO_ACTION", hasChatPhotoActionPermisison);
                PreferencesUtil.putBoolean(context, "PERMISSION_CHAT_VIDEO_ACTION", hasChatVideoActionPermisison);
                PreferencesUtil.putBoolean(context, "PERMISSION_CHAT_FILE_ACTION", hasChatFileActionPermisison);
                PreferencesUtil.putBoolean(context, "PERMISSION_PHOTO_EDIT", hasPhotoPermisison);
                PreferencesUtil.putBoolean(context, "PERMISSION_ADD_TO_INBOUND_BLACKLIST", hasAddToInboundBlacklistPermisison);
                PreferencesUtil.putBoolean(context, "PERMISSION_OUTBOUND_PREFIX_EDIT", hasOutboundPrefixPermisison);
                PreferencesUtil.putBoolean(context, "PERMISSION_FUZZY_OUTBOUND_NUMBER", fuzzyOutboundNumber);
                PreferencesUtil.putBoolean(context, "PERMISSION_FAX_ENABLED", faxEnabled);
                PreferencesUtil.putBoolean(context, "PERMISSION_CHECK_RECORDING", checkRecording);
                if (PreferencesUtil.isFaxEnabled(context)) {
                    WebAgent.getInstance().getFaxDocList();
                    WebAgent.getInstance().getFaxDocDeletedList();
                }
                if (PreferencesUtil.isCheckRecording(context)) {
                    WebAgent.getInstance().getEmpContactRecordsByPage();
                }
                BroadcastUtil.sendPersonalInfoChanged(context);
                return;
            } else if ("ADDRESS_BOOK_SCOPE_CHANGED".equals(type)) {
                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        try {
                            JSONObject exteaJson = dataObj.getJSONObject("extra");
                            JSONObject addressBookScopeObj = exteaJson.getJSONObject("addressBookScope");
                            AddressBookScopeManager.changeScope(context, addressBookScopeObj);
                        }
                        catch (JSONException e) {
                            Log.e(DataChangeEventManager.class.getSimpleName(), "[ERROR] data change event: " + String.valueOf(dataObj), e);
                        }
                    }
                }, 3000L);
                return;
            } else if ("SUBSCRIBE".equals(type)) {
                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        if (PreferencesUtil.isAddressBookSyncDone(context)) {
                            long timestamp = PreferencesUtil.getTimeStamp(context, "employee.getEmployeeList.TimeStamp.20200730");
                            WebAgent.getInstance().getDirtyEmployeeListByPage(timestamp, -1L);
                        }
                    }
                }, 3000L);
                return;
            } else if ("EMP_DEPT".equals(type)) {
                DataChangeEventManager.fetchEmployeeInfo(context, ids);
                return;
            } else if ("DEPT".equals(type)) {
                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        WebAgent.getInstance().getAllDepartmentList();
                    }
                }, 3000L);
                return;
            } else if ("EMP_SITE".equals(type)) {
                JSONObject extraJson = dataObj.getJSONObject("extra");
                JSONArray mySiteListAry = extraJson.getJSONArray("mySiteList");
                PreferencesUtil.setSipMyPbxSiteList(context, mySiteListAry.toString());
                String[] myPbxSiteIds = CommonUtil.getJsonDataArray(PreferencesUtil.getSipMyPbxSiteList(context), "id");
                long useSiteId = PreferencesUtil.getSipUsePbxSite(context);
                boolean stillExist = false;
                for (int i = 0; myPbxSiteIds != null && i < myPbxSiteIds.length; ++i) {
                    if (Long.parseLong(myPbxSiteIds[i]) != useSiteId) continue;
                    stillExist = true;
                    break;
                }
                if (!stillExist) {
                    WebAgent.getInstance().logout(101, true);
                    return;
                } else {
                    BroadcastUtil.sendLoginUserSiteChangedEvent(context);
                }
                return;
            } else if ("EMP".equals(type)) {
                if ("INS".equals(reason) || "UPD".equals(reason) || "UNDISABLED".equals(reason) || "UNLOCKED".equals(reason)) {
                    DataChangeEventManager.fetchEmployeeInfo(context, ids);
                    return;
                } else if ("DEL".equals(reason)) {
                    boolean isNeedLogout = ContactManager.removeEmployee(context, ids);
                    if (!isNeedLogout) return;
                    WebAgent.getInstance().logout(3001, true);
                    return;
                } else if ("LOCKED".equals(reason)) {
                    if (ids == null) return;
                    Long myid = PreferencesUtil.getUserId(context);
                    long changeId = Long.parseLong(ids);
                    if (myid != null && changeId == myid) {
                        WebAgent.getInstance().logout(4, true);
                        return;
                    } else {
                        DataChangeEventManager.fetchEmployeeInfo(context, ids);
                    }
                    return;
                } else if ("DISABLED".equals(reason)) {
                    if (ids == null) return;
                    Long myid = PreferencesUtil.getUserId(context);
                    long changeId = Long.parseLong(ids);
                    if (myid != null && changeId == myid) {
                        WebAgent.getInstance().logout(3, true);
                        return;
                    } else {
                        DataChangeEventManager.fetchEmployeeInfo(context, ids);
                    }
                    return;
                } else {
                    if (!"LOGIN_ACCOUNT_CHANGED".equals(reason) || ids == null) return;
                    Long myid = PreferencesUtil.getUserId(context);
                    long changeId = Long.parseLong(ids);
                    if (myid != null && changeId == myid) {
                        WebAgent.getInstance().logout(20, true);
                        return;
                    } else {
                        DataChangeEventManager.fetchEmployeeInfo(context, ids);
                    }
                }
                return;
            } else if ("LC".equals(type)) {
                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                    @Override
                    public void doRun() {
                        WebAgent.getInstance().queryLocation();
                    }
                }, 3000L);
                return;
            } else if ("CR".equals(type)) {
                if (reason.equals("INS") || reason.equals("UPD")) {
                    WebAgent.getInstance().getOneMeetMe(Long.parseLong(ids));
                    return;
                } else {
                    long roomId;
                    LiteConferenceRoom room;
                    if (!reason.equals("DEL") || (room = MeetmeManager.getMeetme(context, roomId = Long.parseLong(ids))) == null) return;
                    ChatRoomManager.selfLeaveConfRoom(context, room.getChatRoomId(), false);
                    MeetmeManager.deleteConfRoomById(context, roomId, null);
                }
                return;
            } else if ("CONTACT".equals(type)) {
                if (reason.equals("INS") || reason.equals("UPD")) {
                    WebAgent.getInstance().queryExternalContactList();
                    return;
                } else {
                    if (!reason.equals("DEL")) return;
                    ContactManager.removeExternalContacts(context, ids);
                }
                return;
            } else if ("GROUP".equals(type)) {
                if (reason.equals("INS") || reason.equals("UPD")) {
                    WebAgent.getInstance().queryGroupList();
                    return;
                } else {
                    if (!reason.equals("DEL")) return;
                    ContactManager.deleteGroup(context, ids);
                }
                return;
            } else if ("PERSONAL_VOICE_MESSAGE".equals(type)) {
                if (reason.equals("INS")) {
                    WebAgent.getInstance().listVoiceAndRecord();
                    return;
                } else if (reason.equals("UPD")) {
                    WebAgent.getInstance().listVoiceAndRecord();
                    return;
                } else {
                    if (!reason.equals("DEL")) return;
                    VoicemailManager.delete(context, Long.parseLong(ids), 0, false, false);
                }
                return;
            } else if ("PERSONAL_RECORD".equals(type)) {
                if (reason.equals("INS")) {
                    WebAgent.getInstance().listVoiceAndRecord();
                    return;
                } else if (reason.equals("UPD")) {
                    WebAgent.getInstance().listVoiceAndRecord();
                    return;
                } else {
                    if (!reason.equals("DEL")) return;
                    VoicemailManager.delete(context, Long.parseLong(ids), 1, false, false);
                }
                return;
            } else if ("COMPANY_NAME".equals(type)) {
                JSONObject exteaJson = dataObj.getJSONObject("extra");
                PreferencesUtil.setCompanyName(context, exteaJson.getString("companyName"));
                BroadcastUtil.sendCompanyNameChangedEvent(context);
                return;
            } else if ("COMPANY_LOGO".equals(type)) {
                JSONObject exteaJson = dataObj.getJSONObject("extra");
                long newPhotoTime = 0L;
                if (exteaJson.has("tenantPhotoTime")) {
                    newPhotoTime = exteaJson.getLong("tenantPhotoTime");
                }
                if (newPhotoTime == 0L) {
                    newPhotoTime = System.currentTimeMillis();
                }
                GetLogoTask task = new GetLogoTask(context, newPhotoTime);
                TaskController.getInstance().addTask(task);
                task.start();
                return;
            } else if ("PW_EXPIRE".equals(type)) {
                int days = 0;
                if (TextUtils.isNotBlank((CharSequence)reason) && TextUtils.isDigitsOnly(reason)) {
                    days = Integer.parseInt(reason);
                }
                if (days < 0) {
                    Log.i(DataChangeEventManager.class.getSimpleName(), "logout because of pwd expired ");
                    PreferencesUtil.cleanLoginPassword(context);
                    WebAgent.getInstance().logout(5, true);
                    return;
                } else {
                    BroadcastUtil.sendPasswordExpiredEvent(context);
                }
                return;
            } else if ("PW_CHANGE_NOW".equals(type)) {
                BroadcastUtil.sendPasswordExpiredNowEvent(context);
                return;
            } else if ("PW_CHANGED".equals(type)) {
                PreferencesUtil.cleanLoginPassword(context);
                WebAgent.getInstance().logout(3002, true);
                return;
            } else if ("CONFERENCE_RECORD".equals(type)) {
                WebAgent.getInstance().listVoiceAndRecord();
                WebAgent.getInstance().listDeletedVoiceAndRecord();
                return;
            } else if ("SITE".equals(type)) {
                JSONObject exteaJson = dataObj.getJSONObject("extra");
                JSONObject obj = exteaJson.getJSONObject("site");
                boolean updatePrefix = false;
                if (reason.equals("INS")) {
                    if (SiteManager.addSite(context, obj.toString())) {
                        updatePrefix = true;
                    }
                } else if (reason.equals("UPD")) {
                    if (SiteManager.updateSite(context, obj.toString())) {
                        updatePrefix = true;
                    }
                } else if (reason.equals("DEL")) {
                    SiteManager.deleteSite(context, Long.parseLong(ids));
                }
                if (!updatePrefix) return;
                DataChangeEventManager.fetchEmployeeInfo(context, "ALL");
                return;
            } else if ("OUTBOUND_PREFIX".equals(type)) {
                JSONObject obj;
                JSONObject exteaJson = dataObj.getJSONObject("extra");
                JSONObject jSONObject = obj = exteaJson.has("outboundPrefix") ? exteaJson.getJSONObject("outboundPrefix") : null;
                if (reason.equals("INS")) {
                    OutboundPrefixManager.addOutboundPrefix(context, obj.toString());
                } else if (reason.equals("UPD")) {
                    OutboundPrefixManager.updateOutboundPrefix(context, obj.toString());
                } else if (reason.equals("DEL")) {
                    OutboundPrefixManager.deleteOutboundPrefix(context, Long.parseLong(ids));
                }
                BroadcastUtil.sendOutboundPrefixListChangedEvent(context);
                BroadcastUtil.sendMeetmePrefixChangedEvent(context);
                return;
            } else {
                if ("RING_SITE".equals(type)) return;
                if ("DEVICE_INFO".equals(type)) {
                    checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                        @Override
                        public void doRun() {
                            WebAgent.getInstance().getDeviceInfo();
                        }
                    }, 3000L);
                    return;
                } else if ("EMP_DEVICE".equals(type)) {
                    checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                        @Override
                        public void doRun() {
                            WebAgent.getInstance().getDeviceInfo();
                        }
                    }, 3000L);
                    return;
                } else {
                    if ("CONTACTRECORD".equals(type)) return;
                    if ("JoinChatRoom".equals(type)) {
                        BroadcastUtil.sendChatRoomJoinOKEvent(context, ids);
                        return;
                    } else if ("DND".equals(type)) {
                        JSONObject exteaJson = dataObj.getJSONObject("extra");
                        if (exteaJson == null || !exteaJson.has("dndFlag")) return;
                        boolean dnd = exteaJson.getBoolean("dndFlag");
                        String voiceConfig = PreferencesUtil.getVoiceSetting(context);
                        if (voiceConfig != null) {
                            try {
                                JSONObject obj = new JSONObject(voiceConfig);
                                obj.put("dndFlag", dnd);
                                PreferencesUtil.saveVoiceSetting(context, obj.toString());
                                BroadcastUtil.sendFetchVoiceConfigOKEvent(context);
                                return;
                            }
                            catch (JSONException e) {
                                Log.e(DataChangeEventManager.class.getSimpleName(), " UPDATE_VOICECONFIG_EVENT :", e);
                            }
                            return;
                        } else {
                            WebAgent.getInstance().getVoiceConfig();
                        }
                        return;
                    } else if ("VOICE_CONFIG".equals(type)) {
                        JSONObject exteaJson = dataObj.getJSONObject("extra");
                        if (exteaJson == null) return;
                        PreferencesUtil.saveVoiceSetting(context, exteaJson.toString());
                        BroadcastUtil.sendFetchVoiceConfigOKEvent(context);
                        return;
                    } else if ("EMP_PHONE_STATUS".equals(type)) {
                        EventController.getInstance().addEvent(context, dataObj, 5);
                        return;
                    } else if ("LOC_PHONE_STATUS".equals(type)) {
                        EventController.getInstance().addEvent(context, dataObj, 8);
                        return;
                    } else {
                        if ("CHAT_ROOM_NEW".equals(type)) return;
                        if ("LICENSE".equals(type)) {
                            JSONObject exteaJson = dataObj.getJSONObject("extra");
                            Log.i(DataChangeEventManager.class.getSimpleName(), "LICENSE:" + exteaJson.toString());
                            if (exteaJson.has("outboundFilterEnabled")) {
                                boolean outboundFilterEnabled = exteaJson.getBoolean("outboundFilterEnabled");
                                PreferencesUtil.setOutboundFilterEnabled(context, outboundFilterEnabled);
                            }
                            DataChangeEventManager.doLicenseChange(context, exteaJson);
                            if ("NG".equals(reason)) {
                                WebAgent.getInstance().logout(10, true);
                                return;
                            } else {
                                if (!"LACK".equals(reason)) return;
                                WebAgent.getInstance().logout(8, true);
                            }
                            return;
                        } else if ("OUTBOUND_FILTER".equals(type)) {
                            JSONObject exteaJson = dataObj.getJSONObject("extra");
                            Log.i(DataChangeEventManager.class.getSimpleName(), "LICENSE:" + exteaJson.toString());
                            if (exteaJson.has("outboundFilterEnabled")) {
                                boolean outboundFilterEnabled = exteaJson.getBoolean("outboundFilterEnabled");
                                PreferencesUtil.setOutboundFilterEnabled(context, outboundFilterEnabled);
                            }
                            if (!exteaJson.has("outboundFilterRecordingIncluded")) return;
                            boolean outboundFilterRecordingIncluded = exteaJson.getBoolean("outboundFilterRecordingIncluded");
                            PreferencesUtil.setOutboundFilterRecordingIncluded(context, outboundFilterRecordingIncluded);
                            return;
                        } else if ("MOBILE_DEVICE".equals(type)) {
                            if (reason.equals("UPD")) {
                                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                    @Override
                                    public void doRun() {
                                        WebAgent.getInstance().queryLoginDeviceList();
                                    }
                                }, 3000L);
                                return;
                            } else if (reason.equals("LOGIN") || reason.equals("LOGOUT")) {
                                String thisDeviceId = PreferencesUtil.getString(context, "DEVICEID", "");
                                if (thisDeviceId.equalsIgnoreCase(ids)) return;
                                checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                    @Override
                                    public void doRun() {
                                        WebAgent.getInstance().queryLoginDeviceList();
                                    }
                                }, 3000L);
                                return;
                            } else if (reason.equals("FORCE_LOGOUT")) {
                                if (ids == null) return;
                                String deviceId = PreferencesUtil.getString(context, "DEVICEID", "");
                                String forceLogoutId = ids;
                                if (TextUtils.isNotBlank((CharSequence)forceLogoutId) && deviceId.equals(forceLogoutId.trim())) {
                                    WebAgent.getInstance().logout(101, true);
                                    return;
                                } else {
                                    checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                        @Override
                                        public void doRun() {
                                            WebAgent.getInstance().queryLoginDeviceList();
                                        }
                                    }, 3000L);
                                }
                                return;
                            } else {
                                if (!reason.equals("FORCE_LOGOUT_BY_ADMIN") || ids == null) return;
                                String deviceId = PreferencesUtil.getString(context, "DEVICEID", "");
                                String forceLogoutId = ids;
                                if (TextUtils.isNotBlank((CharSequence)forceLogoutId) && deviceId.equals(forceLogoutId.trim())) {
                                    WebAgent.getInstance().logout(102, true);
                                    return;
                                } else {
                                    checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                        @Override
                                        public void doRun() {
                                            WebAgent.getInstance().queryLoginDeviceList();
                                        }
                                    }, 3000L);
                                }
                            }
                            return;
                        } else if ("APNS_CHAT_ROOM_FILTER".equals(type)) {
                            if (ids == null) return;
                            if (reason.equals("INS")) {
                                UserDatabase db = UserDatabase.getDB(context);
                                db.disableNotification(ids);
                            } else if (reason.equals("DEL")) {
                                UserDatabase db = UserDatabase.getDB(context);
                                db.enableNotification(ids);
                            }
                            BroadcastUtil.sendChatRoomNotificationUpdateEvent(context, ids);
                            return;
                        } else if ("TWO_STEP_TRANSFER".equals(type)) {
                            PhoneAgent.getInstance().onTwoStepTransfer(context, dataObj);
                            return;
                        } else if ("CALL_BRIDGED".equals(type)) {
                            PhoneAgent.getInstance().onCallBridged(context, dataObj);
                            return;
                        } else if ("THREE_WAY_CALLING".equals(type)) {
                            PhoneAgent.getInstance().onInviteThreeWayCalling(context, dataObj);
                            return;
                        } else if ("INVITE_CONFERENCE".equals(type)) {
                            PhoneAgent.getInstance().onInviteJoinMeetme(context, dataObj);
                            return;
                        } else if ("CHAT_EVENT_READ".equals(type)) {
                            if (TextUtils.isBlank((CharSequence)ids)) {
                                return;
                            }
                            String[] idAry = ids.split(",");
                            for (int i = 0; idAry != null && i < idAry.length; ++i) {
                                if (idAry[i] == null) continue;
                                String chatEventIdStr = idAry[i].trim();
                                long eventId = -1L;
                                try {
                                    eventId = Long.parseLong(chatEventIdStr);
                                    UCDBMessage.updateChatRoomMsgReadStatusByChatEventId(context, eventId);
                                    continue;
                                }
                                catch (Throwable stillExist) {
                                    // empty catch block
                                }
                            }
                            if (!PreferencesUtil.isSyncOldChatEventDone(context)) return;
                            BroadcastUtil.sendMsgChangedEvent(context);
                            BroadcastUtil.sendContactHistoryChangedEvent(context);
                            return;
                        } else if ("CHAT_EVENT_PLAYED".equals(type)) {
                            if (TextUtils.isBlank((CharSequence)ids)) {
                                return;
                            }
                            String[] idAry = ids.split(",");
                            for (int i = 0; idAry != null && i < idAry.length; ++i) {
                                if (idAry[i] == null) continue;
                                String chatEventIdStr = idAry[i].trim();
                                try {
                                    long eventId = Long.parseLong(chatEventIdStr);
                                    if (eventId <= 0L) continue;
                                    UCDBMessage.updateChatRoomMsgPlayedStatusByChatEventId(context, eventId);
                                    Message msg = UCDBMessage.findMsgByEventId(context, eventId);
                                    if (msg == null) continue;
                                    BroadcastUtil.sendMsgPlayedEvent(context, msg.getPacketId());
                                    continue;
                                }
                                catch (Throwable eventId) {
                                    // empty catch block
                                }
                            }
                            if (!PreferencesUtil.isSyncOldChatEventDone(context)) return;
                            BroadcastUtil.sendMsgChangedEvent(context);
                            BroadcastUtil.sendContactHistoryChangedEvent(context);
                            return;
                        } else if ("CHAT_READER_COUNT".equals(type)) {
                            if (!reason.equals("UPD") || !dataObj.has("extra")) return;
                            final String packetId = ids;
                            JSONObject exteaJson = dataObj.getJSONObject("extra");
                            int readCount = 0;
                            String readerList = null;
                            if (exteaJson.has("readerCount")) {
                                readCount = exteaJson.getInt("readerCount");
                            }
                            if (exteaJson.has("readerList")) {
                                readerList = exteaJson.getString("readerList");
                            }
                            if (readCount == 0) return;
                            UCDBMessage.updateChatMsgReadCountInfo(context, packetId, readCount, readerList);
                            BroadcastUtil.sendMsgReadedEvent(context, packetId);
                            if (!ApiVersion.isApi14Later()) return;
                            checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    WebAgent.getInstance().getReaderTime(packetId);
                                }
                            }, 3000L);
                            return;
                        } else if ("WAKE_UP_SIP_AND_RING".equals(type)) {
                            Log.i(DataChangeEventManager.class.getSimpleName(), "RECEIVE RING EVENT PhoneAgent.isRegistered:" + PhoneAgent.isRegistered);
                            BroadcastUtil.sendRestartPhoneServiceRequestEvent(context, "SIP_WAKEUP");
                            return;
                        } else if ("SIP_RELOAD".equals(type)) {
                            Log.i(DataChangeEventManager.class.getSimpleName(), "RECEIVE SIP_RELOAD EVENT PhoneAgent.isRegistered:" + PhoneAgent.isRegistered);
                            BroadcastUtil.sendReloadPhoneServiceRequestEvent(context, "SIP_RELOAD");
                            return;
                        } else if ("WAKE_UP_TRIAL".equals(type)) {
                            Log.i(DataChangeEventManager.class.getSimpleName(), "RECEIVE RING EVENT PhoneAgent.isRegistered:" + PhoneAgent.isRegistered);
                            BroadcastUtil.sendWakeupReconnectEvent(context);
                            return;
                        } else if ("BULLETIN_SCOPE_CHANGE".equals(type)) {
                            checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    UCDBBulletin.deleteAllBulletin(context);
                                    PreferencesUtil.cleanBulletinTimestamp();
                                    WebAgent.getInstance().getPublishBulletinList();
                                }
                            }, 3000L);
                            return;
                        } else if ("PUBLISH_BULLETIN".equals(type)) {
                            checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    WebAgent.getInstance().getPublishBulletinList();
                                }
                            }, 3000L);
                            return;
                        } else if ("SUPPRESS_BULLETIN".equals(type)) {
                            checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    WebAgent.getInstance().getSuppressBulletinList();
                                }
                            }, 3000L);
                            return;
                        } else if ("BULLETIN_READ_COUNT".equals(type)) {
                            if (!reason.equals("UPD") || !dataObj.has("extra")) return;
                            JSONObject exteaJson = dataObj.getJSONObject("extra");
                            int readCount = 0;
                            if (exteaJson.has("readCount")) {
                                readCount = exteaJson.getInt("readCount");
                            }
                            try {
                                long bulletinId = Long.parseLong(ids);
                                UCDBBulletin.saveBulletinReadcount(context, bulletinId, readCount);
                                BroadcastUtil.sendBulletinStatusChangedEvent(context, bulletinId);
                                return;
                            }
                            catch (Throwable t) {
                                Log.e(DataChangeEventManager.class.getSimpleName(), "[ERROR] data change event: " + String.valueOf(dataObj), t);
                            }
                            return;
                        } else if ("BULLETIN_MARK".equals(type)) {
                            if (!reason.equals("UPD")) return;
                            try {
                                JSONObject exteaJson;
                                if (!dataObj.has("extra") || !(exteaJson = dataObj.getJSONObject("extra")).has("marked")) return;
                                boolean isMarked = exteaJson.getBoolean("marked");
                                long bulletinId = Long.parseLong(ids);
                                UCDBBulletin.markBulletinAsMarked(context, bulletinId, isMarked);
                                BroadcastUtil.sendBulletinStatusChangedEvent(context, bulletinId);
                                return;
                            }
                            catch (Throwable t) {
                                Log.e(DataChangeEventManager.class.getSimpleName(), "[ERROR] data change event: " + String.valueOf(dataObj), t);
                            }
                            return;
                        } else if ("BULLETIN_READ".equals(type)) {
                            if (!reason.equals("UPD")) return;
                            try {
                                long bulletinId = Long.parseLong(ids);
                                UCDBBulletin.markBulletinAsReaded(context, bulletinId);
                                BroadcastUtil.sendBulletinStatusChangedEvent(context, bulletinId);
                                return;
                            }
                            catch (Throwable t) {
                                Log.e(DataChangeEventManager.class.getSimpleName(), "[ERROR] data change event: " + String.valueOf(dataObj), t);
                            }
                            return;
                        } else if ("API_USER".equals(type)) {
                            checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    WebAgent.getInstance().getApiUserList();
                                }
                            }, 3000L);
                            return;
                        } else if ("API_USER_ICON".equals(type)) {
                            checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    WebAgent.getInstance().getApiUserList();
                                }
                            }, 3000L);
                            return;
                        } else if ("MEETME_PREFIX".equals(type)) {
                            JSONObject extraJson = dataObj.getJSONObject("extra");
                            JSONObject extraDataJson = extraJson.getJSONObject("data");
                            if (extraDataJson.has("meetmePrefix")) {
                                PreferencesUtil.setMeetmePrefixOld(context, extraDataJson.getString("meetmePrefix"));
                            }
                            BroadcastUtil.sendMeetmePrefixChangedEvent(context);
                            return;
                        } else if ("SATISFACTION_LIST_CHANGED".equals(type)) {
                            checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    WebAgent.getInstance().getSatisfactionSurveyList();
                                }
                            }, new Random().nextInt(5));
                            return;
                        } else {
                            if (!"CALL_PARKED".equals(type)) return;
                            JSONObject extraJson = dataObj.getJSONObject("extra");
                            String deviceId = extraJson.getString("deviceId");
                            String sipUsername = PreferencesUtil.getSipUserName(context);
                            if (!sipUsername.equals(deviceId)) {
                                return;
                            }
                            StringBuffer b = new StringBuffer();
                            String callerIdNum = null;
                            String callerIdName = null;
                            if (extraJson.has("callerIdNum")) {
                                callerIdNum = extraJson.getString("callerIdNum");
                            }
                            if (extraJson.has("callerIdName")) {
                                callerIdName = extraJson.getString("callerIdName");
                            }
                            if (callerIdNum != null && callerIdName != null) {
                                if (!callerIdNum.equals(callerIdName)) {
                                    b.append(callerIdName + "(" + callerIdNum + ")");
                                } else {
                                    b.append(callerIdName);
                                }
                            } else if (callerIdNum != null && callerIdName == null) {
                                b.append(callerIdNum);
                            } else if (callerIdNum == null && callerIdName != null) {
                                b.append(callerIdName);
                            }
                            String transLineText = String.format(I18NUtil.getString("transfer_dialog_park_call_success"), b.toString(), extraJson.optString("parkingSpace", ""));
                            ToastUtil.showLong(transLineText);
                        }
                    }
                }
            }
            return;
        }
        catch (JSONException e) {
            Log.e(DataChangeEventManager.class.getSimpleName(), "[ERROR] data change event: " + String.valueOf(dataObj), e);
        }
    }

    public static void fetchEmployeeInfo(final Context context, final String ids) {
        if (PreferencesUtil.isAddressBookSyncDone(context)) {
            checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

                @Override
                public void doRun() {
                    ContactManager.updateEmployeeInfo(context, ids);
                }
            }, 3000L);
        }
    }

    private static void doLicenseChange(Context context, JSONObject licenseObj) {
        boolean isVoiceChange = false;
        boolean phoneCallLicense = PreferencesUtil.hasPhoneCallLicense(context);
        try {
            PreferencesUtil.saveLicenceInfo(context, licenseObj);
            boolean phoneCallLicenseAfter = PreferencesUtil.hasPhoneCallLicense(context);
            boolean bl = isVoiceChange = phoneCallLicense != phoneCallLicenseAfter;
            if (isVoiceChange && phoneCallLicenseAfter) {
                WebAgent.getInstance().getMySiteList();
            }
            if (isVoiceChange && !phoneCallLicenseAfter) {
                BroadcastUtil.sendStopPhoneServiceRequestEvent(context, "WebAgent-doLicenseChange");
            }
        }
        catch (Exception e) {
            Log.e(ChatEventManager.class.getSimpleName(), e.getLocalizedMessage());
        }
    }
}

