/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.DeletedContact;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBDeletedJidContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeletedContactManager {
    public static void parseDeletedJidList(Context ctx, JSONArray dataArray, long returnTimeStamp) {
        try {
            if (dataArray == null) {
                return;
            }
            HashSet<String> deletedJidSet = new HashSet<String>();
            for (int i = 0; dataArray != null && i < dataArray.length(); ++i) {
                JSONObject obj = dataArray.getJSONObject(i);
                if (!obj.has("jid")) continue;
                String jid = obj.getString("jid");
                boolean isRemoved = false;
                if (obj.has("removed")) {
                    isRemoved = obj.getBoolean("removed");
                }
                if (isRemoved) {
                    UCDBDeletedJidContact.removeDeletedJidContact(ctx, jid);
                    continue;
                }
                deletedJidSet.add(jid);
                ContactManager.cleanCacheAndPhoto(ctx, jid);
                String otherName = null;
                String surName = null;
                String givenName = null;
                if (obj.has("otherName")) {
                    otherName = obj.getString("otherName");
                }
                if (obj.has("surName")) {
                    surName = obj.getString("surName");
                }
                if (obj.has("givenName")) {
                    givenName = obj.getString("givenName");
                }
                UCDBDeletedJidContact.addOrUpdateDeletedJidContact(ctx, jid, otherName, surName, givenName);
            }
            UCDBContact.deleteContactsByJids(ctx, deletedJidSet);
            PreferencesUtil.setTimeStamp(ctx, "employee.getDeletedJidList.TimeStamp", returnTimeStamp);
        }
        catch (Throwable t) {
            Log.e(ContactManager.class.getSimpleName(), t.getLocalizedMessage());
        }
        BroadcastUtil.sendContactListChangedEvent(ctx);
    }

    public static boolean existDeletedContact(Context ctx, String jid) {
        return UCDBDeletedJidContact.existDeletedJidContact(ctx, jid);
    }

    public static void removeDeletedJidContact(Context ctx, String jid) {
        UCDBDeletedJidContact.removeDeletedJidContact(ctx, jid);
    }

    public static void addOrUpdateDeletedContact(Context ctx, String jid, String otherName, String surName, String givenName) {
        UCDBDeletedJidContact.addOrUpdateDeletedJidContact(ctx, jid, otherName, surName, givenName);
    }

    public static void addOrUpdateDeletedContact(Context ctx, String jid) {
        UCDBDeletedJidContact.addOrUpdateDeletedJidContact(ctx, jid);
    }

    public static DeletedContact getDeletedContact(Context ctx, String jid) {
        if (ApiVersion.isApi4Later()) {
            return UCDBDeletedJidContact.getDeletedJidContact(ctx, jid);
        }
        return null;
    }

    public static void getDeletedContact(Context ctx) {
        WebAgent.getInstance().queryDeletedJidList();
    }

    public static String getContactFullName(DeletedContact contact) {
        if (contact == null) {
            throw new RuntimeException("contact is null");
        }
        if (JidUtil.isLocationJid(contact.getJid())) {
            if (StringUtils.isNotBlank((CharSequence)contact.getOtherName())) {
                return contact.getOtherName();
            }
            if (StringUtils.isNotBlank((CharSequence)contact.getGivenName())) {
                return contact.getGivenName();
            }
            if (StringUtils.isNotBlank((CharSequence)contact.getSurName())) {
                return contact.getSurName();
            }
            return contact.getJid().split("@")[0];
        }
        boolean hasOtherName = contact.getOtherName() != null && contact.getOtherName().trim().length() > 0;
        boolean hasGivenName = contact.getGivenName() != null && contact.getGivenName().trim().length() > 0;
        boolean hasSurName = contact.getSurName() != null && contact.getSurName().trim().length() > 0;
        StringBuffer buffer = new StringBuffer();
        if (hasGivenName && hasSurName) {
            buffer.append(contact.getGivenName() + " " + contact.getSurName());
        } else if (!hasGivenName && hasSurName) {
            buffer.append(contact.getSurName());
        } else if (hasGivenName && !hasSurName) {
            buffer.append(contact.getGivenName());
        }
        if (hasOtherName) {
            if (hasGivenName || hasSurName) {
                buffer.append(" ");
            }
            buffer.append(contact.getOtherName());
        }
        if (buffer.length() == 0) {
            buffer.append(JidUtil.getJidName(contact.getJid()));
        }
        return buffer.toString();
    }

    public static String getContactShortName(Context context, DeletedContact liteContact) {
        return DeletedContactManager.getContactShortName(context, liteContact, I18NUtil.getAppLocale());
    }

    public static String getContactShortName(Context context, DeletedContact contact, Locale locale) {
        boolean hasSurName;
        if (contact == null) {
            throw new RuntimeException("contact is null");
        }
        if (locale == null) {
            throw new RuntimeException("locale is null");
        }
        Object userName = "";
        boolean hasOtherName = contact.getOtherName() != null && contact.getOtherName().trim().length() > 0;
        boolean hasGivenName = contact.getGivenName() != null && contact.getGivenName().trim().length() > 0;
        boolean bl = hasSurName = contact.getSurName() != null && contact.getSurName().trim().length() > 0;
        if (locale.equals(Locale.TAIWAN) || locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN)) {
            if (hasOtherName) {
                userName = contact.getOtherName();
            } else if (hasGivenName && hasSurName) {
                userName = contact.getGivenName() + " " + contact.getSurName();
            } else if (!hasGivenName && hasSurName) {
                userName = contact.getSurName();
            } else if (hasGivenName && !hasSurName) {
                userName = contact.getGivenName();
            }
        } else if (hasGivenName && hasSurName) {
            userName = contact.getGivenName() + " " + contact.getSurName();
        } else if (!hasGivenName && hasSurName) {
            userName = contact.getSurName();
        } else if (hasGivenName && !hasSurName) {
            userName = contact.getGivenName();
        } else if (hasOtherName) {
            userName = contact.getOtherName();
        }
        if (userName == null || ((String)userName).length() == 0) {
            userName = JidUtil.getJidName(contact.getJid());
        }
        return userName;
    }
}

