/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.web.LiteOutboundPrefix;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OutboundPrefixManager {
    private static HashMap<Long, LiteOutboundPrefix> outboundprefixmap = new HashMap();
    private static Object lock = new Object();

    public static LiteOutboundPrefix getOutboundPrefix(Context context, long outboundPrefixId) {
        LiteOutboundPrefix item = UCDBSite.getOutboundPrefix(context, outboundPrefixId);
        if (item != null) {
            return item;
        }
        return null;
    }

    public static LiteOutboundPrefix getDefaultOutboundPrefix(Context ctx, long siteId) {
        LiteOutboundPrefix item = UCDBSite.getDefaultOutboundPrefix(ctx, siteId);
        if (item != null) {
            return item;
        }
        return null;
    }

    public static void parseOutboundPrefixListResult(Context context, JSONArray dataArray) {
        try {
            ArrayList<LiteOutboundPrefix> newList = new ArrayList<LiteOutboundPrefix>();
            for (int i = 0; dataArray != null && i < dataArray.length(); ++i) {
                LiteOutboundPrefix item = OutboundPrefixManager.parseOutboundPrefixResultObj(dataArray.getJSONObject(i));
                newList.add(item);
            }
            List<LiteOutboundPrefix> dbPrefixs = UCDBSite.getAllOutboundPrefixs(context);
            if (dbPrefixs != null && dbPrefixs.size() > 0) {
                outboundprefixmap.clear();
                for (LiteOutboundPrefix dbPfix : dbPrefixs) {
                    outboundprefixmap.put(dbPfix.getId(), dbPfix);
                }
            }
            HashSet<Long> keyset = new HashSet<Long>(outboundprefixmap.keySet());
            for (Long key : keyset) {
                boolean shouldBeRemoved = true;
                for (LiteOutboundPrefix item : newList) {
                    if (item.getId().longValue() != key.longValue()) continue;
                    shouldBeRemoved = false;
                }
                if (!shouldBeRemoved) continue;
                OutboundPrefixManager.deleteOutboundPrefix(context, key);
            }
            for (LiteOutboundPrefix item : newList) {
                OutboundPrefixManager.addOrUpdateOutboundPrefix(context, item);
            }
        }
        catch (JSONException e) {
            Log.e(OutboundPrefixManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private static LiteOutboundPrefix parseOutboundPrefixResult(String dataObjStr) throws JSONException {
        try {
            return OutboundPrefixManager.parseOutboundPrefixResultObj(new JSONObject(dataObjStr));
        }
        catch (JSONException e) {
            Log.e(OutboundPrefixManager.class.getSimpleName(), e.getLocalizedMessage(), e);
            throw e;
        }
    }

    private static LiteOutboundPrefix parseOutboundPrefixResultObj(JSONObject dataObj) throws JSONException {
        try {
            LiteOutboundPrefix outboundPrefix = new LiteOutboundPrefix();
            outboundPrefix.setId(dataObj.getLong("id"));
            if (dataObj.has("name")) {
                outboundPrefix.setName(dataObj.getString("name"));
            }
            if (dataObj.has("siteId")) {
                outboundPrefix.setSiteId(dataObj.getLong("siteId"));
            }
            if (dataObj.has("prefix")) {
                outboundPrefix.setPrefix(dataObj.getString("prefix"));
            }
            if (dataObj.has("meetmePrefix")) {
                outboundPrefix.setMeetmePrefix(dataObj.getString("meetmePrefix"));
            }
            if (dataObj.has("order")) {
                outboundPrefix.setOrder(dataObj.getInt("order"));
            }
            if (dataObj.has("defaultRule")) {
                outboundPrefix.setDefaultRule(dataObj.getBoolean("defaultRule"));
            }
            if (dataObj.has("nameEn")) {
                outboundPrefix.setNameEn(dataObj.getString("nameEn"));
            }
            if (dataObj.has("nameTw")) {
                outboundPrefix.setNameTw(dataObj.getString("nameTw"));
            }
            if (dataObj.has("nameCn")) {
                outboundPrefix.setNameCn(dataObj.getString("nameCn"));
            }
            if (dataObj.has("countryNameEn")) {
                outboundPrefix.setCountryNameEn(dataObj.getString("countryNameEn"));
            }
            if (dataObj.has("countryNameTw")) {
                outboundPrefix.setCountryNameTw(dataObj.getString("countryNameTw"));
            }
            if (dataObj.has("countryNameCn")) {
                outboundPrefix.setCountryNameCn(dataObj.getString("countryNameCn"));
            }
            if (dataObj.has("countryCode")) {
                outboundPrefix.setCountryCode(dataObj.getString("countryCode"));
            }
            if (dataObj.has("cityCode")) {
                outboundPrefix.setCityCode(dataObj.getString("cityCode"));
            }
            return outboundPrefix;
        }
        catch (JSONException e) {
            Log.e(OutboundPrefixManager.class.getSimpleName(), e.getLocalizedMessage(), e);
            throw e;
        }
    }

    public static void deleteOutboundPrefix(Context context, long outboundPrefixId) {
        UCDBSite.deleteOutboundPrefix(context, outboundPrefixId);
        outboundprefixmap.remove(outboundPrefixId);
    }

    public static void updateOutboundPrefix(Context context, String outboundPrefixJsonStr) {
        try {
            LiteOutboundPrefix item = OutboundPrefixManager.parseOutboundPrefixResult(outboundPrefixJsonStr);
            OutboundPrefixManager.addOrUpdateOutboundPrefix(context, item);
        }
        catch (JSONException e) {
            Log.e(OutboundPrefixManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    public static void addOutboundPrefix(Context context, String outboundPrefixJsonStr) {
        try {
            LiteOutboundPrefix item = OutboundPrefixManager.parseOutboundPrefixResult(outboundPrefixJsonStr);
            OutboundPrefixManager.addOrUpdateOutboundPrefix(context, item);
        }
        catch (JSONException e) {
            Log.e(OutboundPrefixManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addOrUpdateOutboundPrefix(Context ctx, LiteOutboundPrefix outboundPrefix) {
        Object object = lock;
        synchronized (object) {
            if (UCDBSite.existOutboundPrefixById(ctx, outboundPrefix.getId())) {
                UCDBSite.updateOutboundPrefix(ctx, outboundPrefix);
            } else {
                UCDBSite.addOutboundPrefix(ctx, outboundPrefix);
            }
            outboundprefixmap.put(outboundPrefix.getId(), outboundPrefix);
        }
    }

    public static boolean prefixSelectionEnabled(Context ctx) {
        String[] siteIds;
        String sip_my_pbx_site_list = PreferencesUtil.getSipMyPbxSiteList(ctx);
        for (String siteId : siteIds = CommonUtil.getJsonDataArray(sip_my_pbx_site_list, "id")) {
            LiteSite site = UCDBSite.getSite(ctx, Long.parseLong(siteId));
            List<LiteOutboundPrefix> prefixList = UCDBSite.getOutboundPrefixList(ctx, site.getId());
            if (prefixList == null || prefixList.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public static String getOutboundPrefix(Context ctx) {
        LiteOutboundPrefix outboundPrefix;
        long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
        if (ApiVersion.isApi14Later() && (outboundPrefix = ContactManager.getMySelfOutboundPrefix(ctx, mySiteId)) != null) {
            return outboundPrefix.getPrefix();
        }
        LiteSite site = UCDBSite.getSite(ctx, mySiteId);
        if (site != null) {
            return site.getOutboundPrefix();
        }
        return "0";
    }

    public static String getMeetmePrefix(Context ctx) {
        if (ApiVersion.isApi14Later()) {
            return OutboundPrefixManager.getMeetmePrefixNew(ctx);
        }
        return PreferencesUtil.getMeetmePrefixOld(ctx);
    }

    private static String getMeetmePrefixNew(Context context) {
        long mySiteId = PreferencesUtil.getSipUsePbxSite(context);
        LiteOutboundPrefix outboundPrefix = ContactManager.getMySelfOutboundPrefix(context, mySiteId);
        if (outboundPrefix != null) {
            return outboundPrefix.getMeetmePrefix();
        }
        return "8";
    }
}

