/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.LitePresence;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class PresenceManager {
    private static final List<LitePresence> PRESENCES = new ArrayList<LitePresence>();
    private static final Map<LitePresence, Color> PRESENCES_COLOR = new HashMap<LitePresence, Color>();
    private static final Map<LitePresence, Icon> PRESENCES_ICON = new HashMap<LitePresence, Icon>();
    public static final Color COLOR_OFFLINE = Color.GRAY;
    public static final Color COLOR_INVISIBLE = Color.GRAY;
    public static final Color COLOR_ONLINE = new Color(50, 187, 81);
    public static final Color COLOR_AWAY = Color.ORANGE;
    public static final Color COLOR_BUSY = Color.RED;
    public static final Icon ICON_OFFLINE = new ImageIcon(PresenceManager.class.getClassLoader().getResource("images/presence/offline.png"));
    public static final Icon ICON_INVISIBLE = new ImageIcon(PresenceManager.class.getClassLoader().getResource("images/presence/hide.png"));
    public static final Icon ICON_ONLINE = new ImageIcon(PresenceManager.class.getClassLoader().getResource("images/presence/online.png"));
    public static final Icon ICON_AWAY = new ImageIcon(PresenceManager.class.getClassLoader().getResource("images/presence/away.png"));
    public static final Icon ICON_BUSY = new ImageIcon(PresenceManager.class.getClassLoader().getResource("images/presence/buzy.png"));

    public static Color getPresenceColor(LitePresence presence) {
        if (presence == null || presence.getType() == LitePresence.Type.unavailable) {
            return COLOR_OFFLINE;
        }
        return PRESENCES_COLOR.get(presence);
    }

    public static Icon getPresenceIcon(LitePresence presence) {
        if (presence == null || presence.getType() == LitePresence.Type.unavailable) {
            return ICON_OFFLINE;
        }
        if (presence.getName() == null && presence.getType() == LitePresence.Type.available) {
            return ICON_ONLINE;
        }
        return PRESENCES_ICON.get(presence);
    }

    public static List<LitePresence> getPresences() {
        return PRESENCES;
    }

    static {
        PRESENCES.add(LitePresence.ONLINE);
        PRESENCES.add(LitePresence.INVISIBLE);
        PRESENCES.add(LitePresence.AWAY);
        PRESENCES.add(LitePresence.BUSY);
        PRESENCES_COLOR.put(LitePresence.OFFLINE, COLOR_OFFLINE);
        PRESENCES_COLOR.put(LitePresence.INVISIBLE, COLOR_INVISIBLE);
        PRESENCES_COLOR.put(LitePresence.ONLINE, COLOR_ONLINE);
        PRESENCES_COLOR.put(LitePresence.AWAY, COLOR_AWAY);
        PRESENCES_COLOR.put(LitePresence.BUSY, COLOR_BUSY);
        PRESENCES_ICON.put(LitePresence.OFFLINE, ICON_OFFLINE);
        PRESENCES_ICON.put(LitePresence.INVISIBLE, ICON_INVISIBLE);
        PRESENCES_ICON.put(LitePresence.ONLINE, ICON_ONLINE);
        PRESENCES_ICON.put(LitePresence.AWAY, ICON_AWAY);
        PRESENCES_ICON.put(LitePresence.BUSY, ICON_BUSY);
    }
}

