/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class VerifyPinCodePanel
extends RoundedCornerPanel {
    private JLabel lblTitle;
    private JSeparator jSeparator1;
    private JTextField txtPinCode;
    private JLabel lblMessage;
    private JLabel lblKey;
    private JPanel panelInput;
    private JButton btnClose;
    private JLabel btnJoin;
    private long roomId;

    public VerifyPinCodePanel(long roomId) {
        super(20);
        this.initGUI();
        this.roomId = roomId;
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.btnClose = new JButton();
            this.add((Component)this.btnClose, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(8, 0, 0, 8), 0, 0));
            this.btnClose.setIcon(UIConstants.ICON_CLOSE);
            this.btnClose.setCursor(UIConstants.CURSOR_HAND);
            this.btnClose.setPreferredSize(new Dimension(22, 22));
            this.btnClose.setToolTipText(I18NUtil.getString("common_btn_close"));
            this.btnClose.setBorderPainted(false);
            this.btnClose.setFocusPainted(false);
            this.btnClose.setContentAreaFilled(false);
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    VerifyPinCodePanel.this.btnCloseActionPerformed(evt);
                }
            });
            this.lblTitle = new JLabel();
            this.add((Component)this.lblTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("conference_title_pin_code"));
            this.lblTitle.setFont(UIConstants.FONT_14_BOLD);
            this.lblTitle.setForeground(UIConstants.COLOR_DIALOG_TITLE);
            this.panelInput = new RoundedCornerPanel();
            BorderLayout panelInputLayout = new BorderLayout();
            panelInputLayout.setHgap(5);
            this.panelInput.setLayout(panelInputLayout);
            this.add((Component)this.panelInput, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(20, 50, 0, 50), 0, 0));
            this.panelInput.setPreferredSize(new Dimension(200, 26));
            this.panelInput.setBackground(Color.WHITE);
            this.panelInput.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
            this.panelInput.setOpaque(false);
            this.lblKey = new JLabel();
            this.panelInput.add((Component)this.lblKey, "West");
            this.lblKey.setIcon(UIConstants.ICON_KEY);
            this.txtPinCode = new JTextField();
            this.panelInput.add((Component)this.txtPinCode, "Center");
            this.txtPinCode.setFont(UIConstants.FONT_14_PLAIN);
            this.txtPinCode.setForeground(Color.DARK_GRAY);
            this.txtPinCode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.txtPinCode.setOpaque(false);
            this.txtPinCode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    VerifyPinCodePanel.this.txtPinCodeActionPerformed(evt);
                }
            });
            this.txtPinCode.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "myEsc");
            this.txtPinCode.getActionMap().put("myEsc", new EscAction());
            this.lblMessage = new JLabel();
            this.add((Component)this.lblMessage, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(15, 0, 0, 0), 0, 0));
            this.lblMessage.setText(" ");
            this.lblMessage.setFont(UIConstants.FONT_12_PLAIN);
            this.jSeparator1 = new JSeparator();
            this.add((Component)this.jSeparator1, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(15, 0, 0, 0), 0, 0));
            this.btnJoin = new RoundedCornerLabel(I18NUtil.getString("conference_btn_join"), null, UIConstants.BACKGROUND_UNJOINED_NORMAL, UIConstants.BACKGROUND_UNJOINED_OVER, UIConstants.BACKGROUND_UNJOINED_PRESSED);
            this.add((Component)this.btnJoin, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 0, 15, 0), 0, 0));
            this.btnJoin.setForeground(Color.WHITE);
            this.btnJoin.setCursor(UIConstants.CURSOR_HAND);
            this.btnJoin.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    VerifyPinCodePanel.this.btnJoinMousePressed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void txtPinCodeActionPerformed(ActionEvent evt) {
        this.verifyPinCode();
    }

    private void btnJoinMousePressed(MouseEvent evt) {
        if (this.btnJoin.isEnabled() && evt.getButton() == 1) {
            this.verifyPinCode();
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.verifyPinCodeCancelled();
    }

    private void verifyPinCode() {
        this.btnJoin.setEnabled(false);
        this.lblMessage.setIcon(UIConstants.ICON_LOADING16);
        this.lblMessage.setForeground(Color.BLACK);
        this.lblMessage.setText(I18NUtil.getString("conference_notice_pin_code_verifying"));
        WebAgent.getInstance().verifyConferenceRoomPinCode(this.roomId, this.txtPinCode.getText());
    }

    public void focusTextField() {
        this.txtPinCode.requestFocus();
    }

    public void verifyPinCodeCancelled() {
        this.btnJoin.setEnabled(true);
        this.lblMessage.setIcon(null);
        this.lblMessage.setForeground(Color.BLACK);
        this.lblMessage.setText(" ");
        UCChatClient.getInstance().hideGlassPanel();
    }

    public void verifyPinCodeSucceed(String msg) {
        this.btnJoin.setEnabled(false);
        this.btnClose.setEnabled(false);
        this.lblMessage.setIcon(null);
        this.lblMessage.setForeground(Color.BLACK);
        this.lblMessage.setText(msg);
        SwingUtilities.invokeLater(new Runnable(this){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(700L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                UCChatClient.getInstance().hideGlassPanel();
            }
        });
    }

    public void verifyPinCodeFailed(String msg) {
        this.btnJoin.setEnabled(true);
        this.lblMessage.setIcon(null);
        this.lblMessage.setForeground(Color.RED);
        this.lblMessage.setText(msg);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new VerifyPinCodePanel(1L));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    class EscAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            UCChatClient.getInstance().hideGlassPanel();
        }
    }
}

