/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.callback.WebCallBack;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class ChatEventController
extends Thread {
    private WebCallBack mCallback;
    private List<Event> mList;
    private Map<Long, Event> mMap;
    private boolean mTerminated;
    private boolean activeFlag = false;
    private static int EVENT_TYPE_CHAT = 0;
    private static int EVENT_TYPE_DATACHANGE = 1;
    private static ChatEventController mInstance;

    public static ChatEventController getInstance(WebCallBack callback) {
        if (mInstance == null) {
            mInstance = new ChatEventController(callback);
            mInstance.start();
        }
        return mInstance;
    }

    private ChatEventController(WebCallBack callback) {
        super("EZChatEventController");
        this.mCallback = callback;
        this.mList = Collections.synchronizedList(new LinkedList());
        this.mMap = new HashMap<Long, Event>();
        this.mTerminated = false;
    }

    public synchronized void queueChatEvent(JSONObject data) {
        JSONObject eventObj;
        long id;
        Event event = new Event(EVENT_TYPE_CHAT, data);
        this.mList.add(event);
        if (data instanceof JSONObject && (id = (eventObj = data).optLong("id", -1L)) != -1L) {
            this.mMap.put(id, event);
        }
    }

    public synchronized void unqueueChatEvent(Object data) {
        JSONObject eventObj;
        long id;
        if (data instanceof JSONObject && (id = (eventObj = (JSONObject)data).optLong("id", -1L)) != -1L && this.mMap.containsKey(id)) {
            Event event = this.mMap.remove(id);
            this.mList.remove(event);
        }
    }

    public synchronized void addDataChangedEvent(JSONObject data) {
        Event event = new Event(EVENT_TYPE_DATACHANGE, data);
        this.mList.add(event);
        this.notifyAll();
    }

    public synchronized void addChatEvent(JSONObject data) {
        Event event = new Event(EVENT_TYPE_CHAT, data);
        this.mList.add(event);
        this.notifyAll();
    }

    public synchronized void active() {
        Log.i(this.getClass().getSimpleName(), "active XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX " + this.mList.size());
        this.activeFlag = true;
        this.mMap.clear();
        this.notifyAll();
    }

    public void deactive() {
        Log.i(this.getClass().getSimpleName(), "deactive XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.activeFlag = false;
        this.mList.clear();
        this.mMap.clear();
    }

    public boolean isActive() {
        return this.activeFlag;
    }

    public void terminate() {
        this.mList.clear();
        this.mMap.clear();
        this.mTerminated = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.mTerminated) {
                ChatEventController chatEventController = this;
                synchronized (chatEventController) {
                    if (this.mList.isEmpty() || !this.activeFlag) {
                        this.wait();
                    }
                }
                if (!this.activeFlag || this.mList.size() <= 0) continue;
                Event event = this.mList.remove(0);
                if (event.getType() == EVENT_TYPE_CHAT) {
                    this.mCallback.processChatEvent(event.getData());
                    continue;
                }
                if (event.getType() != EVENT_TYPE_DATACHANGE) continue;
                this.mCallback.processDataChangedEvent(event.getData());
            }
        }
        catch (InterruptedException e) {
            Log.e(this.getClass().getSimpleName(), "terminate", e);
        }
        finally {
            mInstance = null;
            Log.i(this.getClass().getSimpleName(), "terminate XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX end");
        }
    }

    private static class Event {
        private JSONObject mData;
        private int mType;

        public Event(int type, JSONObject data) {
            this.mData = data;
            this.mType = type;
        }

        public JSONObject getData() {
            return this.mData;
        }

        public int getType() {
            return this.mType;
        }
    }
}

