/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.bean.ChatDetailLoadTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ChatEventDownloadController
extends ExThread {
    private static ChatEventDownloadController mInstance;
    private List<ChatDetailLoadTask> mQueue = Collections.synchronizedList(new ArrayList());
    private boolean suspend = false;

    public synchronized void setSuspend(boolean suspend) {
        this.suspend = suspend;
        if (!suspend && !this.mQueue.isEmpty()) {
            this.notifyAll();
        }
    }

    public static ChatEventDownloadController getInstance(Context ctx) {
        if (mInstance == null) {
            mInstance = new ChatEventDownloadController(ctx);
        }
        return mInstance;
    }

    public static void stopInstance() {
        if (mInstance != null) {
            mInstance.terminate();
            mInstance = null;
        }
    }

    public static void suspendInstance(boolean s) {
        if (mInstance != null) {
            mInstance.setSuspend(s);
        }
    }

    private ChatEventDownloadController(Context ctx) {
        super(ctx, "ChatEventDownloadController");
        this.start();
    }

    public synchronized void addTask(long chatEventId) {
        Log.i(this.getClass().getSimpleName(), "add event download task, eventId:" + chatEventId);
        ChatDetailLoadTask task = new ChatDetailLoadTask(chatEventId);
        if (this.existTask(task)) {
            return;
        }
        this.mQueue.add(task);
        this.notifyAll();
    }

    public synchronized void addTask(List<ChatDetailLoadTask> taskList) {
        if (taskList == null || taskList.isEmpty()) {
            Log.e(this.getClass().getSimpleName(), "ChatDetailLoadTask taskList is null or size is 0");
            return;
        }
        for (ChatDetailLoadTask task : taskList) {
            if (this.existTask(task)) continue;
            this.mQueue.add(task);
        }
        this.notifyAll();
    }

    private boolean existTask(ChatDetailLoadTask task) {
        boolean exist = false;
        for (ChatDetailLoadTask queueTask : this.mQueue) {
            if (queueTask.getChatEventId() != task.getChatEventId()) continue;
            exist = true;
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChatEventDownloadController chatEventDownloadController;
        try {
            while (!this.isTerminate()) {
                chatEventDownloadController = this;
                synchronized (chatEventDownloadController) {
                    if (this.suspend || this.mQueue.isEmpty() || !WebAgent.getInstance().isConnected() || !WebAgent.isLogin) {
                        this.wait();
                    }
                }
                Log.i(this.getClass().getSimpleName(), "ChatDetailLoadTask queue size:" + this.mQueue.size() + ", suspend:" + this.suspend);
                if (this.suspend) continue;
                ArrayList<ChatDetailLoadTask> currentTaskList = new ArrayList<ChatDetailLoadTask>();
                if (!this.mQueue.isEmpty()) {
                    ChatEventDownloadController chatEventDownloadController2 = this;
                    synchronized (chatEventDownloadController2) {
                        for (int i = 0; i < 3 && !this.mQueue.isEmpty(); ++i) {
                            ChatDetailLoadTask task = this.mQueue.remove(0);
                            if (task == null) continue;
                            currentTaskList.add(task);
                        }
                    }
                }
                if (currentTaskList.size() == 0) continue;
                this.execute(currentTaskList);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Log.i(this.getClass().getSimpleName(), "Clear instance");
            chatEventDownloadController = this;
            synchronized (chatEventDownloadController) {
                this.mQueue.clear();
                this.mQueue = null;
            }
            mInstance = null;
        }
    }

    private void execute(List<ChatDetailLoadTask> currentTaskList) throws InterruptedException {
        HashSet<Long> eventIdSet = new HashSet<Long>();
        for (ChatDetailLoadTask task : currentTaskList) {
            eventIdSet.add(task.getChatEventId());
        }
        WebAgent.getInstance().getOldChatEventDetailsByEventIds(eventIdSet);
    }
}

