/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.AsyncTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.task.TaskComplete;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckAppBackgroundTask
extends AsyncTask<String, Void, Void> {
    public static final String UC_TENANT_APP_BACKGROUND_TIME = "/ucrm/skin/config?enterpriseNo=%1$s&productType=%2$d";
    public static final String UC_TENANT_APP_BACKGROUND_PHOTO = "/ucrm/skin/getBackground?enterpriseNo=%1$s&productType=%2$d&deviceType=%3$d&dimension=%4$d";
    public static final String UC_TENANT_APP_BACKGROUND_LOGO = "/ucrm/skin/getLogo?enterpriseNo=%1$s&productType=%2$d&deviceType=%3$d&dimension=%4$d";
    public static final String UC_NO_TENANT_APP_BACKGROUND_TIME = "/ucrm/skin/config?productType=%1$d";
    public static final String UC_NO_TENANT_APP_BACKGROUND_PHOTO = "/ucrm/skin/getBackground?productType=%1$d&deviceType=%2$d&dimension=%3$d";
    public static final String UC_NO_TENANT_APP_BACKGROUND_LOGO = "/ucrm/skin/getLogo?productType=%1$d&deviceType=%2$d&dimension=%3$d";
    private Context mCtx = null;
    private TaskComplete<Void> taskCompleteListener = null;

    public CheckAppBackgroundTask(Context context, TaskComplete<Void> listener) {
        this.mCtx = context.getApplicationContext();
        this.taskCompleteListener = listener;
    }

    protected Void doInBackground(String ... params) {
        if (this.isCancelled()) {
            return null;
        }
        boolean updateNeeded = false;
        long lastTimestamp = PreferencesUtil.getTenantAppBackgroundTime(this.mCtx);
        if (lastTimestamp == -1L) {
            updateNeeded = true;
        }
        HttpClient mHttpClient = CommonUtil.getHttpsClient(this.mCtx, true, 6000, 6000);
        int dimension = 1;
        if (!updateNeeded) {
            Log.i(CheckAppBackgroundTask.class.getSimpleName(), "isUpdateRequired check ... ");
            updateNeeded = this.isUpdateRequired(mHttpClient, dimension);
            Log.i(CheckAppBackgroundTask.class.getSimpleName(), "isUpdateRequired check ... done!");
        }
        Log.i(CheckAppBackgroundTask.class.getSimpleName(), "Check timestamp updateNeeded:" + updateNeeded);
        if (updateNeeded) {
            Log.i(CheckAppBackgroundTask.class.getSimpleName(), "fetchAndSavePhotoBackgroundFromWeb check ... ");
            this.fetchAndSavePhotoBackgroundFromWeb(mHttpClient, dimension);
            Log.i(CheckAppBackgroundTask.class.getSimpleName(), "fetchAndSavePhotoBackgroundFromWeb check ... done!");
            Log.i(CheckAppBackgroundTask.class.getSimpleName(), "fetchAndSavePhotoLogoFromWeb check ... ");
            this.fetchAndSavePhotoLogoFromWeb(mHttpClient, dimension);
            Log.i(CheckAppBackgroundTask.class.getSimpleName(), "fetchAndSavePhotoLogoFromWeb check ... done!");
            PreferencesUtil.setTenantAppBackgroundTime(this.mCtx, System.currentTimeMillis());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAndSavePhotoBackgroundFromWeb(HttpClient mHttpClient, int dimension) {
        if (mHttpClient == null) {
            return;
        }
        int productType = PreferencesUtil.getInt(this.mCtx, "PRODUCTTYPE", 0);
        int deviceType = 0;
        String backgroundUrl = null;
        String enterpriseNo = PreferencesUtil.getEnterpriseNo(this.mCtx);
        if (TextUtils.isNotBlank((CharSequence)enterpriseNo)) {
            String encTenant;
            try {
                encTenant = URLEncoder.encode(enterpriseNo, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            backgroundUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + String.format(UC_TENANT_APP_BACKGROUND_PHOTO, encTenant, productType, deviceType, dimension);
        } else {
            backgroundUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + String.format(UC_NO_TENANT_APP_BACKGROUND_PHOTO, productType, deviceType, dimension);
        }
        Log.i(CheckAppBackgroundTask.class.getSimpleName(), "backgroundUrl ... " + backgroundUrl);
        InputStream is = null;
        try {
            HttpGet request = new HttpGet();
            request.setURI(new URI(backgroundUrl));
            HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                request.abort();
                return;
            }
            is = response.getEntity().getContent();
            FileUtil.writeRegistrationBackgtoundFile(is);
            return;
        }
        catch (Throwable t) {
            Log.e(CheckAppBackgroundTask.class.getSimpleName(), "getPhotoFromWeb fail", t);
            return;
        }
        finally {
            if (is != null) {
                try {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        Log.e(CheckAppBackgroundTask.class.getSimpleName(), "getPhotoFromWeb fail", e);
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAndSavePhotoLogoFromWeb(HttpClient mHttpClient, int dimension) {
        if (mHttpClient == null) {
            return;
        }
        int productType = PreferencesUtil.getInt(this.mCtx, "PRODUCTTYPE", 0);
        int deviceType = 0;
        String logoUrl = null;
        String enterpriseNo = PreferencesUtil.getEnterpriseNo(this.mCtx);
        if (TextUtils.isNotBlank((CharSequence)enterpriseNo)) {
            String encTenant;
            try {
                encTenant = URLEncoder.encode(enterpriseNo, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            logoUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + String.format(UC_TENANT_APP_BACKGROUND_LOGO, encTenant, productType, deviceType, dimension);
        } else {
            logoUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + String.format(UC_NO_TENANT_APP_BACKGROUND_LOGO, productType, deviceType, dimension);
        }
        Log.i(CheckAppBackgroundTask.class.getSimpleName(), "logoUrl ... " + logoUrl);
        InputStream is = null;
        try {
            HttpGet request = new HttpGet();
            request.setURI(new URI(logoUrl));
            HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                request.abort();
                return;
            }
            is = response.getEntity().getContent();
            FileUtil.writeRegistrationLogoFile(is);
            is.close();
            return;
        }
        catch (Throwable t) {
            Log.e(CheckAppBackgroundTask.class.getSimpleName(), "getPhotoFromWeb fail", t);
            return;
        }
        finally {
            if (is != null) {
                try {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        Log.e(CheckAppBackgroundTask.class.getSimpleName(), "getPhotoFromWeb fail", e);
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }

    private boolean isUpdateRequired(HttpClient mHttpClient, int dimension) {
        if (mHttpClient == null) {
            return false;
        }
        long lastTimestamp = PreferencesUtil.getTenantAppBackgroundTime(this.mCtx);
        int productType = PreferencesUtil.getInt(this.mCtx, "PRODUCTTYPE", 0);
        String timestampUrl = null;
        String enterpriseNo = PreferencesUtil.getEnterpriseNo(this.mCtx);
        if (TextUtils.isNotBlank((CharSequence)enterpriseNo)) {
            String encTenant;
            try {
                encTenant = URLEncoder.encode(enterpriseNo, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            timestampUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + String.format(UC_TENANT_APP_BACKGROUND_TIME, encTenant, productType);
        } else {
            timestampUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + String.format(UC_NO_TENANT_APP_BACKGROUND_TIME, productType);
        }
        try {
            HttpGet request = new HttpGet();
            request.setURI(new URI(timestampUrl));
            HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 404) {
                request.abort();
                return true;
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                request.abort();
                return true;
            }
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity);
            if (TextUtils.isBlank((CharSequence)result)) {
                return true;
            }
            JSONObject obj = null;
            try {
                obj = new JSONObject(result);
                int resultCode = obj.getInt("returnCode");
                if (resultCode == 0) {
                    int bgType = obj.getInt("bgType");
                    long timestamp = obj.getLong("lastUpdateTime");
                    if (timestamp <= lastTimestamp) {
                        return false;
                    }
                }
            }
            catch (JSONException e) {
                return true;
            }
        }
        catch (Throwable t) {
            Log.e(CheckAppBackgroundTask.class.getSimpleName(), "isUpdateTimestampRequired fail", t);
        }
        return true;
    }

    @Override
    protected void onPostExecute(Void result) {
        this.taskCompleteListener.onLoadFinished(result);
    }
}

