/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ConnectionAgent;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.HttpRequestUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.json.JSONException;
import org.json.JSONObject;

@MigratedFromMobileApp
public class ForgotPasswordTask
implements HttpRequestUtil.IRequestListener {
    public static final int RESULT_OK = 0;
    public static final int RESULT_GENERAL_ERROR = -1;
    public static final int RESULT_CONNECTIONERROR = -1000;
    private HttpRequestUtil mRequest;
    private PasswordCompleteListener mListener;

    public ForgotPasswordTask(Context ctx, String loginAccount, PasswordCompleteListener listener) {
        this.mListener = listener;
        ConnectionAgent.getInstance().checkInOfficeFlag();
        String url = String.format("https://%s", CommonUtil.getHttpsIpPort(ctx)) + String.format("/ucrm/mobileEmployeeAction/forgotPassword?account=%s", loginAccount);
        String enterpriseNo = PreferencesUtil.getEnterpriseNo(ctx);
        if (TextUtils.isNotBlank((CharSequence)enterpriseNo)) {
            this.mRequest = new HttpRequestUtil(ctx, enterpriseNo.trim(), url, new JSONObject(), null, this, true, 5000);
            this.mRequest.execute(new Void[0]);
        } else {
            this.mRequest = new HttpRequestUtil(ctx, null, url, new JSONObject(), null, this, true, 5000);
            this.mRequest.execute(new Void[0]);
        }
    }

    @Override
    public void onRequestCompleted(String result) {
        block6: {
            if (TextUtils.isBlank((CharSequence)result)) {
                if (this.mListener != null) {
                    this.mListener.onCheckCompleted(-1000, null);
                }
                return;
            }
            try {
                JSONObject obj = new JSONObject(result);
                if (obj.has("rc")) {
                    JSONObject rcObject = obj.getJSONObject("rc");
                    String resultString = rcObject.getString("returnInfo");
                    int code = rcObject.getInt("returnCode");
                    if (this.mListener != null) {
                        this.mListener.onCheckCompleted(code, resultString);
                    }
                }
            }
            catch (JSONException e) {
                Log.e(ForgotPasswordTask.class.getSimpleName(), "sendPasswordEmail", e);
                if (this.mListener == null) break block6;
                this.mListener.onCheckCompleted(-1000, null);
            }
        }
    }

    public void terminate() {
        if (this.mRequest != null) {
            this.mRequest.cancel(true);
            this.mRequest = null;
        }
    }

    public static interface PasswordCompleteListener {
        public void onCheckCompleted(int var1, String var2);
    }
}

