/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.EmpPhotoTask;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetContactDataTask
extends ExThread {
    private JSONArray mDataArray;
    private long returnTimeStamp;
    private JSONObject paraObj;

    public GetContactDataTask(Context context, JSONArray dataArray, JSONObject paraObj, long returnTimeStamp) {
        super(context, "GetContactDataTask");
        this.mDataArray = dataArray;
        this.returnTimeStamp = returnTimeStamp;
        this.paraObj = paraObj;
    }

    @Override
    public void run() {
        long empListTimestamp;
        Log.i(this.getClass().getSimpleName(), "start of GetContactDataTask :");
        if (this.isTerminate()) {
            this.cleanUp();
            return;
        }
        boolean isAddressBookSyncDone = PreferencesUtil.isAddressBookSyncDone(this.mCtx);
        List<LiteContact> contacts = ContactManager.parseLiteContactsJson(this.mDataArray);
        Long loginUserId = PreferencesUtil.getUserId(this.mCtx);
        ArrayList<PhotoLoadTask> toGetPhotoEmpList = new ArrayList<PhotoLoadTask>();
        long lastUpdateTimeThisLoop = -1L;
        long startIdThisLoop = -1L;
        for (LiteContact liteContact : contacts) {
            if (this.isTerminate()) {
                Log.i(this.getClass().getSimpleName(), "GetContactDataTask termainate!");
                this.cleanUp();
                return;
            }
            lastUpdateTimeThisLoop = liteContact.getLastUpdateTime();
            startIdThisLoop = liteContact.getId();
            boolean hasPhotoUpdate = ContactManager.setWSContactWithPhotoCheck(this.mCtx, liteContact, 0, 1);
            if (loginUserId != null && liteContact.getId() != null && liteContact.getId().longValue() == loginUserId.longValue()) {
                PreferencesUtil.setUserInfo(this.mCtx, liteContact);
                BroadcastUtil.sendPersonalInfoChanged(this.mCtx);
            }
            if (!hasPhotoUpdate) continue;
            EmpPhotoTask task = new EmpPhotoTask();
            task.setEmpKey(KeyUtil.genEmpKey(liteContact));
            toGetPhotoEmpList.add(task);
        }
        if (toGetPhotoEmpList != null && !toGetPhotoEmpList.isEmpty()) {
            ContactManager.refreshPhotoList(this.mCtx, PhotoType.SMALL, toGetPhotoEmpList);
        }
        if (!isAddressBookSyncDone && (empListTimestamp = PreferencesUtil.getTimeStamp(this.mCtx, "employee.getEmployeeList.TimeStamp.20200730").longValue()) == -1L) {
            long initialtimeStamp = this.returnTimeStamp + 5000L;
            Log.i(this.getClass().getSimpleName(), "AddressBookSyncDone:NO initial timestamp:" + initialtimeStamp);
            PreferencesUtil.setTimeStamp(this.mCtx, "employee.getEmployeeList.TimeStamp.20200730", initialtimeStamp);
        }
        if (contacts.size() != 0) {
            if (!isAddressBookSyncDone) {
                Log.i(this.getClass().getSimpleName(), "AddressBookSyncDone:NO contactsSize:" + contacts.size() + " startIdThisLoop:" + startIdThisLoop);
                WebAgent.getInstance().reloadDirtyEmployeeList(startIdThisLoop);
            } else {
                Log.i(this.getClass().getSimpleName(), "AddressBookSyncDone:YES contactsSize:" + contacts.size() + " lastUpdateTimeThisLoop:" + lastUpdateTimeThisLoop + " startIdThisLoop:" + startIdThisLoop);
                WebAgent.getInstance().getDirtyEmployeeListByPage(lastUpdateTimeThisLoop, startIdThisLoop);
            }
        } else {
            Log.i(this.getClass().getSimpleName(), "AddressBookSyncDone:" + isAddressBookSyncDone + " contactsSize is zero");
            if (!isAddressBookSyncDone) {
                PreferencesUtil.setAddressBookSyncDone(this.mCtx);
                long timestamp = PreferencesUtil.getTimeStamp(this.mCtx, "employee.getEmployeeList.TimeStamp.20200730");
                WebAgent.getInstance().getDirtyEmployeeListByPage(timestamp, -1L);
            } else {
                Long empListTimestamp2 = this.returnTimeStamp;
                try {
                    empListTimestamp2 = this.paraObj.getLong("timeStamp");
                }
                catch (JSONException liteContact) {
                    // empty catch block
                }
                PreferencesUtil.setTimeStamp(this.mCtx, "employee.getEmployeeList.TimeStamp.20200730", empListTimestamp2);
                DeletedContactManager.getDeletedContact(this.mCtx);
                WebAgent.getInstance().listVoiceAndRecord();
                long timestamp = PreferencesUtil.getTimeStamp(this.mCtx, "record.getDeletedVMAndPRList.TimeStamp");
                if (timestamp == -1L) {
                    PreferencesUtil.setTimeStamp(this.mCtx, "record.getDeletedVMAndPRList.TimeStamp", System.currentTimeMillis());
                } else {
                    WebAgent.getInstance().listDeletedVoiceAndRecord();
                }
                WebAgent.getInstance().queryPhoneEmpStatusList();
            }
        }
        if (PreferencesUtil.isSyncOldChatEventDone(this.mCtx)) {
            BroadcastUtil.sendContactListChangedEvent(this.mCtx, 0);
            BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
        }
        this.cleanUp();
        Log.d(this.getClass().getSimpleName(), "end of GetContactDataTask :end");
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }

    @Override
    public String toString() {
        return "GetContactDataTask - " + super.toString();
    }
}

