/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBCustomer;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.Set;

public class GetDataTask
extends ExThread {
    public GetDataTask(Context ctx) {
        super(ctx, "GetDataTask");
    }

    @Override
    public void run() {
        try {
            if (!this.isTerminate()) {
                WebAgent.getInstance().getVoiceConfig();
                MeetmeManager.deleteAllConfRoomUsers(this.mCtx);
                Thread.sleep(3000L);
                WebAgent.getInstance().getAllDepartmentList();
                WebAgent.getInstance().getApiUserList();
                WebAgent.getInstance().queryLocation();
                WebAgent.getInstance().getLanguageList();
                WebAgent.getInstance().queryExternalContactList();
                WebAgent.getInstance().getDeletedContactList();
                if (PreferencesUtil.isBulletinApiEnabled(this.mCtx)) {
                    WebAgent.getInstance().getPublishBulletinList();
                }
                WebAgent.getInstance().queryLoginDeviceList();
                WebAgent.getInstance().getDeviceInfo();
                if (PreferencesUtil.hasConferenceLicense(this.mCtx)) {
                    WebAgent.getInstance().queryMeetMeList();
                }
                WebAgent.getInstance().getDisableChatRoomNoticeList();
                WebAgent.getInstance().getCustomerServiceCategory();
                if (ApiVersion.isApi7Later()) {
                    WebAgent.getInstance().getCustomerInfoList();
                } else {
                    Set<String> accountSet = UCDBCustomer.getCustomerAccounts(this.mCtx);
                    if (accountSet != null) {
                        for (String account : accountSet) {
                            WebAgent.getInstance().getCustomerInfo(account);
                        }
                    }
                }
                WebAgent.getInstance().queryGroupList();
                WebAgent.getInstance().getDeletedGroupList();
                boolean faxEnabled = PreferencesUtil.isFaxEnabled(this.mCtx);
                if (faxEnabled) {
                    WebAgent.getInstance().getFaxDocList();
                    WebAgent.getInstance().getFaxDocDeletedList();
                }
                PreferencesUtil.setSyncDataFlag(this.mCtx, false);
                BroadcastUtil.sendMsgChangedEvent(this.mCtx);
                BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
                boolean syncDone = PreferencesUtil.isSyncOldChatEventDone(this.mCtx);
                if (!syncDone) {
                    long lastEventId = PreferencesUtil.getLastChatEventId(this.mCtx);
                    if (lastEventId != -1L) {
                        PreferencesUtil.setSyncDataFlag(this.mCtx, true);
                        BroadcastUtil.sendDataDownloadStartEvent(this.mCtx);
                        WebAgent.getInstance().getOldChatEventByEventId(lastEventId);
                    } else {
                        WebAgent.getInstance().getChatEventBeginTime();
                    }
                } else {
                    long lastEventId = PreferencesUtil.getLastChatEventId(this.mCtx);
                    WebAgent.getInstance().getOldChatEventByEventId(lastEventId);
                }
            } else {
                Log.e(this.getClass().getSimpleName(), "Skip GetDataTask because of terminated");
            }
        }
        catch (InterruptedException e) {
            Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
        }
        this.cleanUp();
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }

    @Override
    public String toString() {
        return "GetDataTask - " + super.toString();
    }
}

