/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.EmpPhotoTask;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class GetLocationDataTask
extends ExThread {
    private JSONArray mDataArray;
    private long returnTimeStamp;

    public GetLocationDataTask(Context context, JSONArray dataArray, long returnTimeStamp) {
        super(context, "GetLocationDataTask");
        this.mDataArray = dataArray;
        this.returnTimeStamp = returnTimeStamp;
    }

    @Override
    public void run() {
        Log.i(this.getClass().getSimpleName(), "start of GetContactDataTask :");
        if (this.isTerminate()) {
            this.cleanUp();
            return;
        }
        List<LiteContact> newContactList = ContactManager.parseLiteContactsJson(this.mDataArray);
        ArrayList<PhotoLoadTask> toGetPhotoEmpList = new ArrayList<PhotoLoadTask>();
        List<LiteContact> existContactList = UCDBContact.findAllLocationContacts(this.mCtx);
        long lastUpdateTimeThisLoop = -1L;
        for (LiteContact existContact : existContactList) {
            lastUpdateTimeThisLoop = existContact.getLastUpdateTime();
            boolean keep = false;
            for (LiteContact newLiteContact : newContactList) {
                if (existContact.getSiteId().longValue() != newLiteContact.getSiteId().longValue() || !existContact.getExt().equals(newLiteContact.getExt())) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            DeletedContactManager.addOrUpdateDeletedContact(this.mCtx, existContact.getJid(), existContact.getDispName(), null, null);
        }
        ContactManager.removeLocation(this.mCtx);
        for (LiteContact liteContact : newContactList) {
            boolean hasPhotoUpdate;
            if (DeletedContactManager.existDeletedContact(this.mCtx, liteContact.getJid())) {
                DeletedContactManager.removeDeletedJidContact(this.mCtx, liteContact.getJid());
            }
            if (!(hasPhotoUpdate = ContactManager.setWSContactWithPhotoCheck(this.mCtx, liteContact, 1, 1))) continue;
            EmpPhotoTask task = new EmpPhotoTask();
            task.setEmpKey(KeyUtil.genEmpKey(liteContact));
            toGetPhotoEmpList.add(task);
        }
        if (toGetPhotoEmpList != null && !toGetPhotoEmpList.isEmpty()) {
            ContactManager.refreshPhotoList(this.mCtx, PhotoType.SMALL, toGetPhotoEmpList);
        }
        PreferencesUtil.setTimeStamp(this.mCtx, "employee.getLocation.TimeStamp", lastUpdateTimeThisLoop);
        WebAgent.getInstance().queryPhoneLocStatusList();
        if (PreferencesUtil.isSyncOldChatEventDone(this.mCtx)) {
            BroadcastUtil.sendContactListChangedEvent(this.mCtx, 1);
            BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
        }
        this.cleanUp();
        Log.i(this.getClass().getSimpleName(), "end of GetContactDataTask :end");
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }

    @Override
    public String toString() {
        return "GetContactDataTask - " + super.toString();
    }
}

