/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.EmpPhotoTask;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

public class LoadContactDataTask
extends ExThread {
    private JSONArray mDataArray;
    private String mToken;

    public LoadContactDataTask(Context context, JSONArray dataArray, String token) {
        super(context, "LoadContactDataTask");
        this.mDataArray = dataArray;
        this.mToken = token;
    }

    @Override
    public void run() {
        Log.i(this.getClass().getSimpleName(), "start of GetContactDataTask :");
        if (this.isTerminate()) {
            this.cleanUp();
            return;
        }
        if (this.mDataArray == null) {
            this.cleanUp();
            return;
        }
        List<LiteContact> contacts = ContactManager.parseLiteContactsJson(this.mDataArray);
        if (contacts == null || contacts.size() == 0) {
            this.cleanUp();
            return;
        }
        boolean isWhole = PreferencesUtil.isAddressBookScopeWholeCompany(this.mCtx);
        Set<Long> scopeEmpSet = PreferencesUtil.getAddressBookScopeEmpList(this.mCtx);
        Set<Long> extraEmpSet = PreferencesUtil.getAddressBookExtraEmpList(this.mCtx);
        Long loginUserId = PreferencesUtil.getUserId(this.mCtx);
        ArrayList<PhotoLoadTask> toGetPhotoEmpList = new ArrayList<PhotoLoadTask>();
        for (LiteContact liteContact : contacts) {
            if (this.isTerminate()) {
                Log.i(this.getClass().getSimpleName(), "GetContactDataTask termainate!");
                this.cleanUp();
                return;
            }
            boolean hasPhotoUpdate = false;
            hasPhotoUpdate = PreferencesUtil.isAddressBookInit() ? ContactManager.setWSContactWithPhotoCheck(this.mCtx, liteContact, 0, 0) : (isWhole || scopeEmpSet.contains(liteContact.getId()) || extraEmpSet.contains(liteContact.getId()) ? ContactManager.setWSContactWithPhotoCheck(this.mCtx, liteContact, 0, 1) : ContactManager.setWSContactWithPhotoCheck(this.mCtx, liteContact, 0, 0));
            if (loginUserId != null && liteContact.getId() != null && liteContact.getId().longValue() == loginUserId.longValue()) {
                PreferencesUtil.setUserInfo(this.mCtx, liteContact);
                BroadcastUtil.sendPersonalInfoChanged(this.mCtx);
                BroadcastUtil.sendMeetmePrefixChangedEvent(this.mCtx);
            }
            if (hasPhotoUpdate) {
                EmpPhotoTask task = new EmpPhotoTask();
                task.setEmpKey(KeyUtil.genEmpKey(liteContact));
                toGetPhotoEmpList.add(task);
            }
            if (this.mToken != null) {
                PhoneAgent.getInstance().onContactLoaded(this.mToken, liteContact);
                continue;
            }
            PhoneAgent.getInstance().onContactLoaded(liteContact);
        }
        if (toGetPhotoEmpList != null && !toGetPhotoEmpList.isEmpty()) {
            ContactManager.refreshPhotoList(this.mCtx, PhotoType.SMALL, toGetPhotoEmpList);
        }
        if (PreferencesUtil.isSyncOldChatEventDone(this.mCtx)) {
            BroadcastUtil.sendContactListChangedEvent(this.mCtx, 0);
            BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
        }
        this.cleanUp();
        Log.i(this.getClass().getSimpleName(), "end of GetContactDataTask :end");
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

