/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.List;

@MigratedFromMobileApp
public class MarkPhoneRemoteReadTask
extends ExThread {
    public MarkPhoneRemoteReadTask(Context ctx) {
        super(ctx, "MarkPhoneRemoteReadTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Context context = this.mCtx;
        synchronized (context) {
            Long[] ids;
            int i;
            String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
            List<Long[]> msgIdList = ChatRoomManager.findUnreadPhoneMsgIds(this.mCtx, myJid);
            for (i = 0; msgIdList != null && i < msgIdList.size(); ++i) {
                ids = msgIdList.get(i);
                if (ids[1] == null || ids[1] == -1L || ids[1] == 0L) continue;
                UCDBRemoteMark.addRemoteMark(this.mCtx, 3, ids[1]);
                UCDBMessage.updateChatRoomMsgReadStatusByChatEventId(this.mCtx, ids[1]);
            }
            if (msgIdList != null && msgIdList.size() != 0) {
                BroadcastUtil.sendMsgReadStatusChangedEvent(this.mCtx, "__EXTERNAL_TRUNK_CALL_GROUP__");
            }
            if (ApiVersion.isApi1Later()) {
                String chatEventIdStr = this.getUpdateChatEventIdList(msgIdList);
                if (chatEventIdStr != null) {
                    WebAgent.getInstance().markChatEventAsRead(chatEventIdStr);
                }
            } else {
                for (i = 0; msgIdList != null && i < msgIdList.size(); ++i) {
                    ids = msgIdList.get(i);
                    if (ids[1] == null || ids[1] == -1L || ids[1] == 0L) continue;
                    WebAgent.getInstance().markChatEventAsRead(ids[1]);
                }
            }
        }
        TaskController.getInstance().removeTask(this);
    }

    private String getUpdateChatEventIdList(List<Long[]> chatEventIdList) {
        StringBuffer b = new StringBuffer();
        boolean doNeetUpdate = false;
        int index = 0;
        for (int i = 0; chatEventIdList != null && i < chatEventIdList.size(); ++i) {
            Long[] ids = chatEventIdList.get(i);
            if (ids[1] == null || ids[1] == -1L || ids[1] == 0L) continue;
            doNeetUpdate = true;
            if (index != 0) {
                b.append(",");
            }
            b.append(ids[1]);
            ++index;
        }
        if (doNeetUpdate) {
            return b.toString();
        }
        return null;
    }

    @Override
    public String toString() {
        return "MarkRemoteReadTask - " + super.toString();
    }
}

