/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.MsgBean;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.FetchEmpTaskController;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.HashSet;
import org.json.JSONException;
import org.json.JSONObject;

public class MeetmeLeaveTask
extends ExThread {
    private JSONObject mDataObj;

    public MeetmeLeaveTask(Context context, JSONObject dataObj) {
        super(context, "MeetmeLeaveTask");
        this.mDataObj = dataObj;
    }

    @Override
    public void run() {
        this.doAction();
        this.cleanUp();
    }

    private void doAction() {
        try {
            String chatroomJid;
            String callerType = this.mDataObj.getString("callerType");
            String string = chatroomJid = this.mDataObj.has("chatRoomId") ? this.mDataObj.getString("chatRoomId") : null;
            if (chatroomJid == null || "".equals(chatroomJid.trim()) || callerType == null) {
                return;
            }
            boolean newAdd = ChatRoomManager.prepareChatRoom(this.mCtx, chatroomJid);
            if (newAdd) {
                WebAgent.getInstance().getOneRoomSync(chatroomJid);
            }
            long roomId = Long.parseLong(this.mDataObj.getString("meetMe"));
            this.processMeemeLeaveData(roomId, callerType, chatroomJid);
            WebAgent.getInstance().queryMeetMeListUser(roomId);
        }
        catch (Throwable t) {
            Log.e(MeetmeLeaveTask.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private void processMeemeLeaveData(long roomId, String callerType, String chatroomJid) throws JSONException {
        String userNumStr;
        String string = userNumStr = this.mDataObj.has("userNum") ? this.mDataObj.getString("userNum") : null;
        if (TextUtils.isNotBlank((CharSequence)userNumStr)) {
            String[] userNumArray;
            HashSet<String> numbers = new HashSet<String>();
            for (String num : userNumArray = userNumStr.split(",")) {
                numbers.add(num);
            }
            if (numbers.size() != 0) {
                MeetmeManager.leaveConfRoomUser(this.mCtx, roomId, numbers);
            }
        }
        if (!UCDBChatRoom.hasParticipants(this.mCtx, chatroomJid)) {
            return;
        }
        String callerIdNum = this.mDataObj.getString("callerIdNum");
        if (callerType.equals("EMPLOYEE")) {
            String callerJid = null;
            if (this.mDataObj.has("callerJid")) {
                callerJid = this.mDataObj.getString("callerJid");
            }
            if (TextUtils.isNotBlank(callerJid)) {
                LiteContact contact = ContactManager.getContact(this.mCtx, callerJid);
                if (contact == null) {
                    FetchEmpTaskController.getInstance(this.mCtx).addTaskNoScopeCheck(callerJid);
                } else {
                    FetchEmpTaskController.getInstance(this.mCtx).addTask(contact);
                }
                this.newMeetmeleftMsg(chatroomJid, callerJid, callerIdNum);
            } else {
                long callerDbId = Long.parseLong(this.mDataObj.getString("callerDbId"));
                LiteContact contact = ContactManager.getContact(this.mCtx, callerDbId);
                if (contact != null) {
                    FetchEmpTaskController.getInstance(this.mCtx).addTask(contact);
                    this.newMeetmeleftMsg(chatroomJid, contact.getJid(), callerIdNum);
                } else {
                    HashSet<Long> idSet = new HashSet<Long>();
                    idSet.add(callerDbId);
                    WebAgent.getInstance().queryEmployeeListByIds(idSet);
                }
            }
        } else if (callerType.equals("LOCATION")) {
            String callerIdNumberSite = this.mDataObj.getString("callerIdNumberSite");
            String callerJid = ContactManager.getJidByLocId(this.mCtx, callerIdNumberSite, callerIdNum);
            if (callerJid != null) {
                this.newMeetmeleftMsg(chatroomJid, callerJid, callerIdNum);
            }
        } else {
            PhoneMatcherResult result = PhoneMatcher.match(this.mCtx, callerIdNum, true);
            if (result != null) {
                this.newMeetmeleftMsg(chatroomJid, result.getTargetJid(), callerIdNum);
            } else {
                this.newMeetmeleftMsg(chatroomJid, callerIdNum + "@phonenumber", callerIdNum);
            }
        }
    }

    private void newMeetmeleftMsg(String chatroomJid, String callerJid, String number) {
        String userJid = PreferencesUtil.getUserJid(this.mCtx);
        String packetId = ChatRoomManager.genNewPacketId();
        MsgBean bean = new MsgBean();
        bean.setChatEventId(-1L);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(chatroomJid);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(callerJid);
        bean.setToJid(userJid);
        bean.setContent(number);
        bean.setMsgType(callerJid.equals(userJid) ? 233 : 234);
        bean.setDuration(0L);
        bean.setRead(true);
        bean.setPlayed(true);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(false);
        ChatRoomManager.newChatMsg(this.mCtx, chatroomJid, bean, false);
        if (PreferencesUtil.isSyncOldChatEventDone(this.mCtx)) {
            BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
            BroadcastUtil.sendMsgChangedEvent(UCChatClient.context, chatroomJid);
        }
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

