/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceUserStatus;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import java.util.HashSet;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class MeetmeMuteTask
extends ExThread {
    private JSONObject mDataObj;

    public MeetmeMuteTask(Context context, JSONObject dataObj) {
        super(context, "MeetmeMuteTask");
        this.mDataObj = dataObj;
    }

    @Override
    public void run() {
        this.doAction();
        this.cleanUp();
    }

    private void doAction() {
        try {
            String chatroomJid = this.mDataObj.has("chatRoomId") ? this.mDataObj.getString("chatRoomId") : null;
            long roomId = Long.parseLong(this.mDataObj.getString("meetMe"));
            if (roomId == -1L || chatroomJid == null || "".equals(chatroomJid.trim())) {
                return;
            }
            boolean newAdd = ChatRoomManager.prepareChatRoom(this.mCtx, chatroomJid);
            if (newAdd) {
                WebAgent.getInstance().getOneRoomSync(chatroomJid);
            }
            LiteConferenceRoom room = UCDBConf.getConfRoom(this.mCtx, roomId);
            List<LiteConferenceUserStatus> userList = UCDBConf.getConfRoomUsers(this.mCtx, roomId);
            if (room == null || userList == null || userList.size() == 0) {
                WebAgent.getInstance().queryMeetMeListUser(roomId);
            }
            this.processMeetmeMuteData(roomId);
        }
        catch (Throwable t) {
            Log.e(MeetmeMuteTask.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private void processMeetmeMuteData(long roomId) throws JSONException {
        String userNumStr;
        String status = this.mDataObj.has("status") ? this.mDataObj.getString("status") : null;
        String string = userNumStr = this.mDataObj.has("userNum") ? this.mDataObj.getString("userNum") : null;
        if (TextUtils.isNotBlank((CharSequence)userNumStr) && TextUtils.isNotBlank((CharSequence)status)) {
            String[] userNumArray;
            HashSet<String> numbers = new HashSet<String>();
            for (String num : userNumArray = userNumStr.split(",")) {
                numbers.add(num);
            }
            if (numbers.size() != 0) {
                MeetmeManager.muteConfRoomUser(this.mCtx, roomId, numbers, status);
            }
        }
        if ("true".equals(status)) {
            BroadcastUtil.sendMeetmeMuteEvent(this.mCtx, roomId);
        } else {
            BroadcastUtil.sendMeetmeUnmuteEvent(this.mCtx, roomId);
        }
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

